/*
 * Decompiled with CFR 0.152.
 */
package net.silentchaos512.scalinghealth.event;

import java.util.Calendar;
import java.util.Random;
import javax.annotation.Nullable;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.monster.EntitySlime;
import net.minecraft.entity.monster.IMob;
import net.minecraft.entity.passive.EntityTameable;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.item.Item;
import net.minecraft.util.DamageSource;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentString;
import net.minecraft.util.text.TextComponentTranslation;
import net.minecraft.util.text.TextFormatting;
import net.minecraftforge.common.util.FakePlayer;
import net.minecraftforge.event.entity.living.LivingDeathEvent;
import net.minecraftforge.event.entity.living.LivingDropsEvent;
import net.minecraftforge.event.entity.living.LivingExperienceDropEvent;
import net.minecraftforge.event.entity.player.PlayerSleepInBedEvent;
import net.minecraftforge.event.entity.player.PlayerWakeUpEvent;
import net.minecraftforge.fml.client.event.ConfigChangedEvent;
import net.minecraftforge.fml.common.eventhandler.EventPriority;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.common.gameevent.PlayerEvent;
import net.silentchaos512.lib.util.ChatHelper;
import net.silentchaos512.scalinghealth.ScalingHealth;
import net.silentchaos512.scalinghealth.config.Config;
import net.silentchaos512.scalinghealth.event.BlightHandler;
import net.silentchaos512.scalinghealth.init.ModItems;
import net.silentchaos512.scalinghealth.init.ModSounds;
import net.silentchaos512.scalinghealth.lib.module.ModuleAprilTricks;
import net.silentchaos512.scalinghealth.utils.ModifierHandler;
import net.silentchaos512.scalinghealth.utils.SHPlayerDataHandler;

public class ScalingHealthCommonEvents {
    @SubscribeEvent
    public void onLivingDrops(LivingDropsEvent event) {
        EntityPlayer player = this.getPlayerThatCausedDeath(event.getSource());
        if (player == null || player instanceof FakePlayer && !Config.FakePlayer.generateHearts) {
            return;
        }
        if (!player.field_70170_p.func_82736_K().func_82766_b("doMobLoot")) {
            return;
        }
        EntityLivingBase killedEntity = event.getEntityLiving();
        if (!killedEntity.field_70170_p.field_72995_K) {
            float dropRate;
            Random rand = ScalingHealth.random;
            int stackSize = 0;
            float f = dropRate = killedEntity instanceof IMob ? Config.Items.Heart.chanceHostile : Config.Items.Heart.chancePassive;
            if (killedEntity instanceof EntitySlime) {
                dropRate /= 6.0f;
            }
            ScalingHealth.logHelper.debug("heart drop rate for {} is {}", new Object[]{killedEntity.func_70005_c_(), Float.valueOf(dropRate)});
            if (event.isRecentlyHit() && rand.nextFloat() <= dropRate) {
                ++stackSize;
            }
            if (!killedEntity.func_184222_aU()) {
                int min = Config.Items.Heart.bossMin;
                int max = Config.Items.Heart.bossMax;
                stackSize += min + rand.nextInt(max - min + 1);
            }
            if (stackSize > 0) {
                Item itemToDrop = Config.Items.Heart.dropShardsInstead ? ModItems.crystalShard : ModItems.heart;
                killedEntity.func_145779_a(itemToDrop, stackSize);
            }
        }
    }

    @SubscribeEvent(priority=EventPriority.HIGHEST)
    public void onXPDropped(LivingExperienceDropEvent event) {
        EntityLivingBase entityLiving = event.getEntityLiving();
        short difficulty = entityLiving.getEntityData().func_74765_d("scalinghealth:difficulty");
        float multi = 1.0f + Config.Mob.xpBoost * (float)difficulty;
        float amount = event.getDroppedExperience();
        amount *= multi;
        if (BlightHandler.isBlight(entityLiving)) {
            amount *= Config.Mob.Blight.xpMultiplier;
        }
        event.setDroppedExperience(Math.round(amount));
    }

    @Nullable
    private EntityPlayer getPlayerThatCausedDeath(DamageSource source) {
        EntityTameable tamed;
        boolean isTamedAnimal;
        if (source == null) {
            return null;
        }
        Entity entitySource = source.func_76346_g();
        if (entitySource instanceof EntityPlayer) {
            return (EntityPlayer)entitySource;
        }
        boolean bl = isTamedAnimal = entitySource instanceof EntityTameable && ((EntityTameable)entitySource).func_70909_n();
        if (entitySource instanceof EntityTameable && (tamed = (EntityTameable)entitySource).func_70909_n() && tamed.func_70902_q() instanceof EntityPlayer) {
            return (EntityPlayer)tamed.func_70902_q();
        }
        return null;
    }

    @SubscribeEvent
    public void onPlayerDied(LivingDeathEvent event) {
        if (event.getEntity() == null || !(event.getEntity() instanceof EntityPlayer)) {
            return;
        }
        EntityPlayer player = (EntityPlayer)event.getEntity();
        if (ModuleAprilTricks.instance.isEnabled() && ModuleAprilTricks.instance.isRightDay()) {
            ScalingHealth.proxy.playSoundOnClient(player, ModSounds.PLAYER_DIED, 0.6f, 1.0f);
        }
    }

    @SubscribeEvent
    public void onPlayerRespawn(PlayerEvent.PlayerRespawnEvent event) {
        if (event.player instanceof EntityPlayerMP) {
            EntityPlayerMP player = (EntityPlayerMP)event.player;
            SHPlayerDataHandler.PlayerData data = SHPlayerDataHandler.get((EntityPlayer)player);
            if (data == null) {
                return;
            }
            if (Config.Player.Health.lostOnDeath > 0 && !event.isEndConquered()) {
                float minHealth;
                float newHealth = data.getMaxHealth() - (float)Config.Player.Health.lostOnDeath;
                data.setMaxHealth(newHealth < (minHealth = (float)Config.Player.Health.minHealth) ? minHealth : newHealth);
            }
            if (!event.isEndConquered()) {
                double currentDifficulty = data.getDifficulty();
                double newDifficulty = MathHelper.func_151237_a((double)(currentDifficulty - (double)Config.Difficulty.lostOnDeath), (double)Config.Difficulty.minValue, (double)Config.Difficulty.maxValue);
                data.setDifficulty(newDifficulty);
            }
            if (Config.Player.Health.allowModify) {
                float health = player.func_110143_aJ();
                float maxHealth = data.getMaxHealth();
                ModifierHandler.setMaxHealth((EntityLivingBase)player, maxHealth, 0);
                if (health != maxHealth && maxHealth > 0.0f) {
                    player.func_70606_j(player.func_110138_aP());
                }
            }
        }
    }

    @SubscribeEvent
    public void onPlayerJoinedServer(PlayerEvent.PlayerLoggedInEvent event) {
        if (event.player instanceof EntityPlayerMP) {
            Calendar lastTimePlayed;
            EntityPlayerMP player = (EntityPlayerMP)event.player;
            SHPlayerDataHandler.PlayerData data = SHPlayerDataHandler.get((EntityPlayer)player);
            Calendar today = Calendar.getInstance();
            if (Config.Difficulty.DIFFFICULTY_RESET_TIME.shouldReset(today, lastTimePlayed = data.getLastTimePlayed())) {
                ScalingHealth.logHelper.info("Reset player {}'s difficulty to {}", new Object[]{player.func_70005_c_(), (int)Config.Difficulty.startValue});
                ChatHelper.sendMessage((EntityPlayer)player, (String)"[Scaling Health] Your difficulty has been reset.");
                data.setDifficulty(Config.Difficulty.startValue);
            }
            if (Config.Player.Health.resetTime.shouldReset(today, lastTimePlayed)) {
                data.setMaxHealth(Config.Player.Health.startingHealth);
                ScalingHealth.logHelper.info("Reset player {}'s health to {}", new Object[]{player.func_70005_c_(), Config.Player.Health.startingHealth});
                ChatHelper.sendMessage((EntityPlayer)player, (String)"[Scaling Health] Your health has been reset.");
            }
            data.getLastTimePlayed().setTime(today.getTime());
            if (Config.Player.Health.allowModify) {
                float maxHealth = data.getMaxHealth();
                ModifierHandler.setMaxHealth((EntityLivingBase)player, maxHealth, 0);
            }
        }
        if (ModuleAprilTricks.instance.isEnabled() && ModuleAprilTricks.instance.isRightDay()) {
            ChatHelper.sendMessage((EntityPlayer)event.player, (String)(TextFormatting.RED + "[Scaling Health] It's April Fool's time... hehehe."));
        }
    }

    @SubscribeEvent
    public void onPlayerSleepInBed(PlayerSleepInBedEvent event) {
        EntityPlayer player = event.getEntityPlayer();
        if (!player.field_70170_p.field_72995_K && Config.Client.Difficulty.warnWhenSleeping && Config.Difficulty.forSleeping != 0.0f) {
            String override = Config.Client.Difficulty.sleepMessageOverride;
            if (!override.isEmpty()) {
                player.func_145747_a((ITextComponent)new TextComponentString(override));
            } else {
                player.func_145747_a((ITextComponent)new TextComponentTranslation("misc.scalinghealth.sleepWarning", new Object[0]));
            }
        }
    }

    @SubscribeEvent
    public void onPlayerWakeUp(PlayerWakeUpEvent event) {
        EntityPlayer player;
        SHPlayerDataHandler.PlayerData data;
        if (!event.getEntityPlayer().field_70170_p.field_72995_K && !event.updateWorld() && (data = SHPlayerDataHandler.get(player = event.getEntityPlayer())) != null) {
            data.incrementDifficulty(Config.Difficulty.forSleeping, false);
        }
    }

    @SubscribeEvent
    public void onConfigChanged(ConfigChangedEvent.OnConfigChangedEvent event) {
        if (event.getModID().equals("scalinghealth")) {
            Config.INSTANCE.load();
            Config.INSTANCE.save();
        }
    }
}

