/*
 * Decompiled with CFR 0.152.
 */
package net.silentchaos512.scalinghealth.event;

import gnu.trove.map.hash.THashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.SharedMonsterAttributes;
import net.minecraft.entity.monster.IMob;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.util.DamageSource;
import net.minecraftforge.common.config.Configuration;
import net.minecraftforge.event.entity.living.LivingAttackEvent;
import net.minecraftforge.fml.common.eventhandler.EventPriority;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.common.gameevent.TickEvent;
import net.silentchaos512.lib.config.ConfigMultiValueLineParser;
import net.silentchaos512.scalinghealth.ScalingHealth;
import net.silentchaos512.scalinghealth.api.ScalingHealthAPI;
import net.silentchaos512.scalinghealth.config.Config;
import org.apache.logging.log4j.Marker;
import org.apache.logging.log4j.MarkerManager;

public final class DamageScaling {
    private static final Marker MARKER = MarkerManager.getMarker((String)"DamageScaling");
    private static final String[] SOURCES_DEFAULT = new String[]{"inFire", "lightningBolt", "onFire", "lava", "hotFloor", "inWall", "cramming", "drown", "starve", "cactus", "fall", "flyIntoWall", "outOfWorld", "generic", "magic", "wither", "anvil", "fallingBlock", "dragonBreath", "fireworks"};
    private static final String SOURCES_COMMENT = "Set damage scaling by damage source. All vanilla sources should be included, but set to no scaling. Mod sources can be added too, you'll just need the damage type string. The number represents how steeply the damage scales. 0 means no scaling (vanilla), 1 means it will be proportional to difficulty/max health (whichever you set). The scaling number can be anything, although I recommend a non-negative number.";
    public static final DamageScaling INSTANCE = new DamageScaling();
    private float genericScale;
    private float difficultyWeight;
    private boolean affectHostileMobs;
    private boolean affectPassiveMobs;
    private Mode scaleMode;
    private final Map<String, Float> scalingMap = new THashMap();
    private final Set<UUID> entityAttackedThisTick = new HashSet<UUID>();

    private DamageScaling() {
    }

    @SubscribeEvent(priority=EventPriority.HIGHEST)
    public void onPlayerHurt(LivingAttackEvent event) {
        float original;
        float affectedAmount;
        EntityLivingBase entity = event.getEntityLiving();
        if (entity.field_70170_p.field_72995_K) {
            return;
        }
        if (entity.func_180431_b(event.getSource()) || entity.field_70172_ad > entity.field_70771_an / 2) {
            return;
        }
        if (this.entityAttackedThisTick.contains(entity.getPersistentID()) || entity instanceof IMob && !this.affectHostileMobs || !(entity instanceof EntityPlayer) && !this.affectPassiveMobs) {
            return;
        }
        DamageSource source = event.getSource();
        if (source == null) {
            return;
        }
        float scale = this.scalingMap.getOrDefault(source.func_76355_l(), Float.valueOf(this.genericScale)).floatValue();
        float change = scale * (affectedAmount = this.getEffectScale(entity)) * (original = event.getAmount());
        if (change != 0.0f) {
            float newAmount = DamageScaling.makeSane(event.getAmount() + change);
            event.setCanceled(true);
            this.entityAttackedThisTick.add(entity.getPersistentID());
            entity.func_70097_a(event.getSource(), newAmount);
            if (Config.Debug.debugMode && Config.Debug.logPlayerDamage) {
                ScalingHealth.LOGGER.info(MARKER, "{} on {}: {} -> {} (scale={}, affected={}, change={})", (Object)source.field_76373_n, (Object)entity.func_70005_c_(), (Object)Float.valueOf(original), (Object)Float.valueOf(newAmount), (Object)Float.valueOf(scale), (Object)Float.valueOf(affectedAmount), (Object)Float.valueOf(change));
            }
        }
    }

    private float getEffectScale(EntityLivingBase entity) {
        switch (this.scaleMode) {
            case AREA_DIFFICULTY: {
                return (float)ScalingHealthAPI.getAreaDifficulty(entity.field_70170_p, entity.func_180425_c()) * this.difficultyWeight;
            }
            case MAX_HEALTH: {
                float baseHealth = entity instanceof EntityPlayer ? (float)Config.Player.Health.startingHealth : (float)entity.func_110148_a(SharedMonsterAttributes.field_111267_a).func_111125_b();
                return (entity.func_110138_aP() - baseHealth) / baseHealth;
            }
            case PLAYER_DIFFICULTY: {
                return (float)ScalingHealthAPI.getEntityDifficulty(entity) * this.difficultyWeight;
            }
        }
        throw new IllegalStateException("Unknown damage scaling mode: " + (Object)((Object)this.scaleMode));
    }

    private static float makeSane(float scaledAmount) {
        if (scaledAmount < 0.0f) {
            return 0.0f;
        }
        if (!Float.isFinite(scaledAmount)) {
            return Float.MAX_VALUE;
        }
        return scaledAmount;
    }

    @SubscribeEvent
    public void onServerTick(TickEvent.ServerTickEvent event) {
        this.entityAttackedThisTick.clear();
    }

    public void loadConfig(Configuration config) {
        String category = "main.player.damage";
        this.genericScale = config.getFloat("Generic Scale", "main.player.damage", 0.0f, -3.4028235E38f, Float.MAX_VALUE, "If the damage source is not in the \"Scale By Source\" list, this value is used instead.");
        this.difficultyWeight = config.getFloat("Difficulty Weight", "main.player.damage", 0.04f, 0.0f, 1000.0f, "How much each point of difficulty affects damage scaling. With the default value of 0.04 (1/25th) and max difficulty of 250, that's up to a 10x multiplier on added damage. So player's would take 11x damage at max difficulty, if the source scale is set to 1.0.");
        this.scaleMode = (Mode)Config.INSTANCE.loadEnum("Scaling Mode", "main.player.damage", Mode.class, Mode.MAX_HEALTH, "Set what value we scale against. MAX_HEALTH scales to player's max health MINUS starting health. Defaults to MAX_HEALTH if an invalid string is entered.");
        this.affectHostileMobs = config.getBoolean("Affect Hostile Mobs", "main.player.damage", false, "Also apply damage scaling to hostile mobs when they take damage.");
        this.affectPassiveMobs = config.getBoolean("Affect Passive Mobs", "main.player.damage", false, "Also apply damage scaling to passive mobs when they take damage.");
        ConfigMultiValueLineParser parser = new ConfigMultiValueLineParser("Scale By Source", ScalingHealth.logHelper, "\\s", new Class[]{String.class, Float.class});
        this.scalingMap.clear();
        String[] defaults = new String[SOURCES_DEFAULT.length];
        for (int i = 0; i < defaults.length; ++i) {
            defaults[i] = SOURCES_DEFAULT[i] + " 0.0";
        }
        for (String str : config.getStringList("Scale By Source", "main.player.damage", defaults, SOURCES_COMMENT)) {
            Object[] values = parser.parse(str);
            if (values == null) continue;
            this.scalingMap.put((String)values[0], (Float)values[1]);
        }
    }

    public static enum Mode {
        MAX_HEALTH,
        PLAYER_DIFFICULTY,
        AREA_DIFFICULTY;

    }
}

