/*
 * Decompiled with CFR 0.152.
 */
package artifacts.client.model.layer;

import artifacts.client.model.ModelAmulet;
import artifacts.client.model.ModelPanicNecklace;
import artifacts.client.model.ModelUltimatePendant;
import artifacts.client.model.layer.LayerBauble;
import artifacts.common.init.ModItems;
import artifacts.common.util.RenderHelper;
import baubles.api.BaubleType;
import baubles.api.BaublesApi;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.client.Minecraft;
import net.minecraft.client.model.ModelBase;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.renderer.entity.RenderPlayer;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ResourceLocation;

public class LayerAmulet
extends LayerBauble {
    private static final ResourceLocation SHOCK_TEXTURE = new ResourceLocation("artifacts", "textures/entity/layer/shock_pendant.png");
    private static final ResourceLocation FLAME_TEXTURE = new ResourceLocation("artifacts", "textures/entity/layer/flame_pendant.png");
    private static final ResourceLocation THORN_TEXTURE = new ResourceLocation("artifacts", "textures/entity/layer/thorn_pendant.png");
    private static final ResourceLocation PANIC_TEXTURE = new ResourceLocation("artifacts", "textures/entity/layer/panic_necklace.png");
    private static final ResourceLocation ULTIMATE_TEXTURE = new ResourceLocation("artifacts", "textures/entity/layer/ultimate_pendant.png");
    private static final ResourceLocation SACRIFICIAL_TEXTURE = new ResourceLocation("artifacts", "textures/entity/layer/sacrificial_amulet.png");
    private static final ModelBase AMULET_MODEL = new ModelAmulet();
    private static final ModelBase PANIC_MODEL = new ModelPanicNecklace();
    private static final ModelBase ULTIMATE_MODEL = new ModelUltimatePendant();

    public LayerAmulet(RenderPlayer renderPlayer) {
        super(renderPlayer);
    }

    @Override
    protected void renderLayer(@Nonnull EntityPlayer player, float limbSwing, float limbSwingAmount, float partialTicks, float ageInTicks, float netHeadYaw, float headPitch, float scale) {
        this.renderChest(player, limbSwing, limbSwingAmount, ageInTicks, netHeadYaw, headPitch, scale);
    }

    private void renderChest(@Nonnull EntityPlayer player, float limbSwing, float limbSwingAmount, float ageInTicks, float netHeadYaw, float headPitch, float scale) {
        ModelBase amulet = this.setTexturesGetModel(player);
        if (amulet == null) {
            return;
        }
        if (player.func_70093_af()) {
            GlStateManager.func_179109_b((float)0.0f, (float)0.2f, (float)0.0f);
        }
        this.modelPlayer.field_78115_e.func_78794_c(scale);
        amulet.func_78088_a((Entity)player, limbSwing, limbSwingAmount, ageInTicks, netHeadYaw, headPitch, scale);
    }

    private ModelBase setTexturesGetModel(EntityPlayer player) {
        ItemStack stack = BaublesApi.getBaublesHandler((EntityPlayer)player).getStackInSlot(BaubleType.AMULET.getValidSlots()[0]);
        if (!RenderHelper.shouldItemStackRender(player, stack)) {
            return null;
        }
        ResourceLocation textures = this.getTextures(stack);
        if (textures != null) {
            Minecraft.func_71410_x().func_110434_K().func_110577_a(textures);
            if (stack.func_77973_b() == ModItems.PANIC_NECKLACE) {
                return PANIC_MODEL;
            }
            if (stack.func_77973_b() == ModItems.ULTIMATE_PENDANT) {
                return ULTIMATE_MODEL;
            }
            return AMULET_MODEL;
        }
        return null;
    }

    @Nullable
    private ResourceLocation getTextures(ItemStack stack) {
        if (stack.func_77973_b() == ModItems.SHOCK_PENDANT) {
            return SHOCK_TEXTURE;
        }
        if (stack.func_77973_b() == ModItems.FLAME_PENDANT) {
            return FLAME_TEXTURE;
        }
        if (stack.func_77973_b() == ModItems.THORN_PENDANT) {
            return THORN_TEXTURE;
        }
        if (stack.func_77973_b() == ModItems.PANIC_NECKLACE) {
            return PANIC_TEXTURE;
        }
        if (stack.func_77973_b() == ModItems.ULTIMATE_PENDANT) {
            return ULTIMATE_TEXTURE;
        }
        if (stack.func_77973_b() == ModItems.SACRIFICIAL_AMULET) {
            return SACRIFICIAL_TEXTURE;
        }
        return null;
    }
}

