/*
 * Decompiled with CFR 0.152.
 */
package com.ferreusveritas.dynamictrees.util;

import com.ferreusveritas.dynamictrees.ModBlocks;
import com.ferreusveritas.dynamictrees.api.TreeHelper;
import com.ferreusveritas.dynamictrees.api.network.MapSignal;
import com.ferreusveritas.dynamictrees.blocks.BlockBranch;
import com.ferreusveritas.dynamictrees.blocks.BlockFruit;
import com.ferreusveritas.dynamictrees.blocks.BlockFruitCocoa;
import com.ferreusveritas.dynamictrees.blocks.BlockRooty;
import com.ferreusveritas.dynamictrees.blocks.BlockSurfaceRoot;
import com.ferreusveritas.dynamictrees.entities.EntityFallingTree;
import com.ferreusveritas.dynamictrees.systems.nodemappers.NodeCollector;
import com.ferreusveritas.dynamictrees.util.BlockBounds;
import com.ferreusveritas.dynamictrees.util.BranchDestructionData;
import com.ferreusveritas.dynamictrees.util.SimpleVoxmap;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Optional;
import net.minecraft.block.Block;
import net.minecraft.block.BlockSnow;
import net.minecraft.block.BlockVine;
import net.minecraft.block.state.IBlockState;
import net.minecraft.item.ItemStack;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.ChunkPos;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraft.world.chunk.Chunk;

public class ChunkTreeHelper {
    private static final int chunkWidth = 16;
    private static final byte NONE = 0;
    private static final byte TREE = 1;
    private static final byte SURR = 2;

    public static void removeOrphanedBranchNodes(World world, ChunkPos cPos, int radius) {
        if (cPos == null) {
            throw new NullPointerException("Null Chunk Position");
        }
        HashSet found = new HashSet();
        BlockBounds bounds = ChunkTreeHelper.getEffectiveBlockBounds(world, cPos, radius);
        for (BlockPos.MutableBlockPos pos : bounds.iterate()) {
            EnumFacing trunkDir;
            BlockPos trunkPos;
            IBlockState trunkState;
            Optional<BlockBranch> trunk;
            IBlockState state;
            Optional<BlockBranch> branchBlock;
            if (found.contains(pos) || !(branchBlock = TreeHelper.getBranchOpt(state = world.func_180495_p((BlockPos)pos))).isPresent()) continue;
            BlockPos rootPos = TreeHelper.findRootNode(world, (BlockPos)pos);
            if (rootPos == BlockPos.field_177992_a) {
                ChunkTreeHelper.doTreeDestroy(world, branchBlock, rootPos);
                continue;
            }
            IBlockState rootyState = world.func_180495_p(rootPos);
            Optional<BlockRooty> rootyBlock = TreeHelper.getRootyOpt(rootyState);
            if (!rootyBlock.isPresent() || !(trunk = TreeHelper.getBranchOpt(trunkState = world.func_180495_p(trunkPos = rootPos.func_177972_a(trunkDir = rootyBlock.get().getTrunkDirection((IBlockAccess)world, rootPos))))).isPresent()) continue;
            MapSignal signal = new MapSignal();
            signal.destroyLoopedNodes = false;
            trunk.get().analyse(trunkState, world, trunkPos, null, signal);
            if (signal.multiroot || signal.overflow) {
                ChunkTreeHelper.doTreeDestroy(world, branchBlock, (BlockPos)pos);
                continue;
            }
            trunk.get().analyse(trunkState, world, trunkPos, null, new MapSignal(new NodeCollector(found)));
        }
    }

    public static void removeAllBranchesFromChunk(World world, ChunkPos cPos, int radius) {
        if (cPos == null) {
            throw new NullPointerException("Null Chunk Position");
        }
        BlockBounds bounds = ChunkTreeHelper.getEffectiveBlockBounds(world, cPos, radius);
        for (BlockPos.MutableBlockPos pos : bounds.iterate()) {
            IBlockState state = world.func_180495_p((BlockPos)pos);
            Optional<BlockBranch> branchBlock = TreeHelper.getBranchOpt(state);
            if (!branchBlock.isPresent()) continue;
            ChunkTreeHelper.doTreeDestroy(world, branchBlock, (BlockPos)pos);
        }
    }

    public static BlockBounds getEffectiveBlockBounds(World world, ChunkPos cPos, int radius) {
        Chunk chunk = world.func_72964_e(cPos.field_77276_a, cPos.field_77275_b);
        BlockBounds bounds = new BlockBounds(world, cPos);
        bounds.shrink(EnumFacing.UP, world.func_72800_K() - 1 - (chunk.func_76625_h() + 16));
        for (EnumFacing dir : EnumFacing.field_176754_o) {
            bounds.expand(dir, radius * 16);
        }
        return bounds;
    }

    private static void doTreeDestroy(World world, Optional<BlockBranch> branchBlock, BlockPos pos) {
        BranchDestructionData destroyData = branchBlock.get().destroyBranchFromNode(world, pos, EnumFacing.DOWN, true);
        destroyData.leavesDrops.clear();
        EntityFallingTree.dropTree(world, destroyData, new ArrayList<ItemStack>(0), EntityFallingTree.DestroyType.ROOT);
        ChunkTreeHelper.cleanupNeighbors(world, destroyData);
    }

    public static void cleanupNeighbors(World world, BranchDestructionData destroyData) {
        if (world.field_72995_K) {
            return;
        }
        BlockBounds treeBounds = new BlockBounds(destroyData.cutPos);
        destroyData.getPositions(BranchDestructionData.PosType.LEAVES, true).forEach(pos -> treeBounds.union((BlockPos)pos));
        destroyData.getPositions(BranchDestructionData.PosType.BRANCHES, true).forEach(pos -> treeBounds.union((BlockPos)pos));
        treeBounds.expand(1);
        SimpleVoxmap treeVoxmap = new SimpleVoxmap(treeBounds);
        destroyData.getPositions(BranchDestructionData.PosType.LEAVES, true).forEach(pos -> treeVoxmap.setVoxel((BlockPos)pos, (byte)1));
        destroyData.getPositions(BranchDestructionData.PosType.BRANCHES, true).forEach(pos -> treeVoxmap.setVoxel((BlockPos)pos, (byte)1));
        SimpleVoxmap outlineVoxmap = new SimpleVoxmap(treeVoxmap);
        treeVoxmap.getAllNonZero((byte)1).forEach(pos -> {
            for (EnumFacing dir : EnumFacing.field_82609_l) {
                outlineVoxmap.setVoxel(pos.func_177971_a(dir.func_176730_m()), (byte)2);
            }
        });
        treeVoxmap.getAllNonZero((byte)1).forEach(pos -> outlineVoxmap.setVoxel((BlockPos)pos, (byte)0));
        outlineVoxmap.getAllNonZero((byte)2).forEach(pos -> ChunkTreeHelper.cleanupBlock(world, (BlockPos)pos));
    }

    public static void cleanupBlock(World world, BlockPos pos) {
        IBlockState blockstate = world.func_180495_p(pos);
        if (blockstate == ModBlocks.blockStates.air) {
            return;
        }
        Block block = blockstate.func_177230_c();
        if (block instanceof BlockSnow || block instanceof BlockFruit || block instanceof BlockFruitCocoa || block instanceof BlockSurfaceRoot) {
            world.func_180501_a(pos, ModBlocks.blockStates.air, 2);
        } else if (block instanceof BlockVine) {
            ChunkTreeHelper.cleanupVines(world, pos);
        }
    }

    public static void cleanupVines(World world, BlockPos pos) {
        BlockPos.MutableBlockPos mblock = new BlockPos.MutableBlockPos(pos);
        while (world.func_180495_p((BlockPos)mblock).func_177230_c() instanceof BlockVine) {
            world.func_180501_a((BlockPos)mblock, ModBlocks.blockStates.air, 2);
            mblock.func_189536_c(EnumFacing.DOWN);
        }
    }
}

