/*
 * Decompiled with CFR 0.152.
 */
package com.ferreusveritas.dynamictrees.blocks;

import com.ferreusveritas.dynamictrees.blocks.MimicProperty;
import com.ferreusveritas.dynamictrees.blocks.SpeciesProperty;
import com.ferreusveritas.dynamictrees.tileentity.TileEntityBonsai;
import com.ferreusveritas.dynamictrees.trees.Species;
import java.util.List;
import java.util.Random;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.BlockContainer;
import net.minecraft.block.BlockFlowerPot;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.state.BlockFaceShape;
import net.minecraft.block.state.BlockStateContainer;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.Entity;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.init.Items;
import net.minecraft.item.Item;
import net.minecraft.item.ItemBlock;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.BlockRenderLayer;
import net.minecraft.util.EnumBlockRenderType;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.common.property.ExtendedBlockState;
import net.minecraftforge.common.property.IExtendedBlockState;
import net.minecraftforge.common.property.IUnlistedProperty;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class BlockBonsaiPot
extends BlockContainer {
    public static final MimicProperty POT = new MimicProperty("pot");
    public static final String name = "bonsaipot";
    protected static final AxisAlignedBB FLOWER_POT_AABB = new AxisAlignedBB(0.3125, 0.0, 0.3125, 0.6875, 0.375, 0.6875);

    public BlockBonsaiPot() {
        this(name);
    }

    public BlockBonsaiPot(String name) {
        super(Blocks.field_150457_bL.func_149688_o(Blocks.field_150457_bL.func_176223_P()));
        this.setRegistryName(name);
        this.func_149663_c(this.getRegistryName().toString());
    }

    public Species getSpecies(IBlockAccess access, BlockPos pos) {
        TileEntityBonsai bonsaiPotTE = this.getTileEntityBonsai(access, pos);
        return bonsaiPotTE instanceof TileEntityBonsai ? bonsaiPotTE.getSpecies() : Species.NULLSPECIES;
    }

    public boolean setSpecies(World world, Species species, BlockPos pos) {
        TileEntityBonsai bonsaiPotTE = this.getTileEntityBonsai((IBlockAccess)world, pos);
        if (bonsaiPotTE instanceof TileEntityBonsai) {
            bonsaiPotTE.setSpecies(species);
            return true;
        }
        return false;
    }

    public IBlockState getPotState(IBlockAccess access, BlockPos pos) {
        TileEntityBonsai bonsaiPotTE = this.getTileEntityBonsai(access, pos);
        return bonsaiPotTE instanceof TileEntityBonsai ? bonsaiPotTE.getPot() : Blocks.field_150457_bL.func_176223_P();
    }

    public boolean setPotState(World world, IBlockState potState, BlockPos pos) {
        TileEntityBonsai bonsaiPotTE = this.getTileEntityBonsai((IBlockAccess)world, pos);
        if (bonsaiPotTE instanceof TileEntityBonsai) {
            bonsaiPotTE.setPot(potState);
            return true;
        }
        return false;
    }

    private TileEntityBonsai getTileEntityBonsai(IBlockAccess access, BlockPos pos) {
        TileEntity tileEntity = access.func_175625_s(pos);
        return tileEntity instanceof TileEntityBonsai ? (TileEntityBonsai)tileEntity : null;
    }

    public TileEntity func_149915_a(World worldIn, int meta) {
        return new TileEntityBonsai();
    }

    public boolean func_180639_a(World world, BlockPos pos, IBlockState state, EntityPlayer player, EnumHand hand, EnumFacing facing, float hitX, float hitY, float hitZ) {
        ItemStack heldItem = player.func_184586_b(hand);
        if (hand == EnumHand.MAIN_HAND && heldItem.func_77973_b() == ItemBlock.func_150898_a((Block)Blocks.field_150350_a)) {
            Species species = this.getSpecies((IBlockAccess)world, pos);
            if (!world.field_72995_K) {
                ItemStack seedStack = species.getSeedStack(1);
                world.func_72838_d((Entity)new EntityItem(world, (double)pos.func_177958_n(), (double)pos.func_177956_o(), (double)pos.func_177952_p(), seedStack));
            }
            world.func_175656_a(pos, this.getPotState((IBlockAccess)world, pos));
            return true;
        }
        return false;
    }

    public ItemStack getPickBlock(IBlockState state, RayTraceResult target, World world, BlockPos pos, EntityPlayer player) {
        Species species;
        if (target.field_178784_b == EnumFacing.UP && (species = this.getSpecies((IBlockAccess)world, pos)) != Species.NULLSPECIES) {
            return species.getSeedStack(1);
        }
        IBlockState potState = this.getPotState((IBlockAccess)world, pos);
        if (potState.func_177230_c() == Blocks.field_150457_bL) {
            return new ItemStack(Items.field_151162_bE);
        }
        if (potState.func_177230_c() instanceof BlockFlowerPot) {
            return new ItemStack(potState.func_177230_c(), 1, potState.func_177230_c().func_180651_a(potState));
        }
        return new ItemStack(Items.field_151162_bE);
    }

    @Nullable
    public Item func_180660_a(IBlockState state, Random rand, int fortune) {
        return Items.field_151162_bE;
    }

    public List<ItemStack> getDrops(IBlockAccess world, BlockPos pos, IBlockState state, int fortune) {
        List ret = super.getDrops(world, pos, state, fortune);
        ret.add(this.getSpecies(world, pos).getSeedStack(1));
        return ret;
    }

    public void func_189540_a(IBlockState state, World world, BlockPos pos, Block block, BlockPos fromPos) {
        if (!world.func_180495_p(pos.func_177977_b()).isSideSolid((IBlockAccess)world, pos, EnumFacing.UP)) {
            this.func_176226_b(world, pos, state, 0);
            world.func_175698_g(pos);
        }
    }

    public boolean removedByPlayer(IBlockState state, World world, BlockPos pos, EntityPlayer player, boolean willHarvest) {
        if (willHarvest) {
            return true;
        }
        return super.removedByPlayer(state, world, pos, player, willHarvest);
    }

    public void func_180657_a(World world, EntityPlayer player, BlockPos pos, IBlockState state, @Nullable TileEntity te, ItemStack tool) {
        super.func_180657_a(world, player, pos, state, te, tool);
        world.func_175698_g(pos);
    }

    protected BlockStateContainer func_180661_e() {
        return new ExtendedBlockState((Block)this, new IProperty[0], new IUnlistedProperty[]{SpeciesProperty.SPECIES, POT});
    }

    public IBlockState getExtendedState(IBlockState state, IBlockAccess access, BlockPos pos) {
        return state instanceof IExtendedBlockState ? ((IExtendedBlockState)state).withProperty((IUnlistedProperty)SpeciesProperty.SPECIES, (Object)this.getSpecies(access, pos)).withProperty((IUnlistedProperty)POT, (Object)this.getPotState(access, pos)) : state;
    }

    public AxisAlignedBB func_185496_a(IBlockState state, IBlockAccess source, BlockPos pos) {
        return FLOWER_POT_AABB;
    }

    public boolean func_149686_d(IBlockState state) {
        return false;
    }

    public boolean func_149662_c(IBlockState state) {
        return false;
    }

    @SideOnly(value=Side.CLIENT)
    public BlockRenderLayer func_180664_k() {
        return BlockRenderLayer.CUTOUT;
    }

    public EnumBlockRenderType func_149645_b(IBlockState state) {
        return EnumBlockRenderType.MODEL;
    }

    public BlockFaceShape func_193383_a(IBlockAccess worldIn, IBlockState state, BlockPos pos, EnumFacing face) {
        return face == EnumFacing.DOWN ? BlockFaceShape.CENTER_SMALL : BlockFaceShape.UNDEFINED;
    }
}

