/*
 * Decompiled with CFR 0.152.
 */
package ichttt.mods.firstaid.common.network;

import ichttt.mods.firstaid.FirstAid;
import ichttt.mods.firstaid.api.CapabilityExtendedHealthSystem;
import ichttt.mods.firstaid.api.damagesystem.AbstractPlayerDamageModel;
import ichttt.mods.firstaid.common.CapProvider;
import ichttt.mods.firstaid.common.network.MessageSyncDamageModel;
import io.netty.buffer.ByteBuf;
import java.util.Objects;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import net.minecraftforge.fml.common.network.simpleimpl.IMessageHandler;
import net.minecraftforge.fml.common.network.simpleimpl.MessageContext;

public class MessageClientRequest
implements IMessage {
    private Type type;

    public MessageClientRequest() {
    }

    public MessageClientRequest(Type type) {
        this.type = type;
    }

    public void fromBytes(ByteBuf buf) {
        this.type = Type.TYPES[buf.readByte()];
    }

    public void toBytes(ByteBuf buf) {
        buf.writeByte(this.type.ordinal());
    }

    public static class Handler
    implements IMessageHandler<MessageClientRequest, IMessage> {
        public IMessage onMessage(MessageClientRequest message, MessageContext ctx) {
            EntityPlayerMP player = ctx.getServerHandler().field_147369_b;
            player.func_184102_h().func_152344_a(() -> {
                if (message.type == Type.TUTORIAL_COMPLETE) {
                    CapProvider.tutorialDone.add(player.func_70005_c_());
                    Objects.requireNonNull(player.func_184102_h()).func_152344_a(() -> {
                        ((AbstractPlayerDamageModel)Objects.requireNonNull(player.getCapability(CapabilityExtendedHealthSystem.INSTANCE, null))).hasTutorial = true;
                    });
                } else if (message.type == Type.REQUEST_REFRESH) {
                    FirstAid.NETWORKING.sendTo((IMessage)new MessageSyncDamageModel((AbstractPlayerDamageModel)Objects.requireNonNull(player.getCapability(CapabilityExtendedHealthSystem.INSTANCE, null)), true), player);
                }
            });
            return null;
        }
    }

    public static enum Type {
        TUTORIAL_COMPLETE,
        REQUEST_REFRESH;

        private static final Type[] TYPES;

        static {
            TYPES = Type.values();
        }
    }
}

