/*
 * Decompiled with CFR 0.152.
 */
package de.Whitedraco.switchbow.helper;

import de.Whitedraco.switchbow.helper.ArrowItemStackEqual;
import de.Whitedraco.switchbow.item.ItemMagicQuiver;
import de.Whitedraco.switchbow.item.ItemQuiver;
import java.util.ArrayList;
import java.util.List;
import java.util.Vector;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.InventoryPlayer;
import net.minecraft.item.ItemArrow;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;

public class QuiverArrowHelper {
    private static void removeArrowFromQuiver(ItemStack quiver, ItemStack removeArrow) {
        if (quiver.func_77973_b() instanceof ItemMagicQuiver) {
            QuiverArrowHelper.removeArrowFromQuiver(18, quiver, removeArrow);
        } else if (quiver.func_77973_b() instanceof ItemQuiver) {
            QuiverArrowHelper.removeArrowFromQuiver(9, quiver, removeArrow);
        }
    }

    private static List<ItemStack> getArrowFromQuiver(ItemStack quiver) {
        if (quiver.func_77973_b() instanceof ItemMagicQuiver) {
            return QuiverArrowHelper.getArrowFromQuiver(18, quiver);
        }
        if (quiver.func_77973_b() instanceof ItemQuiver) {
            return QuiverArrowHelper.getArrowFromQuiver(9, quiver);
        }
        return new ArrayList<ItemStack>();
    }

    public static Vector<ItemStack> getArrowsInInvAndQuiver(EntityPlayer player, InventoryPlayer playerinventory) {
        Vector<ItemStack> arrows = new Vector<ItemStack>();
        for (ItemStack stack : playerinventory.field_70462_a) {
            if (stack != ItemStack.field_190927_a && stack.func_77973_b() instanceof ItemQuiver) {
                List<ItemStack> quiverArrow = QuiverArrowHelper.getArrowFromQuiver(stack);
                if (quiverArrow.isEmpty()) continue;
                for (int a = 0; a < quiverArrow.size(); ++a) {
                    ItemStack arrow = quiverArrow.get(a);
                    if (ArrowItemStackEqual.containsArrow(arrows, arrow)) continue;
                    arrows.add(arrow);
                }
                continue;
            }
            if (stack == ItemStack.field_190927_a || !(stack.func_77973_b() instanceof ItemArrow) || ArrowItemStackEqual.containsArrow(arrows, stack)) continue;
            arrows.addElement(stack);
        }
        if (player.func_184592_cb() != ItemStack.field_190927_a) {
            ItemStack stack = player.func_184592_cb();
            if (stack != ItemStack.field_190927_a && stack.func_77973_b() instanceof ItemQuiver) {
                List<ItemStack> quiverArrow = QuiverArrowHelper.getArrowFromQuiver(stack);
                if (!quiverArrow.isEmpty()) {
                    for (int a = 0; a < quiverArrow.size(); ++a) {
                        ItemStack arrow = quiverArrow.get(a);
                        if (ArrowItemStackEqual.containsArrow(arrows, arrow)) continue;
                        arrows.add(arrow);
                    }
                }
            } else if (player.func_184592_cb() != ItemStack.field_190927_a && stack.func_77973_b() instanceof ItemArrow && !ArrowItemStackEqual.containsArrow(arrows, stack)) {
                arrows.addElement(stack);
            }
        }
        return arrows;
    }

    private static List<ItemStack> getArrowFromQuiver(int size, ItemStack quiver) {
        ArrayList<ItemStack> arrows = new ArrayList<ItemStack>();
        if (quiver.func_77942_o()) {
            NBTTagList quiverArrows = quiver.func_77978_p().func_150295_c("ItemInventory", 10);
            for (int i = 0; i < quiverArrows.func_74745_c(); ++i) {
                ItemStack arrow;
                NBTTagCompound item = quiverArrows.func_150305_b(i);
                byte slot = item.func_74771_c("Slot");
                if (slot < 0 || slot >= size || (arrow = new ItemStack(item)) == null || arrow == ItemStack.field_190927_a || ArrowItemStackEqual.containsArrow(arrows, arrow)) continue;
                arrows.add(arrow);
            }
        }
        return arrows;
    }

    private static void removeArrowFromQuiver(int size, ItemStack quiver, ItemStack removeArrow) {
        boolean flag = true;
        if (quiver.func_77942_o()) {
            NBTTagList quiverArrows = quiver.func_77978_p().func_150295_c("ItemInventory", 10);
            ArrayList<ItemStack> arrows = new ArrayList<ItemStack>();
            for (int i = 0; i < quiverArrows.func_74745_c(); ++i) {
                ItemStack arrow;
                NBTTagCompound item = quiverArrows.func_150305_b(i);
                byte slot = item.func_74771_c("Slot");
                if (slot < 0 || slot >= size || (arrow = new ItemStack(item)) == null || arrow == ItemStack.field_190927_a) continue;
                if (ArrowItemStackEqual.containsArrow(arrow, removeArrow) && flag) {
                    arrow.func_190918_g(1);
                    if (arrow.func_190916_E() == 0) {
                        arrows.add(ItemStack.field_190927_a);
                    } else {
                        arrows.add(arrow);
                    }
                    flag = false;
                    continue;
                }
                arrows.add(arrow);
            }
            NBTTagList nbttaglist = new NBTTagList();
            for (int i = 0; i < arrows.size(); ++i) {
                ItemStack stack = (ItemStack)arrows.get(i);
                if (stack == ItemStack.field_190927_a || stack == null) continue;
                NBTTagCompound nbttagcompound1 = new NBTTagCompound();
                nbttagcompound1.func_74774_a("Slot", (byte)i);
                stack.func_77955_b(nbttagcompound1);
                nbttaglist.func_74742_a((NBTBase)nbttagcompound1);
            }
            quiver.func_77978_p().func_74782_a("ItemInventory", (NBTBase)nbttaglist);
        }
    }

    public static void removeArrow(EntityPlayer player, ItemStack removeArrow) {
        InventoryPlayer inventory = player.field_71071_by;
        ArrayList<ItemStack> quiverList = new ArrayList<ItemStack>();
        if (player.func_184592_cb() != ItemStack.field_190927_a) {
            ItemStack stack = player.func_184592_cb();
            if (stack.func_77973_b() instanceof ItemArrow) {
                if (ArrowItemStackEqual.containsArrow(stack, removeArrow)) {
                    stack.func_190918_g(1);
                    if (stack.func_190916_E() == 0) {
                        player.field_71071_by.func_184437_d(stack);
                    }
                    return;
                }
            } else if (stack.func_77973_b() instanceof ItemQuiver) {
                quiverList.add(stack);
            }
        }
        for (ItemStack stack : inventory.field_70462_a) {
            if (stack.func_77973_b() instanceof ItemArrow) {
                if (!ArrowItemStackEqual.containsArrow(stack, removeArrow)) continue;
                stack.func_190918_g(1);
                if (stack.func_190916_E() == 0) {
                    player.field_71071_by.func_184437_d(stack);
                }
                return;
            }
            if (!(stack.func_77973_b() instanceof ItemQuiver)) continue;
            quiverList.add(stack);
        }
        if (!quiverList.isEmpty()) {
            for (ItemStack quiver : quiverList) {
                if (!ArrowItemStackEqual.containsArrow(QuiverArrowHelper.getArrowFromQuiver(quiver), removeArrow)) continue;
                QuiverArrowHelper.removeArrowFromQuiver(quiver, removeArrow);
                return;
            }
        }
    }
}

