/*
 * Decompiled with CFR 0.152.
 */
package cursedflames.bountifulbaubles.util;

import cursedflames.bountifulbaubles.network.NBTPacket;
import cursedflames.bountifulbaubles.network.PacketHandler;
import java.io.File;
import java.util.HashMap;
import java.util.Map;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.common.config.Configuration;
import net.minecraftforge.common.config.Property;
import net.minecraftforge.fml.common.FMLCommonHandler;
import net.minecraftforge.fml.common.event.FMLPostInitializationEvent;
import net.minecraftforge.fml.common.event.FMLPreInitializationEvent;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.common.gameevent.PlayerEvent;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import net.minecraftforge.fml.relauncher.Side;
import org.apache.logging.log4j.Logger;

public class Config {
    public static Config config;
    final String version;
    Configuration configuration;
    Logger logger;
    boolean configReset = false;
    boolean isDedicatedServer;
    Map<String, Property> clientProps = new HashMap<String, Property>();
    Map<String, Property> localProps = new HashMap<String, Property>();
    Map<String, Property> syncedProps = new HashMap<String, Property>();
    Map<String, Property> serverProps = new HashMap<String, Property>();

    public Map<String, Property> getLocalPropMap(EnumPropSide side) {
        if (side == EnumPropSide.CLIENT) {
            return this.clientProps;
        }
        if (side == EnumPropSide.SERVER) {
            return this.serverProps;
        }
        return this.localProps;
    }

    public Map<String, Property> getSyncedPropMap() {
        if (this.isDedicatedServer) {
            return this.localProps;
        }
        return this.syncedProps;
    }

    public Property getSyncedProperty(String key) {
        if (this.syncedProps.containsKey(key)) {
            return this.syncedProps.get(key);
        }
        if (!this.localProps.containsKey(key)) {
            return null;
        }
        Property copy = this.copyProperty(this.localProps.get(key));
        this.syncedProps.put(key, copy);
        return copy;
    }

    public Config(String version, Logger logger) {
        this.version = version;
        this.logger = logger;
        config = this;
        this.isDedicatedServer = FMLCommonHandler.instance().getSide() == Side.SERVER;
    }

    public void preInit(FMLPreInitializationEvent e) {
        File directory = e.getModConfigurationDirectory();
        File configFile = new File(directory.getPath(), "bountifulbaubles.cfg");
        this.configuration = new Configuration(configFile, this.version);
        MinecraftForge.EVENT_BUS.register((Object)this);
    }

    public void postInit(FMLPostInitializationEvent e) {
        if (this.configuration.hasChanged()) {
            this.configuration.save();
        }
    }

    private Property copyProperty(Property prop) {
        if (prop == null) {
            return null;
        }
        Property.Type type = prop.getType();
        Property prop1 = new Property(prop.getName(), prop.getString(), type, prop.getValidValues(), prop.getLanguageKey());
        prop1.setComment(prop.getComment());
        return prop1;
    }

    public void readConfig() {
        try {
            this.configuration.load();
        }
        catch (Exception e) {
            this.logger.error("Failed to load config: ", (Throwable)e);
        }
        finally {
            if (this.configuration.hasChanged() || this.configReset) {
                this.configuration.save();
            }
        }
    }

    public Property addPropInt(String name, String category, String desc, int defaultVal, EnumPropSide side) {
        Property prop = this.configuration.get(category, name, defaultVal);
        prop.setComment(desc);
        this.getLocalPropMap(side).put(name, prop);
        return prop;
    }

    public Property addPropInt(String name, String category, String desc, int defaultVal, EnumPropSide side, int min, int max) {
        Property prop = this.addPropInt(name, category, desc, defaultVal, side);
        prop.setMinValue(min);
        prop.setMaxValue(max);
        return prop;
    }

    public Property addPropDouble(String name, String category, String desc, double defaultVal, EnumPropSide side) {
        Property prop = this.configuration.get(category, name, defaultVal);
        prop.setComment(desc);
        this.getLocalPropMap(side).put(name, prop);
        return prop;
    }

    public Property addPropDouble(String name, String category, String desc, double defaultVal, EnumPropSide side, double min, double max) {
        Property prop = this.addPropDouble(name, category, desc, defaultVal, side);
        prop.setMinValue(min);
        prop.setMaxValue(max);
        return prop;
    }

    public Property addPropBoolean(String name, String category, String desc, boolean defaultVal, EnumPropSide side) {
        Property prop = this.configuration.get(category, name, defaultVal);
        prop.setComment(desc);
        this.getLocalPropMap(side).put(name, prop);
        return prop;
    }

    public Property addPropString(String name, String category, String desc, String defaultVal, EnumPropSide side) {
        Property prop = this.configuration.get(category, name, defaultVal);
        prop.setComment(desc);
        this.getLocalPropMap(side).put(name, prop);
        return prop;
    }

    public Property addPropStringList(String name, String category, String desc, String[] defaultVal, EnumPropSide side) {
        Property prop = this.configuration.get(category, name, defaultVal);
        prop.setComment(desc);
        this.getLocalPropMap(side).put(name, prop);
        return prop;
    }

    @SubscribeEvent
    public void onPlayerLoggedIn(PlayerEvent.PlayerLoggedInEvent event) {
        if (!event.player.field_70170_p.field_72995_K) {
            this.logger.info("Attempting to sync config to player " + event.player.func_70005_c_());
            NBTTagCompound tag = this.getSyncTag();
            NBTTagCompound tag1 = new NBTTagCompound();
            tag1.func_74782_a("values", (NBTBase)tag);
            PacketHandler.INSTANCE.sendTo((IMessage)new NBTPacket(tag1, PacketHandler.HandlerIds.SYNC_SERVER_DATA.id), (EntityPlayerMP)event.player);
        }
    }

    public NBTTagCompound getSyncTag() {
        NBTTagCompound tag = new NBTTagCompound();
        for (String key : this.localProps.keySet()) {
            Property prop = this.localProps.get(key);
            Property.Type type = prop.getType();
            if (type == Property.Type.INTEGER) {
                tag.func_74768_a(key, prop.getInt());
                continue;
            }
            if (type == Property.Type.DOUBLE) {
                tag.func_74780_a(key, prop.getDouble());
                continue;
            }
            if (type == Property.Type.BOOLEAN) {
                tag.func_74757_a(key, prop.getBoolean());
                continue;
            }
            if (type != Property.Type.STRING) continue;
            tag.func_74778_a(key, prop.getString());
        }
        return tag;
    }

    public void loadSyncTag(NBTTagCompound tag) {
        for (String key : tag.func_150296_c()) {
            Property prop = this.localProps.get(key);
            if (prop == null) {
                this.logger.warn("Attempted to load nonexistent config value \"" + key + "\"");
                continue;
            }
            Property.Type type = prop.getType();
            Property propSynced = this.getSyncedProperty(key);
            if (type == Property.Type.INTEGER) {
                propSynced.setValue(tag.func_74762_e(key));
                continue;
            }
            if (type == Property.Type.DOUBLE) {
                propSynced.setValue(tag.func_74769_h(key));
                continue;
            }
            if (type == Property.Type.BOOLEAN) {
                propSynced.setValue(tag.func_74767_n(key));
                continue;
            }
            if (type != Property.Type.STRING) continue;
            propSynced.setValue(tag.func_74779_i(key));
        }
    }

    public static enum EnumPropSide {
        CLIENT,
        SERVER,
        SYNCED;

    }
}

