/*
 * Decompiled with CFR 0.152.
 */
package ftblag.lagbgonrevived;

import ftblag.lagbgonrevived.LBGCommand;
import ftblag.lagbgonrevived.LBGConfig;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityAgeable;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.passive.EntityTameable;
import net.minecraft.util.ClassInheritanceMultiMap;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentString;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.world.chunk.Chunk;
import net.minecraftforge.event.entity.living.BabyEntitySpawnEvent;
import net.minecraftforge.event.entity.living.LivingSpawnEvent;
import net.minecraftforge.fml.common.FMLCommonHandler;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.common.eventhandler.Event;
import net.minecraftforge.fml.common.eventhandler.EventPriority;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.common.gameevent.TickEvent;

@Mod.EventBusSubscriber(modid="lagbgonrevived")
public class LBGEvents {
    public static long nextUnload;
    public static long nextClear;
    private static boolean warned;
    private static long tick;

    @SubscribeEvent
    public static void onEntitySpawn(LivingSpawnEvent.CheckSpawn e) {
        if (e.getEntity() == null || e.getWorld().field_72995_K) {
            return;
        }
        if (!LBGConfig.effectsOnSP && FMLCommonHandler.instance().getMinecraftServerInstance().func_184103_al().func_72394_k() <= 1) {
            return;
        }
        Entity ent = e.getEntity();
        if (ent.field_70175_ag || !ent.func_184222_aU() || ent.func_145818_k_() || ent instanceof EntityTameable && ((EntityTameable)ent).func_70909_n()) {
            return;
        }
        if (LBGConfig.perChunkSpawnLimit > 0 && ent instanceof EntityLiving) {
            BlockPos pos = ent.func_180425_c();
            if (e.getWorld().func_175667_e(pos)) {
                Chunk chunk = e.getWorld().func_175726_f(pos);
                int count = 0;
                for (ClassInheritanceMultiMap list : chunk.func_177429_s()) {
                    count += list.size();
                }
                if (count >= LBGConfig.perChunkSpawnLimit) {
                    e.setResult(Event.Result.DENY);
                }
            }
        }
    }

    @SubscribeEvent(priority=EventPriority.HIGH)
    public static void onBabySpawn(BabyEntitySpawnEvent e) {
        if (e.getChild() == null || e.getChild().field_70170_p.field_72995_K) {
            return;
        }
        if (!LBGConfig.effectsOnSP && FMLCommonHandler.instance().getMinecraftServerInstance().func_184103_al().func_72394_k() <= 1) {
            return;
        }
        EntityAgeable ent = e.getChild();
        if (LBGConfig.policeCrowd) {
            if (LBGConfig.crowdLimit <= 1) {
                e.setCanceled(true);
                return;
            }
            int amt = ent.field_70170_p.func_72872_a(EntityAgeable.class, new AxisAlignedBB(ent.func_180425_c()).func_186662_g(5.0)).size();
            if (amt > LBGConfig.crowdLimit) {
                e.setCanceled(true);
            }
        }
    }

    @SubscribeEvent
    public static void onServerTick(TickEvent.ServerTickEvent event) {
        if (event.phase == TickEvent.Phase.START || !LBGConfig.automaticRemoval) {
            return;
        }
        if (!LBGConfig.effectsOnSP && FMLCommonHandler.instance().getMinecraftServerInstance().func_184103_al().func_72394_k() <= 1) {
            return;
        }
        if (++tick % 200L == 0L) {
            LBGCommand.checkTPS();
            if (nextClear <= 0L) {
                nextClear = System.currentTimeMillis() + (long)LBGConfig.entityInterval * 1000L * 60L;
            } else if (nextClear < System.currentTimeMillis()) {
                if (warned) {
                    LBGCommand.doClear();
                    warned = false;
                } else {
                    nextClear = System.currentTimeMillis() + 60000L;
                    FMLCommonHandler.instance().getMinecraftServerInstance().func_184103_al().func_148539_a((ITextComponent)new TextComponentString(TextFormatting.RED.toString() + TextFormatting.BOLD.toString() + "Lag'B'Gon will be clearing entities in 1 minute!"));
                    warned = true;
                }
            }
        }
    }

    static {
        warned = false;
        tick = 0L;
    }
}

