/*
 * Decompiled with CFR 0.152.
 */
package ftblag.lagbgonrevived;

import com.google.common.collect.Lists;
import ftblag.lagbgonrevived.LBGConfig;
import ftblag.lagbgonrevived.LBGEvents;
import ftblag.lagbgonrevived.LagBGonRevived;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import net.minecraft.command.CommandBase;
import net.minecraft.command.CommandException;
import net.minecraft.command.ICommandSender;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityList;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.entity.passive.EntityTameable;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.item.Item;
import net.minecraft.server.MinecraftServer;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.ChunkPos;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentString;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.world.WorldServer;
import net.minecraft.world.chunk.Chunk;
import net.minecraft.world.gen.ChunkProviderServer;
import net.minecraftforge.common.DimensionManager;
import net.minecraftforge.fml.common.FMLCommonHandler;

public class LBGCommand
extends CommandBase {
    private static final String[] al = new String[]{"toggleitem", "toggleentity", "clear", "unload", "toggleauto", "togglededi", "settps", "itemblacklist", "entityblacklist", "togglepolice", "setbreedlimit", "maxperchunk"};

    public String func_71517_b() {
        return "bgon";
    }

    public String func_71518_a(ICommandSender sender) {
        return "/bgon : Shows help for using Lag'B'Gon Revived";
    }

    public int func_82362_a() {
        return 2;
    }

    public List<String> func_184883_a(MinecraftServer server, ICommandSender sender, String[] args, BlockPos pos) {
        if (args.length == 1) {
            return LBGCommand.func_71530_a((String[])args, (String[])al);
        }
        if (args.length == 2 && args[0].equals("toggleentity")) {
            return LBGCommand.func_175762_a((String[])args, (Collection)EntityList.func_180124_b());
        }
        return Collections.emptyList();
    }

    public void func_184881_a(MinecraftServer server, ICommandSender sender, String[] args) throws CommandException {
        if (args.length == 0) {
            LagBGonRevived.sendMsg(sender, "/bgon toggleitem: Toggles the blacklist status of held item.");
            LagBGonRevived.sendMsg(sender, "/bgon toggleitem <modid:name>: Toggles the blacklist status of the named item.");
            LagBGonRevived.sendMsg(sender, "/bgon toggleentity <modid:name>: Toggles the blacklist status of the named entity.");
            LagBGonRevived.sendMsg(sender, "/bgon clear: Clears all items/entities from the world not on blacklist.");
            LagBGonRevived.sendMsg(sender, "/bgon clear <minutes>: Sets the interval for automatic running of /bgon clear.");
            LagBGonRevived.sendMsg(sender, "/bgon unload: Unloads unused chunks.");
            LagBGonRevived.sendMsg(sender, "/bgon unload <minutes>: Sets the interval for automatic running of /bgon unload.");
            LagBGonRevived.sendMsg(sender, "/bgon toggleauto: Toggles automatic clearing of entities, and unloading of chunks.");
            LagBGonRevived.sendMsg(sender, "/bgon togglededi: Toggles all non-command effects when not on a dedicated server.");
            LagBGonRevived.sendMsg(sender, "/bgon settps <target tps>: Sets the maximum TPS for unloading chunks.");
            LagBGonRevived.sendMsg(sender, "/bgon itemblacklist: Switches between using blacklist and whitelist for items.");
            LagBGonRevived.sendMsg(sender, "/bgon entityblacklist: Switches between using blacklist and whitelist for entities.");
            LagBGonRevived.sendMsg(sender, "/bgon togglepolice: Toggles Breeding policing.");
            LagBGonRevived.sendMsg(sender, "/bgon setbreedlimit <amount>: Sets the limit for breeding.");
            LagBGonRevived.sendMsg(sender, "/bgon maxperchunk <amount>: Sets maximum entities to spawn per chunk.");
        } else if (args.length == 1) {
            switch (args[0]) {
                case "toggleitem": {
                    if (!(sender instanceof EntityPlayer)) {
                        LagBGonRevived.sendMsg(sender, "Only for players!");
                        break;
                    }
                    EntityPlayer plr = (EntityPlayer)sender;
                    if (plr.func_184614_ca().func_190926_b()) {
                        LagBGonRevived.sendMsg(sender, "You must have an item held");
                        break;
                    }
                    Item item = plr.func_184614_ca().func_77973_b();
                    String name = item.getRegistryName().toString();
                    LBGConfig.toggleItem(name);
                    boolean added = LBGConfig.isBlacklisted(item, true);
                    LagBGonRevived.sendMsg(sender, name + (added ? " added to" : " removed from") + " blacklist.");
                    break;
                }
                case "clear": {
                    LBGCommand.doClear();
                    break;
                }
                case "unload": {
                    LBGCommand.unloadChunks();
                    break;
                }
                case "toggleauto": {
                    LBGConfig.toggleAuto();
                    LagBGonRevived.sendMsg(sender, "Automatic clearing " + (LBGConfig.automaticRemoval ? "en" : "dis") + "abled.");
                    break;
                }
                case "togglededi": {
                    LBGConfig.toggleEffectSP();
                    LagBGonRevived.sendMsg(sender, "Non-Dedicated Server effects " + (LBGConfig.effectsOnSP ? "en" : "dis") + "abled.");
                    break;
                }
                case "itemblacklist": {
                    LBGConfig.toggleItemBlacklist();
                    LagBGonRevived.sendMsg(sender, "Item " + (LBGConfig.toggleItemBlacklist ? "Black" : "White") + "list enabled.");
                    break;
                }
                case "entityblacklist": {
                    LBGConfig.toggleEntityBlacklist();
                    LagBGonRevived.sendMsg(sender, "Entity " + (LBGConfig.toggleEntityBlacklist ? "Black" : "White") + "list enabled.");
                    break;
                }
                case "togglepolice": {
                    LBGConfig.togglePolice();
                    LagBGonRevived.sendMsg(sender, "Breeding policing " + (LBGConfig.policeCrowd ? "en" : "dis") + "abled.");
                    break;
                }
                default: {
                    LagBGonRevived.sendMsg(sender, "Cmd not found!");
                    break;
                }
            }
        } else if (args.length == 2) {
            switch (args[0]) {
                case "toggleitem": {
                    LBGConfig.toggleItem(args[1]);
                    LagBGonRevived.sendMsg(sender, args[1] + " has been " + (LBGConfig.isBlacklisted(args[1], false) ? "added to" : "removed from") + " the item blacklist.");
                    break;
                }
                case "toggleentity": {
                    LBGConfig.toggleEntity(args[1]);
                    LagBGonRevived.sendMsg(sender, args[1] + " has been " + (LBGConfig.isBlacklisted(args[1], true) ? "added to" : "removed from") + " the entity blacklist.");
                    break;
                }
                case "clear": {
                    int clearInter = LBGCommand.parseIntElse(args[1], 0);
                    LBGConfig.changeEntityInterval(clearInter);
                    LBGEvents.nextClear = System.currentTimeMillis() + (long)LBGConfig.entityInterval * 1000L * 60L;
                    LagBGonRevived.sendMsg(sender, "Automatic entity clear interval set to: " + LBGConfig.entityInterval);
                    break;
                }
                case "unload": {
                    int unloadInter = LBGCommand.parseIntElse(args[1], 0);
                    LBGConfig.changeUnloadInterval(unloadInter);
                    LBGEvents.nextUnload = System.currentTimeMillis() + (long)LBGConfig.unloadInterval * 1000L * 60L;
                    LagBGonRevived.sendMsg(sender, "Automatic chunk unload interval set to: " + LBGConfig.unloadInterval);
                    break;
                }
                case "settps": {
                    int newTPS = LBGCommand.parseIntElse(args[1], 0);
                    LBGConfig.changeTPSForUnload(newTPS);
                    LagBGonRevived.sendMsg(sender, "TPS threshold set to: " + LBGConfig.TPSForUnload);
                    break;
                }
                case "setbreedlimit": {
                    int limit = LBGCommand.parseIntElse(args[1], 0);
                    LBGConfig.changeCrowdLimit(limit);
                    LagBGonRevived.sendMsg(sender, "Breeding limit set to: " + LBGConfig.crowdLimit);
                    break;
                }
                case "maxperchunk": {
                    int max = LBGCommand.parseIntElse(args[1], 0);
                    LBGConfig.changeMaxPerChunk(max);
                    LagBGonRevived.sendMsg(sender, "Spawns per chunk limit set to: " + LBGConfig.perChunkSpawnLimit);
                    break;
                }
                default: {
                    LagBGonRevived.sendMsg(sender, "Cmd not found!");
                    break;
                }
            }
        } else {
            LagBGonRevived.sendMsg(sender, "Cmd not found!");
        }
    }

    public static void doClear() {
        int itemsRemoved = 0;
        int entitiesRemoved = 0;
        int totalItems = 0;
        int totalEntities = 0;
        ArrayList<Entity> toRemove = new ArrayList<Entity>();
        for (WorldServer world : DimensionManager.getWorlds()) {
            if (world == null || world.field_72995_K) continue;
            for (Entity obj : world.field_72996_f) {
                if (obj instanceof EntityItem) {
                    ++totalItems;
                    if (LBGConfig.toggleItemBlacklist == LBGConfig.isBlacklisted(((EntityItem)obj).func_92059_d().func_77973_b(), false) || obj.field_70173_aa < 1200 || obj.func_145818_k_()) continue;
                    toRemove.add(obj);
                    ++itemsRemoved;
                    continue;
                }
                if (obj instanceof EntityPlayer) continue;
                ++totalEntities;
                if (LBGConfig.toggleEntityBlacklist == LBGConfig.isBlacklisted(obj, false) || obj.field_70173_aa < 1200 || !obj.func_184222_aU() || obj.func_145818_k_() || obj instanceof EntityTameable && ((EntityTameable)obj).func_70909_n()) continue;
                toRemove.add(obj);
                ++entitiesRemoved;
            }
            for (Entity e : toRemove) {
                e.func_70106_y();
            }
            toRemove.clear();
        }
        LBGEvents.nextClear = System.currentTimeMillis() + (long)LBGConfig.entityInterval * 1000L * 60L;
        FMLCommonHandler.instance().getMinecraftServerInstance().func_184103_al().func_148539_a((ITextComponent)new TextComponentString(TextFormatting.GREEN.toString() + "Lag'B'Gon has removed " + itemsRemoved + "/" + totalItems + " items and " + entitiesRemoved + "/" + totalEntities + " entities."));
    }

    private static int parseIntElse(String in, int def) {
        try {
            return Integer.parseInt(in);
        }
        catch (NumberFormatException e) {
            return def;
        }
    }

    private static long mean(long[] num) {
        long val = 0L;
        for (long n : num) {
            val += n;
        }
        return val / (long)num.length;
    }

    private static void unloadChunks() {
        ArrayList playerPos = Lists.newArrayList();
        int radius = FMLCommonHandler.instance().getMinecraftServerInstance().func_184103_al().func_72395_o();
        for (EntityPlayerMP player : FMLCommonHandler.instance().getMinecraftServerInstance().func_184103_al().func_181057_v()) {
            for (int x = player.field_70176_ah - radius; x <= player.field_70176_ah + radius; ++x) {
                for (int z = player.field_70164_aj - radius; z <= player.field_70164_aj + radius; ++z) {
                    playerPos.add(new ChunkPos(x, z));
                }
            }
        }
        int chunksQueued = 0;
        for (WorldServer world : DimensionManager.getWorlds()) {
            ChunkProviderServer cPS = world.func_72863_F();
            for (Chunk chunk : cPS.field_73244_f.values()) {
                ChunkPos chunkPos = chunk.func_76632_l();
                if (world.getPersistentChunks().containsKey((Object)chunkPos) || playerPos.contains(chunkPos) || !world.field_73011_w.func_186056_c(chunkPos.field_77276_a, chunkPos.field_77275_b)) continue;
                ++chunksQueued;
                cPS.func_189549_a(chunk);
            }
        }
        playerPos.clear();
        LBGEvents.nextUnload = System.currentTimeMillis() + (long)LBGConfig.unloadInterval * 1000L * 60L;
        FMLCommonHandler.instance().getMinecraftServerInstance().func_184103_al().func_148539_a((ITextComponent)new TextComponentString(TextFormatting.GREEN.toString() + "Lag'B'Gon queued " + chunksQueued + " to be unloaded."));
    }

    public static void checkTPS() {
        double meanTickTime;
        double meanTPS;
        if (LBGEvents.nextUnload <= 0L) {
            LBGEvents.nextUnload = System.currentTimeMillis() + (long)LBGConfig.unloadInterval * 1000L * 60L;
        } else if (LBGEvents.nextUnload < System.currentTimeMillis() && (meanTPS = Math.min(1000.0 / (meanTickTime = (double)LBGCommand.mean(FMLCommonHandler.instance().getMinecraftServerInstance().field_71311_j) * 1.0E-6), 20.0)) < (double)LBGConfig.TPSForUnload) {
            LBGCommand.unloadChunks();
        }
    }
}

