/*
 * Decompiled with CFR 0.152.
 */
package com.lycanitesmobs.core.item.equipment.features;

import com.google.gson.JsonObject;
import com.lycanitesmobs.client.localisation.LanguageManager;
import com.lycanitesmobs.core.entity.BaseProjectileEntity;
import com.lycanitesmobs.core.entity.CustomProjectileEntity;
import com.lycanitesmobs.core.entity.ExtendedEntity;
import com.lycanitesmobs.core.info.projectile.ProjectileInfo;
import com.lycanitesmobs.core.info.projectile.ProjectileManager;
import com.lycanitesmobs.core.item.equipment.features.EquipmentFeature;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.util.EnumHand;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.math.Vec3d;
import net.minecraft.world.World;

public class ProjectileEquipmentFeature
extends EquipmentFeature {
    public String projectileName;
    public String projectileTrigger = "secondary";
    public String projectilePattern = "simple";
    public double hitChance = 0.05;
    public int cooldown = 2;
    public int count = 1;
    public double spreadX = 0.0;
    public double spreadY = 0.0;
    public double ringRange = 0.0;
    public int bonusDamage = 0;
    private BaseProjectileEntity channeledProjectile;

    @Override
    public void loadFromJSON(JsonObject json) {
        super.loadFromJSON(json);
        this.projectileName = json.get("projectileName").getAsString();
        if (json.has("projectileTrigger")) {
            this.projectileTrigger = json.get("projectileTrigger").getAsString();
        }
        if (json.has("projectilePattern")) {
            this.projectilePattern = json.get("projectilePattern").getAsString();
        }
        if (json.has("hitChance")) {
            this.hitChance = json.get("hitChance").getAsDouble();
        }
        if (json.has("cooldown")) {
            this.cooldown = json.get("cooldown").getAsInt();
        }
        if (json.has("count")) {
            this.count = json.get("count").getAsInt();
        }
        if (json.has("spreadX")) {
            this.spreadX = json.get("spreadX").getAsDouble();
        }
        if (json.has("spreadY")) {
            this.spreadY = json.get("spreadY").getAsDouble();
        }
        if (json.has("ringRange")) {
            this.ringRange = json.get("ringRange").getAsDouble();
        }
        if (json.has("bonusDamage")) {
            this.bonusDamage = json.get("bonusDamage").getAsInt();
        }
    }

    @Override
    public boolean isActive(ItemStack itemStack, int level) {
        if (!super.isActive(itemStack, level)) {
            return false;
        }
        return ProjectileManager.getInstance().getProjectile(this.projectileName) != null;
    }

    @Override
    public String getDescription(ItemStack itemStack, int level) {
        if (!this.isActive(itemStack, level)) {
            return null;
        }
        ProjectileInfo projectileInfo = ProjectileManager.getInstance().getProjectile(this.projectileName);
        String description = LanguageManager.translate("equipment.feature." + this.featureType) + " " + projectileInfo.getTitle();
        if (!"simple".equals(this.projectilePattern)) {
            description = description + " " + LanguageManager.translate("equipment.feature.projectile.pattern." + this.projectilePattern);
        }
        description = description + " " + LanguageManager.translate("equipment.feature.projectile.trigger." + this.projectileTrigger);
        description = "hit".equals(this.projectileTrigger) ? description + " " + String.format("%.0f", this.hitChance * 100.0) + "%" : description + " " + String.format("%.1f", Float.valueOf((float)this.cooldown / 20.0f)) + "s";
        return description;
    }

    @Override
    public String getSummary(ItemStack itemStack, int level) {
        if (!this.isActive(itemStack, level)) {
            return null;
        }
        ProjectileInfo projectileInfo = ProjectileManager.getInstance().getProjectile(this.projectileName);
        String summary = projectileInfo.getTitle();
        if (this.bonusDamage != 0) {
            summary = summary + " +" + this.bonusDamage;
        }
        return summary;
    }

    public boolean onUsePrimary(World world, EntityPlayer shooter, EnumHand hand) {
        if (!"primary".equalsIgnoreCase(this.projectileTrigger)) {
            return false;
        }
        ExtendedEntity shooterExt = ExtendedEntity.getForEntity((EntityLivingBase)shooter);
        if (shooterExt == null) {
            return false;
        }
        if (shooterExt.getProjectileCooldown(1, this.projectileName) > 0) {
            return false;
        }
        shooterExt.setProjectileCooldown(1, this.projectileName, this.cooldown);
        this.fireProjectile((EntityLivingBase)shooter);
        return true;
    }

    public boolean onUseSecondary(World world, EntityPlayer shooter, EnumHand hand) {
        return "secondary".equalsIgnoreCase(this.projectileTrigger);
    }

    public boolean onHoldSecondary(EntityLivingBase shooter, int count) {
        if (!"secondary".equalsIgnoreCase(this.projectileTrigger)) {
            return false;
        }
        ExtendedEntity shooterExt = ExtendedEntity.getForEntity(shooter);
        if (shooterExt == null) {
            return false;
        }
        if (shooterExt.getProjectileCooldown(2, this.projectileName) > 0) {
            return false;
        }
        shooterExt.setProjectileCooldown(2, this.projectileName, this.cooldown);
        this.fireProjectile(shooter);
        return true;
    }

    public boolean onHitEntity(ItemStack itemStack, EntityLivingBase target, EntityLivingBase attacker) {
        if (target == null || attacker == null || attacker.func_130014_f_().field_72995_K || attacker.func_70093_af() || !"hit".equals(this.projectileTrigger)) {
            return false;
        }
        if (attacker.func_70681_au().nextDouble() <= this.hitChance) {
            this.fireProjectile(attacker);
            return true;
        }
        return false;
    }

    public void fireProjectile(EntityLivingBase shooter) {
        CustomProjectileEntity customProjectileEntity;
        if (shooter == null || shooter.func_130014_f_().field_72995_K || this.count <= 0) {
            return;
        }
        if (this.channeledProjectile != null) {
            if (!this.channeledProjectile.func_70089_S()) {
                this.channeledProjectile = null;
            } else {
                this.channeledProjectile.projectileLife = 20;
                return;
            }
        }
        World world = shooter.func_130014_f_();
        BaseProjectileEntity mainProjectile = null;
        Vec3d firePos = new Vec3d(shooter.field_70165_t, shooter.field_70163_u + (double)shooter.field_70131_O * 0.65, shooter.field_70161_v);
        double offsetX = 0.0;
        if ("spread".equals(this.projectilePattern)) {
            this.count = 10;
            this.spreadX = 45.0;
            this.spreadY = 10.0;
            for (int i = 0; i < this.count; ++i) {
                double yaw = (double)shooter.field_70177_z + this.spreadX * shooter.func_70681_au().nextDouble() - this.spreadX / 2.0;
                double pitch = (double)shooter.field_70125_A + this.spreadY * shooter.func_70681_au().nextDouble() - this.spreadY / 2.0;
                ProjectileInfo projectileInfo = ProjectileManager.getInstance().getProjectile(this.projectileName);
                BaseProjectileEntity projectile = projectileInfo.createProjectile(world, shooter);
                projectile.func_70107_b(firePos.field_72450_a, firePos.field_72448_b, firePos.field_72449_c);
                projectile.func_184538_a((Entity)shooter, (float)pitch, (float)yaw - (float)offsetX, 0.0f, (float)projectileInfo.velocity, 0.0f);
                projectile.setBonusDamage(this.bonusDamage);
                world.func_72838_d((Entity)projectile);
                mainProjectile = projectile;
            }
        } else if ("ring".equals(this.projectilePattern)) {
            double angle = this.ringRange / (double)this.count;
            for (int i = 0; i < this.count; ++i) {
                double yaw = (double)shooter.field_70177_z + angle * (double)i - this.ringRange / 2.0;
                ProjectileInfo projectileInfo = ProjectileManager.getInstance().getProjectile(this.projectileName);
                BaseProjectileEntity projectile = projectileInfo.createProjectile(world, shooter);
                projectile.func_70107_b(firePos.field_72450_a, firePos.field_72448_b, firePos.field_72449_c);
                projectile.setBonusDamage(this.bonusDamage);
                world.func_72838_d((Entity)projectile);
                projectile.func_184538_a((Entity)shooter, shooter.field_70125_A, (float)yaw - (float)offsetX, 0.0f, (float)projectileInfo.velocity, 0.0f);
                mainProjectile = projectile;
            }
        } else {
            ProjectileInfo projectileInfo = ProjectileManager.getInstance().getProjectile(this.projectileName);
            mainProjectile = projectileInfo.createProjectile(world, shooter);
            mainProjectile.func_70107_b(firePos.field_72450_a, firePos.field_72448_b, firePos.field_72449_c);
            mainProjectile.func_184538_a((Entity)shooter, shooter.field_70125_A, shooter.field_70177_z - (float)offsetX, 0.0f, (float)projectileInfo.velocity, 0.0f);
            mainProjectile.setBonusDamage(this.bonusDamage);
            world.func_72838_d((Entity)mainProjectile);
        }
        if (this.count == 1 && mainProjectile instanceof CustomProjectileEntity && (customProjectileEntity = (CustomProjectileEntity)mainProjectile).shouldChannel()) {
            this.channeledProjectile = customProjectileEntity;
        }
        if (shooter instanceof EntityPlayer && mainProjectile != null) {
            world.func_184133_a(null, shooter.func_180425_c(), mainProjectile.getLaunchSound(), SoundCategory.NEUTRAL, 0.5f, 0.4f / (shooter.func_70681_au().nextFloat() * 0.4f + 0.8f));
        }
    }

    public Vec3d getFacingPosition(EntityLivingBase entity, double distance, double angle) {
        angle = Math.toRadians(angle);
        double xAmount = -Math.sin(angle);
        double zAmount = Math.cos(angle);
        return new Vec3d(entity.field_70165_t + distance * xAmount, entity.field_70163_u, entity.field_70161_v + distance * zAmount);
    }
}

