/*
 * Decompiled with CFR 0.152.
 */
package com.lycanitesmobs.core.entity.goals.actions.abilities;

import com.google.common.base.Predicate;
import com.lycanitesmobs.core.entity.BaseCreatureEntity;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.ai.EntityAIBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.network.Packet;
import net.minecraft.network.play.server.SPacketEntityVelocity;
import net.minecraft.util.math.MathHelper;

public class ForceGoal
extends EntityAIBase {
    BaseCreatureEntity host;
    protected int duration = 200;
    protected int cooldownDuration = 300;
    protected int windUp = 60;
    protected float range = 300.0f;
    protected float force = 1.0f;
    protected int phase = -1;
    public int abilityTime = 0;
    public int cooldownTime = this.cooldownDuration;
    public boolean windUpForce = false;
    public boolean dismountTargets = false;

    public ForceGoal(BaseCreatureEntity setHost) {
        this.host = setHost;
    }

    public ForceGoal setPhase(int phase) {
        this.phase = phase;
        return this;
    }

    public ForceGoal setDuration(int duration) {
        this.duration = duration;
        return this;
    }

    public ForceGoal setCooldown(int cooldown) {
        this.cooldownDuration = cooldown;
        this.cooldownTime = cooldown;
        return this;
    }

    public ForceGoal setWindUp(int windUp) {
        this.windUp = windUp;
        return this;
    }

    public ForceGoal setRange(float range) {
        this.range = range;
        return this;
    }

    public ForceGoal setForce(float force) {
        this.force = force;
        return this;
    }

    public ForceGoal setWindUpForce(boolean windUpForce) {
        this.windUpForce = windUpForce;
        return this;
    }

    public ForceGoal setDismount(boolean dismountTargets) {
        this.dismountTargets = dismountTargets;
        return this;
    }

    public boolean func_75250_a() {
        if (!this.host.func_70089_S()) {
            return false;
        }
        return this.phase < 0 || this.phase == this.host.getBattlePhase();
    }

    public void func_75249_e() {
        this.cooldownTime = this.cooldownDuration;
    }

    public void func_75246_d() {
        if (this.cooldownTime-- > 0) {
            this.abilityTime = 0;
            return;
        }
        if (this.abilityTime == this.windUp) {
            this.host.playAttackSound();
        }
        if (this.abilityTime++ >= this.duration && this.cooldownDuration > 0) {
            this.cooldownTime = this.cooldownDuration;
            return;
        }
        double motionCap = -this.force;
        double factor = (double)(-this.force) * 0.1;
        if (this.abilityTime < this.windUp) {
            if (!this.windUpForce) {
                return;
            }
            factor *= (double)this.abilityTime / (double)this.windUp;
        }
        for (Entity entity : this.host.getNearbyEntities(Entity.class, (Predicate<Entity>)((Predicate)this::isValidTarget), this.range)) {
            if (!(entity instanceof EntityLivingBase)) continue;
            double xDist = this.host.field_70165_t - entity.field_70165_t;
            double yDist = this.host.field_70163_u - entity.field_70163_u;
            double zDist = this.host.field_70161_v - entity.field_70161_v;
            double xzDist = Math.max((double)MathHelper.func_76133_a((double)(xDist * xDist + zDist * zDist)), 0.01);
            EntityPlayerMP player = null;
            if (entity instanceof EntityPlayerMP) {
                player = (EntityPlayerMP)entity;
            }
            if (entity.field_70159_w < motionCap && entity.field_70159_w > -motionCap && entity.field_70179_y < motionCap && entity.field_70179_y > -motionCap) {
                entity.func_70024_g(xDist / xzDist * factor + entity.field_70159_w * factor, yDist * factor * 0.25 + entity.field_70181_x * factor * 0.25, zDist / xzDist * factor + entity.field_70179_y * factor);
            }
            if (this.dismountTargets && entity.func_184187_bx() != null) {
                entity.func_184210_p();
            }
            if (player == null) continue;
            player.field_71135_a.func_147359_a((Packet)new SPacketEntityVelocity(entity));
        }
    }

    public boolean isValidTarget(Entity entity) {
        if (entity == this.host) {
            return false;
        }
        if (entity instanceof EntityPlayer) {
            EntityPlayer player = (EntityPlayer)entity;
            if (player.field_71075_bZ.field_75098_d || player.func_175149_v()) {
                return false;
            }
        }
        return true;
    }
}

