/*
 * Decompiled with CFR 0.152.
 */
package com.lycanitesmobs.core.entity.goals.actions;

import com.lycanitesmobs.core.entity.BaseCreatureEntity;
import java.util.Random;
import net.minecraft.pathfinding.PathNavigate;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.Vec3d;

public class RandomPositionGenerator {
    private static Vec3d staticVector = new Vec3d(0.0, 0.0, 0.0);

    public static Vec3d findRandomTarget(BaseCreatureEntity entity, int range, int height) {
        return RandomPositionGenerator.findRandomTarget(entity, range, height, 0);
    }

    public static Vec3d findRandomTarget(BaseCreatureEntity entity, int range, int height, int heightLevel) {
        return RandomPositionGenerator.getTargetBlock(entity, range, height, null, heightLevel);
    }

    public static Vec3d findRandomTargetTowards(BaseCreatureEntity entity, int range, int height, Vec3d chaseTarget) {
        staticVector = new Vec3d(chaseTarget.field_72450_a - entity.field_70165_t, chaseTarget.field_72448_b - entity.field_70163_u, chaseTarget.field_72449_c - entity.field_70161_v);
        return RandomPositionGenerator.findRandomTargetTowards(entity, range, height, staticVector, 0);
    }

    public static Vec3d findRandomTargetTowards(BaseCreatureEntity entity, int range, int height, Vec3d chaseTarget, int heightLevel) {
        staticVector = new Vec3d(chaseTarget.field_72450_a - entity.field_70165_t, chaseTarget.field_72448_b - entity.field_70163_u, chaseTarget.field_72449_c - entity.field_70161_v);
        return RandomPositionGenerator.getTargetBlock(entity, range, height, staticVector, heightLevel);
    }

    public static Vec3d findRandomTargetAwayFrom(BaseCreatureEntity entity, int range, int height, Vec3d avoidTarget) {
        staticVector = new Vec3d(entity.field_70165_t - avoidTarget.field_72450_a, entity.field_70163_u - avoidTarget.field_72448_b, entity.field_70161_v - avoidTarget.field_72449_c);
        return RandomPositionGenerator.findRandomTargetAwayFrom(entity, range, height, avoidTarget, 0);
    }

    public static Vec3d findRandomTargetAwayFrom(BaseCreatureEntity entity, int range, int height, Vec3d avoidTarget, int heightLevel) {
        staticVector = new Vec3d(entity.field_70165_t, entity.field_70163_u, entity.field_70161_v).func_178788_d(avoidTarget);
        return RandomPositionGenerator.getTargetBlock(entity, range, height, staticVector, heightLevel);
    }

    private static Vec3d getTargetBlock(BaseCreatureEntity entity, int range, int height, Vec3d target, int heightLevel) {
        double homeDistMax;
        double homeDist;
        PathNavigate pathNavigate = entity.func_70661_as();
        Random random = entity.func_70681_au();
        boolean validTarget = false;
        int targetX = 0;
        int targetY = 0;
        int targetZ = 0;
        float pathMin = -99999.0f;
        boolean pastHome = entity.hasHome() ? (homeDist = entity.getHomePosition().func_185332_f(MathHelper.func_76128_c((double)entity.field_70165_t), MathHelper.func_76128_c((double)entity.field_70163_u), MathHelper.func_76128_c((double)entity.field_70161_v)) + 4.0) < (homeDistMax = (double)(entity.getHomeDistanceMax() + (float)range)) * homeDistMax : false;
        for (int attempt = 0; attempt < 10; ++attempt) {
            float pathWeight;
            int possibleX = random.nextInt(2 * range) - range;
            int possibleY = random.nextInt(2 * height) - height;
            int possibleZ = random.nextInt(2 * range) - range;
            if (entity.isFlying() || entity.isStrongSwimmer() && entity.func_70090_H()) {
                if (entity.field_70163_u > (double)entity.func_130014_f_().func_175725_q(entity.func_180425_c()).func_177956_o() + (double)heightLevel * 1.25) {
                    possibleY = random.nextInt(2 * height) - height * 3 / 2;
                } else if (entity.field_70163_u < (double)(entity.func_130014_f_().func_175725_q(entity.func_180425_c()).func_177956_o() + heightLevel)) {
                    possibleY = random.nextInt(2 * height) - height / 2;
                }
            }
            if (target != null && !((double)possibleX * target.field_72450_a + (double)possibleZ * target.field_72449_c >= 0.0)) continue;
            BlockPos possiblePos = new BlockPos(possibleX += MathHelper.func_76128_c((double)entity.field_70165_t), possibleY += MathHelper.func_76128_c((double)entity.field_70163_u), possibleZ += MathHelper.func_76128_c((double)entity.field_70161_v));
            if (pastHome && !entity.positionNearHome(possibleX, possibleY, possibleZ) || !entity.useDirectNavigator() && !pathNavigate.func_188555_b(possiblePos) || !((pathWeight = entity.getBlockPathWeight(possibleX, possibleY, possibleZ)) > pathMin)) continue;
            pathMin = pathWeight;
            targetX = possibleX;
            targetY = possibleY;
            targetZ = possibleZ;
            validTarget = true;
        }
        if (validTarget) {
            return new Vec3d((double)targetX, (double)targetY, (double)targetZ);
        }
        return null;
    }
}

