/*
 * Decompiled with CFR 0.152.
 */
package com.lycanitesmobs.core.entity.creature;

import com.lycanitesmobs.core.entity.AgeableCreatureEntity;
import com.lycanitesmobs.core.entity.BaseCreatureEntity;
import com.lycanitesmobs.core.entity.CreatureBuildTask;
import com.lycanitesmobs.core.entity.CreatureRelationshipEntry;
import com.lycanitesmobs.core.entity.creature.EntityConba;
import com.lycanitesmobs.core.entity.creature.EntityVespidQueen;
import com.lycanitesmobs.core.entity.goals.actions.AttackMeleeGoal;
import com.lycanitesmobs.core.entity.goals.actions.abilities.PlaceBlockGoal;
import com.lycanitesmobs.core.entity.goals.targeting.FindMasterGoal;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.EnumCreatureAttribute;
import net.minecraft.entity.ai.EntityAIBase;
import net.minecraft.entity.monster.IMob;
import net.minecraft.util.DamageSource;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;

public class EntityVespid
extends AgeableCreatureEntity
implements IMob {
    public PlaceBlockGoal aiPlaceBlock;
    public CreatureBuildTask creatureBuildTask;
    private boolean hiveBuilding = true;

    public EntityVespid(World world) {
        super(world);
        this.attribute = EnumCreatureAttribute.ARTHROPOD;
        this.hasAttackSound = true;
        this.setupMob();
        this.canGrow = true;
        this.babySpawnChance = 0.1;
        this.field_70138_W = 1.0f;
        this.setAttackCooldownMax(10);
    }

    @Override
    protected void func_184651_r() {
        super.func_184651_r();
        this.field_70714_bg.func_75776_a(this.nextCombatGoalIndex++, (EntityAIBase)new AttackMeleeGoal(this).setLongMemory(true));
        this.aiPlaceBlock = new PlaceBlockGoal(this).setMaxDistance(128.0).setSpeed(3.0).setReplaceLiquid(true).setReplaceSolid(true);
        this.field_70714_bg.func_75776_a(this.nextIdleGoalIndex++, (EntityAIBase)this.aiPlaceBlock);
        this.field_70715_bh.func_75776_a(this.nextFindTargetIndex++, (EntityAIBase)new FindMasterGoal(this).setTargetClass(EntityVespidQueen.class).setRange(64.0));
    }

    @Override
    public void loadCreatureFlags() {
        this.hiveBuilding = this.creatureInfo.getFlag("hiveBuilding", this.hiveBuilding);
    }

    @Override
    public boolean isPersistant() {
        if (this.getMasterTarget() instanceof BaseCreatureEntity) {
            return ((BaseCreatureEntity)this.getMasterTarget()).isPersistant();
        }
        return super.isPersistant();
    }

    @Override
    public void func_70636_d() {
        super.func_70636_d();
        if (!this.func_130014_f_().field_72995_K && this.hiveBuilding) {
            if (this.getMasterTarget() instanceof EntityVespidQueen) {
                if (this.getMasterTarget().field_70128_L && this.aiPlaceBlock.blockState != null) {
                    this.aiPlaceBlock.func_75251_c();
                } else if (this.aiPlaceBlock.blockState == null) {
                    EntityVespidQueen queen = (EntityVespidQueen)this.getMasterTarget();
                    this.creatureBuildTask = queen.creatureStructure.takeBuildTask((EntityLivingBase)this);
                    if (this.creatureBuildTask != null) {
                        this.aiPlaceBlock.setBlockPlacement(this.creatureBuildTask.blockState, this.creatureBuildTask.pos);
                    }
                }
            } else if (this.aiPlaceBlock.blockState != null) {
                this.aiPlaceBlock.func_75251_c();
            }
        }
        if (!this.func_130014_f_().field_72995_K && this.func_70638_az() instanceof EntityConba && ((EntityConba)this.func_70638_az()).vespidInfection) {
            this.func_70624_b(null);
        }
    }

    @Override
    public void onBlockPlaced(BlockPos blockPos, IBlockState blockState) {
        if (this.getMasterTarget() instanceof EntityVespidQueen) {
            EntityVespidQueen queen = (EntityVespidQueen)this.getMasterTarget();
            if (this.creatureBuildTask != null) {
                queen.creatureStructure.completeBuildTask(this.creatureBuildTask);
                this.creatureBuildTask = null;
            }
        }
    }

    @Override
    public boolean canAttackEntity(EntityLivingBase targetEntity) {
        if (targetEntity == this.getMasterTarget()) {
            return false;
        }
        if (targetEntity instanceof EntityConba) {
            return false;
        }
        if (targetEntity instanceof EntityVespid && (!((EntityVespid)targetEntity).hasMaster() || ((EntityVespid)targetEntity).getMasterTarget() == this.getMasterTarget())) {
            return false;
        }
        if (targetEntity instanceof EntityVespidQueen && (!this.hasMaster() || this.getMasterTarget() == targetEntity)) {
            return false;
        }
        if (this.hasMaster() && this.getMasterTarget() instanceof EntityVespidQueen) {
            EntityVespidQueen entityVespidQueen = (EntityVespidQueen)this.getMasterTarget();
            CreatureRelationshipEntry creatureRelationshipEntry = entityVespidQueen.relationships.getEntry((Entity)targetEntity);
            if (creatureRelationshipEntry != null && !creatureRelationshipEntry.canAttack()) {
                return false;
            }
        }
        return super.canAttackEntity(targetEntity);
    }

    @Override
    public boolean isFlying() {
        return true;
    }

    @Override
    public float getDamageModifier(DamageSource damageSrc) {
        if (damageSrc.func_76347_k()) {
            return 4.0f;
        }
        return 1.0f;
    }

    @Override
    public boolean isDamageTypeApplicable(String type, DamageSource source, float damage) {
        if (type.equals("inWall")) {
            return false;
        }
        return super.isDamageTypeApplicable(type, source, damage);
    }

    @Override
    public boolean func_70685_l(Entity entity) {
        if (entity instanceof EntityVespidQueen) {
            return true;
        }
        return super.func_70685_l(entity);
    }
}

