/*
 * Decompiled with CFR 0.152.
 */
package com.lycanitesmobs.core.entity.creature;

import com.lycanitesmobs.ObjectManager;
import com.lycanitesmobs.api.IGroupHeavy;
import com.lycanitesmobs.core.entity.ExtendedEntity;
import com.lycanitesmobs.core.entity.RideableCreatureEntity;
import com.lycanitesmobs.core.entity.goals.actions.AttackMeleeGoal;
import net.minecraft.block.Block;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.EnumCreatureAttribute;
import net.minecraft.entity.ai.EntityAIBase;
import net.minecraft.init.Blocks;
import net.minecraft.init.MobEffects;
import net.minecraft.pathfinding.PathNodeType;
import net.minecraft.potion.Potion;
import net.minecraft.potion.PotionEffect;
import net.minecraft.util.DamageSource;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;

public class EntityStrider
extends RideableCreatureEntity
implements IGroupHeavy {
    protected int pickupCooldown = 100;
    private int pickupTime = 0;

    public EntityStrider(World world) {
        super(world);
        this.attribute = EnumCreatureAttribute.UNDEFINED;
        this.spawnsOnLand = true;
        this.spawnsInWater = true;
        this.hasAttackSound = true;
        this.babySpawnChance = 0.0;
        this.canGrow = true;
        this.setupMob();
        this.hitAreaWidthScale = 1.5f;
        this.hitAreaHeightScale = 1.0f;
        this.func_184644_a(PathNodeType.WATER, 0.0f);
        this.field_70138_W = 4.0f;
    }

    @Override
    protected void func_184651_r() {
        super.func_184651_r();
        this.field_70714_bg.func_75776_a(this.nextCombatGoalIndex++, (EntityAIBase)new AttackMeleeGoal(this).setLongMemory(false));
    }

    @Override
    public void func_70636_d() {
        super.func_70636_d();
        if (!this.func_130014_f_().field_72995_K) {
            if (this.isTamed() && this.hasPickupEntity() && this.getPickupEntity() == this.func_70902_q()) {
                this.dropPickupEntity();
            }
            if (this.hasPickupEntity()) {
                ExtendedEntity extendedEntity = ExtendedEntity.getForEntity(this.getPickupEntity());
                if (extendedEntity != null) {
                    extendedEntity.setPickedUpByEntity((Entity)this);
                }
                if (this.isTamed() && !this.canAttackEntity(this.getPickupEntity())) {
                    this.getPickupEntity().func_70690_d(new PotionEffect(MobEffects.field_76427_o, this.getEffectDuration(5), 1));
                } else if (this.pickupTime++ % 40 == 0) {
                    this.attackEntityAsMob((Entity)this.getPickupEntity(), 0.5);
                    if (this.getPickupEntity() instanceof EntityLivingBase && ObjectManager.getEffect("penetration") != null) {
                        this.getPickupEntity().func_70690_d(new PotionEffect((Potion)ObjectManager.getEffect("penetration"), this.getEffectDuration(5), 1));
                    }
                }
            } else {
                if (this.pickupCooldown > 0) {
                    --this.pickupCooldown;
                }
                this.pickupTime = 0;
            }
        }
    }

    @Override
    public void mountAbility(Entity rider) {
        if (this.func_130014_f_().field_72995_K) {
            return;
        }
        if (this.abilityToggled) {
            return;
        }
        if (this.hasPickupEntity()) {
            this.dropPickupEntity();
            return;
        }
        if (this.getStamina() < this.getStaminaCost()) {
            return;
        }
        EntityLivingBase nearestTarget = this.getNearestEntity(EntityLivingBase.class, null, 4.0, false);
        if (this.canPickupEntity(nearestTarget)) {
            this.pickupEntity(nearestTarget);
        }
        this.applyStaminaCost();
    }

    @Override
    public float getStaminaCost() {
        return 20.0f;
    }

    @Override
    public int getStaminaRecoveryWarmup() {
        return 100;
    }

    @Override
    public float getStaminaRecoveryMax() {
        return 1.0f;
    }

    @Override
    public float getAISpeedModifier() {
        if (this.func_70090_H()) {
            return 2.0f;
        }
        if (this.waterContact()) {
            return 1.5f;
        }
        return super.getAISpeedModifier();
    }

    @Override
    public boolean func_96092_aw() {
        return false;
    }

    @Override
    public float getBlockPathWeight(int x, int y, int z) {
        int waterWeight = 10;
        Block block = this.func_130014_f_().func_180495_p(new BlockPos(x, y, z)).func_177230_c();
        if (block == Blocks.field_150355_j) {
            return (super.getBlockPathWeight(x, y, z) + 1.0f) * (float)(waterWeight + 1);
        }
        if (this.func_130014_f_().func_72896_J() && this.func_130014_f_().func_175710_j(new BlockPos(x, y, z))) {
            return (super.getBlockPathWeight(x, y, z) + 1.0f) * (float)(waterWeight + 1);
        }
        if (this.func_70638_az() != null) {
            return super.getBlockPathWeight(x, y, z);
        }
        if (this.waterContact()) {
            return -999999.0f;
        }
        return super.getBlockPathWeight(x, y, z);
    }

    @Override
    public BlockPos getWanderPosition(BlockPos wanderPosition) {
        BlockPos groundPos = wanderPosition.func_177977_b();
        while (groundPos.func_177956_o() > 0 && !this.func_130014_f_().func_180495_p(groundPos).func_185904_a().func_76220_a()) {
            groundPos = groundPos.func_177977_b();
        }
        return groundPos.func_177984_a();
    }

    @Override
    public boolean attackMelee(Entity target, double damageScale) {
        EntityLivingBase entityLivingBase;
        if (!super.attackMelee(target, damageScale)) {
            return false;
        }
        if (target instanceof EntityLivingBase && this.canPickupEntity(entityLivingBase = (EntityLivingBase)target) && this.func_70685_l(target)) {
            this.pickupEntity(entityLivingBase);
            this.pickupCooldown = 100;
        }
        return true;
    }

    @Override
    public void onDamage(DamageSource damageSrc, float damage) {
        if (this.hasPickupEntity() && !this.isTamed() && this.func_70681_au().nextFloat() <= 0.25f) {
            this.dropPickupEntity();
        }
        super.onDamage(damageSrc, damage);
    }

    @Override
    public boolean func_70648_aU() {
        return true;
    }

    @Override
    public float getFallResistance() {
        return 20.0f;
    }

    @Override
    public double[] getPickupOffset(Entity entity) {
        return new double[]{0.0, 5.5, 0.0};
    }

    @Override
    public boolean canPickupEntity(EntityLivingBase entity) {
        if (!this.isTamed() && this.pickupCooldown > 0) {
            return false;
        }
        return super.canPickupEntity(entity);
    }

    @Override
    public void dropPickupEntity() {
        ExtendedEntity extendedEntity = ExtendedEntity.getForEntity(this.getPickupEntity());
        if (extendedEntity != null) {
            extendedEntity.setPickedUpByEntity(null);
        }
        this.pickupEntity = null;
    }

    @Override
    public int getNoBagSize() {
        return 0;
    }

    @Override
    public int getBagSize() {
        return this.creatureInfo.bagSize;
    }

    @Override
    public boolean petControlsEnabled() {
        return true;
    }
}

