/*
 * Decompiled with CFR 0.152.
 */
package com.lycanitesmobs.core.entity.creature;

import com.lycanitesmobs.ObjectManager;
import com.lycanitesmobs.api.IGroupBoss;
import com.lycanitesmobs.api.IGroupHeavy;
import com.lycanitesmobs.core.entity.RideableCreatureEntity;
import com.lycanitesmobs.core.entity.goals.actions.AttackMeleeGoal;
import net.minecraft.block.Block;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.EnumCreatureAttribute;
import net.minecraft.entity.ai.EntityAIBase;
import net.minecraft.entity.monster.IMob;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.init.Blocks;
import net.minecraft.init.MobEffects;
import net.minecraft.network.Packet;
import net.minecraft.network.play.server.SPacketEntityVelocity;
import net.minecraft.potion.Potion;
import net.minecraft.potion.PotionEffect;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.world.World;

public class EntityRoa
extends RideableCreatureEntity
implements IMob {
    protected int whirlpoolRange = 6;
    protected int whirlpoolEnergy = 0;
    protected int whirlpoolEnergyMax = 100;
    protected boolean whirlpoolRecharging = true;
    protected int mountedWhirlpool = 0;

    public EntityRoa(World world) {
        super(world);
        this.attribute = EnumCreatureAttribute.UNDEFINED;
        this.spawnsOnLand = false;
        this.spawnsInWater = true;
        this.hasAttackSound = true;
        this.babySpawnChance = 0.0;
        this.canGrow = true;
        this.setupMob();
    }

    @Override
    protected void func_184651_r() {
        super.func_184651_r();
        this.field_70714_bg.func_75776_a(this.nextCombatGoalIndex++, (EntityAIBase)new AttackMeleeGoal(this).setLongMemory(false));
    }

    @Override
    public void loadCreatureFlags() {
        this.whirlpoolRange = this.creatureInfo.getFlag("whirlpoolRange", this.whirlpoolRange);
    }

    @Override
    public void func_70636_d() {
        super.func_70636_d();
        if (!this.func_130014_f_().field_72995_K) {
            if (this.whirlpoolRecharging && ++this.whirlpoolEnergy >= this.whirlpoolEnergyMax) {
                this.whirlpoolRecharging = false;
            }
            this.whirlpoolEnergy = Math.min(this.whirlpoolEnergy, this.whirlpoolEnergyMax);
            if (this.canWhirlpool()) {
                for (Entity entity : this.getNearbyEntities(Entity.class, null, this.whirlpoolRange)) {
                    EntityLivingBase entityLivingBase;
                    if (entity == this || entity.getClass() == ((Object)((Object)this)).getClass() || entity == this.func_184179_bs() || entity instanceof IGroupBoss || entity instanceof IGroupHeavy || entity instanceof EntityLivingBase && ((entityLivingBase = (EntityLivingBase)entity).func_70644_a((Potion)ObjectManager.getEffect("weight")) || !this.canAttackEntity(entityLivingBase) || !entity.func_70090_H() && !this.spawnEventType.equalsIgnoreCase("sharknado"))) continue;
                    EntityPlayerMP player = null;
                    if (entity instanceof EntityPlayerMP) {
                        player = (EntityPlayerMP)entity;
                        if (player.field_71075_bZ.field_75098_d) continue;
                    }
                    double xDist = this.field_70165_t - entity.field_70165_t;
                    double zDist = this.field_70161_v - entity.field_70161_v;
                    double xzDist = Math.max((double)MathHelper.func_76133_a((double)(xDist * xDist + zDist * zDist)), 0.01);
                    double factor = 0.1;
                    double motionCap = 10.0;
                    if (entity.field_70159_w < motionCap && entity.field_70159_w > -motionCap && entity.field_70179_y < motionCap && entity.field_70179_y > -motionCap) {
                        entity.func_70024_g(xDist / xzDist * factor + entity.field_70159_w * factor, 0.0, zDist / xzDist * factor + entity.field_70179_y * factor);
                    }
                    if (player == null) continue;
                    player.field_71135_a.func_147359_a((Packet)new SPacketEntityVelocity(entity));
                }
                if (--this.whirlpoolEnergy <= 0) {
                    this.whirlpoolRecharging = true;
                }
            }
        }
        if (this.mountedWhirlpool > 0) {
            --this.mountedWhirlpool;
        }
    }

    @Override
    public void riderEffects(EntityLivingBase rider) {
        rider.func_70690_d(new PotionEffect(MobEffects.field_76427_o, 105, 1));
        super.riderEffects(rider);
    }

    @Override
    public boolean extraAnimation01() {
        if (this.func_130014_f_().field_72995_K) {
            return super.extraAnimation01();
        }
        return this.canWhirlpool();
    }

    public boolean canWhirlpool() {
        if (this.func_130014_f_().field_72995_K) {
            return this.extraAnimation01();
        }
        if ("sharknado".equals(this.spawnEventType)) {
            return true;
        }
        if (!this.func_70090_H()) {
            return false;
        }
        if (this.func_184179_bs() != null && this.mountedWhirlpool > 0) {
            return true;
        }
        return !this.whirlpoolRecharging && this.hasAttackTarget() && this.func_70032_d((Entity)this.func_70638_az()) <= (float)(this.whirlpoolRange * 3);
    }

    @Override
    public float getBlockPathWeight(int x, int y, int z) {
        int waterWeight = 10;
        Block block = this.func_130014_f_().func_180495_p(new BlockPos(x, y, z)).func_177230_c();
        if (block == Blocks.field_150355_j) {
            return (super.getBlockPathWeight(x, y, z) + 1.0f) * (float)(waterWeight + 1);
        }
        if (this.func_130014_f_().func_72896_J() && this.func_130014_f_().func_175710_j(new BlockPos(x, y, z))) {
            return (super.getBlockPathWeight(x, y, z) + 1.0f) * (float)(waterWeight + 1);
        }
        if (this.func_70638_az() != null) {
            return super.getBlockPathWeight(x, y, z);
        }
        if (this.waterContact()) {
            return -999999.0f;
        }
        return super.getBlockPathWeight(x, y, z);
    }

    @Override
    public boolean isStrongSwimmer() {
        return true;
    }

    @Override
    public boolean canWalk() {
        return false;
    }

    @Override
    public boolean isFlying() {
        if ("sharknado".equals(this.spawnEventType)) {
            return true;
        }
        return super.isFlying();
    }

    @Override
    public double func_70042_X() {
        return (double)this.field_70131_O * 0.25;
    }

    @Override
    public boolean func_70648_aU() {
        return true;
    }

    @Override
    public boolean canBreatheAir() {
        return "sharknado".equals(this.spawnEventType);
    }

    @Override
    public void mountAbility(Entity rider) {
        if (this.func_130014_f_().field_72995_K) {
            return;
        }
        if (this.getStamina() < this.getStaminaCost()) {
            return;
        }
        this.applyStaminaCost();
        this.mountedWhirlpool = 20;
    }

    @Override
    public float getStaminaCost() {
        return 2.0f;
    }

    @Override
    public int getStaminaRecoveryWarmup() {
        return 80;
    }

    @Override
    public float getStaminaRecoveryMax() {
        return 2.0f;
    }

    @Override
    public void onDismounted(Entity entity) {
        super.onDismounted(entity);
        if (entity != null && entity instanceof EntityLivingBase) {
            ((EntityLivingBase)entity).func_70690_d(new PotionEffect(MobEffects.field_76427_o, 100, 1));
        }
    }

    @Override
    public int getNoBagSize() {
        return 0;
    }

    @Override
    public int getBagSize() {
        return this.creatureInfo.bagSize;
    }

    @Override
    public boolean petControlsEnabled() {
        return true;
    }
}

