/*
 * Decompiled with CFR 0.152.
 */
package com.lycanitesmobs.core.entity.creature;

import com.lycanitesmobs.api.IGroupHeavy;
import com.lycanitesmobs.core.entity.RapidFireProjectileEntity;
import com.lycanitesmobs.core.entity.RideableCreatureEntity;
import com.lycanitesmobs.core.entity.goals.actions.AttackRangedGoal;
import com.lycanitesmobs.core.info.projectile.ProjectileInfo;
import com.lycanitesmobs.core.info.projectile.ProjectileManager;
import java.util.ArrayList;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.EnumCreatureAttribute;
import net.minecraft.entity.ai.EntityAIBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.init.MobEffects;
import net.minecraft.potion.PotionEffect;
import net.minecraft.util.DamageSource;
import net.minecraft.util.EnumParticleTypes;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.world.World;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class EntityIgnibus
extends RideableCreatureEntity
implements IGroupHeavy {
    protected boolean wantsToLand;
    protected boolean isLanded;

    public EntityIgnibus(World world) {
        super(world);
        this.attribute = EnumCreatureAttribute.UNDEFINED;
        this.spawnsOnLand = true;
        this.spawnsInWater = true;
        this.isLavaCreature = true;
        this.flySoundSpeed = 20;
        this.hasAttackSound = false;
        this.setAttackCooldownMax(20);
        this.setupMob();
        this.field_70138_W = 1.0f;
        this.hitAreaWidthScale = 1.5f;
    }

    @Override
    protected void func_184651_r() {
        super.func_184651_r();
        this.field_70714_bg.func_75776_a(this.nextCombatGoalIndex++, (EntityAIBase)new AttackRangedGoal(this).setSpeed(0.75).setStaminaTime(100).setRange(24.0f).setMinChaseDistance(10.0f));
    }

    @Override
    public void func_70636_d() {
        super.func_70636_d();
        if (!this.func_130014_f_().field_72995_K) {
            if (this.isLanded) {
                this.wantsToLand = false;
                if (this.hasPickupEntity() || this.func_184179_bs() != null || this.func_110167_bD() || this.func_70090_H() || !this.isTamed() && this.updateTick % 100L == 0L && this.func_70681_au().nextBoolean()) {
                    this.leap(1.0, 1.0);
                    this.isLanded = false;
                }
                if (this.isTamed() && !this.isSitting()) {
                    this.isLanded = false;
                }
            } else if (this.wantsToLand) {
                if (!this.isLanded && this.isSafeToLand()) {
                    this.isLanded = true;
                }
            } else if (!this.hasPickupEntity() && !this.hasAttackTarget() && this.updateTick % 100L == 0L && this.func_70681_au().nextBoolean()) {
                this.wantsToLand = true;
            }
            if (this.hasPickupEntity() || this.func_184179_bs() != null || this.hasAttackTarget() || this.func_70090_H()) {
                this.wantsToLand = false;
            } else if (this.isTamed() && this.isSitting() && !this.func_110167_bD()) {
                this.wantsToLand = true;
            }
        }
        if (this.func_130014_f_().field_72995_K) {
            for (int i = 0; i < 2; ++i) {
                this.func_130014_f_().func_175688_a(EnumParticleTypes.SMOKE_NORMAL, this.field_70165_t + (this.field_70146_Z.nextDouble() - 0.5) * (double)this.field_70130_N, this.field_70163_u + this.field_70146_Z.nextDouble() * (double)this.field_70131_O, this.field_70161_v + (this.field_70146_Z.nextDouble() - 0.5) * (double)this.field_70130_N, 0.0, 0.0, 0.0, new int[0]);
                this.func_130014_f_().func_175688_a(EnumParticleTypes.FLAME, this.field_70165_t + (this.field_70146_Z.nextDouble() - 0.5) * (double)this.field_70130_N, this.field_70163_u + this.field_70146_Z.nextDouble() * (double)this.field_70131_O, this.field_70161_v + (this.field_70146_Z.nextDouble() - 0.5) * (double)this.field_70130_N, 0.0, 0.0, 0.0, new int[0]);
            }
        }
    }

    @Override
    public void riderEffects(EntityLivingBase rider) {
        rider.func_70690_d(new PotionEffect(MobEffects.field_76426_n, 105, 1));
        super.riderEffects(rider);
    }

    @Override
    public BlockPos getWanderPosition(BlockPos wanderPosition) {
        if (this.wantsToLand || !this.isLanded) {
            BlockPos groundPos = wanderPosition.func_177977_b();
            while (groundPos.func_177956_o() > 0 && this.func_130014_f_().func_180495_p(groundPos).func_177230_c() == Blocks.field_150350_a) {
                groundPos = groundPos.func_177977_b();
            }
            if (this.func_130014_f_().func_180495_p(groundPos).func_185904_a().func_76220_a()) {
                return groundPos.func_177984_a();
            }
        }
        return super.getWanderPosition(wanderPosition);
    }

    @Override
    public double getFlightOffset() {
        if (!this.wantsToLand) {
            super.getFlightOffset();
        }
        return 0.0;
    }

    @Override
    public boolean isFlying() {
        return !this.isLanded;
    }

    @Override
    public boolean isStrongSwimmer() {
        return false;
    }

    @Override
    public void attackRanged(Entity target, float range) {
        ProjectileInfo projectileInfo = ProjectileManager.getInstance().getProjectile("primeember");
        if (projectileInfo == null) {
            return;
        }
        ArrayList<RapidFireProjectileEntity> projectiles = new ArrayList<RapidFireProjectileEntity>();
        RapidFireProjectileEntity projectileEntry = new RapidFireProjectileEntity(projectileInfo, this.func_130014_f_(), (EntityLivingBase)this, 15, 3);
        projectiles.add(projectileEntry);
        RapidFireProjectileEntity projectileEntry2 = new RapidFireProjectileEntity(projectileInfo, this.func_130014_f_(), (EntityLivingBase)this, 15, 3);
        projectileEntry2.offsetX += 1.0;
        projectileEntry2.setProjectileScale(0.125f);
        projectiles.add(projectileEntry2);
        RapidFireProjectileEntity projectileEntry3 = new RapidFireProjectileEntity(projectileInfo, this.func_130014_f_(), (EntityLivingBase)this, 15, 3);
        projectileEntry3.offsetX -= 1.0;
        projectileEntry3.setProjectileScale(0.125f);
        projectiles.add(projectileEntry3);
        RapidFireProjectileEntity projectileEntry4 = new RapidFireProjectileEntity(projectileInfo, this.func_130014_f_(), (EntityLivingBase)this, 15, 3);
        projectileEntry4.offsetZ += 1.0;
        projectileEntry4.setProjectileScale(0.125f);
        projectiles.add(projectileEntry4);
        RapidFireProjectileEntity projectileEntry5 = new RapidFireProjectileEntity(projectileInfo, this.func_130014_f_(), (EntityLivingBase)this, 15, 3);
        projectileEntry5.offsetZ -= 1.0;
        projectileEntry5.setProjectileScale(0.125f);
        projectiles.add(projectileEntry5);
        RapidFireProjectileEntity projectileEntry6 = new RapidFireProjectileEntity(projectileInfo, this.func_130014_f_(), (EntityLivingBase)this, 15, 3);
        projectileEntry6.offsetY += 1.0;
        projectileEntry6.setProjectileScale(0.125f);
        projectiles.add(projectileEntry6);
        RapidFireProjectileEntity projectileEntry7 = new RapidFireProjectileEntity(projectileInfo, this.func_130014_f_(), (EntityLivingBase)this, 15, 3);
        projectileEntry7.offsetY -= 1.0;
        projectileEntry7.setProjectileScale(0.125f);
        projectiles.add(projectileEntry7);
        for (RapidFireProjectileEntity projectile : projectiles) {
            projectile.setProjectileScale(0.125f);
            projectile.field_70163_u -= (double)(this.field_70131_O * 0.2f);
            float accuracy = 4.0f * (this.func_70681_au().nextFloat() - 0.5f);
            double d0 = target.field_70165_t - this.field_70165_t + (double)accuracy;
            double d1 = target.field_70163_u + (double)target.func_70047_e() - (double)1.1f - projectile.field_70163_u + (double)accuracy;
            double d2 = target.field_70161_v - this.field_70161_v + (double)accuracy;
            float f1 = MathHelper.func_76133_a((double)(d0 * d0 + d2 * d2)) * 0.2f;
            float velocity = 1.2f;
            projectile.func_70186_c(d0, d1 + (double)f1, d2, velocity, 6.0f);
            projectile.setProjectileScale(2.0f);
            this.func_184185_a(projectile.getLaunchSound(), 1.0f, 1.0f / (this.func_70681_au().nextFloat() * 0.4f + 0.8f));
            this.func_130014_f_().func_72838_d((Entity)projectile);
        }
        super.attackRanged(target, range);
    }

    @Override
    public boolean canBurn() {
        return false;
    }

    @Override
    public boolean canBreatheUnderlava() {
        return true;
    }

    @Override
    public float getFallResistance() {
        return 100.0f;
    }

    @Override
    public float getDamageModifier(DamageSource damageSrc) {
        if (damageSrc.func_76347_k()) {
            return 0.0f;
        }
        return super.getDamageModifier(damageSrc);
    }

    @Override
    public void mountAbility(Entity rider) {
        if (this.func_130014_f_().field_72995_K) {
            return;
        }
        if (this.abilityToggled) {
            return;
        }
        if (this.hasPickupEntity()) {
            this.dropPickupEntity();
            return;
        }
        if (this.getStamina() < this.getStaminaCost()) {
            return;
        }
        if (rider instanceof EntityPlayer) {
            EntityPlayer player = (EntityPlayer)rider;
            ProjectileInfo projectileInfo = ProjectileManager.getInstance().getProjectile("primeember");
            if (projectileInfo == null) {
                return;
            }
            ArrayList<RapidFireProjectileEntity> projectiles = new ArrayList<RapidFireProjectileEntity>();
            RapidFireProjectileEntity projectileEntry = new RapidFireProjectileEntity(projectileInfo, this.func_130014_f_(), (EntityLivingBase)player, 15, 3);
            projectiles.add(projectileEntry);
            RapidFireProjectileEntity projectileEntry2 = new RapidFireProjectileEntity(projectileInfo, this.func_130014_f_(), (EntityLivingBase)this, 15, 3);
            projectileEntry2.offsetX += 1.0;
            projectileEntry2.setProjectileScale(0.25f);
            projectiles.add(projectileEntry2);
            RapidFireProjectileEntity projectileEntry3 = new RapidFireProjectileEntity(projectileInfo, this.func_130014_f_(), (EntityLivingBase)this, 15, 3);
            projectileEntry3.offsetX -= 1.0;
            projectileEntry3.setProjectileScale(0.25f);
            projectiles.add(projectileEntry3);
            RapidFireProjectileEntity projectileEntry4 = new RapidFireProjectileEntity(projectileInfo, this.func_130014_f_(), (EntityLivingBase)this, 15, 3);
            projectileEntry4.offsetZ += 1.0;
            projectileEntry4.setProjectileScale(0.25f);
            projectiles.add(projectileEntry4);
            RapidFireProjectileEntity projectileEntry5 = new RapidFireProjectileEntity(projectileInfo, this.func_130014_f_(), (EntityLivingBase)this, 15, 3);
            projectileEntry5.offsetZ -= 1.0;
            projectileEntry5.setProjectileScale(0.25f);
            projectiles.add(projectileEntry5);
            RapidFireProjectileEntity projectileEntry6 = new RapidFireProjectileEntity(projectileInfo, this.func_130014_f_(), (EntityLivingBase)this, 15, 3);
            projectileEntry6.offsetY += 1.0;
            projectileEntry6.setProjectileScale(0.25f);
            projectiles.add(projectileEntry6);
            RapidFireProjectileEntity projectileEntry7 = new RapidFireProjectileEntity(projectileInfo, this.func_130014_f_(), (EntityLivingBase)this, 15, 3);
            projectileEntry7.offsetY -= 10.0;
            projectileEntry7.setProjectileScale(0.25f);
            projectiles.add(projectileEntry7);
            for (RapidFireProjectileEntity projectile : projectiles) {
                projectile.setProjectileScale(1.0f);
                projectile.field_70163_u -= (double)(this.field_70131_O / 4.0f);
                this.func_184185_a(projectile.getLaunchSound(), 1.0f, 1.0f / (this.func_70681_au().nextFloat() * 0.4f + 0.8f));
                this.func_130014_f_().func_72838_d((Entity)projectile);
            }
            this.triggerAttackCooldown();
        }
        this.applyStaminaCost();
    }

    @Override
    public float getStaminaCost() {
        return 2.0f;
    }

    @Override
    public int getStaminaRecoveryWarmup() {
        return 40;
    }

    @Override
    public float getStaminaRecoveryMax() {
        return 1.0f;
    }

    public float func_70013_c() {
        if (this.isAttackOnCooldown()) {
            return 1.0f;
        }
        return super.func_70013_c();
    }

    @SideOnly(value=Side.CLIENT)
    public int func_70070_b() {
        if (this.isAttackOnCooldown()) {
            return 0xF000F0;
        }
        return super.func_70070_b();
    }
}

