/*
 * Decompiled with CFR 0.152.
 */
package com.lycanitesmobs.core;

import com.google.gson.JsonArray;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import java.io.InputStream;
import java.net.URL;
import java.nio.charset.Charset;
import java.security.SecureRandom;
import java.security.cert.X509Certificate;
import javax.net.ssl.HttpsURLConnection;
import javax.net.ssl.SSLContext;
import javax.net.ssl.TrustManager;
import javax.net.ssl.X509TrustManager;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang3.math.NumberUtils;

public class VersionChecker {
    public static VersionChecker INSTANCE = new VersionChecker();
    public boolean enabled = true;
    protected VersionInfo currentVersion = new VersionInfo("2.0.8.10", "1.12.2");
    protected VersionInfo latestVersion = null;
    protected long lastChecked = -1L;
    public SSLContext sslContext;

    public VersionChecker() {
        TrustManager[] trustAllCerts = new TrustManager[]{new X509TrustManager(){

            @Override
            public X509Certificate[] getAcceptedIssuers() {
                return null;
            }

            @Override
            public void checkClientTrusted(X509Certificate[] certs, String authType) {
            }

            @Override
            public void checkServerTrusted(X509Certificate[] certs, String authType) {
            }
        }};
        try {
            this.sslContext = SSLContext.getInstance("SSL");
            this.sslContext.init(null, trustAllCerts, new SecureRandom());
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public VersionInfo getLatestVersion() {
        if (this.latestVersion != null) {
            return this.latestVersion;
        }
        long currentTime = System.currentTimeMillis() / 1000L;
        if (this.lastChecked < 0L || currentTime - this.lastChecked > 3600L) {
            this.lastChecked = currentTime;
            VersionLoader versionLoader = new VersionLoader();
            Thread thread = new Thread(versionLoader);
            thread.start();
        }
        return this.latestVersion != null ? this.latestVersion : this.currentVersion;
    }

    public static class VersionLoader
    implements Runnable {
        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            VersionChecker.INSTANCE.lastChecked = System.currentTimeMillis() / 1000L;
            try {
                String jsonString;
                URL url = new URL("https://service.lycanitesmobs.com/api/v1/versions?limit=1&sort_by=created_at:desc&mcversion=1.12.2");
                HttpsURLConnection urlConnection = (HttpsURLConnection)url.openConnection();
                urlConnection.setSSLSocketFactory(VersionChecker.INSTANCE.sslContext.getSocketFactory());
                urlConnection.setRequestProperty("Authorization", "Bearer 7ed1f44cbc1aff693e604075f23d56402983a4a0");
                String osName = System.getProperty("os.name");
                urlConnection.setRequestProperty("User-Agent", "Minecraft 1.12.2 (" + osName + ") LycanitesMobs " + "2.0.8.10");
                try (InputStream inputStream = urlConnection.getInputStream();){
                    jsonString = IOUtils.toString((InputStream)inputStream, (Charset)null);
                    jsonString = jsonString.replace("\\r", "");
                }
                JsonParser jsonParser = new JsonParser();
                JsonObject json = jsonParser.parse(jsonString).getAsJsonObject();
                JsonArray jsonArray = json.getAsJsonArray("data");
                JsonObject versionJson = jsonArray.get(0).getAsJsonObject();
                if (!versionJson.has("version") && !versionJson.has("mcversion")) {
                    return;
                }
                String versionNumber = versionJson.get("version").getAsString();
                String mcVersion = versionJson.get("mcversion").getAsString();
                VersionChecker.INSTANCE.latestVersion = new VersionInfo(versionNumber, mcVersion);
                VersionChecker.INSTANCE.latestVersion.loadFromJSON(versionJson);
                VersionChecker.INSTANCE.latestVersion.checkIfNewer(VersionChecker.INSTANCE.currentVersion);
            }
            catch (Throwable e) {
                e.printStackTrace();
            }
        }
    }

    public static class VersionInfo {
        public String versionNumber;
        public String mcVersion;
        public String name = "";
        public String newFeatures = "";
        public String configChanges = "";
        public String majorFixes = "";
        public String changes = "";
        public String balancing = "";
        public String minorFixes = "";
        public boolean isNewer = false;

        public VersionInfo(String versionNumber, String mcVersion) {
            this.versionNumber = versionNumber;
            this.mcVersion = mcVersion;
        }

        public void loadFromJSON(JsonObject versionJson) {
            this.versionNumber = versionJson.get("version").getAsString();
            this.mcVersion = versionJson.get("mcversion").getAsString();
            this.name = versionJson.get("name").getAsString();
            this.newFeatures = versionJson.get("new").getAsString();
            this.configChanges = versionJson.get("config_changes").getAsString();
            this.majorFixes = versionJson.get("major_fixes").getAsString();
            this.changes = versionJson.get("changes").getAsString();
            this.balancing = versionJson.get("balancing").getAsString();
            this.minorFixes = versionJson.get("minor_fixes").getAsString();
        }

        public void checkIfNewer(VersionInfo compareVersion) {
            this.isNewer = false;
            String[] versions = this.versionNumber.split("\\.");
            String[] compareVersions = compareVersion.versionNumber.split("\\.");
            for (int i = 0; i < 4; ++i) {
                int compareVersionNumber;
                int versionNumber = NumberUtils.isCreatable((String)versions[i].replaceAll("[^\\d.]", "")) ? Integer.parseInt(versions[i].replaceAll("[^\\d.]", "")) : 0;
                int n = compareVersionNumber = NumberUtils.isCreatable((String)compareVersions[i].replaceAll("[^\\d.]", "")) ? Integer.parseInt(compareVersions[i].replaceAll("[^\\d.]", "")) : 0;
                if (versionNumber > compareVersionNumber) {
                    this.isNewer = true;
                    return;
                }
                if (versionNumber == compareVersionNumber) continue;
                return;
            }
        }
    }
}

