/*
 * Decompiled with CFR 0.152.
 */
package com.lycanitesmobs.client.model.creature;

import com.lycanitesmobs.LycanitesMobs;
import com.lycanitesmobs.client.model.template.ModelTemplateElemental;
import com.lycanitesmobs.client.renderer.RenderCreature;
import com.lycanitesmobs.client.renderer.layer.LayerCreatureBase;
import com.lycanitesmobs.client.renderer.layer.LayerCreatureEffect;
import com.lycanitesmobs.client.renderer.layer.LayerCreatureScrolling;
import com.lycanitesmobs.core.entity.BaseCreatureEntity;
import javax.vecmath.Vector2f;
import javax.vecmath.Vector4f;
import net.minecraft.client.renderer.OpenGlHelper;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLiving;
import net.minecraft.util.math.MathHelper;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

@SideOnly(value=Side.CLIENT)
public class ModelWraith
extends ModelTemplateElemental {
    public ModelWraith() {
        this(1.0f);
    }

    public ModelWraith(float shadowSize) {
        this.initModel("wraith", LycanitesMobs.modInfo, "entity/wraith");
        this.trophyScale = 1.2f;
        this.trophyOffset = new float[]{0.0f, 0.0f, -0.4f};
    }

    @Override
    public void addCustomLayers(RenderCreature renderer) {
        super.addCustomLayers(renderer);
        renderer.func_177094_a(new LayerCreatureEffect(renderer, "overlay", true, LayerCreatureEffect.BLEND.NORMAL.id, true));
        renderer.func_177094_a(new LayerCreatureEffect(renderer, "skull", false, LayerCreatureEffect.BLEND.NORMAL.id, true));
        renderer.func_177094_a(new LayerCreatureScrolling(renderer, "", true, LayerCreatureEffect.BLEND.ADD.id, true, new Vector2f(-8.0f, 0.0f)));
    }

    @Override
    public void animatePart(String partName, EntityLiving entity, float time, float distance, float loop, float lookY, float lookX, float scale) {
        BaseCreatureEntity entityCreature;
        super.animatePart(partName, entity, time, distance, loop, lookY, lookX, scale);
        if (entity instanceof BaseCreatureEntity && (entityCreature = (BaseCreatureEntity)entity).hasAttackTarget() && partName.equals("mouth")) {
            this.rotate(20.0f + (float)(-Math.toDegrees(MathHelper.func_76134_b((float)loop) * 0.1f)), 0.0f, 0.0f);
        }
        float vibration = loop * 2.0f;
        if ("head".equals(partName)) {
            this.translate(MathHelper.func_76134_b((float)vibration) * 0.01f, MathHelper.func_76134_b((float)vibration) * 0.01f, MathHelper.func_76134_b((float)vibration) * 0.01f);
        } else if ("mouth".equals(partName)) {
            this.rotate((float)(-Math.toDegrees(MathHelper.func_76134_b((float)vibration) * 0.025f)), 0.0f, 0.0f);
        }
    }

    @Override
    public boolean canRenderPart(String partName, Entity entity, LayerCreatureBase layer, boolean trophy) {
        if ("head".equals(partName)) {
            return layer == null || "overlay".equals(layer.name);
        }
        if ("fire".equals(partName)) {
            return layer != null && layer instanceof LayerCreatureScrolling;
        }
        return layer != null && "skull".equals(layer.name);
    }

    @Override
    public Vector2f getBaseTextureOffset(String partName, Entity entity, boolean trophy, float loop) {
        return new Vector2f(-loop * 8.0f, 0.0f);
    }

    @Override
    public Vector4f getPartColor(String partName, Entity entity, LayerCreatureBase layer, boolean trophy, float loop) {
        if (layer == null || layer instanceof LayerCreatureScrolling) {
            float glowSpeed = 80.0f;
            float glow = loop * glowSpeed % 360.0f;
            float color = (float)Math.cos(Math.toRadians(glow)) * 0.1f + 0.9f;
            float alpha = 1.0f;
            if ("fire".equals(partName)) {
                alpha = 1.0f;
            }
            return new Vector4f(color, color, color, alpha);
        }
        return super.getPartColor(partName, entity, layer, trophy, loop);
    }

    @Override
    public void onRenderStart(LayerCreatureBase layer, Entity entity, boolean renderAsTrophy) {
        super.onRenderStart(layer, entity, renderAsTrophy);
        if (layer != null) {
            return;
        }
        int i = 0xF000F0;
        int j = i % 65536;
        int k = i / 65536;
        OpenGlHelper.func_77475_a((int)OpenGlHelper.field_77476_b, (float)j, (float)k);
    }

    @Override
    public void onRenderFinish(LayerCreatureBase layer, Entity entity, boolean renderAsTrophy) {
        super.onRenderFinish(layer, entity, renderAsTrophy);
        if (layer != null) {
            return;
        }
        int i = entity.func_70070_b();
        int j = i % 65536;
        int k = i / 65536;
        OpenGlHelper.func_77475_a((int)OpenGlHelper.field_77476_b, (float)j, (float)k);
    }
}

