/*
 * Decompiled with CFR 0.152.
 */
package com.lycanitesmobs.client.gui;

import com.lycanitesmobs.client.AssetManager;
import com.lycanitesmobs.client.gui.BaseContainerScreen;
import com.lycanitesmobs.client.gui.buttons.MainTab;
import com.lycanitesmobs.client.gui.widgets.SummoningPedestalList;
import com.lycanitesmobs.client.localisation.LanguageManager;
import com.lycanitesmobs.core.container.SummoningPedestalContainer;
import com.lycanitesmobs.core.entity.BaseCreatureEntity;
import com.lycanitesmobs.core.entity.ExtendedPlayer;
import com.lycanitesmobs.core.pets.SummonSet;
import com.lycanitesmobs.core.tileentity.TileEntitySummoningPedestal;
import java.io.IOException;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.FontRenderer;
import net.minecraft.client.gui.GuiButton;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.fml.client.GuiScrollingList;
import org.lwjgl.opengl.GL11;

public class SummoningPedestalScreen
extends BaseContainerScreen {
    public EntityPlayer player;
    public ExtendedPlayer playerExt;
    public TileEntitySummoningPedestal summoningPedestal;
    public SummonSet summonSet;
    public GuiScrollingList list;
    public int centerX;
    public int centerY;
    public int windowWidth;
    public int windowHeight;
    public int halfX;
    public int halfY;
    public int windowX;
    public int windowY;
    public static int TAB_BUTTON_ID = 55555;
    public int editSet;

    public SummoningPedestalScreen(EntityPlayer player, TileEntitySummoningPedestal summoningPedestal) {
        super(new SummoningPedestalContainer(summoningPedestal, player.field_71071_by));
        this.summoningPedestal = summoningPedestal;
        this.player = player;
        this.playerExt = ExtendedPlayer.getForPlayer(player);
        this.summonSet = this.summoningPedestal.summonSet;
    }

    public FontRenderer getFontRenderer() {
        return this.field_146289_q;
    }

    public boolean func_73868_f() {
        return false;
    }

    public void func_73866_w_() {
        super.func_73866_w_();
        this.field_146292_n.clear();
        this.windowWidth = 256;
        this.windowHeight = 166;
        this.halfX = this.windowWidth / 2;
        this.halfY = this.windowHeight / 2;
        this.windowX = this.field_146294_l / 2 - this.windowWidth / 2;
        this.windowY = this.field_146295_m / 2 - this.windowHeight / 2;
        this.centerX = this.windowX + this.windowWidth / 2;
        this.centerY = this.windowY + this.windowHeight / 2;
        this.initControls();
        this.initList();
    }

    public void initList() {
        if (this.hasPets() && this.summoningPedestal.summonSet != null) {
            this.selectMinion(this.summoningPedestal.summonSet.summonType);
        }
        int buttonSpacing = 2;
        int listWidth = this.windowWidth / 2 - buttonSpacing * 4;
        int listHeight = this.windowHeight - (39 + buttonSpacing) - 16;
        int listTop = this.windowY + 39 + buttonSpacing;
        int listBottom = listTop + listHeight;
        int listX = this.windowX + buttonSpacing * 2;
        this.list = new SummoningPedestalList(this, this.playerExt, listWidth, listHeight, listTop, listBottom, listX);
        this.list.registerScrollButtons(this.field_146292_n, 51, 52);
    }

    protected void initControls() {
        GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        int buttonSpacing = 2;
        int buttonWidth = this.windowWidth / 4 - buttonSpacing * 2;
        int buttonHeight = 20;
        int buttonX = this.windowX + 6;
        int buttonY = this.windowY;
        this.field_146292_n.add(new MainTab(TAB_BUTTON_ID, buttonX, buttonY - 24));
        buttonX = this.centerX + buttonSpacing;
        int buttonXRight = buttonX + buttonWidth + buttonSpacing;
        buttonY = this.windowY + 39 + buttonSpacing;
        this.field_146292_n.add(new GuiButton((int)BaseCreatureEntity.GUI_COMMAND.SITTING.id, buttonX, buttonY += buttonHeight + buttonSpacing * 2, buttonWidth * 2, buttonHeight, "..."));
        this.field_146292_n.add(new GuiButton((int)BaseCreatureEntity.GUI_COMMAND.PASSIVE.id, buttonX, buttonY += buttonHeight + buttonSpacing * 2, buttonWidth, buttonHeight, "..."));
        this.field_146292_n.add(new GuiButton((int)BaseCreatureEntity.GUI_COMMAND.STANCE.id, buttonXRight, buttonY, buttonWidth, buttonHeight, "..."));
        this.field_146292_n.add(new GuiButton((int)BaseCreatureEntity.GUI_COMMAND.PVP.id, buttonX, buttonY += buttonHeight + buttonSpacing * 2, buttonWidth * 2, buttonHeight, "..."));
    }

    @Override
    public void func_73863_a(int mouseX, int mouseY, float partialTicks) {
        super.func_73863_a(mouseX, mouseY, partialTicks);
        this.updateControls();
        this.drawGuiContainerForegroundLayer(partialTicks, mouseX, mouseY);
        if (this.hasPets()) {
            this.list.drawScreen(mouseX, mouseY, partialTicks);
        }
    }

    protected void drawGuiContainerForegroundLayer(float partialTicks, int mouseX, int mouseY) {
        GL11.glColor4f((float)255.0f, (float)255.0f, (float)255.0f, (float)1.0f);
        Minecraft.func_71410_x().func_110434_K().func_110577_a(this.getTexture());
        if (!this.hasPets()) {
            this.getFontRenderer().func_175063_a(LanguageManager.translate("gui.beastiary.summoning.empty.title"), (float)(this.centerX - 96), (float)(this.windowY + 6), 0xFFFFFF);
            this.getFontRenderer().func_78279_b(LanguageManager.translate("gui.beastiary.summoning.empty.info"), this.windowX + 16, this.windowY + 30, this.windowWidth - 32, 0xFFFFFF);
            return;
        }
        this.getFontRenderer().func_78276_b(this.getTitle(), this.centerX - 48, this.windowY + 6, 0xFFFFFF);
        this.getFontRenderer().func_78276_b(this.getEnergyTitle(), this.windowX + 16, this.windowY + 20, 0xFFFFFF);
    }

    public String getTitle() {
        return LanguageManager.translate("gui.summoningpedestal.name");
    }

    public String getEnergyTitle() {
        return LanguageManager.translate("stat.portal.name");
    }

    protected void func_146976_a(float partialTicks, int mouseX, int mouseY) {
        GL11.glColor4f((float)255.0f, (float)255.0f, (float)255.0f, (float)1.0f);
        this.field_146297_k.func_110434_K().func_110577_a(this.getTexture());
        this.func_73729_b(this.windowX, this.windowY, 0, 0, this.windowWidth, this.windowHeight);
        this.func_73729_b(this.windowX + 40, this.windowY + this.windowHeight, 40, 224, this.windowWidth - 80, 29);
        if (!this.hasPets()) {
            return;
        }
        this.drawFuel();
        this.drawCapacityBar();
        this.drawProgressBar();
    }

    public void drawFuel() {
        int fuelX = this.windowX + 132;
        int fuelY = this.windowY + 42;
        this.func_73729_b(fuelX, fuelY, 47, 170, 18, 18);
        int barWidth = 38;
        int barHeight = 11;
        int barX = fuelX + 22;
        int barY = fuelY + 3;
        int barU = 218;
        int barV = 225;
        this.func_73729_b(barX, barY, barU, barV + barHeight, barWidth, barHeight);
        barWidth = Math.round((float)barWidth * ((float)this.summoningPedestal.summoningFuel / (float)this.summoningPedestal.summoningFuelMax));
        this.func_73729_b(barX, barY, barU, barV, barWidth, barHeight);
    }

    public void drawCapacityBar() {
        int energyBarWidth = 9;
        int energyBarHeight = 9;
        int energyBarX = this.windowX + 16;
        int energyBarY = this.windowY + 40 - energyBarHeight;
        int energyBarU = 256 - energyBarWidth;
        int energyBarV = 256 - energyBarHeight;
        for (int energyBarEnergyN = 1; energyBarEnergyN <= 10; ++energyBarEnergyN) {
            this.func_73729_b(energyBarX - energyBarWidth + energyBarWidth * energyBarEnergyN, energyBarY, energyBarU, energyBarV, energyBarWidth, energyBarHeight);
            if (this.summoningPedestal.capacity >= energyBarEnergyN * this.summoningPedestal.capacityCharge) {
                this.func_73729_b(energyBarX - energyBarWidth + energyBarWidth * energyBarEnergyN, energyBarY, energyBarU - energyBarWidth * 2, energyBarV, energyBarWidth, energyBarHeight);
                continue;
            }
            if (this.summoningPedestal.capacity + this.summoningPedestal.capacityCharge <= energyBarEnergyN * this.summoningPedestal.capacityCharge) continue;
            float spiritChargeScale = (float)(this.summoningPedestal.capacity % this.summoningPedestal.capacityCharge) / (float)this.summoningPedestal.capacityCharge;
            this.func_73729_b(energyBarX - energyBarWidth + energyBarWidth * energyBarEnergyN, energyBarY, energyBarU - energyBarWidth * 2, energyBarV, Math.round((float)energyBarWidth * spiritChargeScale), energyBarHeight);
        }
    }

    public void drawProgressBar() {
        GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        this.field_146297_k.func_110434_K().func_110577_a(AssetManager.getTexture("GUIInventoryCreature"));
        int barWidth = 80;
        int barHeight = 11;
        int barX = this.centerX + 2;
        int barY = this.windowY + 26;
        int barU = 144;
        int barV = 256 - barHeight * 2;
        this.func_73729_b(barX, barY, barU, barV, barWidth, barHeight);
        barWidth = Math.round((float)barWidth * ((float)this.summoningPedestal.summonProgress / (float)this.summoningPedestal.summonProgressMax));
        this.func_73729_b(barX, barY, barU, barV += barHeight, barWidth, barHeight);
    }

    public void updateControls() {
        for (Object buttonObj : this.field_146292_n) {
            if (!(buttonObj instanceof GuiButton)) continue;
            GuiButton button = (GuiButton)buttonObj;
            if (button instanceof MainTab) {
                button.field_146124_l = true;
                button.field_146125_m = true;
                continue;
            }
            if (!this.hasSelectedPet()) {
                button.field_146124_l = false;
                button.field_146125_m = false;
                continue;
            }
            this.updateButtons(button);
        }
    }

    public void updateButtons(GuiButton button) {
        if (button.field_146127_k == BaseCreatureEntity.GUI_COMMAND.SITTING.id) {
            button.field_146126_j = LanguageManager.translate("gui.pet.sit") + ": " + (this.summonSet.getSitting() ? LanguageManager.translate("common.yes") : LanguageManager.translate("common.no"));
        }
        if (button.field_146127_k == BaseCreatureEntity.GUI_COMMAND.PASSIVE.id) {
            button.field_146126_j = LanguageManager.translate("gui.pet.passive") + ": " + (this.summonSet.getPassive() ? LanguageManager.translate("common.yes") : LanguageManager.translate("common.no"));
        }
        if (button.field_146127_k == BaseCreatureEntity.GUI_COMMAND.STANCE.id) {
            String string = button.field_146126_j = this.summonSet.getAggressive() ? LanguageManager.translate("gui.pet.aggressive") : LanguageManager.translate("gui.pet.defensive");
        }
        if (button.field_146127_k == BaseCreatureEntity.GUI_COMMAND.PVP.id) {
            button.field_146126_j = LanguageManager.translate("gui.pet.pvp") + ": " + (this.summonSet.getPVP() ? LanguageManager.translate("common.yes") : LanguageManager.translate("common.no"));
        }
    }

    public void sendCommandsToServer() {
        this.summoningPedestal.sendSummonSetToServer(this.summonSet);
    }

    protected void func_146284_a(GuiButton guiButton) throws IOException {
        if (!this.hasSelectedPet()) {
            super.func_146284_a(guiButton);
            return;
        }
        if (guiButton.field_146127_k == BaseCreatureEntity.GUI_COMMAND.SITTING.id) {
            boolean bl = this.summonSet.sitting = !this.summonSet.sitting;
        }
        if (guiButton.field_146127_k == BaseCreatureEntity.GUI_COMMAND.FOLLOWING.id) {
            boolean bl = this.summonSet.following = !this.summonSet.following;
        }
        if (guiButton.field_146127_k == BaseCreatureEntity.GUI_COMMAND.PASSIVE.id) {
            boolean bl = this.summonSet.passive = !this.summonSet.passive;
        }
        if (guiButton.field_146127_k == BaseCreatureEntity.GUI_COMMAND.STANCE.id) {
            boolean bl = this.summonSet.aggressive = !this.summonSet.aggressive;
        }
        if (guiButton.field_146127_k == BaseCreatureEntity.GUI_COMMAND.PVP.id) {
            boolean bl = this.summonSet.pvp = !this.summonSet.pvp;
        }
        if (guiButton.field_146127_k < 100) {
            this.sendCommandsToServer();
        }
        super.func_146284_a(guiButton);
    }

    protected void func_73869_a(char par1, int par2) throws IOException {
        if (par2 == 1 || par2 == this.field_146297_k.field_71474_y.field_151445_Q.func_151463_i()) {
            this.field_146297_k.field_71439_g.func_71053_j();
        }
        super.func_73869_a(par1, par2);
    }

    public void selectMinion(String minionName) {
        if (this.summonSet == null) {
            if (this.summoningPedestal.summonSet == null) {
                this.summoningPedestal.summonSet = new SummonSet(this.playerExt);
                this.summoningPedestal.sendSummonSetToServer(this.summoningPedestal.summonSet);
            }
            this.summonSet = this.summoningPedestal.summonSet;
        }
        this.summonSet.setSummonType(minionName);
        this.sendCommandsToServer();
    }

    public String getSelectedMinion() {
        if (this.summonSet == null) {
            return null;
        }
        return this.summonSet.summonType;
    }

    public boolean hasPets() {
        return this.playerExt.getBeastiary().getSummonableList().size() > 0;
    }

    public boolean hasSelectedPet() {
        return this.hasPets() && this.summonSet != null && !this.summonSet.summonType.equals("");
    }

    protected ResourceLocation getTexture() {
        return AssetManager.getTexture("GUIMinionLg");
    }
}

