/*
 * Decompiled with CFR 0.152.
 */
package de.keksuccino.fancymenu.menu.variables;

import de.keksuccino.fancymenu.FancyMenu;
import de.keksuccino.konkrete.properties.PropertiesSection;
import de.keksuccino.konkrete.properties.PropertiesSerializer;
import de.keksuccino.konkrete.properties.PropertiesSet;
import java.io.File;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.annotation.Nullable;

public class VariableHandler {
    protected static final File VARIABLES_FILE = new File(FancyMenu.MOD_DIR.getPath() + "/user_variables.db");
    protected static Map<String, String> variables = new HashMap<String, String>();

    public static void init() {
        VariableHandler.readFromFile();
        String variablesToResetOnLaunch = ((String)FancyMenu.config.getOrDefault("variables_to_reset_on_launch", (Object)"")).replace(" ", "");
        if (variablesToResetOnLaunch.contains(",")) {
            for (String s : variablesToResetOnLaunch.split(",")) {
                if (s.length() <= 0) continue;
                VariableHandler.removeVariable(s);
            }
        }
    }

    public static List<String> getVariableNames() {
        ArrayList<String> l = new ArrayList<String>();
        l.addAll(variables.keySet());
        return l;
    }

    @Nullable
    public static String getVariable(String name) {
        return variables.get(name);
    }

    public static void setVariable(String name, String value) {
        variables.put(name, value);
        VariableHandler.writeToFile();
    }

    public static void removeVariable(String name) {
        variables.remove(name);
        VariableHandler.writeToFile();
    }

    public static void clearVariables() {
        variables.clear();
        VariableHandler.writeToFile();
    }

    protected static void writeToFile() {
        try {
            if (!VARIABLES_FILE.exists()) {
                VARIABLES_FILE.createNewFile();
            }
            PropertiesSet set = new PropertiesSet("cached_variables");
            PropertiesSection sec = new PropertiesSection("variables");
            for (Map.Entry<String, String> m : variables.entrySet()) {
                sec.addEntry(m.getKey(), m.getValue());
            }
            set.addProperties(sec);
            PropertiesSerializer.writeProperties((PropertiesSet)set, (String)VARIABLES_FILE.getPath());
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    protected static void readFromFile() {
        try {
            List secs;
            if (!VARIABLES_FILE.exists()) {
                VariableHandler.writeToFile();
            }
            variables.clear();
            PropertiesSet set = PropertiesSerializer.getProperties((String)VARIABLES_FILE.getPath());
            if (set != null && !(secs = set.getPropertiesOfType("variables")).isEmpty()) {
                PropertiesSection sec = (PropertiesSection)secs.get(0);
                for (Map.Entry m : sec.getEntries().entrySet()) {
                    variables.put((String)m.getKey(), (String)m.getValue());
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }
}

