/*
 * Decompiled with CFR 0.152.
 */
package de.keksuccino.fancymenu.menu.placeholder.v2.placeholders.server;

import de.keksuccino.fancymenu.menu.placeholder.v2.DeserializedPlaceholderString;
import de.keksuccino.fancymenu.menu.placeholder.v2.Placeholder;
import de.keksuccino.fancymenu.menu.servers.ServerCache;
import de.keksuccino.konkrete.input.StringUtils;
import de.keksuccino.konkrete.localization.Locals;
import de.keksuccino.konkrete.math.MathUtils;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.client.multiplayer.ServerData;

public class ServerMotdPlaceholder
extends Placeholder {
    public ServerMotdPlaceholder() {
        super("servermotd");
    }

    @Override
    public String getReplacementFor(DeserializedPlaceholderString dps) {
        String ip = dps.values.get("ip");
        String line = dps.values.get("line");
        if (ip != null && line != null && MathUtils.isInteger((String)line)) {
            return ServerMotdPlaceholder.getServerMotdLine(ip, Integer.valueOf(line));
        }
        return null;
    }

    private static String getServerMotdLine(String ip, int line) {
        try {
            List<String> lines;
            ServerData sd;
            if (line > 2) {
                line = 2;
            }
            if (line < 1) {
                line = 1;
            }
            if ((sd = ServerCache.getServer(ip)) != null && sd.field_78843_d != null && (lines = ServerMotdPlaceholder.splitMotdLines(sd.field_78843_d)).size() >= 2) {
                return lines.get(line - 1);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return "";
    }

    private static List<String> splitMotdLines(String motd) {
        ArrayList<String> l = new ArrayList<String>();
        try {
            if (motd.contains("\n")) {
                l.addAll(Arrays.asList(motd.split("\n")));
            } else {
                l.add(motd);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return l;
    }

    @Override
    @Nullable
    public List<String> getValueNames() {
        ArrayList<String> l = new ArrayList<String>();
        l.add("ip");
        l.add("line");
        return l;
    }

    @Override
    public String getDisplayName() {
        return Locals.localize((String)"fancymenu.helper.ui.dynamicvariabletextfield.variables.servermotd", (String[])new String[0]);
    }

    @Override
    public List<String> getDescription() {
        return Arrays.asList(StringUtils.splitLines((String)Locals.localize((String)"fancymenu.helper.ui.dynamicvariabletextfield.variables.servermotd.desc", (String[])new String[0]), (String)"%n%"));
    }

    @Override
    public String getCategory() {
        return Locals.localize((String)"fancymenu.helper.ui.dynamicvariabletextfield.categories.server", (String[])new String[0]);
    }

    @Override
    @Nonnull
    public DeserializedPlaceholderString getDefaultPlaceholderString() {
        DeserializedPlaceholderString dps = new DeserializedPlaceholderString();
        dps.placeholder = this.getIdentifier();
        dps.values.put("ip", "someserver.com:25565");
        dps.values.put("line", "1");
        return dps;
    }
}

