/*
 * Decompiled with CFR 0.152.
 */
package de.keksuccino.fancymenu.menu.placeholder.v1.placeholders;

import de.keksuccino.fancymenu.api.placeholder.PlaceholderTextContainer;
import de.keksuccino.fancymenu.menu.fancy.helper.MenuReloadedEvent;
import de.keksuccino.konkrete.input.StringUtils;
import de.keksuccino.konkrete.localization.Locals;
import de.keksuccino.konkrete.web.WebUtils;
import java.net.URL;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class WebTextPlaceholder
extends PlaceholderTextContainer {
    private static final Logger LOGGER = LogManager.getLogger((String)"fancymenu/WebTextPlaceholder");
    protected static volatile Map<String, List<String>> cachedPlaceholders = new HashMap<String, List<String>>();
    protected static volatile List<String> currentlyUpdatingPlaceholders = new ArrayList<String>();
    protected static volatile List<String> invalidWebPlaceholderLinks = new ArrayList<String>();
    protected static boolean eventsRegistered = false;

    public WebTextPlaceholder() {
        super("fancymenu_placeholder_web_text");
        if (!eventsRegistered) {
            MinecraftForge.EVENT_BUS.register(WebTextPlaceholder.class);
            eventsRegistered = true;
        }
    }

    @SubscribeEvent
    public static void onReload(MenuReloadedEvent e) {
        try {
            cachedPlaceholders.clear();
            invalidWebPlaceholderLinks.clear();
            LOGGER.info("WebTextPlaceholder cache successfully cleared!");
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    @Override
    public String replacePlaceholders(String rawIn) {
        String s = rawIn;
        List<String> l = WebTextPlaceholder.getPlaceholdersWithValue(s, "%webtext:");
        for (String s2 : l) {
            String blank;
            String link;
            if (!s2.contains(":") || WebTextPlaceholder.isInvalidWebPlaceholderLink(link = (blank = WebTextPlaceholder.getPlaceholderWithoutPercentPrefixSuffix(s2)).split("[:]", 2)[1])) continue;
            List<String> lines = WebTextPlaceholder.getCachedWebPlaceholder(s2);
            if (lines != null) {
                if (lines.isEmpty()) continue;
                s = s.replace(s2, lines.get(0));
                continue;
            }
            if (!WebTextPlaceholder.isWebPlaceholderUpdating(s2)) {
                WebTextPlaceholder.cacheWebPlaceholder(s2, link);
            }
            s = s.replace(s2, "");
        }
        return s;
    }

    protected static boolean isInvalidWebPlaceholderLink(String link) {
        try {
            return invalidWebPlaceholderLinks.contains(link);
        }
        catch (Exception e) {
            e.printStackTrace();
            return true;
        }
    }

    protected static List<String> getCachedWebPlaceholder(String placeholder) {
        try {
            return cachedPlaceholders.get(placeholder);
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    protected static boolean isWebPlaceholderUpdating(String placeholder) {
        try {
            return currentlyUpdatingPlaceholders.contains(placeholder);
        }
        catch (Exception e) {
            e.printStackTrace();
            return true;
        }
    }

    protected static void cacheWebPlaceholder(String placeholder, String link) {
        try {
            if (!currentlyUpdatingPlaceholders.contains(placeholder)) {
                currentlyUpdatingPlaceholders.add(placeholder);
                new Thread(() -> {
                    try {
                        if (WebUtils.isValidUrl((String)link)) {
                            cachedPlaceholders.put(placeholder, WebUtils.getPlainTextContentOfPage((URL)new URL(link)));
                        } else {
                            invalidWebPlaceholderLinks.add(link);
                        }
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                    }
                    try {
                        currentlyUpdatingPlaceholders.remove(placeholder);
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                    }
                }).start();
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    @Override
    public String getPlaceholder() {
        return "%webtext:<link_to_text>%";
    }

    @Override
    public String getCategory() {
        return null;
    }

    @Override
    public String getDisplayName() {
        return Locals.localize((String)"fancymenu.helper.placeholder.webtext", (String[])new String[0]);
    }

    @Override
    public String[] getDescription() {
        return StringUtils.splitLines((String)Locals.localize((String)"fancymenu.helper.placeholder.webtext.desc", (String[])new String[0]), (String)"%n%");
    }
}

