/*
 * Decompiled with CFR 0.152.
 */
package de.keksuccino.fancymenu.menu.fancy.menuhandler.deepcustomizationlayer.layers.titlescreen.splash;

import com.google.common.collect.Lists;
import de.keksuccino.fancymenu.menu.fancy.menuhandler.deepcustomizationlayer.DeepCustomizationElement;
import de.keksuccino.fancymenu.menu.fancy.menuhandler.deepcustomizationlayer.DeepCustomizationItem;
import de.keksuccino.konkrete.file.FileUtils;
import de.keksuccino.konkrete.math.MathUtils;
import de.keksuccino.konkrete.properties.PropertiesSection;
import de.keksuccino.konkrete.rendering.RenderUtils;
import java.awt.Color;
import java.io.BufferedReader;
import java.io.Closeable;
import java.io.File;
import java.io.IOException;
import java.io.InputStreamReader;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.List;
import java.util.Random;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.FontRenderer;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.resources.IResource;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.MathHelper;
import org.apache.commons.io.IOUtils;

public class TitleScreenSplashItem
extends DeepCustomizationItem {
    private static final Random RANDOM = new Random();
    private static final ResourceLocation SPLASH_TEXTS = new ResourceLocation("texts/splashes.txt");
    public static String cachedSplashText;
    public String splashTextFilePath;
    public int splashRotation = -20;
    public Color splashColor = new Color(255, 255, 0);
    public String splashColorHEX = "#ffff00";
    protected int lastSplashPosX = 0;
    protected int lastSplashPosY = 0;

    public TitleScreenSplashItem(DeepCustomizationElement parentElement, PropertiesSection item) {
        super(parentElement, item);
        Color c;
        String splashCol;
        this.splashTextFilePath = item.getEntryValue("splash_file_path");
        String splashRot = item.getEntryValue("splash_rotation");
        if (splashRot != null && MathUtils.isInteger((String)splashRot)) {
            this.splashRotation = Integer.parseInt(splashRot);
        }
        if ((splashCol = item.getEntryValue("splash_color")) != null && (c = RenderUtils.getColorFromHexString((String)splashCol)) != null) {
            this.splashColor = c;
            this.splashColorHEX = splashCol;
        }
    }

    @Override
    public int getPosX(GuiScreen menu) {
        return this.lastSplashPosX - this.getWidth() / 2;
    }

    @Override
    public int getPosY(GuiScreen menu) {
        return this.lastSplashPosY - this.getHeight() / 2;
    }

    @Override
    public void render(GuiScreen menu) throws IOException {
        this.setWidth(60);
        this.setHeight(30);
        if (!this.hidden) {
            GlStateManager.func_179147_l();
            this.renderSplash(Minecraft.func_71410_x().field_71466_p, menu);
        }
    }

    protected void renderSplash(FontRenderer font, GuiScreen s) {
        float finalPosX = s.field_146294_l / 2 + 90;
        float finalPosY = 70.0f;
        int originX = 0;
        int originY = 0;
        if (this.orientation.equalsIgnoreCase("original")) {
            originX = (int)finalPosX;
            originY = (int)finalPosY;
        } else if (!this.orientation.equalsIgnoreCase("top-left")) {
            if (this.orientation.equalsIgnoreCase("mid-left")) {
                originY = s.field_146295_m / 2;
            } else if (this.orientation.equalsIgnoreCase("bottom-left")) {
                originY = s.field_146295_m;
            } else if (this.orientation.equalsIgnoreCase("top-centered")) {
                originX = s.field_146294_l / 2;
            } else if (this.orientation.equalsIgnoreCase("mid-centered")) {
                originX = s.field_146294_l / 2;
                originY = s.field_146295_m / 2;
            } else if (this.orientation.equalsIgnoreCase("bottom-centered")) {
                originX = s.field_146294_l / 2;
                originY = s.field_146295_m;
            } else if (this.orientation.equalsIgnoreCase("top-right")) {
                originX = s.field_146294_l;
            } else if (this.orientation.equalsIgnoreCase("mid-right")) {
                originX = s.field_146294_l;
                originY = s.field_146295_m / 2;
            } else if (this.orientation.equalsIgnoreCase("bottom-right")) {
                originX = s.field_146294_l;
                originY = s.field_146295_m;
            }
        }
        finalPosX = originX + this.posX;
        finalPosY = originY + this.posY;
        this.lastSplashPosX = (int)finalPosX;
        this.lastSplashPosY = (int)finalPosY;
        if (cachedSplashText == null) {
            cachedSplashText = this.getRandomSplashText();
        }
        if (cachedSplashText == null) {
            cachedSplashText = "\u00a7c< ERROR! UNABLE TO GET SPLASH TEXT! >";
        }
        GlStateManager.func_179094_E();
        GlStateManager.func_179109_b((float)finalPosX, (float)finalPosY, (float)0.0f);
        GlStateManager.func_179114_b((float)this.splashRotation, (float)0.0f, (float)0.0f, (float)1.0f);
        float f = 1.8f - MathHelper.func_76135_e((float)(MathHelper.func_76126_a((float)((float)(System.currentTimeMillis() % 1000L) / 1000.0f * ((float)Math.PI * 2))) * 0.1f));
        f = f * 100.0f / (float)(font.func_78256_a(cachedSplashText) + 32);
        GlStateManager.func_179152_a((float)f, (float)f, (float)f);
        this.func_73732_a(font, cachedSplashText, 0, -8, this.splashColor.getRGB());
        GlStateManager.func_179121_F();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getRandomSplashText() {
        IResource iresource;
        String sp;
        block9: {
            List l;
            File f;
            if (this.splashTextFilePath != null && !this.splashTextFilePath.replace(" ", "").equals("") && (f = new File(this.splashTextFilePath)).exists() && f.isFile() && f.getPath().toLowerCase().endsWith(".txt") && (l = FileUtils.getFileLines((File)f)) != null && !l.isEmpty()) {
                int random = MathUtils.getRandomNumberInRange((int)0, (int)(l.size() - 1));
                return (String)l.get(random);
            }
            sp = "missingno";
            iresource = null;
            try {
                String s;
                ArrayList list = Lists.newArrayList();
                iresource = Minecraft.func_71410_x().func_110442_L().func_110536_a(SPLASH_TEXTS);
                BufferedReader bufferedreader = new BufferedReader(new InputStreamReader(iresource.func_110527_b(), StandardCharsets.UTF_8));
                while ((s = bufferedreader.readLine()) != null) {
                    if ((s = s.trim()).isEmpty()) continue;
                    list.add(s);
                }
                if (!list.isEmpty()) {
                    while ((sp = (String)list.get(RANDOM.nextInt(list.size()))).hashCode() == 125780783) {
                    }
                }
                Calendar calendar = Calendar.getInstance();
                calendar.setTime(new Date());
                if (calendar.get(2) + 1 == 12 && calendar.get(5) == 24) {
                    sp = "Merry X-mas!";
                    break block9;
                }
                if (calendar.get(2) + 1 == 1 && calendar.get(5) == 1) {
                    sp = "Happy new year!";
                    break block9;
                }
                if (calendar.get(2) + 1 != 10 || calendar.get(5) != 31) break block9;
                sp = "OOoooOOOoooo! Spooky!";
            }
            catch (IOException iOException) {
                IOUtils.closeQuietly(iresource);
            }
            catch (Throwable throwable) {
                IOUtils.closeQuietly(iresource);
                throw throwable;
            }
        }
        IOUtils.closeQuietly((Closeable)iresource);
        return sp;
    }
}

