/*
 * Decompiled with CFR 0.152.
 */
package de.keksuccino.fancymenu.menu.fancy.item;

import de.keksuccino.fancymenu.menu.fancy.item.CustomizationItemBase;
import de.keksuccino.konkrete.properties.PropertiesSection;
import de.keksuccino.konkrete.rendering.animation.ExternalGifAnimationRenderer;
import de.keksuccino.konkrete.resources.ExternalTextureResourceLocation;
import de.keksuccino.konkrete.resources.TextureHandler;
import java.io.File;
import java.io.IOException;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.client.renderer.GlStateManager;

public class TextureCustomizationItem
extends CustomizationItemBase {
    public ExternalTextureResourceLocation texture;
    public ExternalGifAnimationRenderer gif;

    public TextureCustomizationItem(PropertiesSection item) {
        super(item);
        if (this.action != null && this.action.equalsIgnoreCase("addtexture")) {
            this.value = TextureCustomizationItem.fixBackslashPath(item.getEntryValue("path"));
            if (this.value != null) {
                this.value = this.value.replace("\\", "/");
                File f = new File(this.value);
                String finalValue = this.value;
                if (!f.exists() || !f.getAbsolutePath().replace("\\", "/").startsWith(Minecraft.func_71410_x().field_71412_D.getAbsolutePath().replace("\\", "/"))) {
                    finalValue = Minecraft.func_71410_x().field_71412_D.getAbsolutePath().replace("\\", "/") + "/" + this.value;
                    f = new File(finalValue);
                }
                if (f.exists() && f.isFile() && (f.getName().endsWith(".png") || f.getName().endsWith(".jpg") || f.getName().endsWith(".jpeg") || f.getName().endsWith(".gif"))) {
                    try {
                        int w = 0;
                        int h = 0;
                        if (f.getName().endsWith(".gif")) {
                            this.gif = TextureHandler.getGifResource((String)finalValue);
                            if (this.gif != null) {
                                w = this.gif.getWidth();
                                h = this.gif.getHeight();
                            }
                        } else {
                            this.texture = TextureHandler.getResource((String)finalValue);
                            if (this.texture != null) {
                                w = this.texture.getWidth();
                                h = this.texture.getHeight();
                            }
                        }
                        double ratio = (double)w / (double)h;
                        if (this.getWidth() < 0 && this.getHeight() >= 0) {
                            this.setWidth((int)((double)this.getHeight() * ratio));
                        }
                        if (this.getHeight() < 0 && this.getWidth() >= 0) {
                            this.setHeight((int)((double)this.getWidth() / ratio));
                        }
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                    }
                }
            }
        }
    }

    @Override
    public void render(GuiScreen menu) throws IOException {
        if (this.shouldRender()) {
            int x = this.getPosX(menu);
            int y = this.getPosY(menu);
            if (this.gif != null) {
                int w = this.gif.getWidth();
                int h = this.gif.getHeight();
                int x2 = this.gif.getPosX();
                int y2 = this.gif.getPosY();
                GlStateManager.func_179147_l();
                GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)this.opacity);
                this.gif.setPosX(x);
                this.gif.setPosY(y);
                this.gif.setWidth(this.getWidth());
                this.gif.setHeight(this.getHeight());
                this.gif.setOpacity(this.opacity);
                this.gif.render();
                this.gif.setPosX(x2);
                this.gif.setPosY(y2);
                this.gif.setWidth(w);
                this.gif.setHeight(h);
                GlStateManager.func_179084_k();
            } else if (this.texture != null) {
                Minecraft.func_71410_x().func_110434_K().func_110577_a(this.texture.getResourceLocation());
                GlStateManager.func_179147_l();
                GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)this.opacity);
                GuiScreen.func_146110_a((int)x, (int)y, (float)0.0f, (float)0.0f, (int)this.getWidth(), (int)this.getHeight(), (float)this.getWidth(), (float)this.getHeight());
                GlStateManager.func_179084_k();
            }
        }
    }

    @Override
    public boolean shouldRender() {
        if (this.texture == null && this.gif == null) {
            return false;
        }
        if (this.getWidth() < 0 || this.getHeight() < 0) {
            return false;
        }
        return super.shouldRender();
    }
}

