/*
 * Decompiled with CFR 0.152.
 */
package de.keksuccino.fancymenu.menu.fancy.item;

import com.google.common.collect.Lists;
import de.keksuccino.fancymenu.menu.fancy.helper.MenuReloadedEvent;
import de.keksuccino.fancymenu.menu.fancy.item.CustomizationItemBase;
import de.keksuccino.fancymenu.menu.placeholder.v2.PlaceholderParser;
import de.keksuccino.konkrete.file.FileUtils;
import de.keksuccino.konkrete.input.StringUtils;
import de.keksuccino.konkrete.math.MathUtils;
import de.keksuccino.konkrete.properties.PropertiesSection;
import de.keksuccino.konkrete.rendering.RenderUtils;
import java.awt.Color;
import java.io.BufferedReader;
import java.io.Closeable;
import java.io.File;
import java.io.IOException;
import java.io.InputStreamReader;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Random;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.FontRenderer;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.resources.IResource;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.MathHelper;
import net.minecraftforge.client.event.GuiScreenEvent;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import org.apache.commons.io.IOUtils;

public class SplashTextCustomizationItem
extends CustomizationItemBase {
    private static final Random RANDOM = new Random();
    private static final ResourceLocation SPLASH_TEXTS = new ResourceLocation("texts/splashes.txt");
    protected static Map<String, String> splashCache = new HashMap<String, String>();
    protected static boolean init = false;
    public float scale = 1.0f;
    public boolean shadow = true;
    public boolean bounce = true;
    public float rotation = 20.0f;
    public Color basecolor = new Color(255, 255, 0);
    public String basecolorString = "#ffff00";
    public boolean refreshOnMenuReload = false;
    public File splashfile;
    public String text = null;
    public boolean vanillaLike = false;
    protected float basescale = 1.8f;
    protected static boolean isNewMenu = false;
    protected boolean isNewMenuThis = false;
    protected static GuiScreen lastScreen = null;
    protected static Map<String, String> vanillaLikeCache = new HashMap<String, String>();

    public SplashTextCustomizationItem(PropertiesSection item) {
        super(item);
        if (!init) {
            MinecraftForge.EVENT_BUS.register(SplashTextCustomizationItem.class);
            init = true;
        }
        if (this.action != null && this.action.equalsIgnoreCase("addsplash")) {
            String b;
            String sc;
            String sh;
            Color c;
            String co;
            String re;
            String filepath;
            String vanillaLikeString = item.getEntryValue("vanilla-like");
            if (vanillaLikeString != null && vanillaLikeString.equals("true")) {
                this.vanillaLike = true;
            }
            if ((filepath = SplashTextCustomizationItem.fixBackslashPath(item.getEntryValue("splashfilepath"))) != null) {
                this.splashfile = new File(filepath);
                if (!this.splashfile.exists() || !this.splashfile.getAbsolutePath().replace("\\", "/").startsWith(Minecraft.func_71410_x().field_71412_D.getAbsolutePath().replace("\\", "/"))) {
                    filepath = Minecraft.func_71410_x().field_71412_D.getAbsolutePath().replace("\\", "/") + "/" + filepath;
                    this.splashfile = new File(filepath);
                }
                if (!this.splashfile.exists() || !this.splashfile.getPath().toLowerCase().endsWith(".txt")) {
                    this.splashfile = null;
                }
            }
            if (!this.vanillaLike) {
                this.text = item.getEntryValue("text");
            } else if (vanillaLikeCache.containsKey(this.actionId)) {
                this.text = vanillaLikeCache.get(this.actionId);
            }
            String ro = item.getEntryValue("rotation");
            if (ro != null && MathUtils.isFloat((String)ro)) {
                this.rotation = Float.parseFloat(ro);
            }
            if ((re = item.getEntryValue("refresh")) != null && re.equalsIgnoreCase("true")) {
                this.refreshOnMenuReload = true;
            }
            if ((co = item.getEntryValue("basecolor")) != null && (c = RenderUtils.getColorFromHexString((String)co)) != null) {
                this.basecolor = c;
                this.basecolorString = co;
            }
            if ((sh = item.getEntryValue("shadow")) != null && sh.equalsIgnoreCase("false")) {
                this.shadow = false;
            }
            if ((sc = item.getEntryValue("scale")) != null && MathUtils.isFloat((String)sc)) {
                this.scale = Float.parseFloat(sc);
            }
            if ((b = item.getEntryValue("bouncing")) != null && b.equalsIgnoreCase("false")) {
                this.bounce = false;
            }
            this.value = "splash text";
            this.setWidth((int)(30.0f * this.basescale * this.scale));
            this.setHeight((int)(10.0f * this.basescale * this.scale));
        }
    }

    @Override
    public void render(GuiScreen menu) throws IOException {
        if (this.isNewMenuThis) {
            isNewMenu = false;
        }
        this.isNewMenuThis = isNewMenu;
        this.setWidth((int)(30.0f * this.basescale * this.scale));
        this.setHeight((int)(10.0f * this.basescale * this.scale));
        if (this.shouldRender()) {
            this.renderSplash(Minecraft.func_71410_x().field_71466_p, menu);
        }
    }

    protected void renderSplash(FontRenderer font, GuiScreen s) {
        String splash = null;
        if (this.vanillaLike && this.text == null) {
            this.text = SplashTextCustomizationItem.getVanillaSplash();
            vanillaLikeCache.put(this.actionId, this.text);
        }
        if (this.splashfile != null && this.text == null) {
            List l;
            if (isNewMenu && this.refreshOnMenuReload) {
                splashCache.remove(this.getActionId());
            }
            if (!splashCache.containsKey(this.getActionId()) && !(l = FileUtils.getFileLines((File)this.splashfile)).isEmpty()) {
                int i = MathUtils.getRandomNumberInRange((int)0, (int)(l.size() - 1));
                splashCache.put(this.getActionId(), (String)l.get(i));
            }
            if (splashCache.containsKey(this.getActionId())) {
                splash = splashCache.get(this.getActionId());
            }
        }
        if (this.text != null) {
            splash = this.text;
        }
        if (splash != null) {
            if (this.value != null) {
                splash = !SplashTextCustomizationItem.isEditorActive() ? PlaceholderParser.replacePlaceholders(splash) : StringUtils.convertFormatCodes((String)splash, (String)"&", (String)"\u00a7");
            }
            this.value = splash;
            float f = this.basescale;
            if (this.bounce) {
                f -= MathHelper.func_76135_e((float)(MathHelper.func_76126_a((float)((float)(System.currentTimeMillis() % 1000L) / 1000.0f * ((float)Math.PI * 2))) * 0.1f));
            }
            f = f * 100.0f / (float)(font.func_78256_a(splash) + 32);
            GlStateManager.func_179147_l();
            GlStateManager.func_179094_E();
            GlStateManager.func_179152_a((float)this.scale, (float)this.scale, (float)this.scale);
            GlStateManager.func_179094_E();
            GlStateManager.func_179109_b((float)((float)(this.getPosX(s) + this.getWidth() / 2) / this.scale), (float)((float)this.getPosY(s) / this.scale), (float)0.0f);
            GlStateManager.func_179114_b((float)this.rotation, (float)0.0f, (float)0.0f, (float)1.0f);
            GlStateManager.func_179152_a((float)f, (float)f, (float)f);
            int alpha = this.basecolor.getAlpha();
            int i = MathHelper.func_76123_f((float)(this.opacity * 255.0f));
            if (i < alpha) {
                alpha = i;
            }
            Color c = new Color(this.basecolor.getRed(), this.basecolor.getGreen(), this.basecolor.getBlue(), alpha);
            if (this.shadow) {
                font.func_175063_a(splash, (float)(-(font.func_78256_a(splash) / 2)), 0.0f, c.getRGB());
            } else {
                font.func_78276_b(splash, -(font.func_78256_a(splash) / 2), 0, c.getRGB());
            }
            GlStateManager.func_179121_F();
            GlStateManager.func_179121_F();
        }
    }

    @SubscribeEvent
    public static void onInitScreenPre(GuiScreenEvent.InitGuiEvent.Pre e) {
        GuiScreen s = Minecraft.func_71410_x().field_71462_r;
        if (!(s == null || lastScreen != null && lastScreen.getClass().getName().equals(s.getClass().getName()))) {
            isNewMenu = true;
        }
        lastScreen = s;
    }

    @SubscribeEvent
    public static void onMenuReloaded(MenuReloadedEvent e) {
        splashCache.clear();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String getVanillaSplash() {
        IResource iresource;
        String sp;
        block8: {
            sp = "missingno";
            iresource = null;
            try {
                String s;
                ArrayList list = Lists.newArrayList();
                iresource = Minecraft.func_71410_x().func_110442_L().func_110536_a(SPLASH_TEXTS);
                BufferedReader bufferedreader = new BufferedReader(new InputStreamReader(iresource.func_110527_b(), StandardCharsets.UTF_8));
                while ((s = bufferedreader.readLine()) != null) {
                    if ((s = s.trim()).isEmpty()) continue;
                    list.add(s);
                }
                if (!list.isEmpty()) {
                    while ((sp = (String)list.get(RANDOM.nextInt(list.size()))).hashCode() == 125780783) {
                    }
                }
                Calendar calendar = Calendar.getInstance();
                calendar.setTime(new Date());
                if (calendar.get(2) + 1 == 12 && calendar.get(5) == 24) {
                    sp = "Merry X-mas!";
                    break block8;
                }
                if (calendar.get(2) + 1 == 1 && calendar.get(5) == 1) {
                    sp = "Happy new year!";
                    break block8;
                }
                if (calendar.get(2) + 1 != 10 || calendar.get(5) != 31) break block8;
                sp = "OOoooOOOoooo! Spooky!";
            }
            catch (IOException iOException) {
                IOUtils.closeQuietly(iresource);
            }
            catch (Throwable throwable) {
                IOUtils.closeQuietly(iresource);
                throw throwable;
            }
        }
        IOUtils.closeQuietly((Closeable)iresource);
        return sp;
    }
}

