/*
 * Decompiled with CFR 0.152.
 */
package de.keksuccino.fancymenu.menu.fancy.helper.ui.texteditor;

import de.keksuccino.fancymenu.menu.fancy.helper.layoutcreator.LayoutEditorScreen;
import de.keksuccino.fancymenu.menu.fancy.helper.ui.FMContextMenu;
import de.keksuccino.fancymenu.menu.fancy.helper.ui.UIBase;
import de.keksuccino.fancymenu.menu.fancy.helper.ui.compat.AbstractGui;
import de.keksuccino.fancymenu.menu.fancy.helper.ui.compat.RenderSystem;
import de.keksuccino.fancymenu.menu.fancy.helper.ui.compat.Screen;
import de.keksuccino.fancymenu.menu.fancy.helper.ui.compat.component.Component;
import de.keksuccino.fancymenu.menu.fancy.helper.ui.compat.widget.AdvancedButton;
import de.keksuccino.fancymenu.menu.fancy.helper.ui.compat.widget.AdvancedTextField;
import de.keksuccino.fancymenu.menu.fancy.helper.ui.scroll.scrollbar.ScrollBar;
import de.keksuccino.fancymenu.menu.fancy.helper.ui.texteditor.TextEditorFormattingRule;
import de.keksuccino.fancymenu.menu.fancy.helper.ui.texteditor.TextEditorLine;
import de.keksuccino.fancymenu.menu.fancy.helper.ui.texteditor.formattingrules.TextEditorFormattingRules;
import de.keksuccino.fancymenu.menu.placeholder.v2.Placeholder;
import de.keksuccino.fancymenu.menu.placeholder.v2.PlaceholderRegistry;
import de.keksuccino.fancymenu.mixin.client.IMixinGuiTextField;
import de.keksuccino.konkrete.input.CharacterFilter;
import de.keksuccino.konkrete.input.MouseInput;
import de.keksuccino.konkrete.input.StringUtils;
import de.keksuccino.konkrete.localization.Locals;
import java.awt.Color;
import java.lang.reflect.Array;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Consumer;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.FontRenderer;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.client.gui.ScaledResolution;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.text.ITextComponent;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class TextEditorScreen
extends Screen {
    private static final Logger LOGGER = LogManager.getLogger();
    public GuiScreen parentScreen;
    public CharacterFilter characterFilter;
    public Consumer<String> callback;
    public List<TextEditorLine> textFieldLines = new ArrayList<TextEditorLine>();
    public ScrollBar verticalScrollBar = new ScrollBar(ScrollBar.ScrollBarDirection.VERTICAL, 5, 40, 0, 0, 0, 0, (Color)null, null);
    public ScrollBar horizontalScrollBar = new ScrollBar(ScrollBar.ScrollBarDirection.HORIZONTAL, 40, 5, 0, 0, 0, 0, (Color)null, null);
    public ScrollBar verticalScrollBarPlaceholderMenu = new ScrollBar(ScrollBar.ScrollBarDirection.VERTICAL, 5, 40, 0, 0, 0, 0, (Color)null, null);
    public ScrollBar horizontalScrollBarPlaceholderMenu = new ScrollBar(ScrollBar.ScrollBarDirection.HORIZONTAL, 40, 5, 0, 0, 0, 0, (Color)null, null);
    public FMContextMenu rightClickContextMenu;
    public AdvancedButton cancelButton;
    public AdvancedButton doneButton;
    public AdvancedButton placeholderButton;
    public int lastCursorPosSetByUser = 0;
    public boolean justSwitchedLineByWordDeletion = false;
    public boolean triggeredFocusedLineWasTooHighInCursorPosMethod = false;
    public int headerHeight = 50;
    public int footerHeight = 50;
    public int borderLeft = 40;
    public int borderRight = 20;
    public int lineHeight = 14;
    public Color screenBackgroundColor = UIBase.SCREEN_BACKGROUND_COLOR;
    public Color editorAreaBorderColor = UIBase.ELEMENT_BORDER_COLOR_IDLE;
    public Color editorAreaBackgroundColor = UIBase.AREA_BACKGROUND_COLOR;
    public Color textColor = UIBase.TEXT_COLOR_GRAY_1;
    public Color focusedLineColor = UIBase.ENTRY_COLOR_FOCUSED;
    public Color scrollGrabberIdleColor = UIBase.SCROLL_GRABBER_IDLE_COLOR;
    public Color scrollGrabberHoverColor = UIBase.SCROLL_GRABBER_HOVER_COLOR;
    public Color sideBarColor = UIBase.SIDE_BAR_COLOR;
    public Color lineNumberTextColorNormal = UIBase.TEXT_COLOR_GREY_2;
    public Color lineNumberTextColorFocused = UIBase.TEXT_COLOR_GREY_3;
    public Color multilineNotSupportedNotificationColor = UIBase.TEXT_COLOR_RED_1;
    public Color placeholderEntryBackgroundColorIdle = UIBase.AREA_BACKGROUND_COLOR;
    public Color placeholderEntryBackgroundColorHover = UIBase.ENTRY_COLOR_FOCUSED;
    public Color placeholderEntryDotColorPlaceholder = UIBase.LISTING_DOT_BLUE;
    public Color placeholderEntryDotColorCategory = UIBase.LISTING_DOT_RED;
    public Color placeholderEntryLabelColor = UIBase.TEXT_COLOR_GRAY_1;
    public Color placeholderEntryBackToCategoriesLabelColor = UIBase.TEXT_COLOR_ORANGE_1;
    public int currentLineWidth;
    public int lastTickFocusedLineIndex = -1;
    public TextEditorLine startHighlightLine = null;
    public int startHighlightLineIndex = -1;
    public int endHighlightLineIndex = -1;
    public int overriddenTotalScrollHeight = -1;
    public List<Runnable> lineNumberRenderQueue = new ArrayList<Runnable>();
    public List<TextEditorFormattingRule> formattingRules = new ArrayList<TextEditorFormattingRule>();
    public int currentRenderCharacterIndexTotal = 0;
    public static boolean showPlaceholderMenu = false;
    public int placeholderMenuWidth = 120;
    public int placeholderMenuEntryHeight = 16;
    public List<PlaceholderMenuEntry> placeholderMenuEntries = new ArrayList<PlaceholderMenuEntry>();
    public boolean multilineMode = true;
    public long multilineNotSupportedNotificationDisplayStart = -1L;
    public boolean boldTitle = true;

    public TextEditorScreen(GuiScreen parent, CharacterFilter characterFilter, Consumer<String> callback) {
        this(null, parent, characterFilter, callback);
    }

    public TextEditorScreen(ITextComponent title, GuiScreen parent, CharacterFilter characterFilter, Consumer<String> callback) {
        super((ITextComponent)(title != null ? title : Component.literal("")));
        this.minecraft = Minecraft.func_71410_x();
        this.font = Minecraft.func_71410_x().field_71466_p;
        this.parentScreen = parent;
        this.characterFilter = characterFilter;
        this.callback = callback;
        this.addLine();
        this.getLine(0).func_146195_b(true);
        this.verticalScrollBar.setScrollWheelAllowed(true);
        this.verticalScrollBarPlaceholderMenu.setScrollWheelAllowed(true);
        this.updateRightClickContextMenu();
        this.formattingRules.addAll(TextEditorFormattingRules.getRules());
        this.updatePlaceholderEntries(null, true, true);
        this.updateCurrentLineWidth();
    }

    @Override
    public void init() {
        if (this.parentScreen != null && this.parentScreen instanceof LayoutEditorScreen && ((LayoutEditorScreen)this.parentScreen).oriscale != -1) {
            Minecraft.func_71410_x().field_71474_y.field_74335_Z = ((LayoutEditorScreen)this.parentScreen).oriscale;
            ((LayoutEditorScreen)this.parentScreen).oriscale = -1;
            ScaledResolution res = new ScaledResolution(Minecraft.func_71410_x());
            this.field_146294_l = res.func_78326_a();
            this.field_146295_m = res.func_78328_b();
        }
        super.init();
        this.verticalScrollBar.scrollAreaStartX = this.getEditorAreaX() + 1;
        this.verticalScrollBar.scrollAreaStartY = this.getEditorAreaY() + 1;
        this.verticalScrollBar.scrollAreaEndX = this.getEditorAreaX() + this.getEditorAreaWidth() - 2;
        this.verticalScrollBar.scrollAreaEndY = this.getEditorAreaY() + this.getEditorAreaHeight() - this.horizontalScrollBar.grabberHeight - 2;
        this.horizontalScrollBar.scrollAreaStartX = this.getEditorAreaX() + 1;
        this.horizontalScrollBar.scrollAreaStartY = this.getEditorAreaY() + 1;
        this.horizontalScrollBar.scrollAreaEndX = this.getEditorAreaX() + this.getEditorAreaWidth() - this.verticalScrollBar.grabberWidth - 2;
        this.horizontalScrollBar.scrollAreaEndY = this.getEditorAreaY() + this.getEditorAreaHeight() - 1;
        int placeholderAreaX = this.field_146294_l - this.borderRight - this.placeholderMenuWidth;
        int placeholderAreaY = this.getEditorAreaY();
        this.verticalScrollBarPlaceholderMenu.scrollAreaStartX = placeholderAreaX + 1;
        this.verticalScrollBarPlaceholderMenu.scrollAreaStartY = placeholderAreaY + 1;
        this.verticalScrollBarPlaceholderMenu.scrollAreaEndX = placeholderAreaX + this.placeholderMenuWidth - 2;
        this.verticalScrollBarPlaceholderMenu.scrollAreaEndY = placeholderAreaY + this.getEditorAreaHeight() - this.horizontalScrollBarPlaceholderMenu.grabberHeight - 2;
        this.horizontalScrollBarPlaceholderMenu.scrollAreaStartX = placeholderAreaX + 1;
        this.horizontalScrollBarPlaceholderMenu.scrollAreaStartY = placeholderAreaY + 1;
        this.horizontalScrollBarPlaceholderMenu.scrollAreaEndX = placeholderAreaX + this.placeholderMenuWidth - this.verticalScrollBarPlaceholderMenu.grabberWidth - 2;
        this.horizontalScrollBarPlaceholderMenu.scrollAreaEndY = placeholderAreaY + this.getEditorAreaHeight() - 1;
        this.verticalScrollBar.idleBarColor = this.scrollGrabberIdleColor;
        this.verticalScrollBar.hoverBarColor = this.scrollGrabberHoverColor;
        this.horizontalScrollBar.idleBarColor = this.scrollGrabberIdleColor;
        this.horizontalScrollBar.hoverBarColor = this.scrollGrabberHoverColor;
        this.verticalScrollBarPlaceholderMenu.idleBarColor = this.scrollGrabberIdleColor;
        this.verticalScrollBarPlaceholderMenu.hoverBarColor = this.scrollGrabberHoverColor;
        this.horizontalScrollBarPlaceholderMenu.idleBarColor = this.scrollGrabberIdleColor;
        this.horizontalScrollBarPlaceholderMenu.hoverBarColor = this.scrollGrabberHoverColor;
        this.cancelButton = new AdvancedButton(this.field_146294_l - this.borderRight - 100 - 5 - 100, this.field_146295_m - 35, 100, 20, Locals.localize((String)"fancymenu.guicomponents.cancel", (String[])new String[0]), true, button -> this.onClose());
        UIBase.applyDefaultButtonSkinTo(this.cancelButton);
        this.doneButton = new AdvancedButton(this.field_146294_l - this.borderRight - 100, this.field_146295_m - 35, 100, 20, Locals.localize((String)"fancymenu.guicomponents.done", (String[])new String[0]), true, button -> {
            Minecraft.func_71410_x().func_147108_a(this.parentScreen);
            if (this.callback != null) {
                this.callback.accept(this.getText());
            }
        });
        UIBase.applyDefaultButtonSkinTo(this.doneButton);
        this.placeholderButton = new AdvancedButton(this.field_146294_l - this.borderRight - 100, this.headerHeight / 2 - 10, 100, 20, Locals.localize((String)"fancymenu.ui.text_editor.placeholders", (String[])new String[0]), true, button -> {
            showPlaceholderMenu = !showPlaceholderMenu;
            this.init();
        });
        this.placeholderButton.setDescription(StringUtils.splitLines((String)Locals.localize((String)"helper.ui.dynamicvariabletextfield.variables.desc", (String[])new String[0]), (String)"%n%"));
        UIBase.applyDefaultButtonSkinTo(this.placeholderButton);
        if (showPlaceholderMenu) {
            this.placeholderButton.setBackgroundColor(UIBase.getButtonIdleColor(), UIBase.getButtonHoverColor(), this.editorAreaBorderColor, this.editorAreaBorderColor, 1);
            this.placeholderButton.setHeight(this.getEditorAreaY() - (this.headerHeight / 2 - 10));
        }
    }

    public void updateRightClickContextMenu() {
        TextEditorLine hoveredLine = this.getHoveredLine();
        if (this.rightClickContextMenu != null) {
            this.rightClickContextMenu.closeMenu();
        }
        this.rightClickContextMenu = new FMContextMenu();
        AdvancedButton cutButton = new AdvancedButton(0, 0, 0, 0, Locals.localize((String)"fancymenu.ui.text_editor.cut", (String[])new String[0]), true, press -> {
            Screen.func_146275_d((String)this.cutHighlightedText());
            this.rightClickContextMenu.closeMenu();
        });
        this.rightClickContextMenu.addContent(cutButton);
        if (hoveredLine == null || !hoveredLine.isHighlightedHovered()) {
            cutButton.field_146124_l = false;
        }
        AdvancedButton copyButton = new AdvancedButton(0, 0, 0, 0, Locals.localize((String)"fancymenu.ui.text_editor.copy", (String[])new String[0]), true, press -> {
            Screen.func_146275_d((String)this.getHighlightedText());
            this.rightClickContextMenu.closeMenu();
        });
        this.rightClickContextMenu.addContent(copyButton);
        if (hoveredLine == null || !hoveredLine.isHighlightedHovered()) {
            copyButton.field_146124_l = false;
        }
        AdvancedButton pasteButton = new AdvancedButton(0, 0, 0, 0, Locals.localize((String)"fancymenu.ui.text_editor.paste", (String[])new String[0]), true, press -> {
            this.pasteText(Screen.func_146277_j());
            this.rightClickContextMenu.closeMenu();
        });
        this.rightClickContextMenu.addContent(pasteButton);
        this.rightClickContextMenu.addSeparator();
        AdvancedButton selectAllButton = new AdvancedButton(0, 0, 0, 0, Locals.localize((String)"fancymenu.ui.text_editor.select_all", (String[])new String[0]), true, press -> {
            for (TextEditorLine t : this.textFieldLines) {
                t.setHighlightPos(0);
                t.func_146190_e(t.getValue().length());
            }
            this.setFocusedLine(this.getLineCount() - 1);
            this.startHighlightLineIndex = 0;
            this.endHighlightLineIndex = this.getLineCount() - 1;
            this.rightClickContextMenu.closeMenu();
        });
        this.rightClickContextMenu.addContent(selectAllButton);
    }

    @Override
    public void render(int mouseX, int mouseY, float partial) {
        if (this.currentLineWidth <= this.getEditorAreaWidth()) {
            this.horizontalScrollBar.setScroll(0.0f);
        }
        if (this.getTotalLineHeight() <= this.getEditorAreaHeight()) {
            this.verticalScrollBar.setScroll(0.0f);
        }
        this.justSwitchedLineByWordDeletion = false;
        this.updateCurrentLineWidth();
        this.verticalScrollBar.setWheelScrollSpeed(1.0f / ((float)this.getTotalScrollHeight() / 500.0f));
        this.renderScreenBackground();
        this.renderEditorAreaBackground();
        ScaledResolution res = new ScaledResolution(this.field_146297_k);
        double scaleW = (double)this.field_146297_k.field_71443_c / res.func_78327_c();
        double scaleH = (double)this.field_146297_k.field_71440_d / res.func_78324_d();
        int sciBottomY = this.field_146295_m - this.footerHeight;
        RenderSystem.enableScissor((int)((double)this.borderLeft * scaleW), (int)((double)this.field_146297_k.field_71440_d - (double)sciBottomY * scaleH), (int)((double)this.getEditorAreaWidth() * scaleW), (int)((double)this.getEditorAreaHeight() * scaleH));
        this.formattingRules.forEach(rule -> rule.resetRule(this));
        this.currentRenderCharacterIndexTotal = 0;
        this.lineNumberRenderQueue.clear();
        this.updateLines(line -> {
            if (line.isInEditorArea()) {
                this.lineNumberRenderQueue.add(() -> this.renderLineNumber((TextEditorLine)((Object)line)));
            }
            line.render(mouseX, mouseY, partial);
        });
        RenderSystem.disableScissor();
        this.renderLineNumberBackground(this.borderLeft);
        RenderSystem.enableScissor(0, (int)((double)this.field_146297_k.field_71440_d - (double)sciBottomY * scaleH), (int)((double)this.borderLeft * scaleW), (int)((double)this.getEditorAreaHeight() * scaleH));
        for (Runnable r : this.lineNumberRenderQueue) {
            r.run();
        }
        RenderSystem.disableScissor();
        this.lastTickFocusedLineIndex = this.getFocusedLineIndex();
        this.triggeredFocusedLineWasTooHighInCursorPosMethod = false;
        UIBase.renderBorder(this.borderLeft - 1, this.headerHeight - 1, this.getEditorAreaX() + this.getEditorAreaWidth(), this.field_146295_m - this.footerHeight + 1, 1, this.editorAreaBorderColor, true, true, true, true);
        this.verticalScrollBar.render();
        this.horizontalScrollBar.render();
        this.renderPlaceholderMenu(mouseX, mouseY, partial);
        this.cancelButton.render(mouseX, mouseY, partial);
        this.doneButton.render(mouseX, mouseY, partial);
        this.renderMultilineNotSupportedNotification(mouseX, mouseY, partial);
        UIBase.renderScaledContextMenu(this.rightClickContextMenu);
        this.tickMouseHighlighting();
        this.title.func_150256_b().func_150227_a(Boolean.valueOf(this.boldTitle));
        AbstractGui.drawFormattedString(this.font, this.title, this.borderLeft, this.headerHeight / 2 - this.font.field_78288_b / 2, -1);
    }

    protected void renderMultilineNotSupportedNotification(int mouseX, int mouseY, float partial) {
        long now = System.currentTimeMillis();
        if (!this.multilineMode && this.multilineNotSupportedNotificationDisplayStart + 3000L >= now) {
            int a = 255;
            int diff = (int)(this.multilineNotSupportedNotificationDisplayStart + 3000L - now);
            if (diff <= 1000) {
                float f = (float)diff / 1000.0f;
                a = Math.max(10, (int)(255.0f * f));
            }
            Color c = new Color(this.multilineNotSupportedNotificationColor.getRed(), this.multilineNotSupportedNotificationColor.getGreen(), this.multilineNotSupportedNotificationColor.getBlue(), a);
            this.font.func_78276_b(Locals.localize((String)"fancymenu.ui.text_editor.error.multiline_support", (String[])new String[0]), this.borderLeft, this.headerHeight - this.font.field_78288_b - 5, c.getRGB());
        }
    }

    protected void renderPlaceholderMenu(int mouseX, int mouseY, float partial) {
        if (showPlaceholderMenu) {
            if (this.getTotalPlaceholderEntriesWidth() <= this.placeholderMenuWidth) {
                this.horizontalScrollBarPlaceholderMenu.setScroll(0.0f);
            }
            if (this.getTotalPlaceholderEntriesHeight() <= this.getEditorAreaHeight()) {
                this.verticalScrollBarPlaceholderMenu.setScroll(0.0f);
            }
            TextEditorScreen.fill(this.field_146294_l - this.borderRight - this.placeholderMenuWidth, this.getEditorAreaY(), this.field_146294_l - this.borderRight, this.getEditorAreaY() + this.getEditorAreaHeight(), this.editorAreaBackgroundColor.getRGB());
            ScaledResolution res = new ScaledResolution(this.field_146297_k);
            double scaleW = (double)this.field_146297_k.field_71443_c / res.func_78327_c();
            double scaleH = (double)this.field_146297_k.field_71440_d / res.func_78324_d();
            int sciBottom = this.field_146295_m - this.footerHeight;
            RenderSystem.enableScissor((int)((double)(this.field_146294_l - this.borderRight - this.placeholderMenuWidth) * scaleW), (int)((double)this.field_146297_k.field_71440_d - (double)sciBottom * scaleH), (int)((double)this.placeholderMenuWidth * scaleW), (int)((double)this.getEditorAreaHeight() * scaleH));
            ArrayList<PlaceholderMenuEntry> entries = new ArrayList<PlaceholderMenuEntry>();
            entries.addAll(this.placeholderMenuEntries);
            int index = 0;
            for (PlaceholderMenuEntry e : entries) {
                e.x = this.field_146294_l - this.borderRight - this.placeholderMenuWidth + this.getPlaceholderEntriesRenderOffsetX();
                e.y = this.getEditorAreaY() + this.placeholderMenuEntryHeight * index + this.getPlaceholderEntriesRenderOffsetY();
                e.render(mouseX, mouseY, partial);
                ++index;
            }
            RenderSystem.disableScissor();
            UIBase.renderBorder(this.field_146294_l - this.borderRight - this.placeholderMenuWidth - 1, this.headerHeight - 1, this.field_146294_l - this.borderRight, this.field_146295_m - this.footerHeight + 1, 1, this.editorAreaBorderColor, true, true, true, true);
            this.verticalScrollBarPlaceholderMenu.render();
            this.horizontalScrollBarPlaceholderMenu.render();
        }
        this.placeholderButton.render(mouseX, mouseY, partial);
    }

    public int getTotalPlaceholderEntriesHeight() {
        return this.placeholderMenuEntryHeight * this.placeholderMenuEntries.size();
    }

    public int getTotalPlaceholderEntriesWidth() {
        int i = this.placeholderMenuWidth;
        for (PlaceholderMenuEntry e : this.placeholderMenuEntries) {
            if (e.getWidth() <= i) continue;
            i = e.getWidth();
        }
        return i;
    }

    public int getPlaceholderEntriesRenderOffsetX() {
        int totalScrollWidth = Math.max(0, this.getTotalPlaceholderEntriesWidth() - this.placeholderMenuWidth);
        return -((int)((float)totalScrollWidth / 100.0f * (this.horizontalScrollBarPlaceholderMenu.getScroll() * 100.0f)));
    }

    public int getPlaceholderEntriesRenderOffsetY() {
        int totalScrollHeight = Math.max(0, this.getTotalPlaceholderEntriesHeight() - this.getEditorAreaHeight());
        return -((int)((float)totalScrollHeight / 100.0f * (this.verticalScrollBarPlaceholderMenu.getScroll() * 100.0f)));
    }

    public void updatePlaceholderEntries(String category, boolean clearList, boolean addBackButton) {
        List<Placeholder> otherCategory;
        Map<String, List<Placeholder>> categories;
        if (clearList) {
            this.placeholderMenuEntries.clear();
        }
        if (!(categories = this.getPlaceholdersOrderedByCategories()).isEmpty() && (otherCategory = categories.get(Locals.localize((String)"fancymenu.helper.ui.dynamicvariabletextfield.categories.other", (String[])new String[0]))) != null) {
            if (category == null) {
                for (Map.Entry<String, List<Placeholder>> m : categories.entrySet()) {
                    if (m.getValue() == otherCategory) continue;
                    PlaceholderMenuEntry entry = new PlaceholderMenuEntry(this, (ITextComponent)Component.literal((String)m.getKey()), () -> this.updatePlaceholderEntries((String)m.getKey(), true, true));
                    entry.dotColor = this.placeholderEntryDotColorCategory;
                    entry.entryLabelColor = this.placeholderEntryLabelColor;
                    this.placeholderMenuEntries.add(entry);
                }
                this.updatePlaceholderEntries(Locals.localize((String)"fancymenu.helper.ui.dynamicvariabletextfield.categories.other", (String[])new String[0]), false, false);
            } else {
                List<Placeholder> placeholders;
                if (addBackButton) {
                    PlaceholderMenuEntry backToCategoriesEntry = new PlaceholderMenuEntry(this, (ITextComponent)Component.literal(Locals.localize((String)"fancymenu.ui.text_editor.placeholders.back_to_categories", (String[])new String[0])), () -> this.updatePlaceholderEntries(null, true, true));
                    backToCategoriesEntry.dotColor = this.placeholderEntryDotColorCategory;
                    backToCategoriesEntry.entryLabelColor = this.placeholderEntryBackToCategoriesLabelColor;
                    this.placeholderMenuEntries.add(backToCategoriesEntry);
                }
                if ((placeholders = categories.get(category)) != null) {
                    for (Placeholder p : placeholders) {
                        PlaceholderMenuEntry entry = new PlaceholderMenuEntry(this, (ITextComponent)Component.literal(p.getDisplayName()), () -> this.pasteText(p.getDefaultPlaceholderString().toString()));
                        List<String> desc = p.getDescription();
                        if (desc != null) {
                            entry.setDescription(desc.toArray(new String[0]));
                        }
                        entry.dotColor = this.placeholderEntryDotColorPlaceholder;
                        entry.entryLabelColor = this.placeholderEntryLabelColor;
                        this.placeholderMenuEntries.add(entry);
                    }
                }
            }
            for (PlaceholderMenuEntry e : this.placeholderMenuEntries) {
                e.backgroundColorIdle = this.placeholderEntryBackgroundColorIdle;
                e.backgroundColorHover = this.placeholderEntryBackgroundColorHover;
            }
            this.verticalScrollBarPlaceholderMenu.setScroll(0.0f);
            this.horizontalScrollBarPlaceholderMenu.setScroll(0.0f);
        }
    }

    protected Map<String, List<Placeholder>> getPlaceholdersOrderedByCategories() {
        LinkedHashMap<String, List<Placeholder>> categories = new LinkedHashMap<String, List<Placeholder>>();
        for (Placeholder p : PlaceholderRegistry.getPlaceholdersList()) {
            ArrayList<Placeholder> l;
            String cat = p.getCategory();
            if (cat == null) {
                cat = Locals.localize((String)"fancymenu.helper.ui.dynamicvariabletextfield.categories.other", (String[])new String[0]);
            }
            if ((l = (ArrayList<Placeholder>)categories.get(cat)) == null) {
                l = new ArrayList<Placeholder>();
                categories.put(cat, l);
            }
            l.add(p);
        }
        List otherCategory = (List)categories.get(Locals.localize((String)"fancymenu.helper.ui.dynamicvariabletextfield.categories.other", (String[])new String[0]));
        if (otherCategory != null) {
            categories.remove(Locals.localize((String)"fancymenu.helper.ui.dynamicvariabletextfield.categories.other", (String[])new String[0]));
            categories.put(Locals.localize((String)"fancymenu.helper.ui.dynamicvariabletextfield.categories.other", (String[])new String[0]), otherCategory);
        }
        return categories;
    }

    protected void renderLineNumberBackground(int width) {
        TextEditorScreen.fill(this.getEditorAreaX(), this.getEditorAreaY() - 1, this.getEditorAreaX() - width - 1, this.getEditorAreaY() + this.getEditorAreaHeight() + 1, this.sideBarColor.getRGB());
    }

    protected void renderLineNumber(TextEditorLine line) {
        String lineNumberString = "" + (line.lineIndex + 1);
        int lineNumberWidth = this.font.func_78256_a(lineNumberString);
        this.font.func_78276_b(lineNumberString, this.getEditorAreaX() - 3 - lineNumberWidth, line.getY() + line.getHeight() / 2 - this.font.field_78288_b / 2, line.func_146206_l() ? this.lineNumberTextColorFocused.getRGB() : this.lineNumberTextColorNormal.getRGB());
    }

    protected void renderEditorAreaBackground() {
        TextEditorScreen.fill(this.getEditorAreaX(), this.getEditorAreaY(), this.getEditorAreaX() + this.getEditorAreaWidth(), this.getEditorAreaY() + this.getEditorAreaHeight(), this.editorAreaBackgroundColor.getRGB());
    }

    protected void renderScreenBackground() {
        TextEditorScreen.fill(0, 0, this.field_146294_l, this.field_146295_m, this.screenBackgroundColor.getRGB());
    }

    protected void tickMouseHighlighting() {
        TextEditorLine focused;
        if (!MouseInput.isLeftMouseDown()) {
            this.startHighlightLine = null;
            for (TextEditorLine t : this.textFieldLines) {
                t.isInMouseHighlightingMode = false;
            }
            return;
        }
        if (this.isInMouseHighlightingMode()) {
            float f;
            int mX = MouseInput.getMouseX();
            int mY = MouseInput.getMouseY();
            float speedMult = 0.008f;
            if (mX < this.borderLeft) {
                f = Math.max(0.01f, (float)(this.borderLeft - mX) * speedMult);
                this.horizontalScrollBar.setScroll(this.horizontalScrollBar.getScroll() - f);
            } else if (mX > this.getEditorAreaX() + this.getEditorAreaWidth()) {
                f = Math.max(0.01f, (float)(mX - (this.getEditorAreaX() + this.getEditorAreaWidth())) * speedMult);
                this.horizontalScrollBar.setScroll(this.horizontalScrollBar.getScroll() + f);
            }
            if (mY < this.headerHeight) {
                f = Math.max(0.01f, (float)(this.headerHeight - mY) * speedMult);
                this.verticalScrollBar.setScroll(this.verticalScrollBar.getScroll() - f);
            } else if (mY > this.field_146295_m - this.footerHeight) {
                f = Math.max(0.01f, (float)(mY - (this.field_146295_m - this.footerHeight)) * speedMult);
                this.verticalScrollBar.setScroll(this.verticalScrollBar.getScroll() + f);
            }
        }
        if (!this.isMouseInsideEditorArea()) {
            return;
        }
        TextEditorLine first = this.startHighlightLine;
        TextEditorLine hovered = this.getHoveredLine();
        if (hovered != null && !hovered.func_146206_l() && first != null) {
            boolean firstIsAfterHovered;
            int firstIndex = this.getLineIndex(first);
            int hoveredIndex = this.getLineIndex(hovered);
            boolean firstIsBeforeHovered = hoveredIndex > firstIndex;
            boolean bl = firstIsAfterHovered = hoveredIndex < firstIndex;
            if (first.isInMouseHighlightingMode) {
                if (firstIsAfterHovered) {
                    this.setFocusedLine(this.getLineIndex(hovered));
                    if (!hovered.isInMouseHighlightingMode) {
                        hovered.isInMouseHighlightingMode = true;
                        hovered.shiftPressed = false;
                        hovered.moveCursorTo(hovered.getValue().length());
                    }
                } else if (firstIsBeforeHovered) {
                    this.setFocusedLine(this.getLineIndex(hovered));
                    if (!hovered.isInMouseHighlightingMode) {
                        hovered.isInMouseHighlightingMode = true;
                        hovered.shiftPressed = false;
                        hovered.moveCursorTo(0);
                    }
                } else if (first == hovered) {
                    this.setFocusedLine(this.getLineIndex(first));
                }
            }
            int startIndex = Math.min(hoveredIndex, firstIndex);
            int endIndex = Math.max(hoveredIndex, firstIndex);
            int index = 0;
            for (TextEditorLine t : this.textFieldLines) {
                if (t != hovered && t != first) {
                    if (index > startIndex && index < endIndex) {
                        if (firstIsAfterHovered) {
                            t.func_146190_e(0);
                            t.setHighlightPos(t.getValue().length());
                        } else if (firstIsBeforeHovered) {
                            t.func_146190_e(t.getValue().length());
                            t.setHighlightPos(0);
                        }
                    } else {
                        t.shiftPressed = false;
                        t.moveCursorTo(0);
                        t.isInMouseHighlightingMode = false;
                    }
                }
                ++index;
            }
            this.startHighlightLineIndex = startIndex;
            this.endHighlightLineIndex = endIndex;
            if (first != hovered) {
                first.shiftPressed = true;
                if (firstIsAfterHovered) {
                    first.moveCursorTo(0);
                } else if (firstIsBeforeHovered) {
                    first.moveCursorTo(first.getValue().length());
                }
                first.shiftPressed = false;
            }
        }
        if ((focused = this.getFocusedLine()) != null && focused.isInMouseHighlightingMode) {
            if (this.startHighlightLineIndex == -1 && this.endHighlightLineIndex == -1) {
                this.endHighlightLineIndex = this.startHighlightLineIndex = this.getLineIndex(focused);
            }
            int i = MathHelper.func_76141_d((float)MouseInput.getMouseX()) - focused.getX();
            if (focused.getAsAccessor().getBorderedFancyMenu()) {
                i -= 4;
            }
            String s = this.font.func_78269_a(focused.getValue().substring(focused.getAsAccessor().getDisplayPosFancyMenu()), focused.getInnerWidth());
            focused.shiftPressed = true;
            focused.moveCursorTo(this.font.func_78269_a(s, i).length() + focused.getAsAccessor().getDisplayPosFancyMenu());
            focused.shiftPressed = false;
            if (focused.getAsAccessor().getHighlightPosFancyMenu() == focused.func_146198_h() && this.startHighlightLineIndex == this.endHighlightLineIndex) {
                this.resetHighlighting();
            }
        }
    }

    public void updateLines(Consumer<TextEditorLine> doAfterEachLineUpdate) {
        try {
            int index = 0;
            for (TextEditorLine line : this.textFieldLines) {
                line.lineIndex = index;
                line.setY(this.headerHeight + this.lineHeight * index + this.getLineRenderOffsetY());
                line.setX(this.borderLeft + this.getLineRenderOffsetX());
                line.setWidth(this.currentLineWidth);
                line.setHeight(this.lineHeight);
                line.getAsAccessor().setDisplayPosFancyMenu(0);
                if (doAfterEachLineUpdate != null) {
                    doAfterEachLineUpdate.accept(line);
                }
                ++index;
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void updateCurrentLineWidth() {
        int longestTextWidth = 0;
        for (TextEditorLine f : this.textFieldLines) {
            if (f.textWidth <= longestTextWidth) continue;
            longestTextWidth = f.textWidth;
        }
        this.currentLineWidth = longestTextWidth + 30;
    }

    public int getLineRenderOffsetX() {
        return -((int)((float)this.getTotalScrollWidth() / 100.0f * (this.horizontalScrollBar.getScroll() * 100.0f)));
    }

    public int getLineRenderOffsetY() {
        return -((int)((float)this.getTotalScrollHeight() / 100.0f * (this.verticalScrollBar.getScroll() * 100.0f)));
    }

    public int getTotalLineHeight() {
        return this.lineHeight * this.textFieldLines.size();
    }

    public TextEditorLine addLineAtIndex(int index) {
        TextEditorLine before;
        if (!this.multilineMode && this.getLineCount() > 0) {
            this.multilineNotSupportedNotificationDisplayStart = System.currentTimeMillis();
            return null;
        }
        TextEditorLine f = new TextEditorLine(Minecraft.func_71410_x().field_71466_p, 0, 0, 50, this.lineHeight, false, this.characterFilter, this);
        f.setMaxLength(Integer.MAX_VALUE);
        f.lineIndex = index;
        if (index > 0 && (before = this.getLine(index - 1)) != null) {
            f.setY(before.getY() + this.lineHeight);
        }
        this.textFieldLines.add(index, f);
        return f;
    }

    public TextEditorLine addLine() {
        return this.addLineAtIndex(this.getLineCount());
    }

    public void removeLineAtIndex(int index) {
        if (index < 1) {
            return;
        }
        if (index <= this.getLineCount() - 1) {
            this.textFieldLines.remove(index);
        }
    }

    public void removeLastLine() {
        this.removeLineAtIndex(this.getLineCount() - 1);
    }

    public int getLineCount() {
        return this.textFieldLines.size();
    }

    public TextEditorLine getLine(int index) {
        return this.textFieldLines.get(index);
    }

    public void setFocusedLine(int index) {
        if (index <= this.getLineCount() - 1) {
            for (TextEditorLine f : this.textFieldLines) {
                f.func_146195_b(false);
            }
            this.getLine(index).func_146195_b(true);
        }
    }

    public int getFocusedLineIndex() {
        int index = 0;
        for (TextEditorLine f : this.textFieldLines) {
            if (f.func_146206_l()) {
                return index;
            }
            ++index;
        }
        return -1;
    }

    public TextEditorLine getFocusedLine() {
        int index = this.getFocusedLineIndex();
        if (index != -1) {
            return this.getLine(index);
        }
        return null;
    }

    public boolean isLineFocused() {
        return this.getFocusedLineIndex() > -1;
    }

    public TextEditorLine getLineAfter(TextEditorLine line) {
        int index = this.getLineIndex(line);
        if (index > -1 && index < this.getLineCount() - 1) {
            return this.getLine(index + 1);
        }
        return null;
    }

    public TextEditorLine getLineBefore(TextEditorLine line) {
        int index = this.getLineIndex(line);
        if (index > 0) {
            return this.getLine(index - 1);
        }
        return null;
    }

    public boolean isAtLeastOneLineInHighlightMode() {
        for (TextEditorLine t : this.textFieldLines) {
            if (!t.isInMouseHighlightingMode) continue;
            return true;
        }
        return false;
    }

    public List<TextEditorLine> getLinesBetweenIndexes(int startIndex, int endIndex) {
        startIndex = Math.min(Math.max(startIndex, 0), this.textFieldLines.size() - 1);
        endIndex = Math.min(Math.max(endIndex, 0), this.textFieldLines.size() - 1);
        ArrayList<TextEditorLine> l = new ArrayList<TextEditorLine>();
        l.addAll(this.textFieldLines.subList(startIndex, endIndex));
        if (!l.isEmpty()) {
            l.remove(0);
        }
        return l;
    }

    public TextEditorLine getHoveredLine() {
        for (TextEditorLine t : this.textFieldLines) {
            if (!t.isHovered()) continue;
            return t;
        }
        return null;
    }

    public int getLineIndex(TextEditorLine inputBox) {
        return this.textFieldLines.indexOf((Object)inputBox);
    }

    public void goUpLine() {
        int current;
        if (this.isLineFocused() && (current = Math.max(0, this.getFocusedLineIndex())) > 0) {
            TextEditorLine currentLine = this.getLine(current);
            this.setFocusedLine(current - 1);
            if (currentLine != null) {
                this.getFocusedLine().moveCursorTo(this.lastCursorPosSetByUser);
            }
        }
    }

    public void goDownLine(boolean isNewLine) {
        if (this.isLineFocused()) {
            int current = Math.max(0, this.getFocusedLineIndex());
            if (isNewLine) {
                this.addLineAtIndex(current + 1);
            }
            TextEditorLine currentLine = this.getLine(current);
            this.setFocusedLine(current + 1);
            if (currentLine != null) {
                TextEditorLine nextLine = this.getFocusedLine();
                if (isNewLine) {
                    String textBeforeCursor = currentLine.getValue().substring(0, currentLine.func_146198_h());
                    String textAfterCursor = currentLine.getValue().substring(currentLine.func_146198_h());
                    currentLine.setValue(textBeforeCursor);
                    nextLine.setValue(textAfterCursor);
                    nextLine.moveCursorTo(0);
                    if (textBeforeCursor.startsWith(" ")) {
                        int spaces = 0;
                        for (char c : textBeforeCursor.toCharArray()) {
                            if (!String.valueOf(c).equals(" ")) break;
                            ++spaces;
                        }
                        nextLine.setValue(textBeforeCursor.substring(0, spaces) + nextLine.getValue());
                        nextLine.moveCursorTo(spaces);
                    }
                } else {
                    nextLine.moveCursorTo(this.lastCursorPosSetByUser);
                }
            }
        }
    }

    public List<TextEditorLine> getCopyOfLines() {
        ArrayList<TextEditorLine> l = new ArrayList<TextEditorLine>();
        for (TextEditorLine t : this.textFieldLines) {
            TextEditorLine n = new TextEditorLine(this.font, 0, 0, 0, 0, false, this.characterFilter, this);
            n.setValue(t.getValue());
            n.func_146195_b(t.func_146206_l());
            n.moveCursorTo(t.func_146198_h());
            l.add(n);
        }
        return l;
    }

    public boolean isTextHighlighted() {
        return this.startHighlightLineIndex != -1 && this.endHighlightLineIndex != -1;
    }

    public boolean isHighlightedTextHovered() {
        if (this.isTextHighlighted()) {
            ArrayList<TextEditorLine> highlightedLines = new ArrayList<TextEditorLine>();
            if (this.endHighlightLineIndex <= this.getLineCount() - 1) {
                highlightedLines.addAll(this.textFieldLines.subList(this.startHighlightLineIndex, this.endHighlightLineIndex + 1));
            }
            for (TextEditorLine t : highlightedLines) {
                if (!t.isHighlightedHovered()) continue;
                return true;
            }
        }
        return false;
    }

    public String getHighlightedText() {
        try {
            if (this.startHighlightLineIndex != -1 && this.endHighlightLineIndex != -1) {
                ArrayList<TextEditorLine> lines = new ArrayList<TextEditorLine>();
                lines.add(this.getLine(this.startHighlightLineIndex));
                if (this.startHighlightLineIndex != this.endHighlightLineIndex) {
                    lines.addAll(this.getLinesBetweenIndexes(this.startHighlightLineIndex, this.endHighlightLineIndex));
                    lines.add(this.getLine(this.endHighlightLineIndex));
                }
                StringBuilder s = new StringBuilder();
                boolean b = false;
                for (TextEditorLine t : lines) {
                    if (b) {
                        s.append("\n");
                    }
                    s.append(t.getHighlighted());
                    b = true;
                }
                String ret = s.toString();
                return ret;
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return "";
    }

    public String cutHighlightedText() {
        String highlighted = this.getHighlightedText();
        this.deleteHighlightedText();
        return highlighted;
    }

    public void deleteHighlightedText() {
        int linesRemoved = 0;
        try {
            if (this.startHighlightLineIndex != -1 && this.endHighlightLineIndex != -1) {
                if (this.startHighlightLineIndex == this.endHighlightLineIndex) {
                    this.getLine(this.startHighlightLineIndex).insertText("");
                } else {
                    TextEditorLine start = this.getLine(this.startHighlightLineIndex);
                    start.insertText("");
                    TextEditorLine end = this.getLine(this.endHighlightLineIndex);
                    end.insertText("");
                    if (this.endHighlightLineIndex - this.startHighlightLineIndex > 1) {
                        for (TextEditorLine line : this.getLinesBetweenIndexes(this.startHighlightLineIndex, this.endHighlightLineIndex)) {
                            this.removeLineAtIndex(this.getLineIndex(line));
                            ++linesRemoved;
                        }
                    }
                    String oldStartValue = start.getValue();
                    start.func_146190_e(start.getValue().length());
                    start.setHighlightPos(start.func_146198_h());
                    start.insertText(end.getValue());
                    start.func_146190_e(oldStartValue.length());
                    start.setHighlightPos(start.func_146198_h());
                    this.removeLineAtIndex(this.getLineIndex(end));
                    ++linesRemoved;
                    this.setFocusedLine(this.startHighlightLineIndex);
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        this.correctYScroll(-linesRemoved);
        this.resetHighlighting();
    }

    public void resetHighlighting() {
        this.startHighlightLineIndex = -1;
        this.endHighlightLineIndex = -1;
        for (TextEditorLine t : this.textFieldLines) {
            t.setHighlightPos(t.func_146198_h());
        }
    }

    public boolean isInMouseHighlightingMode() {
        return MouseInput.isLeftMouseDown() && this.startHighlightLine != null;
    }

    public void pasteText(String text) {
        try {
            if (text != null && !text.equals("")) {
                int addedLinesCount = 0;
                if (this.isTextHighlighted()) {
                    this.deleteHighlightedText();
                }
                if (!this.isLineFocused()) {
                    this.setFocusedLine(this.getLineCount() - 1);
                    this.getFocusedLine().moveCursorToEnd();
                }
                TextEditorLine focusedLine = this.getFocusedLine();
                String textBeforeCursor = "";
                String textAfterCursor = "";
                if (focusedLine.getValue().length() > 0) {
                    textBeforeCursor = focusedLine.getValue().substring(0, focusedLine.func_146198_h());
                    if (focusedLine.func_146198_h() < focusedLine.getValue().length()) {
                        textAfterCursor = this.getFocusedLine().getValue().substring(focusedLine.func_146198_h(), focusedLine.getValue().length());
                    }
                }
                focusedLine.setValue(textBeforeCursor);
                focusedLine.func_146190_e(textBeforeCursor.length());
                String[] lines = new String[]{text};
                if (text.contains("\n")) {
                    lines = text.split("\n", -1);
                }
                if (!this.multilineMode && lines.length > 1) {
                    lines = new String[]{lines[0]};
                    this.multilineNotSupportedNotificationDisplayStart = System.currentTimeMillis();
                }
                Array.set(lines, lines.length - 1, lines[lines.length - 1] + textAfterCursor);
                if (lines.length == 1) {
                    this.getFocusedLine().insertText(lines[0]);
                } else if (lines.length > 1) {
                    int index = -1;
                    for (String s : lines) {
                        if (index == -1) {
                            index = this.getFocusedLineIndex();
                        } else {
                            this.addLineAtIndex(index);
                            ++addedLinesCount;
                        }
                        this.getLine(index).insertText(s);
                        ++index;
                    }
                    this.setFocusedLine(index - 1);
                    this.getFocusedLine().func_146190_e(Math.max(0, this.getFocusedLine().getValue().length() - textAfterCursor.length()));
                    this.getFocusedLine().setHighlightPos(this.getFocusedLine().func_146198_h());
                }
                this.correctYScroll(addedLinesCount);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        this.resetHighlighting();
    }

    public void setText(String text) {
        TextEditorLine t = this.getLine(0);
        this.textFieldLines.clear();
        this.textFieldLines.add(t);
        this.setFocusedLine(0);
        t.setValue("");
        t.moveCursorTo(0);
        this.pasteText(text);
        this.setFocusedLine(0);
        t.moveCursorTo(0);
        this.verticalScrollBar.setScroll(0.0f);
    }

    public String getText() {
        StringBuilder s = new StringBuilder();
        boolean b = false;
        for (TextEditorLine t : this.textFieldLines) {
            if (b) {
                s.append("\n");
            }
            s.append(t.getValue());
            b = true;
        }
        return s.toString();
    }

    public String getTextBeforeCursor() {
        if (!this.isLineFocused()) {
            return null;
        }
        int focusedLineIndex = this.getFocusedLineIndex();
        ArrayList<TextEditorLine> lines = new ArrayList<TextEditorLine>();
        if (focusedLineIndex == 0) {
            lines.add(this.getLine(0));
        } else if (focusedLineIndex > 0) {
            lines.addAll(this.textFieldLines.subList(0, focusedLineIndex + 1));
        }
        TextEditorLine lastLine = (TextEditorLine)((Object)lines.get(lines.size() - 1));
        StringBuilder s = new StringBuilder();
        boolean b = false;
        for (TextEditorLine t : lines) {
            if (b) {
                s.append("\n");
            }
            if (t != lastLine) {
                s.append(t.getValue());
            } else {
                s.append(t.getValue().substring(0, t.func_146198_h()));
            }
            b = true;
        }
        return s.toString();
    }

    public String getTextAfterCursor() {
        if (!this.isLineFocused()) {
            return null;
        }
        int focusedLineIndex = this.getFocusedLineIndex();
        ArrayList<TextEditorLine> lines = new ArrayList<TextEditorLine>();
        if (focusedLineIndex == this.getLineCount() - 1) {
            lines.add(this.getLine(this.getLineCount() - 1));
        } else if (focusedLineIndex < this.getLineCount() - 1) {
            lines.addAll(this.textFieldLines.subList(focusedLineIndex, this.getLineCount()));
        }
        TextEditorLine firstLine = (TextEditorLine)((Object)lines.get(0));
        StringBuilder s = new StringBuilder();
        boolean b = false;
        for (TextEditorLine t : lines) {
            if (b) {
                s.append("\n");
            }
            if (t != firstLine) {
                s.append(t.getValue());
            } else {
                s.append(t.getValue().substring(t.func_146198_h(), t.getValue().length()));
            }
            b = true;
        }
        return s.toString();
    }

    @Override
    public boolean charTyped(char character, int keyCode) {
        for (TextEditorLine l : this.textFieldLines) {
            l.charTyped(character, keyCode);
        }
        return super.charTyped(character, keyCode);
    }

    @Override
    public boolean keyPressed(int keycode, int i1, int i2) {
        for (TextEditorLine l : this.textFieldLines) {
            l.keyPressed(keycode, i1, i2);
        }
        if (keycode == 28) {
            if (!this.isInMouseHighlightingMode() && this.multilineMode && this.isLineFocused()) {
                this.resetHighlighting();
                this.goDownLine(true);
                this.correctYScroll(1);
            }
            if (!this.multilineMode) {
                this.multilineNotSupportedNotificationDisplayStart = System.currentTimeMillis();
            }
            return true;
        }
        if (keycode == 200) {
            if (!this.isInMouseHighlightingMode()) {
                this.resetHighlighting();
                this.goUpLine();
                this.correctYScroll(0);
            }
            return true;
        }
        if (keycode == 208) {
            if (!this.isInMouseHighlightingMode()) {
                this.resetHighlighting();
                this.goDownLine(false);
                this.correctYScroll(0);
            }
            return true;
        }
        if (keycode == 14) {
            if (!this.isInMouseHighlightingMode()) {
                if (this.isTextHighlighted()) {
                    this.deleteHighlightedText();
                } else if (this.isLineFocused()) {
                    TextEditorLine focused = this.getFocusedLine();
                    focused.shiftPressed = false;
                    focused.deleteText(-1);
                    focused.shiftPressed = Screen.hasShiftDown();
                }
                this.resetHighlighting();
            }
            return true;
        }
        if (Screen.isCopy(keycode)) {
            Screen.func_146275_d((String)this.getHighlightedText());
            return true;
        }
        if (Screen.isPaste(keycode)) {
            this.pasteText(Screen.func_146277_j());
            return true;
        }
        if (Screen.isSelectAll(keycode)) {
            for (TextEditorLine t : this.textFieldLines) {
                t.setHighlightPos(0);
                t.func_146190_e(t.getValue().length());
            }
            this.setFocusedLine(this.getLineCount() - 1);
            this.startHighlightLineIndex = 0;
            this.endHighlightLineIndex = this.getLineCount() - 1;
            return true;
        }
        if (Screen.isCut(keycode)) {
            Screen.func_146275_d((String)this.cutHighlightedText());
            this.resetHighlighting();
            return true;
        }
        if (keycode == 203 || keycode == 205) {
            this.resetHighlighting();
            return true;
        }
        return super.keyPressed(keycode, i1, i2);
    }

    @Override
    public boolean keyReleased(int i1, int i2, int i3) {
        for (TextEditorLine l : this.textFieldLines) {
            l.keyReleased(i1, i2, i3);
        }
        return super.keyReleased(i1, i2, i3);
    }

    @Override
    public boolean mouseClicked(double mouseX, double mouseY, int button) {
        if (!this.isMouseInteractingWithGrabbers()) {
            for (TextEditorLine l : this.textFieldLines) {
                l.mouseClicked(mouseX, mouseY, button);
            }
            if (this.isMouseInsideEditorArea()) {
                if (button == 1) {
                    this.rightClickContextMenu.closeMenu();
                }
                if (button == 0 || button == 1) {
                    boolean isHighlightedHovered = this.isHighlightedTextHovered();
                    TextEditorLine hoveredLine = this.getHoveredLine();
                    if (!this.rightClickContextMenu.isOpen()) {
                        if (button == 0 || !isHighlightedHovered) {
                            this.resetHighlighting();
                        }
                        if (hoveredLine == null) {
                            TextEditorLine focus = this.getLine(this.getLineCount() - 1);
                            for (TextEditorLine t : this.textFieldLines) {
                                if (MouseInput.getMouseY() < t.field_146210_g || MouseInput.getMouseY() > t.field_146210_g + t.getHeight()) continue;
                                focus = t;
                                break;
                            }
                            this.setFocusedLine(this.getLineIndex(focus));
                            this.getFocusedLine().moveCursorToEnd();
                            this.correctYScroll(0);
                        } else if (button == 1 && !isHighlightedHovered) {
                            this.setFocusedLine(this.getLineIndex(hoveredLine));
                            String s = this.font.func_78269_a(hoveredLine.getValue().substring(hoveredLine.getAsAccessor().getDisplayPosFancyMenu()), hoveredLine.getInnerWidth());
                            hoveredLine.moveCursorTo(this.font.func_78269_a(s, MouseInput.getMouseX() - hoveredLine.getX()).length() + hoveredLine.getAsAccessor().getDisplayPosFancyMenu());
                        }
                    }
                    if (button == 1) {
                        this.updateRightClickContextMenu();
                        UIBase.openScaledContextMenuAtMouse(this.rightClickContextMenu);
                    } else if (this.rightClickContextMenu.isOpen() && !this.rightClickContextMenu.isHovered()) {
                        this.rightClickContextMenu.closeMenu();
                        this.textFieldLines.forEach(line -> line.mouseClicked(mouseX, mouseY, button));
                        this.mouseClicked(mouseX, mouseY, button);
                    }
                }
            }
        }
        return super.mouseClicked(mouseX, mouseY, button);
    }

    @Override
    public void tick() {
        for (TextEditorLine l : this.textFieldLines) {
            l.tick();
        }
        super.tick();
    }

    @Override
    public void onClose() {
        if (this.parentScreen != null) {
            Minecraft.func_71410_x().func_147108_a(this.parentScreen);
        } else {
            super.onClose();
        }
        if (this.callback != null) {
            this.callback.accept(null);
        }
    }

    public boolean isMouseInteractingWithGrabbers() {
        return this.verticalScrollBar.isGrabberGrabbed() || this.verticalScrollBar.isGrabberHovered() || this.horizontalScrollBar.isGrabberGrabbed() || this.horizontalScrollBar.isGrabberHovered();
    }

    public boolean isMouseInteractingWithPlaceholderGrabbers() {
        return this.verticalScrollBarPlaceholderMenu.isGrabberGrabbed() || this.verticalScrollBarPlaceholderMenu.isGrabberHovered() || this.horizontalScrollBarPlaceholderMenu.isGrabberGrabbed() || this.horizontalScrollBarPlaceholderMenu.isGrabberHovered();
    }

    public int getEditBoxCursorX(AdvancedTextField editBox) {
        try {
            int l;
            IMixinGuiTextField b = (IMixinGuiTextField)((Object)editBox);
            String s = this.font.func_78269_a(editBox.getValue().substring(b.getDisplayPosFancyMenu()), editBox.getInnerWidth());
            int j = editBox.func_146198_h() - b.getDisplayPosFancyMenu();
            boolean flag = j >= 0 && j <= s.length();
            boolean flag2 = editBox.func_146198_h() < editBox.getValue().length() || editBox.getValue().length() >= b.getMaxLengthFancyMenu();
            int j1 = l = b.getBorderedFancyMenu() ? editBox.field_146209_f + 4 : editBox.field_146209_f;
            if (!s.isEmpty()) {
                String s1 = flag ? s.substring(0, j) : s;
                j1 += this.font.func_78256_a(s1);
            }
            int k1 = j1;
            if (!flag) {
                k1 = j > 0 ? l + editBox.func_146200_o() : l;
            } else if (flag2) {
                k1 = j1 - 1;
                --j1;
            }
            return k1;
        }
        catch (Exception e) {
            e.printStackTrace();
            return 0;
        }
    }

    public void scrollToLine(int lineIndex, boolean bottom) {
        if (bottom) {
            this.scrollToLine(lineIndex, -Math.max(0, this.getEditorAreaHeight() - this.lineHeight));
        } else {
            this.scrollToLine(lineIndex, 0);
        }
    }

    public void scrollToLine(int lineIndex, int offset) {
        int totalLineHeight = this.getTotalScrollHeight();
        float f = (float)Math.max(0, (lineIndex + 1) * this.lineHeight - this.lineHeight) / (float)totalLineHeight;
        if (offset != 0) {
            f = offset > 0 ? (f += (float)offset / (float)totalLineHeight) : (f -= (float)Math.abs(offset) / (float)totalLineHeight);
        }
        this.verticalScrollBar.setScroll(f);
    }

    public int getTotalScrollHeight() {
        if (this.overriddenTotalScrollHeight != -1) {
            return this.overriddenTotalScrollHeight;
        }
        return this.getTotalLineHeight();
    }

    public int getTotalScrollWidth() {
        return this.currentLineWidth;
    }

    public void correctYScroll(int lineCountOffsetAfterRemovingAdding) {
        if (this.isInMouseHighlightingMode() || !this.isLineFocused()) {
            return;
        }
        int minY = this.getEditorAreaY();
        int maxY = this.getEditorAreaY() + this.getEditorAreaHeight();
        int currentLineY = this.getFocusedLine().getY();
        if (currentLineY < minY) {
            this.scrollToLine(this.getFocusedLineIndex(), false);
        } else if (currentLineY + this.lineHeight > maxY) {
            this.scrollToLine(this.getFocusedLineIndex(), true);
        } else if (lineCountOffsetAfterRemovingAdding != 0) {
            this.overriddenTotalScrollHeight = -1;
            int removedAddedLineCount = Math.abs(lineCountOffsetAfterRemovingAdding);
            if (lineCountOffsetAfterRemovingAdding > 0) {
                this.overriddenTotalScrollHeight = this.getTotalScrollHeight() - this.lineHeight * removedAddedLineCount;
            } else if (lineCountOffsetAfterRemovingAdding < 0) {
                this.overriddenTotalScrollHeight = this.getTotalScrollHeight() + this.lineHeight * removedAddedLineCount;
            }
            this.updateLines(null);
            this.overriddenTotalScrollHeight = -1;
            int diffToTop = Math.max(0, this.getFocusedLine().getY() - this.getEditorAreaY());
            this.scrollToLine(this.getFocusedLineIndex(), -diffToTop);
            this.correctYScroll(0);
        }
        if (this.getTotalLineHeight() <= this.getEditorAreaHeight()) {
            this.verticalScrollBar.setScroll(0.0f);
        }
    }

    public void correctXScroll(TextEditorLine line) {
        if (this.isInMouseHighlightingMode()) {
            return;
        }
        if (this.isLineFocused() && this.getFocusedLine() == line) {
            boolean textGotAdded;
            int oldX = line.field_146209_f;
            this.updateCurrentLineWidth();
            this.updateLines(null);
            int newX = line.field_146209_f;
            String oldValue = line.lastTickValue;
            String newValue = line.getValue();
            int cursorWidth = 2;
            if (line.func_146198_h() >= newValue.length()) {
                cursorWidth = 6;
            }
            int editorAreaCenterX = this.getEditorAreaX() + this.getEditorAreaWidth() / 2;
            int cursorX = this.getEditBoxCursorX(line);
            if (cursorX > editorAreaCenterX) {
                cursorX += cursorWidth + 5;
            } else if (cursorX < editorAreaCenterX) {
                cursorX -= cursorWidth + 5;
            }
            int maxToRight = this.getEditorAreaX() + this.getEditorAreaWidth();
            int maxToLeft = this.getEditorAreaX();
            float currentScrollX = this.horizontalScrollBar.getScroll();
            int currentLineW = this.getTotalScrollWidth();
            boolean textGotDeleted = oldValue.length() > newValue.length();
            boolean bl = textGotAdded = oldValue.length() < newValue.length();
            if (cursorX > maxToRight) {
                float f = (float)(cursorX - maxToRight) / (float)currentLineW;
                this.horizontalScrollBar.setScroll(currentScrollX + f);
            } else if (cursorX < maxToLeft) {
                float f = (float)(maxToLeft - cursorX) / (float)currentLineW;
                if (textGotDeleted) {
                    f = (float)(maxToRight - maxToLeft) / (float)currentLineW;
                }
                this.horizontalScrollBar.setScroll(currentScrollX - f);
            } else if (textGotDeleted && oldX < newX) {
                float f = (float)(newX - oldX) / (float)currentLineW;
                this.horizontalScrollBar.setScroll(currentScrollX + f);
            } else if (textGotAdded && oldX > newX) {
                float f = (float)(oldX - newX) / (float)currentLineW;
                this.horizontalScrollBar.setScroll(currentScrollX - f);
            }
            if (line.func_146198_h() == 0) {
                this.horizontalScrollBar.setScroll(0.0f);
            }
        }
    }

    public boolean isMouseInsideEditorArea() {
        int xStart = this.borderLeft;
        int yStart = this.headerHeight;
        int xEnd = this.getEditorAreaX() + this.getEditorAreaWidth();
        int yEnd = this.field_146295_m - this.footerHeight;
        int mX = MouseInput.getMouseX();
        int mY = MouseInput.getMouseY();
        return mX >= xStart && mX <= xEnd && mY >= yStart && mY <= yEnd;
    }

    public int getEditorAreaWidth() {
        int i = this.field_146294_l - this.borderRight - this.borderLeft;
        if (showPlaceholderMenu) {
            i = i - this.placeholderMenuWidth - 15;
        }
        return i;
    }

    public int getEditorAreaHeight() {
        return this.field_146295_m - this.footerHeight - this.headerHeight;
    }

    public int getEditorAreaX() {
        return this.borderLeft;
    }

    public int getEditorAreaY() {
        return this.headerHeight;
    }

    public static class PlaceholderMenuEntry
    extends UIBase {
        public TextEditorScreen parent;
        public final ITextComponent label;
        public Runnable clickAction;
        public int x;
        public int y;
        public final int labelWidth;
        public Color backgroundColorIdle = Color.GRAY;
        public Color backgroundColorHover = Color.LIGHT_GRAY;
        public Color dotColor = Color.BLUE;
        public Color entryLabelColor = Color.WHITE;
        public AdvancedButton buttonBase;
        public FontRenderer font;

        public PlaceholderMenuEntry(TextEditorScreen parent, ITextComponent label, Runnable clickAction) {
            this.font = Minecraft.func_71410_x().field_71466_p;
            this.parent = parent;
            this.label = label;
            this.clickAction = clickAction;
            this.labelWidth = this.font.func_78256_a(this.label.func_150254_d());
            this.buttonBase = new AdvancedButton(0, 0, this.getWidth(), this.getHeight(), "", true, button -> this.clickAction.run()){

                @Override
                public boolean isHovered() {
                    if (parent.isMouseInteractingWithPlaceholderGrabbers()) {
                        return false;
                    }
                    return super.isHovered();
                }

                @Override
                public void onClick(double p_93371_, double p_93372_) {
                    if (parent.isMouseInteractingWithPlaceholderGrabbers()) {
                        return;
                    }
                    super.onClick(p_93371_, p_93372_);
                }

                @Override
                public void render(int p_93658_, int p_93659_, float p_93660_) {
                    if (parent.isMouseInteractingWithPlaceholderGrabbers()) {
                        this.field_146123_n = false;
                    }
                    super.render(p_93658_, p_93659_, p_93660_);
                }
            };
        }

        public void render(int mouseX, int mouseY, float partial) {
            this.buttonBase.setBackgroundColor(this.backgroundColorIdle, this.backgroundColorHover, this.backgroundColorIdle, this.backgroundColorHover, 1);
            this.buttonBase.field_146128_h = this.x;
            this.buttonBase.field_146129_i = this.y;
            int yCenter = this.y + this.getHeight() / 2;
            this.buttonBase.render(mouseX, mouseY, partial);
            PlaceholderMenuEntry.renderListingDot(this.x + 5, yCenter - 2, this.dotColor);
            AbstractGui.drawFormattedString(this.font, this.label, this.x + 5 + 4 + 3, yCenter - this.font.field_78288_b / 2, this.entryLabelColor.getRGB());
        }

        public int getWidth() {
            return Math.max(this.parent.placeholderMenuWidth, 12 + this.labelWidth + 5);
        }

        public int getHeight() {
            return this.parent.placeholderMenuEntryHeight;
        }

        public boolean isHovered() {
            return this.buttonBase.isHovered();
        }

        public void setDescription(String ... desc) {
            this.buttonBase.setDescription(desc);
        }
    }
}

