/*
 * Decompiled with CFR 0.152.
 */
package de.keksuccino.fancymenu.menu.fancy.helper.ui.scroll.scrollarea.entry;

import de.keksuccino.fancymenu.menu.fancy.helper.ui.compat.AbstractGui;
import de.keksuccino.fancymenu.menu.fancy.helper.ui.scroll.scrollarea.ScrollArea;
import de.keksuccino.fancymenu.menu.fancy.helper.ui.scroll.scrollarea.entry.ScrollAreaEntry;
import java.util.function.Consumer;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.FontRenderer;
import net.minecraft.util.text.ITextComponent;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class TextScrollAreaEntry
extends ScrollAreaEntry {
    private static final Logger LOGGER = LogManager.getLogger();
    protected ITextComponent text;
    public boolean shadow = false;
    protected int textWidth;
    public FontRenderer font;
    protected Consumer<TextScrollAreaEntry> onClickCallback;

    public TextScrollAreaEntry(ScrollArea parent, ITextComponent text, Consumer<TextScrollAreaEntry> onClick) {
        super(parent, 0, 14);
        this.font = Minecraft.func_71410_x().field_71466_p;
        this.onClickCallback = onClick;
        this.setText(text);
    }

    @Override
    public void render(int mouseX, int mouseY, float partial) {
        super.render(mouseX, mouseY, partial);
        int centerY = this.getY() + this.getHeight() / 2;
        AbstractGui.drawFormattedString(this.font, this.text, this.getX() + 5, centerY - this.font.field_78288_b / 2, -1, this.shadow);
    }

    @Override
    public void onClick(ScrollAreaEntry entry) {
        this.onClickCallback.accept((TextScrollAreaEntry)entry);
    }

    public void setText(ITextComponent text) {
        this.text = text;
        this.textWidth = this.font.func_78256_a(this.text.func_150254_d());
        this.setWidth(5 + this.textWidth + 5);
    }

    public ITextComponent getText() {
        return this.text;
    }

    public int getTextWidth() {
        return this.textWidth;
    }
}

