/*
 * Decompiled with CFR 0.152.
 */
package de.keksuccino.fancymenu.menu.fancy.helper.layoutcreator.loadingrequirement;

import de.keksuccino.fancymenu.menu.fancy.helper.layoutcreator.LayoutEditorScreen;
import de.keksuccino.fancymenu.menu.fancy.helper.layoutcreator.loadingrequirement.BuildRequirementGroupScreen;
import de.keksuccino.fancymenu.menu.fancy.helper.layoutcreator.loadingrequirement.BuildRequirementScreen;
import de.keksuccino.fancymenu.menu.fancy.helper.ui.ConfirmationScreen;
import de.keksuccino.fancymenu.menu.fancy.helper.ui.UIBase;
import de.keksuccino.fancymenu.menu.fancy.helper.ui.compat.AbstractGui;
import de.keksuccino.fancymenu.menu.fancy.helper.ui.compat.RenderSystem;
import de.keksuccino.fancymenu.menu.fancy.helper.ui.compat.Screen;
import de.keksuccino.fancymenu.menu.fancy.helper.ui.compat.TextStyle;
import de.keksuccino.fancymenu.menu.fancy.helper.ui.compat.component.Component;
import de.keksuccino.fancymenu.menu.fancy.helper.ui.compat.widget.AdvancedButton;
import de.keksuccino.fancymenu.menu.fancy.helper.ui.scroll.scrollarea.ScrollArea;
import de.keksuccino.fancymenu.menu.fancy.helper.ui.scroll.scrollarea.entry.ScrollAreaEntry;
import de.keksuccino.fancymenu.menu.fancy.helper.ui.scroll.scrollarea.entry.TextListScrollAreaEntry;
import de.keksuccino.fancymenu.menu.loadingrequirement.v2.internal.LoadingRequirementContainer;
import de.keksuccino.fancymenu.menu.loadingrequirement.v2.internal.LoadingRequirementGroup;
import de.keksuccino.fancymenu.menu.loadingrequirement.v2.internal.LoadingRequirementInstance;
import de.keksuccino.konkrete.input.StringUtils;
import de.keksuccino.konkrete.localization.Locals;
import java.util.function.Consumer;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.FontRenderer;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.client.gui.ScaledResolution;
import net.minecraft.util.text.ITextComponent;

public class ManageRequirementsScreen
extends Screen {
    protected GuiScreen parentScreen;
    protected LoadingRequirementContainer container;
    protected Consumer<LoadingRequirementContainer> callback;
    protected ScrollArea requirementsScrollArea = new ScrollArea(0, 0, 0, 0);
    protected AdvancedButton addRequirementButton;
    protected AdvancedButton addGroupButton;
    protected AdvancedButton editButton;
    protected AdvancedButton removeButton;
    protected AdvancedButton doneButton;

    public ManageRequirementsScreen(GuiScreen parentScreen, LoadingRequirementContainer container, Consumer<LoadingRequirementContainer> callback) {
        super((ITextComponent)Component.literal(Locals.localize((String)"fancymenu.editor.loading_requirement.screens.manage_screen.manage", (String[])new String[0])));
        this.parentScreen = parentScreen;
        this.container = container;
        this.callback = callback;
        this.updateRequirementsScrollArea();
        this.addRequirementButton = new AdvancedButton(0, 0, 150, 20, Locals.localize((String)"fancymenu.editor.loading_requirement.screens.add_requirement", (String[])new String[0]), true, button -> {
            BuildRequirementScreen s = new BuildRequirementScreen(this, this.container, null, call -> {
                if (call != null) {
                    this.container.addInstance((LoadingRequirementInstance)call);
                    this.updateRequirementsScrollArea();
                }
            });
            Minecraft.func_71410_x().func_147108_a((GuiScreen)s);
        });
        this.addRequirementButton.setDescription(StringUtils.splitLines((String)Locals.localize((String)"fancymenu.editor.loading_requirement.screens.manage_screen.add_requirement.desc", (String[])new String[0]), (String)"%n%"));
        UIBase.applyDefaultButtonSkinTo(this.addRequirementButton);
        this.addGroupButton = new AdvancedButton(0, 0, 150, 20, Locals.localize((String)"fancymenu.editor.loading_requirement.screens.add_group", (String[])new String[0]), true, button -> {
            BuildRequirementGroupScreen s = new BuildRequirementGroupScreen(this, this.container, null, call -> {
                if (call != null) {
                    this.container.addGroup((LoadingRequirementGroup)call);
                    this.updateRequirementsScrollArea();
                }
            });
            Minecraft.func_71410_x().func_147108_a((GuiScreen)s);
        });
        this.addGroupButton.setDescription(StringUtils.splitLines((String)Locals.localize((String)"fancymenu.editor.loading_requirement.screens.manage_screen.add_group.desc", (String[])new String[0]), (String)"%n%"));
        UIBase.applyDefaultButtonSkinTo(this.addGroupButton);
        this.editButton = new AdvancedButton(0, 0, 150, 20, "", true, button -> {
            Screen s = null;
            if (this.isInstanceSelected()) {
                s = new BuildRequirementScreen(this, this.container, this.getSelectedInstance(), call -> {
                    if (call != null) {
                        this.updateRequirementsScrollArea();
                    }
                });
            } else if (this.isGroupSelected()) {
                s = new BuildRequirementGroupScreen(this, this.container, this.getSelectedGroup(), call -> {
                    if (call != null) {
                        this.updateRequirementsScrollArea();
                    }
                });
            }
            if (s != null) {
                Minecraft.func_71410_x().func_147108_a(s);
            }
        }){

            @Override
            public void render(int p_93658_, int p_93659_, float p_93660_) {
                ManageRequirementsScreen s = ManageRequirementsScreen.this;
                if (!s.isInstanceSelected() && !s.isGroupSelected()) {
                    this.setMessage(Locals.localize((String)"fancymenu.editor.loading_requirement.screens.manage_screen.edit.generic", (String[])new String[0]));
                    this.setDescription(StringUtils.splitLines((String)Locals.localize((String)"fancymenu.editor.loading_requirement.screens.manage_screen.no_entry_selected", (String[])new String[0]), (String)"%n%"));
                    this.field_146124_l = false;
                } else {
                    if (s.isInstanceSelected()) {
                        this.setMessage(Locals.localize((String)"fancymenu.editor.loading_requirement.screens.edit_requirement", (String[])new String[0]));
                    } else {
                        this.setMessage(Locals.localize((String)"fancymenu.editor.loading_requirement.screens.edit_group", (String[])new String[0]));
                    }
                    this.setDescription(StringUtils.splitLines((String)Locals.localize((String)"fancymenu.editor.loading_requirement.screens.manage_screen.edit.desc", (String[])new String[0]), (String)"%n%"));
                    this.field_146124_l = true;
                }
                super.render(p_93658_, p_93659_, p_93660_);
            }
        };
        UIBase.applyDefaultButtonSkinTo(this.editButton);
        this.removeButton = new AdvancedButton(0, 0, 150, 20, "", true, button -> {
            ConfirmationScreen s = null;
            if (this.isInstanceSelected()) {
                LoadingRequirementInstance i = this.getSelectedInstance();
                s = new ConfirmationScreen(this, call -> {
                    if (call.booleanValue()) {
                        this.container.removeInstance(i);
                        this.updateRequirementsScrollArea();
                    }
                }, StringUtils.splitLines((String)Locals.localize((String)"fancymenu.editor.loading_requirement.screens.remove_requirement.confirm", (String[])new String[0]), (String)"%n%"));
            } else if (this.isGroupSelected()) {
                LoadingRequirementGroup g = this.getSelectedGroup();
                s = new ConfirmationScreen(this, call -> {
                    if (call.booleanValue()) {
                        this.container.removeGroup(g);
                        this.updateRequirementsScrollArea();
                    }
                }, StringUtils.splitLines((String)Locals.localize((String)"fancymenu.editor.loading_requirement.screens.remove_group.confirm", (String[])new String[0]), (String)"%n%"));
            }
            if (s != null) {
                Minecraft.func_71410_x().func_147108_a(s);
            }
        }){

            @Override
            public void render(int p_93658_, int p_93659_, float p_93660_) {
                ManageRequirementsScreen s = ManageRequirementsScreen.this;
                if (!s.isInstanceSelected() && !s.isGroupSelected()) {
                    this.setMessage(Locals.localize((String)"fancymenu.editor.loading_requirement.screens.manage_screen.remove.generic", (String[])new String[0]));
                    this.setDescription(StringUtils.splitLines((String)Locals.localize((String)"fancymenu.editor.loading_requirement.screens.manage_screen.no_entry_selected", (String[])new String[0]), (String)"%n%"));
                    this.field_146124_l = false;
                } else {
                    if (s.isInstanceSelected()) {
                        this.setMessage(Locals.localize((String)"fancymenu.editor.loading_requirement.screens.remove_requirement", (String[])new String[0]));
                    } else {
                        this.setMessage(Locals.localize((String)"fancymenu.editor.loading_requirement.screens.remove_group", (String[])new String[0]));
                    }
                    this.setDescription(StringUtils.splitLines((String)Locals.localize((String)"fancymenu.editor.loading_requirement.screens.manage_screen.remove.desc", (String[])new String[0]), (String)"%n%"));
                    this.field_146124_l = true;
                }
                super.render(p_93658_, p_93659_, p_93660_);
            }
        };
        UIBase.applyDefaultButtonSkinTo(this.removeButton);
        this.doneButton = new AdvancedButton(0, 0, 150, 20, Locals.localize((String)"fancymenu.guicomponents.done", (String[])new String[0]), true, button -> {
            Minecraft.func_71410_x().func_147108_a(this.parentScreen);
            this.callback.accept(this.container);
        });
        UIBase.applyDefaultButtonSkinTo(this.doneButton);
    }

    @Override
    protected void init() {
        if (this.parentScreen != null && this.parentScreen instanceof LayoutEditorScreen && ((LayoutEditorScreen)this.parentScreen).oriscale != -1) {
            Minecraft.func_71410_x().field_71474_y.field_74335_Z = ((LayoutEditorScreen)this.parentScreen).oriscale;
            ((LayoutEditorScreen)this.parentScreen).oriscale = -1;
            ScaledResolution res = new ScaledResolution(Minecraft.func_71410_x());
            this.field_146294_l = res.func_78326_a();
            this.field_146295_m = res.func_78328_b();
        }
        super.init();
    }

    @Override
    public void onClose() {
        Minecraft.func_71410_x().func_147108_a(this.parentScreen);
        this.callback.accept(this.container);
    }

    @Override
    public void render(int mouseX, int mouseY, float partial) {
        ManageRequirementsScreen.fill(0, 0, this.field_146294_l, this.field_146295_m, UIBase.SCREEN_BACKGROUND_COLOR.getRGB());
        this.title.func_150256_b().func_150227_a(Boolean.valueOf(true));
        AbstractGui.drawFormattedString(this.font, this.title, 20, 20, -1);
        this.font.func_78276_b(Locals.localize((String)"fancymenu.editor.loading_requirement.screens.manage_screen.requirements_and_groups", (String[])new String[0]), 20, 50, -1);
        this.requirementsScrollArea.setWidth(this.field_146294_l - 20 - 150 - 20 - 20, true);
        this.requirementsScrollArea.setHeight(this.field_146295_m - 85, true);
        this.requirementsScrollArea.setX(20, true);
        this.requirementsScrollArea.setY(65, true);
        this.requirementsScrollArea.render(mouseX, mouseY, partial);
        this.doneButton.setX(this.field_146294_l - 20 - this.doneButton.getWidth());
        this.doneButton.setY(this.field_146295_m - 20 - 20);
        this.doneButton.render(mouseX, mouseY, partial);
        this.removeButton.setX(this.field_146294_l - 20 - this.removeButton.getWidth());
        this.removeButton.setY(this.doneButton.getY() - 15 - 20);
        this.removeButton.render(mouseX, mouseY, partial);
        this.editButton.setX(this.field_146294_l - 20 - this.editButton.getWidth());
        this.editButton.setY(this.removeButton.getY() - 5 - 20);
        this.editButton.render(mouseX, mouseY, partial);
        this.addGroupButton.setX(this.field_146294_l - 20 - this.addGroupButton.getWidth());
        this.addGroupButton.setY(this.editButton.getY() - 5 - 20);
        this.addGroupButton.render(mouseX, mouseY, partial);
        this.addRequirementButton.setX(this.field_146294_l - 20 - this.addRequirementButton.getWidth());
        this.addRequirementButton.setY(this.addGroupButton.getY() - 5 - 20);
        this.addRequirementButton.render(mouseX, mouseY, partial);
        super.render(mouseX, mouseY, partial);
    }

    protected LoadingRequirementInstance getSelectedInstance() {
        ScrollAreaEntry e = this.requirementsScrollArea.getFocusedEntry();
        if (e instanceof RequirementInstanceEntry) {
            return ((RequirementInstanceEntry)e).instance;
        }
        return null;
    }

    protected boolean isInstanceSelected() {
        return this.getSelectedInstance() != null;
    }

    protected LoadingRequirementGroup getSelectedGroup() {
        ScrollAreaEntry e = this.requirementsScrollArea.getFocusedEntry();
        if (e instanceof RequirementGroupEntry) {
            return ((RequirementGroupEntry)e).group;
        }
        return null;
    }

    protected boolean isGroupSelected() {
        return this.getSelectedGroup() != null;
    }

    protected void updateRequirementsScrollArea() {
        ScrollAreaEntry e;
        this.requirementsScrollArea.clearEntries();
        for (LoadingRequirementGroup g : this.container.getGroups()) {
            e = new RequirementGroupEntry(this.requirementsScrollArea, g);
            this.requirementsScrollArea.addEntry(e);
        }
        for (LoadingRequirementInstance i : this.container.getInstances()) {
            e = new RequirementInstanceEntry(this.requirementsScrollArea, i, 14);
            this.requirementsScrollArea.addEntry(e);
        }
    }

    public static class RequirementInstanceEntry
    extends ScrollAreaEntry {
        public static final int HEADER_FOOTER_HEIGHT = 3;
        public LoadingRequirementInstance instance;
        public final int lineHeight;
        public FontRenderer font;
        private ITextComponent displayNameComponent;
        private ITextComponent modeComponent;
        private ITextComponent valueComponent;

        public RequirementInstanceEntry(ScrollArea parent, LoadingRequirementInstance instance, int lineHeight) {
            super(parent, 100, 30);
            this.font = Minecraft.func_71410_x().field_71466_p;
            this.instance = instance;
            this.lineHeight = lineHeight;
            this.displayNameComponent = Component.literal(this.instance.requirement.getDisplayName()).setStyle(new TextStyle().setColorRGB(TEXT_COLOR_GRAY_1.getRGB()));
            String modeString = this.instance.mode == LoadingRequirementInstance.RequirementMode.IF ? Locals.localize((String)"fancymenu.editor.loading_requirement.screens.requirement.info.mode.normal", (String[])new String[0]) : Locals.localize((String)"fancymenu.editor.loading_requirement.screens.requirement.info.mode.opposite", (String[])new String[0]);
            this.modeComponent = Component.literal(Locals.localize((String)"fancymenu.editor.loading_requirement.screens.requirement.info.mode", (String[])new String[0]) + " ").setStyle(new TextStyle().setColorRGB(TEXT_COLOR_GRAY_1.getRGB())).append((ITextComponent)Component.literal(modeString).setStyle(new TextStyle().setColorRGB(TEXT_COLOR_GREY_4.getRGB())));
            String valueString = this.instance.value != null ? this.instance.value : Locals.localize((String)"fancymenu.editor.loading_requirement.screens.requirement.info.value.none", (String[])new String[0]);
            this.valueComponent = Component.literal(Locals.localize((String)"fancymenu.editor.loading_requirement.screens.requirement.info.value", (String[])new String[0]) + " ").setStyle(new TextStyle().setColorRGB(TEXT_COLOR_GRAY_1.getRGB())).append((ITextComponent)Component.literal(valueString).setStyle(new TextStyle().setColorRGB(TEXT_COLOR_GREY_4.getRGB())));
            this.setWidth(this.calculateWidth());
            this.setHeight(lineHeight * 3 + 6);
        }

        @Override
        public void render(int mouseX, int mouseY, float partial) {
            super.render(mouseX, mouseY, partial);
            int centerYLine1 = this.getY() + 3 + this.lineHeight / 2;
            int centerYLine2 = this.getY() + 3 + this.lineHeight / 2 * 3;
            int centerYLine3 = this.getY() + 3 + this.lineHeight / 2 * 5;
            RenderSystem.func_179147_l();
            RequirementInstanceEntry.renderListingDot(this.getX() + 5, centerYLine1 - 2, LISTING_DOT_RED);
            AbstractGui.drawFormattedString(this.font, this.displayNameComponent, this.getX() + 5 + 4 + 3, centerYLine1 - this.font.field_78288_b / 2, -1);
            RequirementInstanceEntry.renderListingDot(this.getX() + 5 + 4 + 3, centerYLine2 - 2, LISTING_DOT_BLUE);
            AbstractGui.drawFormattedString(this.font, this.modeComponent, this.getX() + 5 + 4 + 3 + 4 + 3, centerYLine2 - this.font.field_78288_b / 2, -1);
            RequirementInstanceEntry.renderListingDot(this.getX() + 5 + 4 + 3, centerYLine3 - 2, LISTING_DOT_BLUE);
            AbstractGui.drawFormattedString(this.font, this.valueComponent, this.getX() + 5 + 4 + 3 + 4 + 3, centerYLine3 - this.font.field_78288_b / 2, -1);
        }

        private int calculateWidth() {
            int w = 12 + this.font.func_78256_a(this.displayNameComponent.func_150254_d()) + 5;
            int w2 = 19 + this.font.func_78256_a(this.modeComponent.func_150254_d()) + 5;
            int w3 = 19 + this.font.func_78256_a(this.valueComponent.func_150254_d()) + 5;
            if (w2 > w) {
                w = w2;
            }
            if (w3 > w) {
                w = w3;
            }
            return w;
        }

        @Override
        public void onClick(ScrollAreaEntry entry) {
        }
    }

    public static class RequirementGroupEntry
    extends TextListScrollAreaEntry {
        public static final int HEADER_FOOTER_HEIGHT = 3;
        public LoadingRequirementGroup group;

        public RequirementGroupEntry(ScrollArea parent, LoadingRequirementGroup group) {
            super(parent, (ITextComponent)Component.literal(group.identifier).setStyle(new TextStyle().setColorRGB(TEXT_COLOR_GRAY_1.getRGB())).append((ITextComponent)Component.literal(" (" + Locals.localize((String)"fancymenu.editor.loading_requirement.screens.manage_screen.group.info", (String[])new String[]{"" + group.getInstances().size()}) + ")").setStyle(new TextStyle().setColorRGB(TEXT_COLOR_GREY_4.getRGB()))), LISTING_DOT_ORANGE, entry -> {});
            this.group = group;
            this.setHeight(this.getHeight() + 6);
        }
    }
}

