/*
 * Decompiled with CFR 0.152.
 */
package de.keksuccino.fancymenu.menu.fancy;

import de.keksuccino.fancymenu.FancyMenu;
import de.keksuccino.fancymenu.menu.fancy.MenuCustomization;
import de.keksuccino.konkrete.Konkrete;
import de.keksuccino.konkrete.input.StringUtils;
import de.keksuccino.konkrete.math.MathUtils;
import de.keksuccino.konkrete.properties.PropertiesSection;
import de.keksuccino.konkrete.properties.PropertiesSerializer;
import de.keksuccino.konkrete.properties.PropertiesSet;
import java.io.File;
import java.util.ArrayList;
import java.util.List;
import net.minecraftforge.fml.common.Loader;

public class MenuCustomizationProperties {
    private static List<PropertiesSet> properties = new ArrayList<PropertiesSet>();
    private static List<PropertiesSet> disabled = new ArrayList<PropertiesSet>();

    public static void loadProperties() {
        File f = FancyMenu.getCustomizationPath();
        properties = MenuCustomizationProperties.parsePropertiesFromDir(f);
        File f3 = new File(FancyMenu.getCustomizationPath().getPath() + "/.disabled");
        disabled = MenuCustomizationProperties.parsePropertiesFromDir(f3);
    }

    public static List<PropertiesSet> parsePropertiesFromDir(File dir) {
        ArrayList<PropertiesSet> props = new ArrayList<PropertiesSet>();
        if (!dir.exists()) {
            dir.mkdirs();
        }
        for (File f2 : dir.listFiles()) {
            PropertiesSet s;
            if (!f2.getPath().toLowerCase().endsWith(".txt") || (s = PropertiesSerializer.getProperties((String)f2.getAbsolutePath().replace("\\", "/"))) == null || !s.getPropertiesType().equalsIgnoreCase("menu")) continue;
            List l = s.getPropertiesOfType("customization-meta");
            if (l.isEmpty()) {
                l = s.getPropertiesOfType("type-meta");
            }
            if (l.isEmpty()) continue;
            String s2 = ((PropertiesSection)l.get(0)).getEntryValue("identifier");
            String s3 = ((PropertiesSection)l.get(0)).getEntryValue("requiredmods");
            String s4 = ((PropertiesSection)l.get(0)).getEntryValue("minimumfmversion");
            String s5 = ((PropertiesSection)l.get(0)).getEntryValue("maximumfmversion");
            String s6 = ((PropertiesSection)l.get(0)).getEntryValue("minimummcversion");
            String s7 = ((PropertiesSection)l.get(0)).getEntryValue("maximummcversion");
            if (s2 == null || !MenuCustomizationProperties.isVersionCompatible(s4, s5, "2.14.9") || !MenuCustomizationProperties.isVersionCompatible(s6, s7, "1.12.2") || !MenuCustomizationProperties.allRequiredModsLoaded(s3)) continue;
            ((PropertiesSection)l.get(0)).removeEntry("identifier");
            ((PropertiesSection)l.get(0)).addEntry("identifier", MenuCustomization.getValidMenuIdentifierFor(s2));
            ((PropertiesSection)l.get(0)).addEntry("path", f2.getPath());
            props.add(s);
        }
        return props;
    }

    private static String fillUpToLength(String s, String fillWith, int length) {
        String out = s;
        int add = length - s.length();
        for (int i = 1; i <= add; ++i) {
            out = out + fillWith;
        }
        return out;
    }

    private static boolean isVersionCompatible(String minimum, String maximum, String version) {
        if (version == null) {
            return true;
        }
        String versionRaw = MenuCustomizationProperties.fillUpToLength(StringUtils.replaceAllExceptOf((String)version, (String)"", (String[])new String[]{"0", "1", "2", "3", "4", "5", "6", "7", "8", "9"}), "0", 9);
        if (MathUtils.isInteger((String)versionRaw)) {
            String maxRaw;
            int max;
            String maxShort;
            String minRaw;
            int min;
            String minShort;
            int ver = Integer.parseInt(versionRaw);
            if (minimum != null && (minShort = StringUtils.replaceAllExceptOf((String)minimum, (String)"", (String[])new String[]{"0", "1", "2", "3", "4", "5", "6", "7", "8", "9"})).length() > 0 && MathUtils.isInteger((String)minShort) && ver < (min = Integer.parseInt(minRaw = MenuCustomizationProperties.fillUpToLength(minShort, "0", 9)))) {
                return false;
            }
            if (maximum != null && (maxShort = StringUtils.replaceAllExceptOf((String)maximum, (String)"", (String[])new String[]{"0", "1", "2", "3", "4", "5", "6", "7", "8", "9"})).length() > 0 && MathUtils.isInteger((String)maxShort) && ver > (max = Integer.parseInt(maxRaw = MenuCustomizationProperties.fillUpToLength(maxShort, "0", 9)))) {
                return false;
            }
        }
        return true;
    }

    private static boolean allRequiredModsLoaded(String requiredMods) {
        if (requiredMods == null || requiredMods.replace(" ", "").length() == 0) {
            return true;
        }
        ArrayList<Object> mods = new ArrayList<Object>();
        if (requiredMods.contains(",")) {
            for (String s : requiredMods.replace(" ", "").split("[,]")) {
                if (s.length() <= 0) continue;
                mods.add(s);
            }
        } else {
            mods.add(requiredMods.replace(" ", ""));
        }
        for (String string : mods) {
            if (!(string.equals("optifine") ? !Konkrete.isOptifineLoaded : !Loader.isModLoaded((String)string))) continue;
            return false;
        }
        return true;
    }

    public static List<PropertiesSet> getProperties() {
        return properties;
    }

    public static List<PropertiesSet> getDisabledProperties() {
        return disabled;
    }

    public static List<PropertiesSet> getPropertiesWithIdentifier(String identifier) {
        ArrayList<PropertiesSet> l = new ArrayList<PropertiesSet>();
        for (PropertiesSet s : MenuCustomizationProperties.getProperties()) {
            String s2;
            List l2 = s.getPropertiesOfType("customization-meta");
            if (l2.isEmpty()) {
                l2 = s.getPropertiesOfType("type-meta");
            }
            if (l2.isEmpty() || (s2 = ((PropertiesSection)l2.get(0)).getEntryValue("identifier")) == null) continue;
            if (s2.equalsIgnoreCase(identifier)) {
                l.add(s);
                continue;
            }
            if (!s2.equals("%fancymenu:universal_layout%")) continue;
            String whitelistRaw = ((PropertiesSection)l2.get(0)).getEntryValue("universal_layout_whitelist");
            String blacklistRaw = ((PropertiesSection)l2.get(0)).getEntryValue("universal_layout_blacklist");
            ArrayList<String> whitelist = new ArrayList<String>();
            ArrayList<String> blacklist = new ArrayList<String>();
            if (whitelistRaw != null && whitelistRaw.contains(";")) {
                for (String s3 : whitelistRaw.split("[;]")) {
                    if (s3.length() <= 0) continue;
                    whitelist.add(MenuCustomization.getValidMenuIdentifierFor(s3));
                }
            }
            if (blacklistRaw != null && blacklistRaw.contains(";")) {
                for (String s3 : blacklistRaw.split("[;]")) {
                    if (s3.length() <= 0) continue;
                    blacklist.add(MenuCustomization.getValidMenuIdentifierFor(s3));
                }
            }
            if (!whitelist.isEmpty() || !blacklist.isEmpty()) {
                if (!whitelist.isEmpty() && whitelist.contains(identifier)) {
                    l.add(s);
                    continue;
                }
                if (blacklist.isEmpty() || blacklist.contains(identifier)) continue;
                l.add(s);
                continue;
            }
            l.add(s);
        }
        return l;
    }

    public static List<PropertiesSet> getDisabledPropertiesWithIdentifier(String identifier) {
        ArrayList<PropertiesSet> l = new ArrayList<PropertiesSet>();
        for (PropertiesSet s : MenuCustomizationProperties.getDisabledProperties()) {
            String s2;
            List l2 = s.getPropertiesOfType("customization-meta");
            if (l2.isEmpty()) {
                l2 = s.getPropertiesOfType("type-meta");
            }
            if (l2.isEmpty() || !(s2 = ((PropertiesSection)l2.get(0)).getEntryValue("identifier")).equalsIgnoreCase(identifier)) continue;
            l.add(s);
        }
        return l;
    }

    public static List<LayoutProperties> getAsLayoutProperties(List<PropertiesSet> propsList) {
        ArrayList<LayoutProperties> l = new ArrayList<LayoutProperties>();
        propsList.forEach(props -> l.add(new LayoutProperties((PropertiesSet)props)));
        return l;
    }

    public static class LayoutProperties {
        public PropertiesSet properties;
        public String menuIdentifier;
        public String path;

        public LayoutProperties(PropertiesSet props) {
            List l = props.getPropertiesOfType("customization-meta");
            if (!l.isEmpty()) {
                PropertiesSection meta = (PropertiesSection)l.get(0);
                this.path = meta.getEntryValue("path");
                this.menuIdentifier = meta.getEntryValue("identifier");
            }
        }
    }
}

