/*
 * Decompiled with CFR 0.152.
 */
package com.endertech.minecraft.mods.adhooks.shot;

import com.endertech.common.CommonMath;
import com.endertech.common.FloatBounds;
import com.endertech.minecraft.forge.entities.ForgeEntity;
import com.endertech.minecraft.forge.math.Combustion;
import com.endertech.minecraft.forge.math.ForgeMath;
import com.endertech.minecraft.forge.math.Rotation;
import com.endertech.minecraft.forge.math.Vect3d;
import com.endertech.minecraft.forge.world.ForgeWorld;
import com.endertech.minecraft.mods.adhooks.init.HookType;
import com.endertech.minecraft.mods.adhooks.items.Hook;
import com.endertech.minecraft.mods.adhooks.items.Launcher;
import com.endertech.minecraft.mods.adhooks.items.Rope;
import com.endertech.minecraft.mods.adhooks.motion.BoostUpMsg;
import com.endertech.minecraft.mods.adhooks.motion.EntityTarget;
import com.endertech.minecraft.mods.adhooks.motion.MotionController;
import com.endertech.minecraft.mods.adhooks.motion.SinglePlayerTarget;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.material.Material;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.Minecraft;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.IEntityMultiPart;
import net.minecraft.entity.IProjectile;
import net.minecraft.entity.MultiPartEntityPart;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.entity.player.InventoryPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.init.SoundEvents;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.datasync.DataParameter;
import net.minecraft.network.datasync.DataSerializer;
import net.minecraft.network.datasync.DataSerializers;
import net.minecraft.network.datasync.EntityDataManager;
import net.minecraft.server.MinecraftServer;
import net.minecraft.util.DamageSource;
import net.minecraft.util.EntityDamageSourceIndirect;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumParticleTypes;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.util.math.Vec3d;
import net.minecraft.util.math.Vec3i;
import net.minecraft.world.World;
import net.minecraft.world.WorldServer;
import net.minecraftforge.fml.common.registry.IThrowableEntity;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class HookShot
extends ForgeEntity
implements IThrowableEntity,
IProjectile {
    public static final float GRAVITY_VELOCITY = 0.005f;
    public static final int RENDER_DISTANCE = Rope.LENGTH_BOUNDS.getMax();
    private float shootStrength = 1.5f;
    private float size = 0.6f;
    private EnumFacing hitSide = null;
    private Combustion combustion = new Combustion();

    public HookShot(World world) {
        super(world);
        this.func_70105_a(this.size, this.size);
        this.field_70158_ak = true;
    }

    public HookShot(World world, EntityLivingBase shooter, HookType hookType) {
        this(world);
        this.field_70180_af.func_187227_b(WatchedInt.SHOOTER_ID.key, (Object)ForgeEntity.getId((Entity)shooter));
        this.setHookType(hookType);
        this.func_70012_b(shooter.field_70165_t, shooter.field_70163_u + (double)shooter.func_70047_e(), shooter.field_70161_v, shooter.field_70177_z, shooter.field_70125_A);
        this.field_70165_t -= (double)(ForgeMath.cos((float)this.field_70177_z) * 0.16f);
        this.field_70163_u -= (double)0.1f;
        this.field_70161_v -= (double)(ForgeMath.sin((float)this.field_70177_z) * 0.16f);
        this.func_70107_b(this.field_70165_t, this.field_70163_u, this.field_70161_v);
        this.field_70159_w = -ForgeMath.sin((float)this.field_70177_z) * ForgeMath.cos((float)this.field_70125_A);
        this.field_70179_y = ForgeMath.cos((float)this.field_70177_z) * ForgeMath.cos((float)this.field_70125_A);
        this.field_70181_x = -ForgeMath.sin((float)this.field_70125_A);
        this.func_70186_c(this.field_70159_w, this.field_70181_x, this.field_70179_y, this.shootStrength, 1.0f);
        if (world != null && shooter != null) {
            world.func_184148_a((EntityPlayer)null, shooter.field_70165_t, shooter.field_70163_u, shooter.field_70161_v, SoundEvents.field_187737_v, SoundCategory.NEUTRAL, 1.0f, 1.0f / (this.field_70146_Z.nextFloat() * 0.4f + 1.2f) + 0.5f);
        }
    }

    protected void func_70088_a() {
        super.func_70088_a();
        for (WatchedBool watchedBool : WatchedBool.values()) {
            this.field_70180_af.func_187214_a(watchedBool.key, (Object)false);
        }
        for (Enum enum_ : WatchedInt.values()) {
            this.field_70180_af.func_187214_a(((WatchedInt)enum_).key, (Object)0);
        }
        for (Enum enum_ : WatchedFloat.values()) {
            this.field_70180_af.func_187214_a(((WatchedFloat)enum_).key, (Object)Float.valueOf(0.0f));
        }
        this.setState(State.SHOOTING);
    }

    public boolean isLoosening() {
        return (Boolean)this.field_70180_af.func_187225_a(WatchedBool.LOOSENING.key);
    }

    public void setLoosening(boolean loosening) {
        if (this.isServerSide()) {
            this.field_70180_af.func_187227_b(WatchedBool.LOOSENING.key, (Object)loosening);
        }
    }

    public boolean isPulling() {
        return (Boolean)this.field_70180_af.func_187225_a(WatchedBool.PULLING.key);
    }

    public void setPulling(boolean pulling) {
        if (this.isServerSide()) {
            this.field_70180_af.func_187227_b(WatchedBool.PULLING.key, (Object)pulling);
        }
    }

    public State getPrevState() {
        int i = (Integer)this.field_70180_af.func_187225_a(WatchedInt.PREV_STATE.key);
        return State.values()[i];
    }

    public State getState() {
        int i = (Integer)this.field_70180_af.func_187225_a(WatchedInt.STATE.key);
        return State.values()[i];
    }

    public void setState(State state) {
        State prevState;
        if (this.isServerSide() && state != (prevState = this.getState())) {
            this.field_70180_af.func_187227_b(WatchedInt.PREV_STATE.key, (Object)prevState.ordinal());
            this.field_70180_af.func_187227_b(WatchedInt.STATE.key, (Object)state.ordinal());
        }
    }

    public float getRopeLength() {
        return ((Float)this.field_70180_af.func_187225_a(WatchedFloat.ROPE_LENGTH.key)).floatValue();
    }

    public void setRopeLength(float ropeLength) {
        if (this.isServerSide()) {
            this.field_70180_af.func_187227_b(WatchedFloat.ROPE_LENGTH.key, (Object)Float.valueOf(ropeLength));
        }
    }

    public float getSagging() {
        return ((Float)this.field_70180_af.func_187225_a(WatchedFloat.SAGGING.key)).floatValue();
    }

    public void setSagging(float sagging) {
        if (this.isServerSide()) {
            if (sagging < 0.0f) {
                sagging = 0.0f;
            }
            this.field_70180_af.func_187227_b(WatchedFloat.SAGGING.key, (Object)Float.valueOf(sagging));
        }
    }

    public void setHookType(HookType value) {
        if (this.isServerSide() && value != null) {
            this.field_70180_af.func_187227_b(WatchedInt.HOOK_TYPE.key, (Object)value.ordinal());
        }
    }

    public HookType getHookType() {
        int ordinal = (Integer)this.field_70180_af.func_187225_a(WatchedInt.HOOK_TYPE.key);
        return HookType.values()[ordinal];
    }

    public boolean canHookOnReeling() {
        return this.getHookType() == HookType.PUDGE;
    }

    public BlockAction getBlockAction(World world, BlockPos pos) {
        IBlockState state = world.func_180495_p(pos);
        Material material = state.func_185904_a();
        if (ForgeWorld.isAirBlock((IBlockState)state)) {
            return BlockAction.PASS;
        }
        HookType hookType = this.getHookType();
        Hook hook = hookType.hook;
        switch (hookType) {
            case WEB: {
                if (hook.canHookAnyBlock) {
                    return BlockAction.HOOK;
                }
                if (material == Material.field_151595_p) {
                    return BlockAction.BOUNCE;
                }
                return BlockAction.HOOK;
            }
            case PUDGE: {
                if (material == Material.field_151592_s) {
                    return BlockAction.BREAK;
                }
                if (material == Material.field_151584_j) {
                    return BlockAction.BREAK;
                }
                return BlockAction.BOUNCE;
            }
            case SPEAR: {
                float hardness;
                if (material == Material.field_151592_s) {
                    return BlockAction.BREAK;
                }
                if (material == Material.field_151584_j) {
                    return BlockAction.PASS;
                }
                if (material == Material.field_151575_d) {
                    return BlockAction.HOOK;
                }
                if (!hook.canHookAnyBlock && ((hardness = state.func_185887_b(world, pos)) < 0.0f || hardness > hookType.hook.getStrength() / 2.0f)) {
                    return BlockAction.BOUNCE;
                }
                return BlockAction.HOOK;
            }
        }
        return BlockAction.BOUNCE;
    }

    protected Vect3d getHitPosition() {
        return Vect3d.from((double)((Float)this.field_70180_af.func_187225_a(WatchedFloat.HIT_X.key)).floatValue(), (double)((Float)this.field_70180_af.func_187225_a(WatchedFloat.HIT_Y.key)).floatValue(), (double)((Float)this.field_70180_af.func_187225_a(WatchedFloat.HIT_Z.key)).floatValue());
    }

    public Vect3d getLauncherPosition() {
        return HookShot.getCenterPosition((Entity)this.getThrower());
    }

    public Vect3d getLauncherPosition(float tickProgress) {
        return HookShot.getCenterPosition((Entity)this.getThrower(), (float)tickProgress);
    }

    public void setHitPosition(Vect3d hitPosition) {
        if (this.isServerSide() && hitPosition != null) {
            this.field_70180_af.func_187227_b(WatchedFloat.HIT_X.key, (Object)Float.valueOf((float)hitPosition.x));
            this.field_70180_af.func_187227_b(WatchedFloat.HIT_Y.key, (Object)Float.valueOf((float)hitPosition.y));
            this.field_70180_af.func_187227_b(WatchedFloat.HIT_Z.key, (Object)Float.valueOf((float)hitPosition.z));
        }
    }

    public boolean isHookingBlock() {
        return this.getState() == State.HOOKING_BLOCK;
    }

    public boolean isHookingEntity() {
        return this.getState() == State.HOOKING_ENTITY;
    }

    public boolean isLauncherInMainHand() {
        ItemStack itemStack = this.getThrower() != null ? this.getThrower().func_184614_ca() : null;
        return itemStack != null && itemStack.func_77973_b() instanceof Launcher && Launcher.isAttachedToHookShot(itemStack, this);
    }

    public BlockPos getHookedBlockPos() {
        return new BlockPos(((Integer)this.field_70180_af.func_187225_a(WatchedInt.HOOKED_BLOCK_X.key)).intValue(), ((Integer)this.field_70180_af.func_187225_a(WatchedInt.HOOKED_BLOCK_Y.key)).intValue(), ((Integer)this.field_70180_af.func_187225_a(WatchedInt.HOOKED_BLOCK_Z.key)).intValue());
    }

    private void setHookedBlockPos(RayTraceResult rayTraceResult) {
        if (this.isServerSide() && rayTraceResult != null && rayTraceResult.func_178782_a() != null) {
            this.field_70180_af.func_187227_b(WatchedInt.HOOKED_BLOCK_X.key, (Object)rayTraceResult.func_178782_a().func_177958_n());
            this.field_70180_af.func_187227_b(WatchedInt.HOOKED_BLOCK_Y.key, (Object)rayTraceResult.func_178782_a().func_177956_o());
            this.field_70180_af.func_187227_b(WatchedInt.HOOKED_BLOCK_Z.key, (Object)rayTraceResult.func_178782_a().func_177952_p());
        }
    }

    private void onTargetHit(RayTraceResult rayTraceResult) {
        if (rayTraceResult == null) {
            return;
        }
        if (this.getState() == State.REELING && !this.canHookOnReeling()) {
            return;
        }
        Vect3d hitPosition = Vect3d.from((Vec3d)rayTraceResult.field_72307_f);
        switch (rayTraceResult.field_72313_a) {
            case BLOCK: {
                BlockPos pos = rayTraceResult.func_178782_a();
                BlockAction action = this.getBlockAction(this.field_70170_p, pos);
                if (action == BlockAction.BOUNCE && this.getHook().canHookAnyBlock) {
                    action = BlockAction.HOOK;
                }
                switch (action) {
                    case HOOK: {
                        break;
                    }
                    case BREAK: {
                        IBlockState state = this.field_70170_p.func_180495_p(pos);
                        this.field_70170_p.func_175655_b(pos, state.func_185904_a() != Material.field_151592_s);
                    }
                    case BOUNCE: {
                        this.setState(State.REELING);
                    }
                    default: {
                        return;
                    }
                }
                this.hitSide = rayTraceResult.field_178784_b;
                Vect3d offsetVec = Vect3d.from((Vec3i)this.hitSide.func_176730_m()).scale(0.05);
                hitPosition = hitPosition.add(offsetVec);
                this.setHookedBlockPos(rayTraceResult);
                this.setHitPosition(hitPosition);
                this.setState(State.HOOKING_BLOCK);
                break;
            }
            case ENTITY: {
                IEntityMultiPart dragon;
                Entity target = rayTraceResult.field_72308_g;
                if (target instanceof MultiPartEntityPart && (dragon = ((MultiPartEntityPart)target).field_70259_a) instanceof Entity) {
                    target = (Entity)dragon;
                }
                if (!this.canBeAttachedTo(target)) {
                    return;
                }
                Hook hook = this.getHookType().hook;
                if (hook != null && hook.getDamage() > 0.0f) {
                    DamageSource damageSource = new EntityDamageSourceIndirect("arrow", (Entity)this, (Entity)this.getThrower()).func_76349_b();
                    target.func_70097_a(damageSource, hook.getDamage());
                }
                this.field_70180_af.func_187227_b(WatchedInt.HOOKED_ENTITY_ID.key, (Object)target.func_145782_y());
                this.setState(State.HOOKING_ENTITY);
                break;
            }
            default: {
                return;
            }
        }
        float ropeLength = (float)(this.getLauncherPosition().distance(hitPosition) + (double)this.getHookType().launcher.getReelingSpeed());
        this.setRopeLength(ropeLength);
        this.func_184185_a(SoundEvents.field_187731_t, 1.0f, 1.2f / (this.field_70146_Z.nextFloat() * 0.2f + 0.9f));
    }

    protected boolean canBeAttachedTo(Entity entity) {
        HookType type = this.getHookType();
        Hook hook = type.hook;
        if (entity == null || hook == null || this.getThrower() == null) {
            return false;
        }
        if (entity instanceof EntityPlayer) {
            if (hook.affectsPlayers) {
                return true;
            }
        } else if (hook.affectsNPCs) {
            float maxWeight = hook.maxEntityWeight;
            float targetWeight = ForgeEntity.getWeight((Entity)entity, (boolean)false);
            return targetWeight <= maxWeight;
        }
        return false;
    }

    protected boolean isSinglePlayer() {
        MinecraftServer server;
        if (this.field_70170_p instanceof WorldServer && (server = ((WorldServer)this.field_70170_p).func_73046_m()) != null) {
            return server.func_71264_H();
        }
        if (ForgeWorld.isClientSide((World)this.field_70170_p)) {
            return Minecraft.func_71410_x().func_71356_B();
        }
        return true;
    }

    protected void updatePhysics() {
        Entity hookedEntity;
        HookType hookType = this.getHookType();
        State state = this.getState();
        EntityLivingBase shooter = this.getThrower();
        Entity entity = hookedEntity = state == State.HOOKING_ENTITY ? this.findHookedEntity() : null;
        if (shooter == null || shooter.field_70128_L) {
            this.func_70106_y();
            return;
        }
        if (shooter instanceof EntityPlayerMP) {
            EntityPlayerMP player = (EntityPlayerMP)shooter;
            if (Launcher.findAttachedLauncher(player.field_71071_by, this) == null) {
                this.func_70106_y();
                return;
            }
        }
        Vect3d launcherPosition = this.getLauncherPosition();
        Vect3d tensionVec = Vect3d.ZERO;
        float tensionForce = 0.0f;
        float hookDistance = this.getHookDistance();
        Vect3d hookPosition = this.getCurPosition();
        FloatBounds ropeLengthBounds = hookType.rope.getLengthBounds(shooter, hookedEntity);
        float ropeLength = ropeLengthBounds.enclose(Float.valueOf(this.getRopeLength())).floatValue();
        float reelingSpeed = hookType.launcher.getReelingSpeed();
        switch (state) {
            case SHOOTING: {
                ropeLength = hookDistance + reelingSpeed;
                if (!this.isServerSide() || !(ropeLength > ropeLengthBounds.getMax().floatValue())) break;
                this.setState(State.REELING);
                return;
            }
            case REELING: {
                float reelingSpeedMult = 4.0f;
                if (this.isPulling()) {
                    reelingSpeedMult *= 2.0f;
                }
                Vect3d motionVec = launcherPosition.subtract(hookPosition).resize((double)(reelingSpeed * reelingSpeedMult));
                this.setMotion(motionVec);
                float hookNextDistance = (float)launcherPosition.distance(this.getNextPosition());
                ropeLength = hookDistance;
                if (!(ropeLength <= ropeLengthBounds.getMin().floatValue()) && !(hookDistance <= hookNextDistance)) break;
                this.func_70106_y();
                return;
            }
            case HOOKING_BLOCK: 
            case HOOKING_ENTITY: {
                if (!(ropeLength < hookDistance)) break;
                tensionForce = hookType.rope.getTensionForce(ropeLength, hookDistance);
                tensionVec = hookPosition.subtract(launcherPosition).resize((double)tensionForce);
                float hookStrength = hookType.hook.getStrength();
                if (tensionForce > hookStrength) {
                    this.setState(State.REELING);
                    return;
                }
                HookShot.setFallDistance((Entity)shooter, (float)0.0f, (boolean)true);
                break;
            }
        }
        switch (state) {
            case HOOKING_BLOCK: {
                this.addMotionTo((Entity)shooter, tensionVec);
                break;
            }
            case HOOKING_ENTITY: {
                float targetWeight;
                if (hookedEntity == null) {
                    this.setState(State.REELING);
                    return;
                }
                float shooterWeightAdvantage = 2.0f;
                float shooterWeight = HookShot.getWeight((Entity)shooter, (boolean)false) * 2.0f;
                float totalWeight = (shooterWeight += HookShot.getWeight((Entity)shooter, (boolean)true)) + (targetWeight = HookShot.getWeight((Entity)hookedEntity, (boolean)true));
                if (totalWeight == 0.0f) {
                    totalWeight = 1.0f;
                }
                if (ropeLength <= hookDistance || tensionVec.notZero()) {
                    HookShot.setFallDistance((Entity)hookedEntity, (float)0.0f, (boolean)true);
                }
                if (hookType == HookType.PUDGE && ropeLength <= ropeLengthBounds.getMin().floatValue()) {
                    this.addMotionTo(hookedEntity, tensionVec);
                    this.func_70106_y();
                    return;
                }
                this.addMotionTo(hookedEntity, tensionVec.invert().scale((double)(shooterWeight / totalWeight)));
                this.addMotionTo((Entity)shooter, tensionVec.scale((double)(targetWeight / totalWeight)));
                break;
            }
        }
        ropeLength = ropeLengthBounds.enclose(Float.valueOf(ropeLength)).floatValue();
        if (this.isServerSide()) {
            this.setRopeLength(ropeLength);
            this.setSagging(ropeLength - hookDistance);
            this.setState(state);
            this.setTensionForce(tensionForce);
        }
    }

    private void setTensionForce(float tensionForce) {
        if (this.isServerSide()) {
            this.field_70180_af.func_187227_b(WatchedFloat.TENSION_FORCE.key, (Object)Float.valueOf(tensionForce));
        }
    }

    public float getHookDistance() {
        return (float)this.getLauncherPosition().distance(this.getCurPosition());
    }

    protected void updateControlling() {
        if (!this.isServerSide()) {
            return;
        }
        HookType hookType = this.getHookType();
        EntityLivingBase shooter = this.getThrower();
        if (!this.isLauncherInMainHand() || hookType == null || hookType.launcher == null || shooter == null) {
            return;
        }
        State state = this.getState();
        float ropeLength = this.getRopeLength();
        float pullingSpeed = hookType.launcher.getReelingSpeed();
        switch (state) {
            case HOOKING_BLOCK: 
            case HOOKING_ENTITY: {
                if (shooter.func_70093_af()) {
                    pullingSpeed *= 0.5f;
                }
                if (this.isPulling()) {
                    ropeLength -= pullingSpeed;
                }
                if (!this.isLoosening() || hookType == HookType.PUDGE) break;
                ropeLength += pullingSpeed;
                break;
            }
        }
        if (((Boolean)this.field_70180_af.func_187225_a(WatchedBool.DROPPING.key)).booleanValue()) {
            ropeLength -= (pullingSpeed *= 4.0f);
            if (this.isPulling() && state == State.HOOKING_BLOCK && (CommonMath.notZero((double)this.getTensionForce()) || ropeLength <= this.getHookDistance())) {
                this.boostUpShooter();
            }
            this.setState(State.REELING);
            return;
        }
        switch (state) {
            case HOOKING_BLOCK: {
                if (!shooter.func_70051_ag() || !CommonMath.notZero((double)this.getTensionForce())) break;
                ropeLength += pullingSpeed;
                break;
            }
            case HOOKING_ENTITY: {
                if (hookType != HookType.PUDGE || this.isLoosening()) break;
                ropeLength -= pullingSpeed * 2.0f;
                break;
            }
        }
        if (ropeLength < 0.0f) {
            ropeLength = 0.0f;
        }
        this.setRopeLength(ropeLength);
    }

    public Rope getRope() {
        HookType hookType = this.getHookType();
        return hookType.rope;
    }

    public Launcher getLauncher() {
        HookType hookType = this.getHookType();
        return hookType.launcher;
    }

    public Hook getHook() {
        HookType hookType = this.getHookType();
        return hookType.hook;
    }

    protected void addMotionTo(Entity entity, Vect3d motion) {
        EntityTarget target = MotionController.getTarget(entity.func_184208_bv()).orElse(null);
        if (target != null) {
            target.addDampedMotion(motion);
            if (HookShot.isClientSide((Entity)entity) && target instanceof SinglePlayerTarget) {
                ((SinglePlayerTarget)target).setSwinging(!entity.field_70122_E);
            }
        }
    }

    public void func_70037_a(NBTTagCompound nbt) {
        this.func_70106_y();
    }

    public boolean func_70067_L() {
        return false;
    }

    @Nullable
    public EntityLivingBase getThrower() {
        Entity entity = ForgeWorld.findEntity((World)this.field_70170_p, (int)((Integer)this.field_70180_af.func_187225_a(WatchedInt.SHOOTER_ID.key)));
        return entity instanceof EntityLivingBase ? (EntityLivingBase)entity : null;
    }

    public void setThrower(Entity entity) {
        if (entity instanceof EntityLivingBase) {
            this.field_70180_af.func_187227_b(WatchedInt.SHOOTER_ID.key, (Object)ForgeEntity.getId((Entity)entity));
        }
    }

    public Block getHookedBlock() {
        return ForgeWorld.getBlock((World)this.field_70170_p, (BlockPos)this.getHookedBlockPos());
    }

    public boolean hookedBlockExists() {
        return this.getHookedBlock() != Blocks.field_150350_a;
    }

    @Nullable
    public Entity findHookedEntity() {
        return HookShot.findEntity((World)this.field_70170_p, (int)((Integer)this.field_70180_af.func_187225_a(WatchedInt.HOOKED_ENTITY_ID.key)));
    }

    public boolean hookedEntityIsAlive() {
        Entity entity = this.findHookedEntity();
        return entity != null && entity.func_70089_S();
    }

    public void func_70071_h_() {
        super.func_70071_h_();
        this.move();
        this.setPrevRotation(this.getCurRotation());
        this.updateControlling();
        this.updateCombustion();
        this.updatePhysics();
        this.updateCollisions();
        this.updateTargetState();
        this.updateMotion();
        this.updateRotation();
    }

    private void updateCombustion() {
        if (this.isServerSide()) {
            double fireResistance = this.getHookType().hook.resistance;
            boolean fireInfluenced = false;
            switch (this.getState()) {
                case HOOKING_BLOCK: {
                    fireInfluenced = ForgeWorld.getBlock((World)this.field_70170_p, (BlockPos)this.getHookedBlockPos().func_177972_a(this.hitSide)) == Blocks.field_150480_ab;
                    break;
                }
                case HOOKING_ENTITY: {
                    Entity entity = this.findHookedEntity();
                    fireInfluenced = entity != null && entity.func_70027_ad();
                    break;
                }
            }
            if (this.func_70027_ad()) {
                this.combustion.fire();
            }
            if (this.combustion.getFireInfluencedTime().inSeconds() > fireResistance) {
                this.combustion.fire();
            }
            if (this.combustion.isBurning()) {
                this.func_70015_d(1);
            }
            if (this.combustion.getBurningTime().inSeconds() > fireResistance) {
                this.func_70106_y();
            }
            this.combustion.update(fireInfluenced);
        }
    }

    private void updateCollisions() {
        if (!this.isServerSide()) {
            return;
        }
        State state = this.getState();
        if (this.isHookingTarget()) {
            return;
        }
        if (state == State.REELING) {
            if (!this.canHookOnReeling()) {
                return;
            }
            if (this.getHookType() == HookType.PUDGE && this.getPrevState() == State.HOOKING_ENTITY) {
                return;
            }
        }
        ArrayList<RayTraceResult> rayTraceResultsList = new ArrayList<RayTraceResult>();
        if (this.field_70170_p != null) {
            rayTraceResultsList.add(this.field_70170_p.func_147447_a(this.getPrevPosition().toVec3d(), this.getCurPosition().toVec3d(), false, true, false));
        }
        AxisAlignedBB aaBB = this.getBB().func_72321_a(this.field_70159_w, this.field_70181_x, this.field_70179_y);
        List list = this.getEntitiesWithinAABB(aaBB);
        EntityLivingBase shooter = this.getThrower();
        Entity shooterRide = shooter != null ? shooter.func_184187_bx() : null;
        for (Entity target : list) {
            RayTraceResult rayTraceResult;
            if (target == shooter && state == State.REELING) {
                this.func_70106_y();
                return;
            }
            if (!this.isServerSide() || !target.func_70067_L() || target == shooter || target == shooterRide || (rayTraceResult = HookShot.getBB((Entity)target).func_72327_a(this.getCurPosition().toVec3d(), this.getNextPosition().toVec3d())) == null) continue;
            rayTraceResultsList.add(new RayTraceResult(target, HookShot.getCenterPosition((Entity)target).toVec3d()));
        }
        RayTraceResult nearestResult = null;
        double minDistance = Double.MAX_VALUE;
        for (RayTraceResult rayTraceResult : rayTraceResultsList) {
            double distance;
            if (rayTraceResult == null || !((distance = this.getCurPosition().distance(Vect3d.from((Vec3d)rayTraceResult.field_72307_f))) < minDistance)) continue;
            nearestResult = rayTraceResult;
            minDistance = distance;
        }
        if (nearestResult != null) {
            this.onTargetHit(nearestResult);
        }
    }

    private void updateTargetState() {
        if (this.isServerSide()) {
            switch (this.getState()) {
                case HOOKING_BLOCK: {
                    if (this.hookedBlockExists()) break;
                    this.setState(State.REELING);
                    break;
                }
                case HOOKING_ENTITY: {
                    Entity entity = this.findHookedEntity();
                    if (!(entity == null || entity.field_70128_L || entity instanceof EntityLivingBase && ((EntityLivingBase)entity).field_82175_bq && entity.func_70093_af() || entity instanceof EntityPlayer && entity.func_184218_aH() && ((EntityPlayer)entity).field_82175_bq) && !HookShot.hasSwingingPlayerPassenger((Entity)entity)) break;
                    this.setState(State.REELING);
                    break;
                }
            }
        }
    }

    public boolean isHookingTarget() {
        switch (this.getState()) {
            case HOOKING_BLOCK: 
            case HOOKING_ENTITY: {
                return true;
            }
        }
        return false;
    }

    private void updateRotation() {
        if (this.isHookingTarget()) {
            this.setAllRotations(this.getCurRotation());
        } else {
            Vect3d motion = this.getMotion();
            if (motion.notZero()) {
                if (this.getState() == State.REELING) {
                    motion = motion.invert();
                }
                this.setCurRotation(motion.rotation());
            }
        }
    }

    private void updateMotion() {
        State state = this.getState();
        switch (state) {
            case HOOKING_BLOCK: {
                if (!this.hookedBlockExists()) break;
                this.setAllPositions(this.getHitPosition());
                this.stopMoving();
                this.field_70122_E = true;
                break;
            }
            case HOOKING_ENTITY: {
                Entity entity;
                if (!this.func_184218_aH() && (entity = this.findHookedEntity()) != null) {
                    this.stopMoving();
                    this.func_184205_a(entity, true);
                    if (this.getHookType() == HookType.PUDGE) {
                        entity.func_184210_p();
                    }
                }
                this.field_70122_E = true;
                break;
            }
            default: {
                if (this.func_184218_aH()) {
                    this.func_184210_p();
                }
                this.field_70122_E = false;
                double motionFactor = 0.99f;
                if (this.func_70090_H()) {
                    Vect3d bubblePos = this.getCurPosition().subtract(this.getMotion().scale(0.25));
                    for (int i = 0; i < 4; ++i) {
                        ForgeWorld.spawnParticle((World)this.field_70170_p, (EnumParticleTypes)EnumParticleTypes.WATER_BUBBLE, (Vect3d)bubblePos, (Vect3d)this.getMotion());
                    }
                    motionFactor = 0.8f;
                }
                this.setMotion(this.getMotion().scale(motionFactor));
                this.field_70181_x -= (double)0.005f;
            }
        }
    }

    public void func_70186_c(double x, double y, double z, float velocity, float inaccuracy) {
        Vect3d vec = Vect3d.from((double)x, (double)y, (double)z).normalize().scale((double)velocity);
        Rotation rotation = new Rotation(vec.pitch(), vec.yaw());
        this.setMotion(vec);
        this.setAllRotations(rotation);
    }

    public void func_70106_y() {
        InventoryPlayer inventory;
        ItemStack launcher;
        if (this.getThrower() instanceof EntityPlayerMP && (launcher = Launcher.findAttachedLauncher(inventory = ((EntityPlayerMP)this.getThrower()).field_71071_by, this)) != null) {
            Launcher.unattach(launcher);
        }
        super.func_70106_y();
    }

    public float getTensionForce() {
        return ((Float)this.field_70180_af.func_187225_a(WatchedFloat.TENSION_FORCE.key)).floatValue();
    }

    @SideOnly(value=Side.CLIENT)
    public boolean func_70112_a(double distance) {
        return distance < (double)(RENDER_DISTANCE * RENDER_DISTANCE);
    }

    @SideOnly(value=Side.CLIENT)
    public AxisAlignedBB func_184177_bl() {
        return this.getBB().func_111270_a(HookShot.getBB((Entity)this.getThrower()));
    }

    protected void boostUpShooter() {
        EntityLivingBase shooter = this.getThrower();
        Launcher launcher = this.getLauncher();
        if (shooter instanceof EntityPlayerMP && launcher != null) {
            float strength = launcher.getBoostStrength();
            new BoostUpMsg(strength).sendTo((EntityPlayerMP)shooter);
            HookShot.setFallDistance((Entity)shooter, (float)0.0f, (boolean)true);
        }
    }

    @Deprecated
    protected Vect3d getPlayerMovement() {
        EntityLivingBase shooter = this.getThrower();
        if (!(shooter instanceof EntityPlayer)) {
            return Vect3d.ZERO;
        }
        Vect3d direction = Vect3d.ZERO;
        EntityPlayer player = (EntityPlayer)shooter;
        EntityDataManager value = this.func_184212_Q();
        if (((Boolean)value.func_187225_a(WatchedBool.MOVING_FORWARD.key)).booleanValue()) {
            direction = direction.move(0.0, 0.0, 1.0);
        }
        if (((Boolean)value.func_187225_a(WatchedBool.MOVING_BACKWARD.key)).booleanValue()) {
            direction = direction.move(0.0, 0.0, -1.0);
        }
        if (((Boolean)value.func_187225_a(WatchedBool.MOVING_LEFT.key)).booleanValue()) {
            direction = direction.move(1.0, 0.0, 0.0);
        }
        if (((Boolean)value.func_187225_a(WatchedBool.MOVING_RIGHT.key)).booleanValue()) {
            direction = direction.move(-1.0, 0.0, 0.0);
        }
        if (direction.notZero()) {
            direction = direction.rotateAroundY(-player.field_70177_z).normalize();
        }
        double strength = 0.03;
        if (player.func_70051_ag()) {
            strength *= 2.0;
        }
        if (!player.field_70122_E) {
            strength = 0.015 + ForgeEntity.getMotion((Entity)player).length() * 0.01;
        }
        Vect3d motion = direction.resize(strength);
        if (((Boolean)value.func_187225_a(WatchedBool.JUMPING.key)).booleanValue() && (player.func_70090_H() || player.func_180799_ab())) {
            motion = motion.move(0.0, 0.12, 0.0);
        }
        return motion;
    }

    static enum BlockAction {
        BOUNCE,
        BREAK,
        HOOK,
        PASS;

    }

    public static enum State {
        SHOOTING,
        REELING,
        HOOKING_BLOCK,
        HOOKING_ENTITY;

    }

    public static enum WatchedFloat {
        HIT_X,
        HIT_Y,
        HIT_Z,
        ROPE_LENGTH,
        SAGGING,
        TENSION_FORCE;

        public final DataParameter<Float> key = EntityDataManager.func_187226_a(HookShot.class, (DataSerializer)DataSerializers.field_187193_c);
    }

    public static enum WatchedInt {
        HOOKED_BLOCK_X,
        HOOKED_BLOCK_Y,
        HOOKED_BLOCK_Z,
        HOOKED_ENTITY_ID,
        HOOK_TYPE,
        PREV_STATE,
        SHOOTER_ID,
        STATE;

        public final DataParameter<Integer> key = EntityDataManager.func_187226_a(HookShot.class, (DataSerializer)DataSerializers.field_187192_b);
    }

    public static enum WatchedBool {
        PULLING,
        LOOSENING,
        DROPPING,
        MOVING_FORWARD,
        MOVING_BACKWARD,
        MOVING_LEFT,
        MOVING_RIGHT,
        JUMPING;

        public final DataParameter<Boolean> key = EntityDataManager.func_187226_a(HookShot.class, (DataSerializer)DataSerializers.field_187198_h);
    }
}

