/*
 * Decompiled with CFR 0.152.
 */
package com.endertech.minecraft.mods.adhooks.motion.realistic;

import com.endertech.minecraft.forge.entities.ForgeEntity;
import com.endertech.minecraft.forge.math.Vect3d;
import com.endertech.minecraft.mods.adhooks.motion.MotionMsg;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import net.minecraft.entity.Entity;

@Deprecated
public class RealisticTarget {
    public final Entity entity;
    protected final Set<Entity> sources;
    protected Vect3d motion;
    protected int jumpTicksLeft;
    protected boolean noFrictions;
    protected boolean noLimitations;

    public RealisticTarget(Entity entity) {
        this.entity = entity;
        this.sources = new HashSet<Entity>();
        this.motion = ForgeEntity.getMotion((Entity)entity);
        this.jumpTicksLeft = 0;
        this.noFrictions = false;
        this.noLimitations = false;
    }

    public RealisticTarget addForceFrom(Entity source, Vect3d motion) {
        this.sources.add(source);
        return this.addMotion(motion);
    }

    public RealisticTarget reduceBounce(Vect3d tension, float reduction) {
        Vect3d bounce = this.motion.projectOn(tension);
        this.motion = this.motion.subtract(bounce.scale((double)reduction));
        return this;
    }

    public Vect3d getMotion() {
        return this.motion;
    }

    public RealisticTarget addMotion(Vect3d motion) {
        this.motion = this.motion.add(motion);
        return this;
    }

    public RealisticTarget noFrictions(boolean value) {
        this.noFrictions = value;
        return this;
    }

    public RealisticTarget noLimitations(boolean value) {
        this.noLimitations = value;
        return this;
    }

    protected RealisticTarget applyFriction(double factor) {
        double decel;
        double veloc = this.motion.length();
        if ((veloc -= (decel = veloc * veloc * factor)) < 0.0) {
            veloc = 0.0;
        }
        this.motion = this.motion.resize(veloc);
        return this;
    }

    protected RealisticTarget applyFrictions() {
        if (this.noFrictions) {
            return this;
        }
        double factor = 0.05;
        if (this.entity.func_70090_H() || this.entity.func_180799_ab()) {
            factor += 0.25;
        }
        if (this.entity.field_70122_E) {
            factor += 0.5;
        }
        return this.applyFriction(factor);
    }

    protected RealisticTarget applyGravity() {
        return this.entity.func_189652_ae() ? this : this.addMotion(Vect3d.from((double)0.0, (double)-0.08, (double)0.0));
    }

    protected RealisticTarget applyLimitations() {
        if (this.noLimitations) {
            return this;
        }
        double maxLength = 1.0;
        if (this.motion.length() > 1.0) {
            this.motion = this.motion.resize(1.0);
        }
        double minValue = 0.003;
        double x = Math.abs(this.motion.x) < 0.003 ? 0.0 : this.motion.x;
        double y = Math.abs(this.motion.y) < 0.003 ? 0.0 : this.motion.y;
        double z = Math.abs(this.motion.z) < 0.003 ? 0.0 : this.motion.z;
        this.motion = Vect3d.from((double)x, (double)y, (double)z);
        return this;
    }

    protected RealisticTarget applyJumping() {
        if (!this.entity.field_70122_E && this.jumpTicksLeft > 0) {
            --this.jumpTicksLeft;
            this.motion = this.motion.withY(ForgeEntity.getMotion((Entity)this.entity).y);
        }
        return this;
    }

    protected RealisticTarget applyCollisions() {
        if (!this.entity.field_70122_E) {
            if (this.entity.field_70123_F) {
                this.motion = ForgeEntity.getMotion((Entity)this.entity).withY(this.motion.y);
            }
            if (this.entity.field_70124_G) {
                this.motion = this.motion.withY(ForgeEntity.getMotion((Entity)this.entity).y);
            }
        }
        return this;
    }

    protected void removeDeadSources() {
        Iterator<Entity> iterator = this.sources.iterator();
        while (iterator.hasNext()) {
            Entity entity = iterator.next();
            if (entity.func_70089_S()) continue;
            iterator.remove();
        }
    }

    public boolean hasSources() {
        for (Entity entity : this.sources) {
            if (!entity.func_70089_S()) continue;
            return true;
        }
        return false;
    }

    public void applyMotion() {
        this.removeDeadSources();
        this.applyFrictions();
        this.applyGravity();
        this.applyCollisions();
        this.applyLimitations();
        this.applyJumping();
        ForgeEntity.setMotion((Entity)this.entity, (Vect3d)this.motion);
        MotionMsg message = MotionMsg.of(this.entity);
        if (ForgeEntity.isServerSide((Entity)this.entity)) {
            message.sendToAllTracking(this.entity);
        } else if (!this.entity.field_70122_E) {
            message.sendToServer();
        }
    }
}

