/*
 * Decompiled with CFR 0.152.
 */
package svenhjol.charm.enchanting.enchantment;

import net.minecraft.block.Block;
import net.minecraft.enchantment.Enchantment;
import net.minecraft.enchantment.EnumEnchantmentType;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.init.Items;
import net.minecraft.inventory.EntityEquipmentSlot;
import net.minecraft.item.ItemHoe;
import net.minecraft.item.ItemStack;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraftforge.event.entity.player.PlayerInteractEvent;
import svenhjol.charm.base.CharmSounds;
import svenhjol.charm.enchanting.feature.Homing;
import svenhjol.meson.MesonEnchantment;
import svenhjol.meson.helper.EnchantmentHelper;
import svenhjol.meson.helper.SoundHelper;
import svenhjol.meson.helper.WorldHelper;

public class EnchantmentHoming
extends MesonEnchantment {
    public EnchantmentHoming() {
        super("homing", Enchantment.Rarity.RARE, EnumEnchantmentType.BREAKABLE, EntityEquipmentSlot.MAINHAND);
    }

    @Override
    public String getModId() {
        return "charm";
    }

    @Override
    public boolean func_185261_e() {
        return true;
    }

    public boolean func_92089_a(ItemStack stack) {
        return stack.func_77973_b() == Items.field_151012_L || stack.func_77973_b() == Items.field_151013_M || stack.func_77973_b() == Items.field_151019_K || stack.func_77973_b() == Items.field_151122_aG;
    }

    @Override
    public int func_77325_b() {
        return 1;
    }

    @Override
    public int func_77321_a(int enchantmentLevel) {
        return Homing.minEnchantability;
    }

    public void onBlockInteract(PlayerInteractEvent.RightClickBlock event) {
        ItemStack held = event.getEntityPlayer().func_184586_b(event.getHand());
        if (held.func_77973_b() instanceof ItemHoe && EnchantmentHelper.hasEnchantment(this, held)) {
            World world = event.getWorld();
            EntityPlayer player = event.getEntityPlayer();
            Block checkFor = null;
            if (held.func_77973_b() == Items.field_151019_K) {
                checkFor = Blocks.field_150366_p;
            } else if (held.func_77973_b() == Items.field_151013_M) {
                checkFor = Blocks.field_150352_o;
            } else if (held.func_77973_b() == Items.field_151012_L) {
                checkFor = Blocks.field_150482_ag;
            }
            if (checkFor != null) {
                int range = Homing.range;
                double distance = 0.0;
                BlockPos eventPos = event.getPos();
                Iterable positions = BlockPos.func_177980_a((BlockPos)eventPos.func_177982_a(-range, -range, -range), (BlockPos)eventPos.func_177982_a(range, range, range));
                for (BlockPos pos : positions) {
                    if (world.func_180495_p(pos).func_177230_c() != checkFor) continue;
                    double d = WorldHelper.getDistanceSq(eventPos, pos);
                    if (distance != 0.0 && !(d < distance)) continue;
                    distance = d;
                }
                if (distance != 0.0) {
                    held.func_77972_a(held.func_77958_k() / Homing.damage, (EntityLivingBase)player);
                    if (world.field_72995_K) {
                        float vol = 1.0f - Math.min((float)distance, 100.0f) / 100.0f;
                        float pitch = 1.0f - Math.min((float)distance, 100.0f) / 100.0f;
                        player.func_184609_a(event.getHand());
                        SoundHelper.playerSound(player, CharmSounds.HOMING, vol, pitch, SoundCategory.AMBIENT);
                    }
                }
            }
        }
    }
}

