/*
 * Decompiled with CFR 0.152.
 */
package svenhjol.charm.crafting.tile;

import javax.annotation.Nonnull;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.util.text.translation.I18n;
import net.minecraftforge.fml.common.Optional;
import net.minecraftforge.items.ItemStackHandler;
import svenhjol.charm.crafting.block.BlockBookshelfChest;
import svenhjol.charm.crafting.feature.BookshelfChest;
import svenhjol.meson.MesonTileInventory;
import svenhjol.meson.helper.ItemHelper;
import vazkii.quark.api.IDropoffManager;

@Optional.Interface(iface="vazkii.quark.api.IDropoffManager", modid="quark")
public class TileBookshelfChest
extends MesonTileInventory
implements IDropoffManager {
    private int inventorySize;
    public static final int SIZE = 9;
    public ItemStackHandler inventory = new ItemStackHandler(9){

        protected int getStackLimit(int slot, @Nonnull ItemStack stack) {
            boolean allowed = !ItemHelper.getMatchingItemKey(BookshelfChest.validItems, stack).isEmpty();
            return allowed ? 64 : 0;
        }

        protected void onLoad() {
            super.onLoad();
            this.recalculateSize();
        }

        protected void onContentsChanged(int slot) {
            this.recalculateSize();
            TileBookshelfChest.this.func_70296_d();
            TileBookshelfChest.this.updateBlock();
        }

        protected void recalculateSize() {
            int occupied = 0;
            for (int i = 0; i < this.getSlots(); ++i) {
                if (this.getStackInSlot(i).func_190926_b()) continue;
                ++occupied;
            }
            TileBookshelfChest.this.inventorySize = occupied;
        }
    };

    protected void updateBlock() {
        if (this.field_145850_b.func_180495_p(this.field_174879_c).func_177230_c() == BookshelfChest.bookshelfChest) {
            int slots = this.getNumberOfFilledSlots();
            IBlockState state = this.field_145850_b.func_180495_p(this.field_174879_c).func_177226_a((IProperty)BlockBookshelfChest.SLOTS, (Comparable)Integer.valueOf(slots));
            this.field_145850_b.func_180501_a(this.field_174879_c, state, 2);
        }
    }

    public boolean acceptsDropoff(EntityPlayer player) {
        return true;
    }

    @Override
    public ItemStackHandler getInventory() {
        return this.inventory;
    }

    @Override
    public int getInventorySize() {
        return 9;
    }

    @Override
    public String getModId() {
        return "charm";
    }

    public int getNumberOfFilledSlots() {
        if (this.hasLootTable() && this.lootSize > 0) {
            return this.lootSize;
        }
        return this.inventorySize;
    }

    @Override
    public int getComparatorOutput() {
        return this.getNumberOfFilledSlots();
    }

    @Override
    public String getDefaultName() {
        return I18n.func_74838_a((String)"tile.charm:bookshelf_chest.name");
    }
}

