/*
 * Decompiled with CFR 0.152.
 */
package com.teamwizardry.librarianlib.features.gui.provided.book.hierarchy.entry;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonPrimitive;
import com.teamwizardry.librarianlib.core.LibrarianLog;
import com.teamwizardry.librarianlib.features.gui.component.GuiComponent;
import com.teamwizardry.librarianlib.features.gui.components.ComponentSprite;
import com.teamwizardry.librarianlib.features.gui.components.ComponentText;
import com.teamwizardry.librarianlib.features.gui.provided.book.IBookGui;
import com.teamwizardry.librarianlib.features.gui.provided.book.context.Bookmark;
import com.teamwizardry.librarianlib.features.gui.provided.book.context.PaginationContext;
import com.teamwizardry.librarianlib.features.gui.provided.book.helper.TranslationHolder;
import com.teamwizardry.librarianlib.features.gui.provided.book.hierarchy.IBookElement;
import com.teamwizardry.librarianlib.features.gui.provided.book.hierarchy.book.Book;
import com.teamwizardry.librarianlib.features.gui.provided.book.hierarchy.entry.criterion.ICriterion;
import com.teamwizardry.librarianlib.features.gui.provided.book.hierarchy.entry.criterion.game.EntryUnlockedEvent;
import com.teamwizardry.librarianlib.features.gui.provided.book.hierarchy.page.Page;
import com.teamwizardry.librarianlib.features.math.Vec2d;
import java.awt.Color;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.Regex;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.fml.common.eventhandler.Event;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 1, 13}, bv={1, 0, 3}, k=1, d1={"\u0000h\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0006\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u0000 62\u00020\u0001:\u00016B5\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\u0007\u0012\u0006\u0010\t\u001a\u00020\u0005\u0012\u0006\u0010\n\u001a\u00020\u000b\u00a2\u0006\u0002\u0010\fJ\u0016\u0010/\u001a\b\u0012\u0004\u0012\u0002000&2\u0006\u00101\u001a\u000202H\u0017J\u000e\u00103\u001a\u00020\u001f2\u0006\u00104\u001a\u000205R\u0011\u0010\r\u001a\u00020\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u000fR\u0014\u0010\u0002\u001a\u00020\u0003X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\u0011R\u0013\u0010\u0012\u001a\u0004\u0018\u00010\u0013\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0014\u0010\u0015R\u0013\u0010\u0016\u001a\u0004\u0018\u00010\u0017\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0018\u0010\u0019R\u0011\u0010\u001a\u001a\u00020\u001b\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001c\u0010\u001dR\u001a\u0010\u001e\u001a\u00020\u001fX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u001e\u0010 \"\u0004\b!\u0010\"R\u0011\u0010#\u001a\u00020\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b$\u0010\u000fR\u0017\u0010%\u001a\b\u0012\u0004\u0012\u00020'0&\u00a2\u0006\b\n\u0000\u001a\u0004\b(\u0010)R\u0011\u0010*\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b+\u0010,R\u0013\u0010-\u001a\u0004\u0018\u00010\u0017\u00a2\u0006\b\n\u0000\u001a\u0004\b.\u0010\u0019\u00a8\u00067"}, d2={"Lcom/teamwizardry/librarianlib/features/gui/provided/book/hierarchy/entry/Entry;", "Lcom/teamwizardry/librarianlib/features/gui/provided/book/hierarchy/IBookElement;", "bookParent", "Lcom/teamwizardry/librarianlib/features/gui/provided/book/hierarchy/book/Book;", "parentSheet", "", "parentOuter", "Ljava/awt/Color;", "parentBinding", "rl", "json", "Lcom/google/gson/JsonObject;", "(Lcom/teamwizardry/librarianlib/features/gui/provided/book/hierarchy/book/Book;Ljava/lang/String;Ljava/awt/Color;Ljava/awt/Color;Ljava/lang/String;Lcom/google/gson/JsonObject;)V", "bindingColor", "getBindingColor", "()Ljava/awt/Color;", "getBookParent", "()Lcom/teamwizardry/librarianlib/features/gui/provided/book/hierarchy/book/Book;", "criterion", "Lcom/teamwizardry/librarianlib/features/gui/provided/book/hierarchy/entry/criterion/ICriterion;", "getCriterion", "()Lcom/teamwizardry/librarianlib/features/gui/provided/book/hierarchy/entry/criterion/ICriterion;", "desc", "Lcom/teamwizardry/librarianlib/features/gui/provided/book/helper/TranslationHolder;", "getDesc", "()Lcom/teamwizardry/librarianlib/features/gui/provided/book/helper/TranslationHolder;", "icon", "Lcom/google/gson/JsonElement;", "getIcon", "()Lcom/google/gson/JsonElement;", "isValid", "", "()Z", "setValid", "(Z)V", "outerColor", "getOuterColor", "pages", "", "Lcom/teamwizardry/librarianlib/features/gui/provided/book/hierarchy/page/Page;", "getPages", "()Ljava/util/List;", "sheet", "getSheet", "()Ljava/lang/String;", "title", "getTitle", "createComponents", "Lcom/teamwizardry/librarianlib/features/gui/provided/book/context/PaginationContext;", "book", "Lcom/teamwizardry/librarianlib/features/gui/provided/book/IBookGui;", "isUnlocked", "player", "Lnet/minecraft/entity/player/EntityPlayer;", "Companion", "librarianlib-1.12.2"})
public final class Entry
implements IBookElement {
    @NotNull
    private final List<Page> pages;
    @Nullable
    private final TranslationHolder title;
    @Nullable
    private final TranslationHolder desc;
    @NotNull
    private final JsonElement icon;
    @Nullable
    private final ICriterion criterion;
    @NotNull
    private final String sheet;
    @NotNull
    private final Color outerColor;
    @NotNull
    private final Color bindingColor;
    private boolean isValid;
    @NotNull
    private final Book bookParent;
    @NotNull
    private static final Map<ResourceLocation, Entry> ENTRIES;
    public static final Companion Companion;

    @NotNull
    public final List<Page> getPages() {
        return this.pages;
    }

    @Nullable
    public final TranslationHolder getTitle() {
        return this.title;
    }

    @Nullable
    public final TranslationHolder getDesc() {
        return this.desc;
    }

    @NotNull
    public final JsonElement getIcon() {
        return this.icon;
    }

    @Nullable
    public final ICriterion getCriterion() {
        return this.criterion;
    }

    @NotNull
    public final String getSheet() {
        return this.sheet;
    }

    @NotNull
    public final Color getOuterColor() {
        return this.outerColor;
    }

    @NotNull
    public final Color getBindingColor() {
        return this.bindingColor;
    }

    public final boolean isValid() {
        return this.isValid;
    }

    public final void setValid(boolean bl) {
        this.isValid = bl;
    }

    public final boolean isUnlocked(@NotNull EntityPlayer player) {
        Intrinsics.checkParameterIsNotNull(player, "player");
        if (this.criterion == null) {
            return true;
        }
        EntryUnlockedEvent event = new EntryUnlockedEvent(player, this, false, 4, null);
        MinecraftForge.EVENT_BUS.post((Event)event);
        return this.criterion.isUnlocked(player, event.getResult());
    }

    /*
     * WARNING - void declaration
     */
    @Override
    @SideOnly(value=Side.CLIENT)
    @NotNull
    public List<PaginationContext> createComponents(@NotNull IBookGui book) {
        void x$iv;
        Intrinsics.checkParameterIsNotNull(book, "book");
        book.updateTextureData(this.sheet, this.outerColor, this.bindingColor);
        String title = String.valueOf(this.title);
        int xSize = book.getMainBookComponent().getSize().getXi() - 32;
        int ySize = book.getMainBookComponent().getSize().getYi() - 32;
        int n = xSize;
        int y$iv = ySize;
        Vec2d size2 = Vec2d.Companion.getPooled((double)x$iv, y$iv);
        List pageComponents = new ArrayList();
        for (Page page : this.pages) {
            for (Function0<GuiComponent> component : page.createBookComponents(book, size2)) {
                pageComponents.add(new PaginationContext((Function0<? extends GuiComponent>)new Function0<GuiComponent>(component, book, xSize, title){
                    final /* synthetic */ Function0 $component;
                    final /* synthetic */ IBookGui $book;
                    final /* synthetic */ int $xSize;
                    final /* synthetic */ String $title;

                    /*
                     * WARNING - void declaration
                     */
                    @NotNull
                    public final GuiComponent invoke() {
                        void var1_1;
                        GuiComponent holderComponent = (GuiComponent)this.$component.invoke();
                        ComponentSprite titleBar = new ComponentSprite(this.$book.getTitleBarSprite(), 16 + this.$xSize / 2 - this.$book.getTitleBarSprite().getWidth() / 2, -31, 0, 0, 24, null);
                        titleBar.getColor().setValue(this.$book.getBook().getBookColor());
                        holderComponent.add(titleBar);
                        ComponentText titleText = new ComponentText(titleBar.getSize().getXi() / 2 - 12, titleBar.getSize().getYi() / 2 + 1, ComponentText.TextAlignH.CENTER, ComponentText.TextAlignV.MIDDLE);
                        titleText.getText().setValue(this.$title);
                        titleText.getColor().setValue(this.$book.getBook().getEntryTitleTextColor());
                        titleBar.add(titleText);
                        return var1_1;
                    }
                    {
                        this.$component = function0;
                        this.$book = iBookGui;
                        this.$xSize = n;
                        this.$title = string;
                        super(0);
                    }
                }, page.getExtraBookmarks()));
            }
        }
        return pageComponents;
    }

    @Override
    @NotNull
    public Book getBookParent() {
        return this.bookParent;
    }

    public Entry(@NotNull Book bookParent, @NotNull String parentSheet, @NotNull Color parentOuter, @NotNull Color parentBinding, @NotNull String rl, @NotNull JsonObject json) {
        Object object;
        Intrinsics.checkParameterIsNotNull(bookParent, "bookParent");
        Intrinsics.checkParameterIsNotNull(parentSheet, "parentSheet");
        Intrinsics.checkParameterIsNotNull(parentOuter, "parentOuter");
        Intrinsics.checkParameterIsNotNull(parentBinding, "parentBinding");
        Intrinsics.checkParameterIsNotNull(rl, "rl");
        Intrinsics.checkParameterIsNotNull(json, "json");
        this.bookParent = bookParent;
        Map<ResourceLocation, Entry> map = ENTRIES;
        ResourceLocation resourceLocation = new ResourceLocation(rl);
        Object object2 = this;
        map.put(resourceLocation, (Entry)object2);
        List pages = new ArrayList();
        object2 = rl;
        Object object3 = "^.*/(?=\\w+)";
        Object object4 = new StringBuilder().append(this.getBookParent().getLocation().func_110624_b()).append(".").append(this.getBookParent().getLocation().func_110623_a()).append(".");
        object3 = object = new Regex((String)object3);
        String string = "";
        object = ((Regex)object3).replace((CharSequence)object2, string);
        String baseKey = ((StringBuilder)object4).append((String)object).toString();
        TranslationHolder title = new TranslationHolder(baseKey + ".title", null, 2, null);
        TranslationHolder desc = new TranslationHolder(baseKey + ".description", null, 2, null);
        JsonElement icon = (JsonElement)new JsonObject();
        ICriterion criterion = null;
        String sheet = parentSheet;
        Color outerColor = parentOuter;
        Color bindingColor = parentBinding;
        try {
            if (json.has("title")) {
                title = TranslationHolder.Companion.fromJson(json.get("title"));
            }
            if (json.has("description")) {
                desc = TranslationHolder.Companion.fromJson(json.get("description"));
            }
            JsonElement jsonElement = json.get("icon");
            Intrinsics.checkExpressionValueIsNotNull(jsonElement, "json.get(\"icon\")");
            icon = jsonElement;
            if (json.has("criteria")) {
                JsonElement jsonElement2 = json.get("criteria");
                Intrinsics.checkExpressionValueIsNotNull(jsonElement2, "json.get(\"criteria\")");
                criterion = ICriterion.Companion.fromJson(jsonElement2);
            }
            if (json.has("style")) {
                JsonObject obj = json.getAsJsonObject("style");
                if (obj.has("sheet")) {
                    JsonPrimitive jsonPrimitive = obj.getAsJsonPrimitive("sheet");
                    Intrinsics.checkExpressionValueIsNotNull(jsonPrimitive, "obj.getAsJsonPrimitive(\"sheet\")");
                    String string2 = jsonPrimitive.getAsString();
                    Intrinsics.checkExpressionValueIsNotNull(string2, "obj.getAsJsonPrimitive(\"sheet\").asString");
                    sheet = string2;
                }
                if (obj.has("color")) {
                    JsonElement jsonElement3 = obj.get("color");
                    Intrinsics.checkExpressionValueIsNotNull(jsonElement3, "obj.get(\"color\")");
                    outerColor = Book.Companion.colorFromJson(jsonElement3);
                }
                if (obj.has("binding")) {
                    JsonElement jsonElement4 = obj.get("binding");
                    Intrinsics.checkExpressionValueIsNotNull(jsonElement4, "obj.get(\"binding\")");
                    bindingColor = Book.Companion.colorFromJson(jsonElement4);
                }
            }
            this.isValid = true;
        }
        catch (Exception exception) {
            LibrarianLog.INSTANCE.error(exception, "Failed trying to parse an entry component", new Object[0]);
        }
        this.title = title;
        this.desc = desc;
        this.icon = icon;
        this.criterion = criterion;
        this.sheet = sheet;
        this.outerColor = outerColor;
        this.bindingColor = bindingColor;
        if (this.isValid) {
            try {
                boolean bl;
                Iterable $receiver$iv;
                JsonArray allPages;
                this.isValid = false;
                JsonArray jsonArray = allPages = json.getAsJsonArray("content");
                Intrinsics.checkExpressionValueIsNotNull(jsonArray, "allPages");
                Iterable $receiver$iv$iv = $receiver$iv = (Iterable)jsonArray;
                Iterator iterator2 = $receiver$iv$iv.iterator();
                while (iterator2.hasNext()) {
                    Page page;
                    JsonElement it;
                    Object element$iv$iv;
                    Object element$iv = element$iv$iv = iterator2.next();
                    JsonElement jsonElement = it = (JsonElement)element$iv;
                    Intrinsics.checkExpressionValueIsNotNull(jsonElement, "it");
                    if (Page.Companion.fromJson(this, jsonElement) == null) continue;
                    Page it$iv = page;
                    ((Collection)pages).add(it$iv);
                }
                Collection collection = pages;
                object4 = this;
                ((Entry)object4).isValid = bl = !collection.isEmpty();
            }
            catch (Exception exception) {
                LibrarianLog.INSTANCE.error(exception, "Failed trying to parse an entry component", new Object[0]);
            }
        }
        this.pages = pages;
    }

    static {
        Companion = new Companion(null);
        ENTRIES = new LinkedHashMap();
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    @NotNull
    public List<Bookmark> addAllBookmarks(@Nullable List<? extends Bookmark> list2) {
        return IBookElement.DefaultImpls.addAllBookmarks(this, list2);
    }

    @Metadata(mv={1, 1, 13}, bv={1, 0, 3}, k=1, d1={"\u0000\u001c\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010%\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u001d\u0010\u0003\u001a\u000e\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\u00060\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\b\u00a8\u0006\t"}, d2={"Lcom/teamwizardry/librarianlib/features/gui/provided/book/hierarchy/entry/Entry$Companion;", "", "()V", "ENTRIES", "", "Lnet/minecraft/util/ResourceLocation;", "Lcom/teamwizardry/librarianlib/features/gui/provided/book/hierarchy/entry/Entry;", "getENTRIES", "()Ljava/util/Map;", "librarianlib-1.12.2"})
    public static final class Companion {
        @NotNull
        public final Map<ResourceLocation, Entry> getENTRIES() {
            return ENTRIES;
        }

        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

