/*
 * Decompiled with CFR 0.152.
 */
package com.teamwizardry.librarianlib.features.facade.provided.book.search;

import com.teamwizardry.librarianlib.features.facade.provided.book.IBookGui;
import com.teamwizardry.librarianlib.features.facade.provided.book.hierarchy.IBookElement;
import com.teamwizardry.librarianlib.features.facade.provided.book.hierarchy.entry.Entry;
import com.teamwizardry.librarianlib.features.facade.provided.book.search.ISearchAlgorithm;
import com.teamwizardry.librarianlib.features.facade.provided.book.search.TFIDFSearch;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.ListIterator;
import java.util.Locale;
import java.util.Map;
import kotlin.Metadata;
import kotlin.TuplesKt;
import kotlin.TypeCastException;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.ranges.RangesKt;
import kotlin.sequences.SequencesKt;
import kotlin.text.MatchResult;
import kotlin.text.Regex;
import kotlin.text.StringsKt;
import net.minecraft.client.Minecraft;
import net.minecraft.client.entity.EntityPlayerSP;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import org.apache.commons.lang3.StringUtils;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@SideOnly(value=Side.CLIENT)
@Metadata(mv={1, 1, 13}, bv={1, 0, 3}, k=1, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0003\b\u0007\u0018\u00002\u00020\u0001:\u0002\n\u000bB\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0018\u0010\u0005\u001a\n\u0012\u0004\u0012\u00020\u0007\u0018\u00010\u00062\u0006\u0010\b\u001a\u00020\tH\u0016R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\f"}, d2={"Lcom/teamwizardry/librarianlib/features/facade/provided/book/search/TFIDFSearch;", "Lcom/teamwizardry/librarianlib/features/facade/provided/book/search/ISearchAlgorithm;", "book", "Lcom/teamwizardry/librarianlib/features/facade/provided/book/IBookGui;", "(Lcom/teamwizardry/librarianlib/features/facade/provided/book/IBookGui;)V", "search", "", "Lcom/teamwizardry/librarianlib/features/facade/provided/book/search/ISearchAlgorithm$Result;", "input", "", "FrequencySearchResult", "MatchCountSearchResult", "librarianlib-1.12.2"})
public final class TFIDFSearch
implements ISearchAlgorithm {
    private final IBookGui book;

    /*
     * WARNING - void declaration
     */
    @Override
    @Nullable
    public List<ISearchAlgorithm.Result> search(@NotNull String input) {
        Object object;
        Object object2;
        Object it22;
        List list2;
        Collection $receiver$iv;
        Intrinsics.checkParameterIsNotNull(input, "input");
        EntityPlayerSP player = Minecraft.func_71410_x().field_71439_g;
        String string = StringsKt.replace$default(input, "'", "", false, 4, null);
        Locale locale = Locale.ROOT;
        Intrinsics.checkExpressionValueIsNotNull(locale, "Locale.ROOT");
        List<String> list3 = locale;
        String string2 = string;
        if (string2 == null) {
            throw new TypeCastException("null cannot be cast to non-null type java.lang.String");
        }
        String string3 = string2.toLowerCase((Locale)((Object)list3));
        Intrinsics.checkExpressionValueIsNotNull(string3, "(this as java.lang.String).toLowerCase(locale)");
        String query = string3;
        list3 = query;
        Object object3 = " ";
        object3 = new Regex((String)object3);
        int n = 0;
        list3 = ((Regex)object3).split((CharSequence)((Object)list3), n);
        if (!$receiver$iv.isEmpty()) {
            ListIterator iterator$iv = $receiver$iv.listIterator($receiver$iv.size());
            while (iterator$iv.hasPrevious()) {
                String it = (String)iterator$iv.previous();
                CharSequence charSequence = it;
                if (charSequence.length() == 0) continue;
                list2 = CollectionsKt.take($receiver$iv, iterator$iv.nextIndex() + 1);
                break;
            }
        } else {
            list2 = CollectionsKt.emptyList();
        }
        $receiver$iv = list2;
        Collection collection = $receiver$iv;
        if (collection == null) {
            throw new TypeCastException("null cannot be cast to non-null type java.util.Collection<T>");
        }
        Collection thisCollection$iv = collection;
        String[] stringArray = thisCollection$iv.toArray(new String[0]);
        if (stringArray == null) {
            throw new TypeCastException("null cannot be cast to non-null type kotlin.Array<T>");
        }
        String[] keywords = stringArray;
        ArrayList<FrequencySearchResult> unfilteredTfidfResults = new ArrayList<FrequencySearchResult>();
        ArrayList<MatchCountSearchResult> matchCountSearchResults = new ArrayList<MatchCountSearchResult>();
        Map<Entry, String> contentCache = this.book.getCachedSearchContent();
        int nbOfDocuments = contentCache.size();
        for (Entry cachedEntry : contentCache.keySet()) {
            Map.Entry mostRepeatedWord;
            Map map;
            Serializable serializable;
            Object object4;
            Iterator $receiver$iv$iv;
            Map $receiver$iv2;
            List list4;
            CharSequence charSequence;
            Object iterator$iv;
            void $receiver$iv3;
            EntityPlayerSP entityPlayerSP = player;
            Intrinsics.checkExpressionValueIsNotNull(entityPlayerSP, "player");
            if (!cachedEntry.isUnlocked((EntityPlayer)entityPlayerSP)) continue;
            String string4 = contentCache.getOrDefault(cachedEntry, "");
            Locale locale2 = Locale.ROOT;
            Intrinsics.checkExpressionValueIsNotNull(locale2, "Locale.ROOT");
            List<String> list5 = locale2;
            String string5 = string4;
            if (string5 == null) {
                throw new TypeCastException("null cannot be cast to non-null type java.lang.String");
            }
            String string6 = string5.toLowerCase((Locale)((Object)list5));
            Intrinsics.checkExpressionValueIsNotNull(string6, "(this as java.lang.String).toLowerCase(locale)");
            String cachedDocument = StringsKt.replace$default(string6, "'", "", false, 4, null);
            list5 = cachedDocument;
            Object object5 = "\\s+";
            object5 = new Regex((String)object5);
            int n2 = 0;
            list5 = ((Regex)object5).split((CharSequence)((Object)list5), n2);
            if (!$receiver$iv3.isEmpty()) {
                iterator$iv = $receiver$iv3.listIterator($receiver$iv3.size());
                while (iterator$iv.hasPrevious()) {
                    String it = (String)iterator$iv.previous();
                    charSequence = it;
                    if (charSequence.length() == 0) continue;
                    list4 = CollectionsKt.take((Iterable)$receiver$iv3, iterator$iv.nextIndex() + 1);
                    break;
                }
            } else {
                list4 = CollectionsKt.emptyList();
            }
            List words = list4;
            iterator$iv = CollectionsKt.toSet(words);
            int capacity$iv = RangesKt.coerceAtLeast(MapsKt.mapCapacity(CollectionsKt.collectionSizeOrDefault($receiver$iv2, 10)), 16);
            charSequence = $receiver$iv2;
            Map destination$iv$iv = new LinkedHashMap(capacity$iv);
            Iterator $i$f$dropLastWhile = $receiver$iv$iv.iterator();
            while ($i$f$dropLastWhile.hasNext()) {
                int n3;
                void $receiver$iv4;
                Object element$iv$iv = $i$f$dropLastWhile.next();
                Map map2 = destination$iv$iv;
                String it = (String)element$iv$iv;
                Iterable iterable = words;
                object4 = it;
                if ($receiver$iv4 instanceof Collection && ((Collection)$receiver$iv4).isEmpty()) {
                    n3 = 0;
                } else {
                    int count$iv = 0;
                    for (Object element$iv : $receiver$iv4) {
                        String word = (String)element$iv;
                        if (!Intrinsics.areEqual(word, it) || (word = ++count$iv) >= 0) continue;
                        CollectionsKt.throwCountOverflow();
                    }
                    n3 = count$iv;
                }
                int n4 = n3;
                serializable = TuplesKt.to(object4, n4);
                map2.put(serializable.getFirst(), serializable.getSecond());
            }
            $receiver$iv2 = destination$iv$iv;
            Iterable iterable = $receiver$iv2.entrySet();
            $receiver$iv$iv = iterable.iterator();
            if (!$receiver$iv$iv.hasNext()) {
                map = null;
            } else {
                destination$iv$iv = $receiver$iv$iv.next();
                it22 = (Map.Entry)((Object)destination$iv$iv);
                int it22 = ((Number)it22.getValue()).intValue();
                while ($receiver$iv$iv.hasNext()) {
                    Object $i$a$2$maxBy = $receiver$iv$iv.next();
                    Map.Entry it32 = (Map.Entry)$i$a$2$maxBy;
                    int it32 = ((Number)it32.getValue()).intValue();
                    if (it22 >= it32) continue;
                    destination$iv$iv = $i$a$2$maxBy;
                    it22 = it32;
                }
                map = destination$iv$iv;
            }
            if ((mostRepeatedWord = (Map.Entry)((Object)map)) == null) continue;
            double documentTfidf = 0.0;
            for (String keyword : keywords) {
                int n5;
                Entry it;
                Iterable $receiver$iv$iv2;
                Iterable $receiver$iv5;
                CharSequence $i$a$2$maxBy = keyword;
                Object $receiver$iv4 = "[\\\\.+*?^$\\[\\](){}/'#:!=|]";
                object2 = new StringBuilder().append("\\b");
                $receiver$iv4 = object = new Regex((String)$receiver$iv4);
                object4 = search.pattern.1.INSTANCE;
                object = ((Regex)$receiver$iv4).replace($i$a$2$maxBy, (Function1<? super MatchResult, ? extends CharSequence>)object4);
                String pattern2 = ((StringBuilder)object2).append((String)object).toString();
                $receiver$iv4 = pattern2;
                int keywordOccurance = SequencesKt.count(Regex.findAll$default(new Regex((String)$receiver$iv4), cachedDocument, 0, 2, null)) - 1;
                double termFrequency = 0.5 + 0.5 * (double)keywordOccurance / ((Number)mostRepeatedWord.getValue()).doubleValue();
                Iterable iterable2 = contentCache.keySet();
                void element$iv = $receiver$iv5;
                Object destination$iv$iv2 = new ArrayList();
                for (Object element$iv$iv : $receiver$iv$iv2) {
                    it = (Entry)element$iv$iv;
                    if (!it.isUnlocked((EntityPlayer)player)) continue;
                    destination$iv$iv2.add(element$iv$iv);
                }
                $receiver$iv5 = (List)destination$iv$iv2;
                $receiver$iv$iv2 = $receiver$iv5;
                destination$iv$iv2 = new ArrayList(CollectionsKt.collectionSizeOrDefault($receiver$iv5, 10));
                for (Object item$iv$iv : $receiver$iv$iv2) {
                    it = (Entry)item$iv$iv;
                    object2 = destination$iv$iv2;
                    String $i$a$1$filter = contentCache.getOrDefault(it, "");
                    Intrinsics.checkExpressionValueIsNotNull(Locale.ROOT, "Locale.ROOT");
                    String string7 = $i$a$1$filter;
                    if (string7 == null) {
                        throw new TypeCastException("null cannot be cast to non-null type java.lang.String");
                    }
                    Intrinsics.checkExpressionValueIsNotNull(string7.toLowerCase((Locale)serializable), "(this as java.lang.String).toLowerCase(locale)");
                    object2.add(object);
                }
                $receiver$iv5 = (List)destination$iv$iv2;
                if ($receiver$iv5 instanceof Collection && ((Collection)$receiver$iv5).isEmpty()) {
                    n5 = 0;
                } else {
                    int count$iv = 0;
                    for (Object element$iv2 : $receiver$iv5) {
                        int n6;
                        String it3 = (String)element$iv2;
                        if (!StringsKt.contains$default((CharSequence)it3, keyword, false, 2, null) || (n6 = ++count$iv) >= 0) continue;
                        CollectionsKt.throwCountOverflow();
                    }
                    n5 = count$iv;
                }
                int keywordDocumentOccurance = n5;
                keywordDocumentOccurance = keywordDocumentOccurance == 0 ? keywordDocumentOccurance + 1 : keywordDocumentOccurance;
                double inverseDocumentFrequency = Math.log(nbOfDocuments / keywordDocumentOccurance);
                double keywordTfidf = termFrequency * inverseDocumentFrequency;
                documentTfidf += keywordTfidf;
            }
            unfilteredTfidfResults.add(new FrequencySearchResult(cachedEntry, documentTfidf));
        }
        ArrayList<FrequencySearchResult> filteredTfidfResults = new ArrayList<FrequencySearchResult>();
        double largestTFIDF = 0.0;
        double smallestTFIDF = Integer.MAX_VALUE;
        for (FrequencySearchResult resultItem2 : unfilteredTfidfResults) {
            largestTFIDF = resultItem2.getFrequency() > largestTFIDF ? resultItem2.getFrequency() : largestTFIDF;
            smallestTFIDF = resultItem2.getFrequency() < smallestTFIDF ? resultItem2.getFrequency() : smallestTFIDF;
        }
        for (FrequencySearchResult resultItem : unfilteredTfidfResults) {
            double matchPercentage = Math.round((resultItem.getFrequency() - smallestTFIDF) / (largestTFIDF - smallestTFIDF) * (double)100);
            if (matchPercentage < (double)5 || Double.isNaN(matchPercentage)) continue;
            filteredTfidfResults.add(resultItem);
        }
        if (!filteredTfidfResults.isEmpty()) {
            return filteredTfidfResults;
        }
        for (Entry cachedComponent : contentCache.keySet()) {
            void $receiver$iv$iv;
            void $receiver$iv6;
            EntityPlayerSP entityPlayerSP = player;
            Intrinsics.checkExpressionValueIsNotNull(entityPlayerSP, "player");
            if (!cachedComponent.isUnlocked((EntityPlayer)entityPlayerSP)) continue;
            String destination$iv$iv = contentCache.getOrDefault(cachedComponent, "");
            Intrinsics.checkExpressionValueIsNotNull(Locale.ROOT, "Locale.ROOT");
            it22 = Locale.ROOT;
            String string8 = destination$iv$iv;
            if (string8 == null) {
                throw new TypeCastException("null cannot be cast to non-null type java.lang.String");
            }
            String string9 = string8.toLowerCase((Locale)it22);
            Intrinsics.checkExpressionValueIsNotNull(string9, "(this as java.lang.String).toLowerCase(locale)");
            String cachedDocument = StringsKt.replace$default(string9, "'", "", false, 4, null);
            it22 = keywords;
            void $i$a$2$maxBy = $receiver$iv6;
            Collection destination$iv$iv3 = new ArrayList(((void)$receiver$iv6).length);
            void var21_49 = $receiver$iv$iv;
            int n7 = ((void)var21_49).length;
            for (int i = 0; i < n7; ++i) {
                void it;
                void item$iv$iv;
                void inverseDocumentFrequency = item$iv$iv = var21_49[i];
                object2 = destination$iv$iv3;
                object = StringUtils.countMatches((CharSequence)cachedDocument, (CharSequence)((CharSequence)it));
                object2.add(object);
            }
            int mostMatches = CollectionsKt.sumOfInt((List)destination$iv$iv3);
            if (mostMatches <= 0) continue;
            matchCountSearchResults.add(new MatchCountSearchResult(cachedComponent, mostMatches));
        }
        return !matchCountSearchResults.isEmpty() ? (List)matchCountSearchResults : null;
    }

    public TFIDFSearch(@NotNull IBookGui book) {
        Intrinsics.checkParameterIsNotNull(book, "book");
        this.book = book;
    }

    @Override
    @NotNull
    public Function1<String, Unit> textBoxConsumer(@NotNull IBookGui book, @NotNull Function1<? super List<? extends ISearchAlgorithm.Result>, ? extends IBookElement> newComponent) {
        Intrinsics.checkParameterIsNotNull(book, "book");
        Intrinsics.checkParameterIsNotNull(newComponent, "newComponent");
        return ISearchAlgorithm.DefaultImpls.textBoxConsumer(this, book, newComponent);
    }

    @Metadata(mv={1, 1, 13}, bv={1, 0, 3}, k=1, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0006\n\u0002\b\u0006\n\u0002\u0010\u000b\n\u0002\b\u0002\u0018\u00002\u00020\u0001B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006R\u0014\u0010\u0002\u001a\u00020\u0003X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR\u0014\u0010\u0004\u001a\u00020\u0005X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\nR\u0014\u0010\u000b\u001a\u00020\f8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u000b\u0010\r\u00a8\u0006\u000e"}, d2={"Lcom/teamwizardry/librarianlib/features/facade/provided/book/search/TFIDFSearch$FrequencySearchResult;", "Lcom/teamwizardry/librarianlib/features/facade/provided/book/search/ISearchAlgorithm$Result;", "entry", "Lcom/teamwizardry/librarianlib/features/facade/provided/book/hierarchy/entry/Entry;", "frequency", "", "(Lcom/teamwizardry/librarianlib/features/facade/provided/book/hierarchy/entry/Entry;D)V", "getEntry", "()Lcom/teamwizardry/librarianlib/features/facade/provided/book/hierarchy/entry/Entry;", "getFrequency", "()D", "isSpecificResult", "", "()Z", "librarianlib-1.12.2"})
    public static final class FrequencySearchResult
    implements ISearchAlgorithm.Result {
        @NotNull
        private final Entry entry;
        private final double frequency;

        @Override
        public boolean isSpecificResult() {
            return true;
        }

        @Override
        @NotNull
        public Entry getEntry() {
            return this.entry;
        }

        @Override
        public double getFrequency() {
            return this.frequency;
        }

        public FrequencySearchResult(@NotNull Entry entry, double frequency) {
            Intrinsics.checkParameterIsNotNull(entry, "entry");
            this.entry = entry;
            this.frequency = frequency;
        }

        @Override
        public int compareTo(@NotNull ISearchAlgorithm.Result other) {
            Intrinsics.checkParameterIsNotNull(other, "other");
            return ISearchAlgorithm.Result.DefaultImpls.compareTo(this, other);
        }
    }

    @Metadata(mv={1, 1, 13}, bv={1, 0, 3}, k=1, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0004\n\u0002\u0010\u0006\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0002\u0018\u00002\u00020\u0001B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006R\u0014\u0010\u0002\u001a\u00020\u0003X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR\u0014\u0010\t\u001a\u00020\n8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u000b\u0010\fR\u0014\u0010\r\u001a\u00020\u000e8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\r\u0010\u000fR\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0010"}, d2={"Lcom/teamwizardry/librarianlib/features/facade/provided/book/search/TFIDFSearch$MatchCountSearchResult;", "Lcom/teamwizardry/librarianlib/features/facade/provided/book/search/ISearchAlgorithm$Result;", "entry", "Lcom/teamwizardry/librarianlib/features/facade/provided/book/hierarchy/entry/Entry;", "nbOfMatches", "", "(Lcom/teamwizardry/librarianlib/features/facade/provided/book/hierarchy/entry/Entry;I)V", "getEntry", "()Lcom/teamwizardry/librarianlib/features/facade/provided/book/hierarchy/entry/Entry;", "frequency", "", "getFrequency", "()D", "isSpecificResult", "", "()Z", "librarianlib-1.12.2"})
    public static final class MatchCountSearchResult
    implements ISearchAlgorithm.Result {
        @NotNull
        private final Entry entry;
        private final int nbOfMatches;

        @Override
        public boolean isSpecificResult() {
            return false;
        }

        @Override
        public double getFrequency() {
            return this.nbOfMatches;
        }

        @Override
        @NotNull
        public Entry getEntry() {
            return this.entry;
        }

        public MatchCountSearchResult(@NotNull Entry entry, int nbOfMatches) {
            Intrinsics.checkParameterIsNotNull(entry, "entry");
            this.entry = entry;
            this.nbOfMatches = nbOfMatches;
        }

        @Override
        public int compareTo(@NotNull ISearchAlgorithm.Result other) {
            Intrinsics.checkParameterIsNotNull(other, "other");
            return ISearchAlgorithm.Result.DefaultImpls.compareTo(this, other);
        }
    }
}

