/*
 * Decompiled with CFR 0.152.
 */
package goblinbob.mobends.core.math.matrix;

import goblinbob.mobends.core.math.matrix.IMat4x4d;
import goblinbob.mobends.core.math.matrix.IMatd;
import goblinbob.mobends.core.math.matrix.Mat4x4d;
import goblinbob.mobends.core.math.vector.Vec4d;
import java.nio.FloatBuffer;

public class MatrixUtils {
    public static FloatBuffer matToGlMatrix(IMat4x4d matIn, FloatBuffer destBuffer) {
        double[] fields;
        destBuffer.clear();
        for (double f : fields = matIn.getFields()) {
            destBuffer.put((float)f);
        }
        destBuffer.rewind();
        return destBuffer;
    }

    public static void identity(IMat4x4d dest) {
        dest.setFields(1.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 1.0);
    }

    public static void inverse(IMat4x4d src, IMat4x4d dest) {
        double[] f = src.getFields();
        double Coef00 = f[10] * f[15] - f[14] * f[11];
        double Coef02 = f[6] * f[15] - f[14] * f[7];
        double Coef03 = f[6] * f[11] - f[10] * f[7];
        double Coef04 = f[9] * f[15] - f[13] * f[11];
        double Coef06 = f[5] * f[15] - f[13] * f[7];
        double Coef07 = f[5] * f[11] - f[9] * f[7];
        double Coef08 = f[9] * f[14] - f[13] * f[10];
        double Coef10 = f[5] * f[14] - f[13] * f[6];
        double Coef11 = f[5] * f[10] - f[9] * f[6];
        double Coef12 = f[8] * f[15] - f[12] * f[11];
        double Coef14 = f[4] * f[15] - f[12] * f[7];
        double Coef15 = f[4] * f[11] - f[8] * f[7];
        double Coef16 = f[8] * f[14] - f[12] * f[10];
        double Coef18 = f[4] * f[14] - f[12] * f[6];
        double Coef19 = f[4] * f[10] - f[8] * f[6];
        double Coef20 = f[8] * f[13] - f[12] * f[9];
        double Coef22 = f[4] * f[13] - f[12] * f[5];
        double Coef23 = f[4] * f[9] - f[8] * f[5];
        Vec4d Fac0 = new Vec4d(Coef00, Coef00, Coef02, Coef03);
        Vec4d Fac1 = new Vec4d(Coef04, Coef04, Coef06, Coef07);
        Vec4d Fac2 = new Vec4d(Coef08, Coef08, Coef10, Coef11);
        Vec4d Fac3 = new Vec4d(Coef12, Coef12, Coef14, Coef15);
        Vec4d Fac4 = new Vec4d(Coef16, Coef16, Coef18, Coef19);
        Vec4d Fac5 = new Vec4d(Coef20, Coef20, Coef22, Coef23);
        Vec4d Vec0 = new Vec4d(f[4], f[0], f[0], f[0]);
        Vec4d Vec1 = new Vec4d(f[5], f[1], f[1], f[1]);
        Vec4d Vec2 = new Vec4d(f[6], f[2], f[2], f[2]);
        Vec4d Vec3 = new Vec4d(f[7], f[3], f[3], f[3]);
        Vec4d Inv0 = new Vec4d(Vec1.x * Fac0.x - Vec2.x * Fac1.x + Vec3.x * Fac2.x, Vec1.y * Fac0.y - Vec2.y * Fac1.y + Vec3.y * Fac2.y, Vec1.z * Fac0.z - Vec2.z * Fac1.z + Vec3.z * Fac2.z, Vec1.w * Fac0.w - Vec2.w * Fac1.w + Vec3.w * Fac2.w);
        Vec4d Inv1 = new Vec4d(Vec0.x * Fac0.x - Vec2.x * Fac3.x + Vec3.x * Fac4.x, Vec0.y * Fac0.y - Vec2.y * Fac3.y + Vec3.y * Fac4.y, Vec0.z * Fac0.z - Vec2.z * Fac3.z + Vec3.z * Fac4.z, Vec0.w * Fac0.w - Vec2.w * Fac3.w + Vec3.w * Fac4.w);
        Vec4d Inv2 = new Vec4d(Vec0.x * Fac1.x - Vec1.x * Fac3.x + Vec3.x * Fac5.x, Vec0.y * Fac1.y - Vec1.y * Fac3.y + Vec3.y * Fac5.y, Vec0.z * Fac1.z - Vec1.z * Fac3.z + Vec3.z * Fac5.z, Vec0.w * Fac1.w - Vec1.w * Fac3.w + Vec3.w * Fac5.w);
        Vec4d Inv3 = new Vec4d(Vec0.x * Fac2.x - Vec1.x * Fac4.x + Vec2.x * Fac5.x, Vec0.y * Fac2.y - Vec1.y * Fac4.y + Vec2.y * Fac5.y, Vec0.z * Fac2.z - Vec1.z * Fac4.z + Vec2.z * Fac5.z, Vec0.w * Fac2.w - Vec1.w * Fac4.w + Vec2.w * Fac5.w);
        Vec4d SignA = new Vec4d(1.0, -1.0, 1.0, -1.0);
        Vec4d SignB = new Vec4d(-1.0, 1.0, -1.0, 1.0);
        double[] inverseFields = new double[]{Inv0.x * SignA.x, Inv0.y * SignA.y, Inv0.z * SignA.z, Inv0.w * SignA.w, Inv1.x * SignB.x, Inv1.y * SignB.y, Inv1.z * SignB.z, Inv1.w * SignB.w, Inv2.x * SignA.x, Inv2.y * SignA.y, Inv2.z * SignA.z, Inv2.w * SignA.w, Inv3.x * SignB.x, Inv3.y * SignB.y, Inv3.z * SignB.z, Inv3.w * SignB.w};
        Mat4x4d Inverse = new Mat4x4d(inverseFields);
        Vec4d Dot0 = new Vec4d(f[0] * inverseFields[0], f[1] * inverseFields[4], f[2] * inverseFields[8], f[3] * inverseFields[12]);
        double Dot1 = Dot0.x + Dot0.y + (Dot0.z + Dot0.w);
        double OneOverDeterminant = 1.0 / Dot1;
        dest.copyFrom(Inverse);
        dest.scale(OneOverDeterminant);
    }

    public static void multiply(IMatd a, IMatd b, IMatd dest) {
        int aCols = a.getCols();
        int bCols = b.getCols();
        int aRows = a.getRows();
        int bRows = b.getRows();
        double[] aFields = a.getFields();
        double[] bFields = b.getFields();
        if (aCols != bRows) {
            return;
        }
        double[] newFields = new double[bCols * aRows];
        for (int i = 0; i < bCols; ++i) {
            for (int j = 0; j < aRows; ++j) {
                double dot = 0.0;
                newFields[i * aRows + j] = 0.0;
                for (int k = 0; k < aCols; ++k) {
                    int n = i * aRows + j;
                    newFields[n] = newFields[n] + aFields[k * aRows + j] * bFields[i * bRows + k];
                }
            }
        }
        dest.setFields(newFields);
    }

    public static String toString(IMatd a) {
        double[] fields = a.getFields();
        int cols = a.getCols();
        int rows = a.getRows();
        StringBuilder builder = new StringBuilder();
        int maxRowLength = 0;
        for (int r = 0; r < rows; ++r) {
            int rowLength = 4;
            builder.append("[ ");
            for (int c = 0; c < cols; ++c) {
                double cell = fields[c * rows + r];
                String cellString = String.valueOf(cell);
                builder.append(cellString);
                rowLength += cellString.length();
                if (c >= cols - 1) continue;
                builder.append(", ");
                rowLength += 2;
            }
            builder.append(" ]\n");
            if (rowLength <= maxRowLength) continue;
            maxRowLength = rowLength;
        }
        builder.insert(0, '\n');
        for (int i = 0; i < maxRowLength; ++i) {
            builder.insert(0, '-');
            builder.append('-');
        }
        return builder.toString();
    }
}

