/*
 * Decompiled with CFR 0.152.
 */
package dynamictreesbop.cells;

import com.ferreusveritas.dynamictrees.api.TreeRegistry;
import com.ferreusveritas.dynamictrees.api.cells.CellNull;
import com.ferreusveritas.dynamictrees.api.cells.ICell;
import com.ferreusveritas.dynamictrees.api.cells.ICellKit;
import com.ferreusveritas.dynamictrees.api.cells.ICellSolver;
import com.ferreusveritas.dynamictrees.cells.CellKits;
import com.ferreusveritas.dynamictrees.cells.CellNormal;
import com.ferreusveritas.dynamictrees.util.SimpleVoxmap;
import dynamictreesbop.cells.CellEucalyptusLeaf;
import dynamictreesbop.cells.CellEucalyptusTopBranch;
import dynamictreesbop.cells.CellMahoganyBranch;
import dynamictreesbop.cells.CellMahoganyLeaf;
import dynamictreesbop.cells.CellPoplarBranch;
import dynamictreesbop.cells.CellPoplarLeaf;
import dynamictreesbop.cells.CellPoplarTopBranch;
import dynamictreesbop.cells.CellSparseBranch;
import dynamictreesbop.cells.DTBOPLeafClusters;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.ResourceLocation;

public class CellKits {
    private final ICellKit sparse = new ICellKit(){
        private final ICell sparseBranch = new CellSparseBranch();
        private final ICell sparseLeaves = new CellNormal(1);
        private final ICellSolver solver = new CellKits.BasicSolver(new short[]{529});

        public ICell getCellForLeaves(int hydro) {
            return hydro > 0 ? this.sparseLeaves : CellNull.NULLCELL;
        }

        public ICell getCellForBranch(int radius, int meta) {
            return radius == 1 ? this.sparseBranch : CellNull.NULLCELL;
        }

        public SimpleVoxmap getLeafCluster() {
            return DTBOPLeafClusters.sparse;
        }

        public ICellSolver getCellSolver() {
            return this.solver;
        }

        public int getDefaultHydration() {
            return 1;
        }
    };
    private final ICellKit poplar = new ICellKit(){
        private final ICell poplarBranch = new CellPoplarBranch();
        private final ICell poplarTopBranch = new CellPoplarTopBranch();
        private final ICell poplarUpperTrunk = new CellNormal(4);
        private final ICell[] poplarLeaves = new ICell[]{CellNull.NULLCELL, new CellPoplarLeaf(1), new CellPoplarLeaf(2), new CellPoplarLeaf(3), new CellPoplarLeaf(4)};
        private final ICellSolver solver = new CellKits.BasicSolver(new short[]{1042, 785, 529});

        public ICell getCellForLeaves(int hydro) {
            return this.poplarLeaves[hydro];
        }

        public ICell getCellForBranch(int radius, int meta) {
            if (meta == 1) {
                return this.poplarTopBranch;
            }
            if (radius == 1) {
                return this.poplarBranch;
            }
            if (radius < 4) {
                return this.poplarUpperTrunk;
            }
            return CellNull.NULLCELL;
        }

        public SimpleVoxmap getLeafCluster() {
            return DTBOPLeafClusters.poplar;
        }

        public ICellSolver getCellSolver() {
            return this.solver;
        }

        public int getDefaultHydration() {
            return 4;
        }
    };
    private final ICellKit mahogany = new ICellKit(){
        private final ICell mahoganyBranch = new CellMahoganyBranch();
        private final ICell[] mahoganyLeafCells = new ICell[]{CellNull.NULLCELL, new CellMahoganyLeaf(1), new CellMahoganyLeaf(2), new CellMahoganyLeaf(3), new CellMahoganyLeaf(4)};
        private final ICellSolver solver = new CellKits.BasicSolver(new short[]{1299, 1043, 802, 785, 529});

        public ICell getCellForLeaves(int hydro) {
            return this.mahoganyLeafCells[hydro];
        }

        public ICell getCellForBranch(int radius, int meta) {
            if (radius == 1) {
                return this.mahoganyBranch;
            }
            return CellNull.NULLCELL;
        }

        public SimpleVoxmap getLeafCluster() {
            return DTBOPLeafClusters.mahogany;
        }

        public ICellSolver getCellSolver() {
            return this.solver;
        }

        public int getDefaultHydration() {
            return 3;
        }
    };
    private final ICellKit brush = new ICellKit(){
        private final ICell branch = new ICell(){
            final int[] map = new int[]{3, 3, 5, 5, 5, 5};

            public int getValue() {
                return 5;
            }

            public int getValueFromSide(EnumFacing side) {
                return this.map[side.ordinal()];
            }
        };
        private final ICell[] normalCells = new ICell[]{CellNull.NULLCELL, new CellNormal(1), new CellNormal(2), new CellNormal(3), new CellNormal(4)};
        private final ICellSolver solver = new CellKits.BasicSolver(new short[]{1299, 1042, 802, 785, 529});

        public ICell getCellForLeaves(int hydro) {
            return this.normalCells[hydro];
        }

        public ICell getCellForBranch(int radius, int meta) {
            if (radius == 1) {
                return this.branch;
            }
            return CellNull.NULLCELL;
        }

        public SimpleVoxmap getLeafCluster() {
            return DTBOPLeafClusters.brush;
        }

        public ICellSolver getCellSolver() {
            return this.solver;
        }

        public int getDefaultHydration() {
            return 3;
        }
    };
    private final ICellKit eucalyptus = new ICellKit(){
        private final ICell eucalyptusTopBranch = new CellEucalyptusTopBranch();
        private final ICell eucalyptusBranch = new CellNormal(2);
        private final ICell eucalyptusUpperTrunk = new CellNormal(3);
        private final ICell[] eucalyptusLeaves = new ICell[]{CellNull.NULLCELL, new CellEucalyptusLeaf(1), new CellEucalyptusLeaf(2), new CellEucalyptusLeaf(3), new CellEucalyptusLeaf(4)};
        private final ICellSolver solver = new CellKits.BasicSolver(new short[]{1300, 1059, 1041, 786, 529});

        public ICell getCellForLeaves(int hydro) {
            return this.eucalyptusLeaves[hydro];
        }

        public ICell getCellForBranch(int radius, int meta) {
            if (meta == 1) {
                return this.eucalyptusTopBranch;
            }
            if (radius == 1) {
                return this.eucalyptusBranch;
            }
            if (radius <= 3) {
                return this.eucalyptusUpperTrunk;
            }
            return CellNull.NULLCELL;
        }

        public SimpleVoxmap getLeafCluster() {
            return DTBOPLeafClusters.eucalyptus;
        }

        public ICellSolver getCellSolver() {
            return this.solver;
        }

        public int getDefaultHydration() {
            return 4;
        }
    };
    private final ICellKit bamboo = new ICellKit(){
        private final ICell bambooTopBranch = new CellEucalyptusTopBranch();
        private final ICell bambooUpperTrunk = new CellNormal(2);
        private final ICell[] bambooLeaves = new ICell[]{CellNull.NULLCELL, new CellEucalyptusLeaf(1), new CellEucalyptusLeaf(2), new CellEucalyptusLeaf(3), new CellEucalyptusLeaf(4)};
        private final ICellSolver solver = new CellKits.BasicSolver(new short[]{1300, 1059, 1041, 786, 529});

        public ICell getCellForLeaves(int hydro) {
            return this.bambooLeaves[hydro];
        }

        public ICell getCellForBranch(int radius, int meta) {
            if (meta == 1) {
                return this.bambooTopBranch;
            }
            if (radius == 2) {
                return this.bambooUpperTrunk;
            }
            return CellNull.NULLCELL;
        }

        public SimpleVoxmap getLeafCluster() {
            return DTBOPLeafClusters.eucalyptus;
        }

        public ICellSolver getCellSolver() {
            return this.solver;
        }

        public int getDefaultHydration() {
            return 4;
        }
    };

    public static void init() {
        new CellKits();
    }

    public CellKits() {
        TreeRegistry.registerCellKit((ResourceLocation)new ResourceLocation("dynamictreesbop", "sparse"), (ICellKit)this.sparse);
        TreeRegistry.registerCellKit((ResourceLocation)new ResourceLocation("dynamictreesbop", "poplar"), (ICellKit)this.poplar);
        TreeRegistry.registerCellKit((ResourceLocation)new ResourceLocation("dynamictreesbop", "mahogany"), (ICellKit)this.mahogany);
        TreeRegistry.registerCellKit((ResourceLocation)new ResourceLocation("dynamictreesbop", "brush"), (ICellKit)this.brush);
        TreeRegistry.registerCellKit((ResourceLocation)new ResourceLocation("dynamictreesbop", "eucalyptus"), (ICellKit)this.eucalyptus);
        TreeRegistry.registerCellKit((ResourceLocation)new ResourceLocation("dynamictreesbop", "bamboo"), (ICellKit)this.bamboo);
    }
}

