/*
 * Decompiled with CFR 0.152.
 */
package com.fantasticsource.tools.datastructures;

import com.fantasticsource.tools.Tools;
import java.util.HashMap;
import java.util.Map;

public class DecimalWeightedPool<T> {
    public HashMap<T, Double> pool = new HashMap();
    public double totalWeight = 0.0;

    public void addWeight(T object, double weight) {
        double old = this.pool.getOrDefault(object, 0.0);
        if ((weight += old) <= 0.0) {
            this.totalWeight -= this.pool.remove(object).doubleValue();
        } else {
            this.pool.put(object, weight);
            this.totalWeight += weight - old;
        }
    }

    public void setWeight(T object, double weight) {
        if (weight < 0.0) {
            weight = 0.0;
        }
        this.totalWeight -= this.pool.getOrDefault(object, 0.0).doubleValue();
        if (weight == 0.0) {
            this.pool.remove(object);
        } else {
            this.pool.put(object, weight);
        }
        this.totalWeight += weight;
    }

    public double getWeight(T object) {
        return this.pool.getOrDefault(object, 0.0);
    }

    public double getChance(T object) {
        if (this.totalWeight == 0.0) {
            return 0.0;
        }
        return this.pool.getOrDefault(object, 0.0) / this.totalWeight;
    }

    public T getRandom() {
        if (this.totalWeight == 0.0) {
            return null;
        }
        double index = Tools.random(this.totalWeight);
        for (Map.Entry<T, Double> entry : this.pool.entrySet()) {
            if (index < entry.getValue()) {
                return entry.getKey();
            }
            index -= entry.getValue().doubleValue();
        }
        throw new IllegalStateException();
    }
}

