/*
 * Decompiled with CFR 0.152.
 */
package com.fantasticsource.tools;

import com.fantasticsource.mctools.MCTools;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;

public class ReflectionTool {
    public static Field getField(Class classType, String ... possibleFieldnames) {
        return ReflectionTool.getField(false, classType, possibleFieldnames);
    }

    public static Field getField(boolean printFound, Class classType, String ... possibleFieldnames) {
        try {
            Field[] fields;
            for (Field field : fields = classType.getDeclaredFields()) {
                for (String name : possibleFieldnames) {
                    if (!field.getName().equals(name)) continue;
                    field.setAccessible(true);
                    Field modifiersField = Field.class.getDeclaredField("modifiers");
                    modifiersField.setAccessible(true);
                    modifiersField.setInt(field, field.getModifiers() & 0xFFFFFFEF);
                    if (printFound) {
                        System.out.println(name);
                    }
                    return field;
                }
            }
        }
        catch (IllegalAccessException | NoSuchFieldException e) {
            return null;
        }
        return null;
    }

    public static Method getMethod(Class classType, String ... possibleMethodNames) {
        return ReflectionTool.getMethod(false, classType, possibleMethodNames);
    }

    public static Method getMethod(boolean printFound, Class classType, String ... possibleMethodNames) {
        return ReflectionTool.getMethod(printFound, classType, null, possibleMethodNames);
    }

    public static Method getMethod(Class classType, int parameterCount, String ... possibleMethodNames) {
        return ReflectionTool.getMethod(false, classType, parameterCount, possibleMethodNames);
    }

    public static Method getMethod(boolean printFound, Class classType, int parameterCount, String ... possibleMethodNames) {
        Class[] paramTypes = new Class[parameterCount];
        for (int i = 0; i < parameterCount; ++i) {
            paramTypes[i] = null;
        }
        return ReflectionTool.getMethod(printFound, classType, paramTypes, possibleMethodNames);
    }

    public static Method getMethod(Class classType, Class[] parameterTypes, String ... possibleMethodNames) {
        return ReflectionTool.getMethod(false, classType, parameterTypes, possibleMethodNames);
    }

    public static Method getMethod(boolean printFound, Class classType, Class[] parameterTypes, String ... possibleMethodNames) {
        Method[] methods;
        for (Method method : methods = classType.getDeclaredMethods()) {
            for (String name : possibleMethodNames) {
                if (!method.getName().equals(name)) continue;
                if (parameterTypes == null) {
                    method.setAccessible(true);
                    if (printFound) {
                        System.out.println(name);
                    }
                    return method;
                }
                if (parameterTypes.length != method.getParameters().length) continue;
                boolean found = true;
                Class<?>[] methodParamTypes = method.getParameterTypes();
                for (int i = 0; i < parameterTypes.length; ++i) {
                    if (parameterTypes[i] == null || parameterTypes[i].equals(methodParamTypes[i])) continue;
                    found = false;
                    break;
                }
                if (!found) continue;
                return method;
            }
        }
        return null;
    }

    public static Class getClassByName(String fullClassPathAndName) {
        try {
            return Class.forName(fullClassPathAndName);
        }
        catch (ClassNotFoundException e) {
            return null;
        }
    }

    public static Class getInternalClass(Class classType, String ... possibleInternalClassNames) {
        Class<?>[] classes;
        for (Class<?> class1 : classes = classType.getDeclaredClasses()) {
            for (String name : possibleInternalClassNames) {
                if (!class1.getSimpleName().equals(name)) continue;
                return class1;
            }
        }
        return null;
    }

    public static Object getInstance(String fullClassPathAndName, Object ... constructorArgs) {
        return ReflectionTool.getInstance(fullClassPathAndName, 0, constructorArgs);
    }

    public static Object getInstance(String fullClassPathAndName, int constructorIndex, Object ... constructorArgs) {
        try {
            return ReflectionTool.getClassByName(fullClassPathAndName).getConstructors()[constructorIndex].newInstance(constructorArgs);
        }
        catch (IllegalAccessException | InstantiationException | InvocationTargetException e) {
            return null;
        }
    }

    public static Object getInstance(Class cls, Object ... constructorArgs) {
        return ReflectionTool.getInstance(cls, 0, constructorArgs);
    }

    public static Object getInstance(Class cls, int constructorIndex, Object ... constructorArgs) {
        try {
            return cls.getConstructors()[constructorIndex].newInstance(constructorArgs);
        }
        catch (IllegalAccessException | InstantiationException | InvocationTargetException e) {
            return null;
        }
    }

    public static void set(Class classType, String possibleFieldname, Object object, Object value) {
        ReflectionTool.set(classType, new String[]{possibleFieldname}, object, value);
    }

    public static void set(Class classType, String[] possibleFieldnames, Object object, Object value) {
        Field field = ReflectionTool.getField(classType, possibleFieldnames);
        if (field != null) {
            ReflectionTool.set(field, object, value);
        }
    }

    public static void set(Field field, Object object, Object value) {
        try {
            field.set(object, value);
        }
        catch (IllegalAccessException e) {
            MCTools.crash(e, false);
        }
    }

    public static Object get(Class classType, String possibleFieldname, Object object) {
        return ReflectionTool.get(classType, new String[]{possibleFieldname}, object);
    }

    public static Object get(Class classType, String[] possibleFieldnames, Object object) {
        Field field = ReflectionTool.getField(classType, possibleFieldnames);
        return field == null ? null : ReflectionTool.get(field, object);
    }

    public static Object get(Field field, Object object) {
        try {
            return field.get(object);
        }
        catch (IllegalAccessException e) {
            MCTools.crash(e, false);
            return null;
        }
    }

    public static Object invoke(Class classType, String possibleMethodName, Object object, Object ... args) {
        return ReflectionTool.invoke(classType, new String[]{possibleMethodName}, object, args);
    }

    public static Object invoke(Class classType, String[] possibleMethodNames, Object object, Object ... args) {
        Method method = ReflectionTool.getMethod(classType, args.length, possibleMethodNames);
        return method == null ? null : ReflectionTool.invoke(method, object, args);
    }

    public static Object invoke(Method method, Object object, Object ... args) {
        try {
            return method.invoke(object, args);
        }
        catch (IllegalAccessException | InvocationTargetException e) {
            MCTools.crash(e, false);
            return null;
        }
    }
}

