/*
 * Decompiled with CFR 0.152.
 */
package com.fantasticsource.mctools.sound;

import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.client.Minecraft;
import net.minecraft.client.audio.ISound;
import net.minecraft.client.audio.Sound;
import net.minecraft.client.audio.SoundEventAccessor;
import net.minecraft.client.audio.SoundHandler;
import net.minecraft.entity.Entity;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.SoundCategory;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

@SideOnly(value=Side.CLIENT)
public class SimpleSound
implements ISound {
    public final ResourceLocation rl;
    public final SoundCategory category;
    public float volume = 1.0f;
    public float pitch = 1.0f;
    public ISound.AttenuationType attenuationType = ISound.AttenuationType.LINEAR;
    protected Sound sound;
    protected boolean repeat;
    protected int repeatDelay;
    protected final Entity following;
    protected final float x;
    protected final float y;
    protected final float z;

    public SimpleSound(ResourceLocation rl, SoundCategory category) {
        this(rl, category, 0);
    }

    public SimpleSound(ResourceLocation rl, SoundCategory category, @Nonnull Entity following) {
        this(rl, category, 0, following);
    }

    public SimpleSound(ResourceLocation rl, SoundCategory category, float x, float y, float z) {
        this(rl, category, 0, x, y, z);
    }

    public SimpleSound(ResourceLocation rl, SoundCategory category, int repeatDelay) {
        this(rl, category, repeatDelay, (Entity)Minecraft.func_71410_x().field_71439_g);
    }

    public SimpleSound(ResourceLocation rl, SoundCategory category, int repeatDelay, @Nonnull Entity following) {
        this.x = 0.0f;
        this.y = 0.0f;
        this.z = 0.0f;
        this.rl = rl;
        this.category = category;
        this.repeatDelay = repeatDelay;
        this.following = following;
        this.repeat = repeatDelay > 0;
    }

    public SimpleSound(ResourceLocation rl, SoundCategory category, int repeatDelay, float x, float y, float z) {
        this.following = null;
        this.rl = rl;
        this.category = category;
        this.repeatDelay = repeatDelay;
        this.x = x;
        this.y = y;
        this.z = z;
        this.repeat = repeatDelay > 0;
    }

    @SideOnly(value=Side.CLIENT)
    public static void play(ResourceLocation rl) {
        Minecraft.func_71410_x().func_147118_V().func_147682_a((ISound)new SimpleSound(rl, SoundCategory.MASTER));
    }

    public ResourceLocation func_147650_b() {
        return this.rl;
    }

    @Nullable
    public SoundEventAccessor func_184366_a(SoundHandler handler) {
        SoundEventAccessor accessor = handler.func_184398_a(this.rl);
        this.sound = accessor == null ? SoundHandler.field_147700_a : accessor.func_148720_g();
        return accessor;
    }

    public Sound func_184364_b() {
        return this.sound;
    }

    public SoundCategory func_184365_d() {
        return this.category;
    }

    public boolean func_147657_c() {
        return this.repeat;
    }

    public int func_147652_d() {
        return this.repeatDelay;
    }

    public float func_147653_e() {
        return this.sound.func_188724_c() * this.volume;
    }

    public float func_147655_f() {
        return this.sound.func_188725_d() * this.pitch;
    }

    public float func_147649_g() {
        return this.following == null ? this.x : (float)this.following.field_70165_t;
    }

    public float func_147654_h() {
        return this.following == null ? this.y : (float)this.following.field_70163_u;
    }

    public float func_147651_i() {
        return this.following == null ? this.z : (float)this.following.field_70161_v;
    }

    public ISound.AttenuationType func_147656_j() {
        return this.attenuationType;
    }
}

