/*
 * Decompiled with CFR 0.152.
 */
package com.fantasticsource.mctools.nbtcap;

import com.fantasticsource.fantasticlib.api.FLibAPI;
import com.fantasticsource.fantasticlib.api.INBTCap;
import com.fantasticsource.mctools.nbtcap.NBTCapProvider;
import java.util.LinkedHashMap;
import java.util.function.Predicate;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.ResourceLocation;
import net.minecraft.village.Village;
import net.minecraft.world.World;
import net.minecraft.world.chunk.Chunk;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import net.minecraftforge.event.AttachCapabilitiesEvent;
import net.minecraftforge.event.entity.player.PlayerEvent;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;

public class NBTCap
implements INBTCap {
    protected LinkedHashMap<String, NBTTagCompound> compounds = new LinkedHashMap();

    @SubscribeEvent
    public static void onPlayerClone(PlayerEvent.Clone event) {
        EntityPlayer player = event.getEntityPlayer();
        INBTCap nbtCap = (INBTCap)player.getCapability(FLibAPI.NBT_CAP, null);
        INBTCap oldNBTCap = (INBTCap)event.getOriginal().getCapability(FLibAPI.NBT_CAP, null);
        if (nbtCap == null || oldNBTCap == null) {
            return;
        }
        for (String modid : oldNBTCap.getRegisteredModIDs()) {
            nbtCap.setCompound(modid, oldNBTCap.getCompound(modid));
        }
    }

    @SubscribeEvent
    public static void attachToEntity(AttachCapabilitiesEvent<Entity> event) {
        Entity entity = (Entity)event.getObject();
        for (Predicate predicate : entityPredicates.values()) {
            if (!predicate.test(entity)) continue;
            event.addCapability(new ResourceLocation("fantasticlib", "nbtcap"), (ICapabilityProvider)new NBTCapProvider());
            return;
        }
    }

    @SubscribeEvent
    public static void attachToStack(AttachCapabilitiesEvent<ItemStack> event) {
        ItemStack stack = (ItemStack)event.getObject();
        for (Predicate predicate : stackPredicates.values()) {
            if (!predicate.test(stack)) continue;
            event.addCapability(new ResourceLocation("fantasticlib", "nbtcap"), (ICapabilityProvider)new NBTCapProvider());
            return;
        }
    }

    @SubscribeEvent
    public static void attachToWorld(AttachCapabilitiesEvent<World> event) {
        World world = (World)event.getObject();
        for (Predicate predicate : worldPredicates.values()) {
            if (!predicate.test(world)) continue;
            event.addCapability(new ResourceLocation("fantasticlib", "nbtcap"), (ICapabilityProvider)new NBTCapProvider());
            return;
        }
    }

    @SubscribeEvent
    public static void attachToTE(AttachCapabilitiesEvent<TileEntity> event) {
        TileEntity te = (TileEntity)event.getObject();
        for (Predicate predicate : tePredicates.values()) {
            if (!predicate.test(te)) continue;
            event.addCapability(new ResourceLocation("fantasticlib", "nbtcap"), (ICapabilityProvider)new NBTCapProvider());
            return;
        }
    }

    @SubscribeEvent
    public static void attachToChunk(AttachCapabilitiesEvent<Chunk> event) {
        Chunk chunk = (Chunk)event.getObject();
        for (Predicate predicate : chunkPredicates.values()) {
            if (!predicate.test(chunk)) continue;
            event.addCapability(new ResourceLocation("fantasticlib", "nbtcap"), (ICapabilityProvider)new NBTCapProvider());
            return;
        }
    }

    @SubscribeEvent
    public static void attachToVillage(AttachCapabilitiesEvent<Village> event) {
        Village village = (Village)event.getObject();
        for (Predicate predicate : villagePredicates.values()) {
            if (!predicate.test(village)) continue;
            event.addCapability(new ResourceLocation("fantasticlib", "nbtcap"), (ICapabilityProvider)new NBTCapProvider());
            return;
        }
    }

    @Override
    public String[] getRegisteredModIDs() {
        return registeredModIDs.toArray(new String[0]);
    }

    @Override
    public NBTTagCompound getCompound(String modid) {
        return this.compounds.computeIfAbsent(modid, o -> new NBTTagCompound());
    }

    @Override
    public void setCompound(String modid, NBTTagCompound compound) {
        this.compounds.put(modid, compound);
    }
}

