/*
 * Decompiled with CFR 0.152.
 */
package com.fantasticsource.mctools.cliententity;

import com.fantasticsource.mctools.ImprovedRayTracing;
import com.fantasticsource.mctools.cliententity.ClientEntity;
import com.fantasticsource.tools.ReflectionTool;
import com.fantasticsource.tools.Smoothing;
import com.fantasticsource.tools.Tools;
import com.fantasticsource.tools.TrigLookupTable;
import java.lang.reflect.Field;
import net.minecraft.client.Minecraft;
import net.minecraft.client.settings.GameSettings;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.util.math.Vec3d;
import net.minecraft.world.World;
import net.minecraftforge.client.event.PlayerSPPushOutOfBlocksEvent;
import net.minecraftforge.client.event.RenderGameOverlayEvent;
import net.minecraftforge.client.event.RenderPlayerEvent;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.world.GetCollisionBoxesEvent;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.common.gameevent.TickEvent;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

@SideOnly(value=Side.CLIENT)
public class Camera
extends ClientEntity {
    protected static final double OFFSET_COLLISION_BUFFER_DIRECT = 0.2;
    protected static final double OFFSET_COLLISION_BUFFER_FORWARD = 0.2;
    protected static final Field MINECRAFT_RENDER_VIEW_ENTITY_FIELD = ReflectionTool.getField(Minecraft.class, "field_175622_Z", "renderViewEntity");
    protected static Camera camera;
    public static final int PLAYER_RENDER_IF_THIRD_PERSON = 0;
    public static final int PLAYER_RENDER_ALWAYS = 1;
    public static final int PLAYER_RENDER_NEVER = 2;
    public static int playerRenderMode;
    public static boolean allowControl;
    public static double followOffsetLR;
    protected boolean active = false;
    protected int mode;
    protected int originalMode;
    protected Entity toFollow = null;
    protected static boolean control1;
    protected static boolean control2;

    public static Camera getCamera() {
        if (camera == null) {
            camera = new Camera(null);
        }
        return camera;
    }

    protected Camera(World worldIn) {
        super(worldIn);
        this.func_70105_a(0.0f, 0.0f);
        this.field_98038_p = true;
    }

    public boolean isActive() {
        return this.active;
    }

    public void activate(Entity toFollow, int mode) {
        this.activate(toFollow, toFollow.field_70170_p, toFollow.field_70165_t, toFollow.field_70163_u + (double)toFollow.func_70047_e(), toFollow.field_70161_v, toFollow.func_70079_am(), toFollow.field_70125_A, mode);
    }

    public void activate(World world, double x, double y, double z, float yaw, float pitch, int mode) {
        this.activate(null, world, x, y, z, yaw, pitch, mode);
    }

    protected void activate(Entity toFollow, World world, double x, double y, double z, float yaw, float pitch, int mode) {
        if (this.active) {
            this.deactivate();
        }
        this.active = true;
        this.toFollow = toFollow;
        this.field_70170_p = world;
        this.field_71093_bK = world.field_73011_w.getDimension();
        this.field_70165_t = x;
        this.field_70169_q = x;
        this.field_70163_u = y;
        this.field_70167_r = y;
        this.field_70161_v = z;
        this.field_70166_s = z;
        this.field_70177_z = yaw;
        this.field_70126_B = yaw;
        this.field_70125_A = pitch;
        this.field_70127_C = pitch;
        this.field_70128_L = false;
        world.func_72838_d((Entity)this);
        this.mode = mode;
        if (mode == -1) {
            this.originalMode = -1;
        } else {
            GameSettings gs = Minecraft.func_71410_x().field_71474_y;
            this.originalMode = gs.field_74320_O;
            gs.field_74320_O = mode;
        }
        Minecraft.func_71410_x().func_175607_a((Entity)camera);
    }

    public void deactivate() {
        if (this.active) {
            this.active = false;
            this.field_70170_p.func_72900_e((Entity)this);
            this.field_70170_p = null;
            Minecraft mc = Minecraft.func_71410_x();
            if (this.mode != -1) {
                mc.field_71474_y.field_74320_O = this.originalMode;
            }
            mc.func_175607_a((Entity)mc.field_71439_g);
        }
    }

    public void func_70071_h_() {
        if (this.active && this.mode != -1) {
            Minecraft.func_71410_x().field_71474_y.field_74320_O = this.mode;
        }
        super.func_70071_h_();
    }

    public void func_70030_z() {
    }

    @SubscribeEvent
    public static void trackFollowed(TickEvent.RenderTickEvent event) {
        if (!Camera.getCamera().active || event.phase != TickEvent.Phase.START) {
            return;
        }
        if (Camera.camera.toFollow != null) {
            Camera.followEntity(event.renderTickTime);
        }
    }

    protected static void followEntity(float partialTick) {
        Entity entity = Camera.camera.toFollow;
        if (Minecraft.func_71410_x().field_71474_y.field_74320_O == 0) {
            Camera.camera.field_70177_z = entity.func_70079_am();
            Camera.camera.field_70125_A = entity.field_70125_A;
            Camera.camera.field_70126_B = entity instanceof EntityLivingBase ? ((EntityLivingBase)entity).field_70758_at : entity.field_70126_B;
            Camera.camera.field_70127_C = entity.field_70127_C;
        } else {
            Camera.camera.field_70177_z = (float)Smoothing.interpolate(entity instanceof EntityLivingBase ? (double)((EntityLivingBase)entity).field_70758_at : (double)entity.field_70126_B, entity.func_70079_am(), partialTick, 0);
            Camera.camera.field_70125_A = (float)Smoothing.interpolate(entity.field_70127_C, entity.field_70125_A, partialTick, 0);
            Camera.camera.field_70126_B = Camera.camera.field_70177_z;
            Camera.camera.field_70127_C = Camera.camera.field_70125_A;
        }
        if (followOffsetLR != 0.0) {
            World world = entity.field_70170_p;
            double testFollowOffsetLR = followOffsetLR > 0.0 ? followOffsetLR + 0.2 : followOffsetLR - 0.2;
            Vec3d start = entity.func_174824_e(1.0f);
            Vec3d testStart = start.func_72441_c(-0.2 * TrigLookupTable.TRIG_TABLE_1024.sin(Tools.degtorad(Camera.camera.field_70177_z)), 0.0, 0.2 * TrigLookupTable.TRIG_TABLE_1024.cos(Tools.degtorad(Camera.camera.field_70177_z)));
            Vec3d testEnd = testStart.func_178786_a(testFollowOffsetLR * TrigLookupTable.TRIG_TABLE_1024.cos(Tools.degtorad(Camera.camera.field_70177_z)), 0.0, testFollowOffsetLR * TrigLookupTable.TRIG_TABLE_1024.sin(Tools.degtorad(Camera.camera.field_70177_z)));
            RayTraceResult testResult = ImprovedRayTracing.rayTraceBlocks(world, testStart, testEnd, Math.abs(testFollowOffsetLR), true);
            Vec3d testHitVec = testResult.field_72307_f != null ? testResult.field_72307_f : testEnd;
            Vec3d testDif = testHitVec.func_178788_d(testStart);
            double testDist = testDif.func_72433_c() - 0.2;
            if (testDist > 0.0) {
                Vec3d end = start.func_178786_a(testFollowOffsetLR * TrigLookupTable.TRIG_TABLE_1024.cos(Tools.degtorad(Camera.camera.field_70177_z)), 0.0, testFollowOffsetLR * TrigLookupTable.TRIG_TABLE_1024.sin(Tools.degtorad(Camera.camera.field_70177_z)));
                RayTraceResult result = ImprovedRayTracing.rayTraceBlocks(world, start, end, testDist + 0.2, true);
                Vec3d hitVec = result.field_72307_f != null ? result.field_72307_f : end;
                Vec3d dif = hitVec.func_178788_d(start);
                double dist = dif.func_72433_c() - 0.2;
                if (dist > 0.0) {
                    camera.setPosition(dif.func_72432_b().func_186678_a(Tools.min(testDist, dist)).func_178787_e(start));
                }
            }
        }
        Camera.camera.field_70169_q = Camera.camera.field_70165_t;
        Camera.camera.field_70167_r = Camera.camera.field_70163_u;
        Camera.camera.field_70166_s = Camera.camera.field_70161_v;
    }

    public void setPositionAndRotation(Vec3d position, float yaw, float pitch) {
        this.setPosition(position);
        this.func_70101_b(yaw, pitch);
    }

    public void func_70080_a(double x, double y, double z, float yaw, float pitch) {
        this.func_70107_b(x, y, z);
        this.func_70101_b(yaw, pitch);
    }

    public void setPosition(Vec3d vec) {
        this.func_70107_b(vec.field_72450_a, vec.field_72448_b, vec.field_72449_c);
    }

    public float func_70047_e() {
        return 0.0f;
    }

    @SubscribeEvent
    public static void renderPlayerPre(RenderPlayerEvent.Pre event) {
        Minecraft mc = Minecraft.func_71410_x();
        switch (playerRenderMode) {
            case 2: {
                return;
            }
            case 1: {
                break;
            }
            default: {
                if (mc.field_71474_y.field_74320_O != 0) break;
                return;
            }
        }
        if (Camera.getCamera().active && event.getEntityPlayer() == mc.field_71439_g) {
            mc.func_175598_ae().field_78734_h = mc.field_71439_g;
        }
    }

    @SubscribeEvent
    public static void renderPlayerPost(RenderPlayerEvent.Post event) {
        Minecraft mc = Minecraft.func_71410_x();
        if (Camera.getCamera().active && event.getEntityPlayer() == mc.field_71439_g) {
            mc.func_175598_ae().field_78734_h = camera;
        }
    }

    @SubscribeEvent
    public static void preOverlayRender(RenderGameOverlayEvent.Pre event) {
        if (event.getType() != RenderGameOverlayEvent.ElementType.ALL) {
            return;
        }
        if (Camera.getCamera().active) {
            Minecraft mc = Minecraft.func_71410_x();
            mc.func_175607_a((Entity)mc.field_71439_g);
        }
    }

    @SubscribeEvent
    public static void postOverlayRender(RenderGameOverlayEvent.Post event) {
        if (event.getType() != RenderGameOverlayEvent.ElementType.ALL) {
            return;
        }
        if (Camera.getCamera().active) {
            Minecraft mc = Minecraft.func_71410_x();
            mc.func_175607_a((Entity)camera);
        }
    }

    @SubscribeEvent
    public static void controlFixPre1(PlayerSPPushOutOfBlocksEvent event) {
        if (!allowControl) {
            return;
        }
        Minecraft mc = Minecraft.func_71410_x();
        if (Camera.getCamera().active && event.getEntityPlayer() == mc.field_71439_g) {
            ReflectionTool.set(MINECRAFT_RENDER_VIEW_ENTITY_FIELD, mc, mc.field_71439_g);
            control1 = true;
        }
    }

    @SubscribeEvent
    public static void controlFixPre2(TickEvent.PlayerTickEvent event) {
        if (!allowControl) {
            return;
        }
        Minecraft mc = Minecraft.func_71410_x();
        if (event.phase == TickEvent.Phase.END && Camera.getCamera().active && event.player == mc.field_71439_g) {
            ReflectionTool.set(MINECRAFT_RENDER_VIEW_ENTITY_FIELD, mc, mc.field_71439_g);
            control2 = true;
        }
    }

    @SubscribeEvent
    public static void controlFixPost(GetCollisionBoxesEvent event) {
        Minecraft mc = Minecraft.func_71410_x();
        if ((control1 || control2) && Camera.getCamera().active && event.getWorld().field_72995_K) {
            control1 = false;
            control2 = false;
            ReflectionTool.set(MINECRAFT_RENDER_VIEW_ENTITY_FIELD, mc, (Object)camera);
        }
    }

    static {
        MinecraftForge.EVENT_BUS.register(Camera.class);
        camera = null;
        playerRenderMode = 0;
        allowControl = true;
        followOffsetLR = 0.0;
        control1 = false;
        control2 = false;
    }
}

