/*
 * Decompiled with CFR 0.152.
 */
package xyz.tcreopargh.ctintegration.scalinghealth;

import crafttweaker.CraftTweakerAPI;
import crafttweaker.annotations.ModOnly;
import crafttweaker.annotations.ZenRegister;
import crafttweaker.api.minecraft.CraftTweakerMC;
import crafttweaker.api.player.IPlayer;
import crafttweaker.api.world.IBlockPos;
import crafttweaker.api.world.IWorld;
import java.util.Objects;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.silentchaos512.scalinghealth.config.Config;
import net.silentchaos512.scalinghealth.utils.SHPlayerDataHandler;
import net.silentchaos512.scalinghealth.world.ScalingHealthSavedData;
import stanhebben.zenscript.annotations.ZenClass;
import stanhebben.zenscript.annotations.ZenMethod;
import xyz.tcreopargh.ctintegration.date.CalendarDate;
import xyz.tcreopargh.ctintegration.date.IDate;

@ModOnly(value="scalinghealth")
@ZenRegister
@ZenClass(value="mods.ctintegration.scalinghealth.DifficultyManager")
public class DifficultyManager {
    @ZenMethod
    public static void setDifficulty(IPlayer player, double value) {
        EntityPlayer entPlayer = CraftTweakerMC.getPlayer((IPlayer)player);
        if (SHPlayerDataHandler.get((EntityPlayer)entPlayer) != null) {
            Objects.requireNonNull(SHPlayerDataHandler.get((EntityPlayer)entPlayer)).setDifficulty(value);
        } else {
            CraftTweakerAPI.logInfo((String)"cannot set difficulty because the player's scaling health data is null");
        }
    }

    @ZenMethod
    public static void addDifficulty(IPlayer player, double value) {
        EntityPlayer entPlayer = CraftTweakerMC.getPlayer((IPlayer)player);
        if (SHPlayerDataHandler.get((EntityPlayer)entPlayer) != null) {
            Objects.requireNonNull(SHPlayerDataHandler.get((EntityPlayer)entPlayer)).incrementDifficulty(value);
        } else {
            CraftTweakerAPI.logInfo((String)"cannot add difficulty because the player's scaling health data is null");
        }
    }

    @ZenMethod
    public static void addDifficulty(IPlayer player, double value, boolean affectWorldDifficulty) {
        EntityPlayer entPlayer = CraftTweakerMC.getPlayer((IPlayer)player);
        if (SHPlayerDataHandler.get((EntityPlayer)entPlayer) != null) {
            Objects.requireNonNull(SHPlayerDataHandler.get((EntityPlayer)entPlayer)).incrementDifficulty(value, affectWorldDifficulty);
        } else {
            CraftTweakerAPI.logInfo((String)"cannot add difficulty because the player's scaling health data is null");
        }
    }

    @ZenMethod
    public static double getDifficulty(IPlayer player) {
        EntityPlayer entPlayer = CraftTweakerMC.getPlayer((IPlayer)player);
        double val = Double.NaN;
        if (SHPlayerDataHandler.get((EntityPlayer)entPlayer) != null) {
            val = Objects.requireNonNull(SHPlayerDataHandler.get((EntityPlayer)entPlayer)).getDifficulty();
        } else {
            CraftTweakerAPI.logInfo((String)"cannot get difficulty because the player's scaling health data is null");
        }
        return val;
    }

    @ZenMethod
    public static double getWorldDifficulty(IWorld world) {
        World mcWorld = CraftTweakerMC.getWorld((IWorld)world);
        ScalingHealthSavedData data = ScalingHealthSavedData.get((World)mcWorld);
        return data.difficulty;
    }

    @ZenMethod
    public static void setWorldDifficulty(IWorld world, double value) {
        World mcWorld = CraftTweakerMC.getWorld((IWorld)world);
        ScalingHealthSavedData data = ScalingHealthSavedData.get((World)mcWorld);
        data.difficulty = value;
    }

    @ZenMethod
    public static void addWorldDifficulty(IWorld world, double value) {
        World mcWorld = CraftTweakerMC.getWorld((IWorld)world);
        ScalingHealthSavedData data = ScalingHealthSavedData.get((World)mcWorld);
        data.difficulty += value;
    }

    @ZenMethod
    public static IDate getLastTimePlayed(IPlayer player) {
        EntityPlayer mcPlayer = CraftTweakerMC.getPlayer((IPlayer)player);
        if (SHPlayerDataHandler.get((EntityPlayer)mcPlayer) != null) {
            return new CalendarDate(Objects.requireNonNull(SHPlayerDataHandler.get((EntityPlayer)mcPlayer)).getLastTimePlayed());
        }
        CraftTweakerAPI.logInfo((String)"cannot get last time played because the player's scaling health data is null");
        return null;
    }

    @ZenMethod
    public static float getMaxHealth(IPlayer player) {
        EntityPlayer mcPlayer = CraftTweakerMC.getPlayer((IPlayer)player);
        if (SHPlayerDataHandler.get((EntityPlayer)mcPlayer) != null) {
            return Objects.requireNonNull(SHPlayerDataHandler.get((EntityPlayer)mcPlayer)).getMaxHealth();
        }
        CraftTweakerAPI.logInfo((String)"cannot get max health because the player's scaling health data is null");
        return Float.NaN;
    }

    @ZenMethod
    public static void setMaxHealth(IPlayer player, float value) {
        EntityPlayer mcPlayer = CraftTweakerMC.getPlayer((IPlayer)player);
        if (SHPlayerDataHandler.get((EntityPlayer)mcPlayer) != null) {
            Objects.requireNonNull(SHPlayerDataHandler.get((EntityPlayer)mcPlayer)).setMaxHealth(value);
        } else {
            CraftTweakerAPI.logInfo((String)"cannot set max health because the player's scaling health data is null");
        }
    }

    @ZenMethod
    public static void addMaxHealth(IPlayer player, float value) {
        EntityPlayer mcPlayer = CraftTweakerMC.getPlayer((IPlayer)player);
        if (SHPlayerDataHandler.get((EntityPlayer)mcPlayer) != null) {
            Objects.requireNonNull(SHPlayerDataHandler.get((EntityPlayer)mcPlayer)).incrementMaxHealth(value);
        } else {
            CraftTweakerAPI.logInfo((String)"cannot add max health because the player's scaling health data is null");
        }
    }

    @ZenMethod
    public static double getAreaDifficulty(IPlayer player) {
        EntityPlayer mcPlayer = CraftTweakerMC.getPlayer((IPlayer)player);
        return Config.Difficulty.AREA_DIFFICULTY_MODE.getAreaDifficulty(mcPlayer.field_70170_p, mcPlayer.func_180425_c());
    }

    @ZenMethod
    public static double getAreaDifficulty(IWorld world, IBlockPos pos) {
        World mcWorld = CraftTweakerMC.getWorld((IWorld)world);
        BlockPos mcBlockPos = CraftTweakerMC.getBlockPos((IBlockPos)pos);
        return Config.Difficulty.AREA_DIFFICULTY_MODE.getAreaDifficulty(mcWorld, mcBlockPos);
    }
}

