/*
 * Decompiled with CFR 0.152.
 */
package xyz.tcreopargh.ctintegration.projecte;

import crafttweaker.CraftTweakerAPI;
import crafttweaker.annotations.ModOnly;
import crafttweaker.annotations.ZenRegister;
import crafttweaker.api.item.IIngredient;
import crafttweaker.api.item.IItemStack;
import crafttweaker.api.minecraft.CraftTweakerMC;
import java.util.List;
import moze_intel.projecte.api.ProjectEAPI;
import moze_intel.projecte.config.CustomEMCParser;
import moze_intel.projecte.emc.EMCMapper;
import net.minecraft.item.ItemStack;
import stanhebben.zenscript.annotations.ZenClass;
import stanhebben.zenscript.annotations.ZenMethod;

@ModOnly(value="projecte")
@ZenRegister
@ZenClass(value="mods.ctintegration.projecte.EMCManager")
public class EMCManager {
    @ZenMethod
    public static void mapEMC() {
        long start = System.currentTimeMillis();
        CustomEMCParser.init();
        CraftTweakerAPI.logInfo((String)"Starting server-side EMC mapping.");
        EMCMapper.map();
        CraftTweakerAPI.logInfo((String)("Registered " + EMCMapper.emc.size() + " EMC values. (took " + (System.currentTimeMillis() - start) + " ms)"));
    }

    @ZenMethod
    public static long getEMC(IItemStack item) {
        ItemStack stack = CraftTweakerMC.getItemStack((IItemStack)item);
        return ProjectEAPI.getEMCProxy().getValue(stack);
    }

    @ZenMethod
    public static long getEMCSellValue(IItemStack item) {
        ItemStack stack = CraftTweakerMC.getItemStack((IItemStack)item);
        return ProjectEAPI.getEMCProxy().getSellValue(stack);
    }

    @ZenMethod
    public static boolean isEMCSet(IItemStack item) {
        ItemStack stack = CraftTweakerMC.getItemStack((IItemStack)item);
        return ProjectEAPI.getEMCProxy().hasValue(stack);
    }

    @ZenMethod
    public static void setEMC(IItemStack item, long value) {
        ItemStack stack = CraftTweakerMC.getItemStack((IItemStack)item);
        ProjectEAPI.getEMCProxy().registerCustomEMC(stack, value);
    }

    @ZenMethod
    public static void setIngredientEMC(IIngredient ingredient, long value) {
        List items = ingredient.getItems();
        for (IItemStack item : items) {
            ItemStack stack = CraftTweakerMC.getItemStack((IItemStack)item);
            ProjectEAPI.getEMCProxy().registerCustomEMC(stack, value);
        }
    }
}

