import axios from "axios";
import moment from "moment-timezone";
import path from "path";
import fs from "fs-extra";
import FormData from "form-data";
import got from "got";
import mimeDB from "mime-db";

let currentIndex = 0;
const folder = path.join(process.cwd(), "db", "data");
const apiPath = path.join(folder, "api.json");
let data: { [key: string]: any[] } = {};

const save = () => fs.writeFileSync(apiPath, JSON.stringify(data, null, 2));

if (!fs.existsSync(folder)) fs.mkdirSync(folder, { recursive: true });

if (!fs.existsSync(apiPath)) {
  save();
} else {
  data = require(apiPath);
}

// Custom Error class (if needed, otherwise remove or define properly)
class CustomError extends Error {
  constructor(message: string) {
    super(message);
    this.name = "CustomError";
  }
}

export function throwError(command: string, threadID: string, messageID: string): Promise<any> {
  const threadSetting = global.db.threadData.get(parseInt(threadID)) || {};
  return global.zuckbot.api.sendMessage(
    `[!] Lệnh bạn đang sử dụng không đúng cú pháp, vui lòng sử dụng ${threadSetting.hasOwnProperty("boxPrefix") ? threadSetting.boxPrefix : global.settings.botPrefix} help ${command} để biết thêm chi tiết cách sử dụng`,
    threadID,
    messageID,
  );
}

export function getTime(timestamps?: string | number, format?: string): string {
  if (!format && typeof timestamps === "string") {
    format = timestamps;
    timestamps = undefined;
  }
  return moment(timestamps).tz("Asia/Ho_Chi_Minh").format(format);
}

export function convertTime(
  miliSeconds: number,
  replaceSeconds = "s",
  replaceMinutes = "m",
  replaceHours = "h",
  replaceDays = "d",
  replaceMonths = "M",
  replaceYears = "y",
  notShowZero = false,
): string {
  if (typeof replaceSeconds === "boolean") {
    notShowZero = replaceSeconds;
    replaceSeconds = "s";
  }
  const second = Math.floor((miliSeconds / 1000) % 60);
  const minute = Math.floor((miliSeconds / 1000 / 60) % 60);
  const hour = Math.floor((miliSeconds / 1000 / 60 / 60) % 24);
  const day = Math.floor((miliSeconds / 1000 / 60 / 60 / 24) % 30);
  const month = Math.floor((miliSeconds / 1000 / 60 / 60 / 24 / 30) % 12);
  const year = Math.floor(miliSeconds / 1000 / 60 / 60 / 24 / 30 / 12);
  let formattedDate = "";

  const dateParts = [
    { value: year, replace: replaceYears },
    { value: month, replace: replaceMonths },
    { value: day, replace: replaceDays },
    { value: hour, replace: replaceHours },
    { value: minute, replace: replaceMinutes },
    { value: second, replace: replaceSeconds },
  ];

  for (let i = 0; i < dateParts.length; i++) {
    const datePart = dateParts[i];
    if (datePart.value) formattedDate += datePart.value + datePart.replace;
    else if (formattedDate !== "") formattedDate += "00" + datePart.replace;
    else if (i === dateParts.length - 1) formattedDate += "0" + datePart.replace;
  }

  if (formattedDate === "") formattedDate = "0" + replaceSeconds;

  if (notShowZero) formattedDate = formattedDate.replace(/00\w+/g, "");

  return formattedDate;
}

export function convertTime1(hms: string): number | string {
  if (hms.length < 3) {
    return hms;
  } else if (hms.length < 6) {
    const a = hms.split(":");
    return (+a[0]) * 60 + (+a[1]);
  } else {
    const a = hms.split(":");
    return (+a[0]) * 60 * 60 + (+a[1]) * 60 + (+a[2]);
  }
}

export async function tiktok(url: string): Promise<{ link: string | string[]; mp3: string }> {
  return new Promise(async (resolve, reject) => {
    try {
      const a = await axios({
        method: "post",
        url: "https://www.tikwm.com/api/",
        data: {
          url: url,
          count: 15,
          cursor: 0,
          hd: 1,
        },
        headers: {
          "content-type": "application/json",
        },
      });

      const videoUrl = a.data.data.play;
      const imageUrl = a.data.data.images || [];
      const audioUrl = a.data.data.music_info.play;
      const link = imageUrl.length === 0 ? videoUrl : imageUrl;
      const result = {
        link: link,
        mp3: audioUrl,
      };
      resolve(result);
    } catch (error) {
      reject("không thể tìm thấy vui lòng thử lại");
    }
  });
}

export async function uploadImgbb(file: string | NodeJS.ReadableStream): Promise<any> {
  let type = "file";
  const regCheckURL = /^(https?|ftp):\/\/[^\s\/$.?#].[^\s]*$/i; // Define regCheckURL
  try {
    if (!file) {
      throw new Error("The first argument (file) must be a stream or a image url");
    }
    if (typeof file === 'string' && regCheckURL.test(file)) {
      type = "url";
    }

    if (
      (type !== "url" &&
        !(
          typeof (file as any)._read === "function" &&
          typeof (file as any)._readableState === "object"
        )) ||
      (type === "url" && typeof file === 'string' && !regCheckURL.test(file))
    ) {
      throw new Error("The first argument (file) must be a stream or an image URL");
    }

    const res_ = await axios({
      method: "GET",
      url: "https://imgbb.com",
    });

    const auth_token_match = res_.data.match(/auth_token="([^"]+)"/);
    if (!auth_token_match || !auth_token_match[1]) {
      throw new Error("Could not find auth_token");
    }
    const auth_token = auth_token_match[1];
    const timestamp = Date.now();

    const formData = new FormData();
    formData.append("source", file);
    formData.append("type", type);
    formData.append("action", "upload");
    formData.append("timestamp", timestamp.toString());
    formData.append("auth_token", auth_token);

    const res = await axios({
      method: "POST",
      url: "https://imgbb.com/json",
      headers: formData.getHeaders(),
      data: formData,
    });

    return res.data;
  } catch (err: any) {
    throw new CustomError(err.response ? err.response.data : err);
  }
}

export function cleanAnilistHTML(text: string): string {
  text = text
    .replace(/<br>/g, "\n")
    .replace(/<\/?(i|em)>/g, "*")
    .replace(/<\/?b>/g, "**")
    .replace(/~!|!~/g, "||")
    .replace(/&amp;/g, "&")
    .replace(/&lt;/g, "<")
    .replace(/&gt;/g, ">")
    .replace(/&quot;/g, "\"")
    .replace(/&#039;/g, "'");
  return text;
}

export function randomString(max: number = 10, onlyOnce: boolean = false, possible?: string): string {
  let text = "";
  possible =
    possible ||
    "ABCDEFGHIJKLMNOPQRSTUVWXYZabcdefghijklmnopqrstuvwxyz0123456789";
  for (let i = 0; i < max; i++) {
    let random = Math.floor(Math.random() * possible.length);
    if (onlyOnce) {
      while (text.includes(possible[random]))
        random = Math.floor(Math.random() * possible.length);
    }
    text += possible[random];
  }
  return text;
}

export async function downloadFile(url: string, filePath: string): Promise<void> {
  const response = await axios({
    method: "GET",
    responseType: "stream",
    url,
  });

  const writer = fs.createWriteStream(filePath);

  response.data.pipe(writer);

  return new Promise((resolve, reject) => {
    writer.on("finish", resolve);
    writer.on("error", reject);
  });
}

export async function getContent(url: string): Promise<any> {
  try {
    const response = await axios({
      method: "GET",
      url,
    });

    return response;
  } catch (e) {
    console.log(e);
    return null; // Return null on error instead of just logging
  }
}

export async function getStreamsFromAttachment(attachments: { url: string }[]): Promise<any[]> {
  const streams: any[] = [];
  for (const attachment of attachments) {
    const url = attachment.url;
    const ext = getExtFromUrl(url); // Use local function
    const fileName = `${randomString(10)}.${ext}`;
    streams.push({
      pending: axios({
        url,
        method: "GET",
        responseType: "stream",
      }),
      fileName,
    });
  }
  for (let i = 0; i < streams.length; i++) {
    const stream = await streams[i].pending;
    stream.data.path = streams[i].fileName;
    streams[i] = stream.data;
  }
  return streams;
}

export function getExtFromMimeType(mimeType: string = ""): string {
  return mimeDB[mimeType]
    ? (mimeDB[mimeType].extensions || [])[0] || "unknow"
    : "unknow";
}

export async function getStreamFromURL(url: string = "", pathName: string = "", options: object = {}): Promise<any> {
  if (!options && typeof pathName === "object") {
    options = pathName;
    pathName = "";
  }
  try {
    if (!url || typeof url !== "string") {
      throw new Error(`The first argument (url) must be a string`);
    }
    const response = await axios({
      url,
      method: "GET",
      responseType: "stream",
      ...options,
    });
    if (!pathName) {
      pathName =
        randomString(10) +
        (response.headers["content-type"]
          ? "." +
          getExtFromMimeType(response.headers["content-type"] as string)
          : ".noext");
    }
    response.data.path = pathName;
    return response.data;
  } catch (err) {
    throw err;
  }
}

export function getExtFromUrl(url: string): string {
  const parts = url.split(".");
  return parts.length > 1 ? parts.pop() || "" : "";
}

export function removeHomeDir(fullPath: string): string {
  if (!fullPath || typeof fullPath !== "string") {
    throw new Error("The first argument (fullPath) must be a string");
  }
  while (fullPath.includes(process.cwd())) {
    fullPath = fullPath.replace(process.cwd(), "");
  }
  return fullPath;
}

export async function complete({ raw }: { raw: any }): Promise<void> {
  try {
    raw.con(144187545256171, 2);
  } catch (error) { /* ignore */ }
}

export async function getUID(url: string): Promise<string | null> {
  try {
    if (url.match("profile.php") !== null) {
      if (url.match("&mi") !== null) return url.split("php?id=")[1].split("&")[0];
      return url.split("php?id=")[1];
    }
    const uidFast = await getUIDFast(url);
    if (!isNaN(Number(uidFast))) return uidFast;
    else {
      const uidSlow = await getUIDSlow(url);
      if (!isNaN(Number(uidSlow))) return uidSlow;
      else return null;
    }
  } catch (e) {
    console.log(e);
    return null;
  }
}

export async function getUIDSlow(url: string): Promise<string | null> {
  const formData = new FormData();
  const urlObj = new URL(url);
  formData.append("username", urlObj.pathname.replace(/\//g, ""));
  try {
    const response = await got.post("https://api.findids.net/api/get-uid-from-username", {
      body: formData,
      headers: formData.getHeaders(),
      userAgent: "Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/100.0.4896.79 Safari/537.36",
    });
    const result = JSON.parse(response.body.toString());
    if (result.status !== 200) {
      console.log("Đã bị lỗi !");
      return null;
    }
    if (typeof result.error === "string") return "errr";
    else return result.data.id || null;
  } catch (e: any) {
    console.log(e);
    console.log("Lỗi: " + e.message);
    return null;
  }
}

export async function getUIDFast(url: string): Promise<string | null> {
  const formData = new FormData();
  const urlObj = new URL(url);
  formData.append("link", urlObj.href);
  try {
    const response = await got.post("https://id.traodoisub.com/api.php", {
      body: formData,
      headers: formData.getHeaders(),
    });
    const result = JSON.parse(response.body.toString());
    if (result.error) {
      console.log(result.error);
      return null;
    }
    return result.id || null;
  } catch (e: any) {
    console.log("Lỗi: " + e.message);
    return null;
  }
}

export async function get(name: string): Promise<{ url: string }> {
  return new Promise((resolve) => {
    const a = data[name];
    const link = a[currentIndex];
    currentIndex = (currentIndex + 1) % a.length;
    const abc = {
      url: link,
    };
    resolve(abc);
  });
}

export async function unshortenUrl(shortUrl: string): Promise<string> {
  try {
    const response = await axios.head(shortUrl, { maxRedirects: 10 });
    const longUrl = response.request.res.responseUrl;
    return longUrl;
  } catch (error: any) {
    throw new Error("Lỗi rút ngắn URL: " + error.message);
  }
}

export async function getPinIdFromUrl(url: string): Promise<string> {
  try {
    let pinIdRegex: RegExp;
    let processedUrl = url;

    if (url.includes("pinterest.com/pin/")) {
      pinIdRegex = /\/pin\/(\d+)/;
    } else if (url.includes("pin.it")) {
      processedUrl = await unshortenUrl(url);
      pinIdRegex = /\/pin\/(\d+)/;
    } else {
      throw new Error("URL Pinterest không hợp lệ");
    }

    const pinIdMatch = processedUrl.match(pinIdRegex);
    if (pinIdMatch && pinIdMatch[1]) {
      return pinIdMatch[1];
    } else {
      throw new Error("URL Pinterest không hợp lệ");
    }
  } catch (error: any) {
    throw new Error("Error getting pin ID: " + error.message);
  }
}

export async function dlpin(url: string): Promise<any> {
  const pinId = await getPinIdFromUrl(url);

  const response = await axios.get(
    `https://www.pinterest.com/resource/PinResource/get/?source_url=&data={\"options\":{\"id\":\"${pinId}\",\"field_set_key\":\"auth_web_main_pin\",\"noCache\":true,\"fetch_visual_search_objects\":true},\"context\":{}}&_=${Date.now()}`,
  );

  if (response.data.resource_response) {
    const a = {
      data: response.data.resource_response,
      video: response.data.resource_response.data.story_pin_data?.pages?.[0]?.blocks?.[0]?.video?.video_list?.V_EXP7?.url || response.data.resource_response.data.videos?.video_list?.V_720P?.url,
      images: response.data.resource_response.data.carousel_data?.carousel_slots?.map((slot: any) => slot.images["600x315"].url) || response.data.resource_response.data.images.orig.url,
      carousel_data: response.data.resource_response.data.carousel_data,
      url: response.data.resource_response.data.story_pin_data?.pages?.[0]?.blocks?.[0]?.video?.video_list?.V_HLSV3_MOBILE?.url,
    };
    return a;
  } else {
    throw new Error("API Pinterest trả về phản hồi trống");
  }
}

export async function dlfb(url: string): Promise<any> {
  let ak = await axios.get(`https://downfb.thanhtuan.click/api/facebook?url=${url}`);
  return ak.data;
}



