import { readdirSync, writeFileSync } from "fs-extra";
import * as fs from "fs-extra";
import { join, resolve } from "path";
import logger from "../FB-API/logger"; // Adjust path as needed
import login from "../FB-API/a"; // Adjust path as needed
import { getStreamFromURL } from "./utils"; // Assuming utils.ts will be created
import { sequelize } from "../db"; // Assuming db/index.ts will be created

// Global type definitions
declare global {
  var urls: { gai: string[]; cosplay: string[] };
  var zuckbot: {
    commands: Map<string, any>;
    events: Map<string, any>;
    cd: Map<string, any>;
    eventRegistered: string[];
    onReaction: any[];
    onReply: any[];
    mainPath: string;
    configPath: string;
    api?: any; // Define a more specific type for api if possible
    timeStart?: number;
    xx?: NodeJS.Timeout;
  };
  var db: {
    threadInfo: Map<string, any>;
    threadData: Map<string, any>;
    userName: Map<string, any>;
    allUserID: any[];
    allCurrenciesID: any[];
    allThreadID: any[];
  };
  var loading: any;
  var settings: any; // Define a more specific type for settings if possible
  var moduleData: any[];
  var account: { cookie?: string };
  var queues: any[];
  var games: any;
  var uploadMode: string;
  var utils: any; // Define a more specific type for utils if possible
}

global.zuckbot = {
  commands: new Map(),
  events: new Map(),
  cd: new Map(),
  eventRegistered: [],
  onReaction: [],
  onReply: [],
  mainPath: process.cwd(),
  configPath: "",
};

global.urls = {
  gai: fs.readJsonSync(join(process.cwd(), "db", "data", "vdgai.json")),
  cosplay: fs.readJsonSync(join(process.cwd(), "db", "data", "vdcosplay.json")),
};

global.db = {
  threadInfo: new Map(),
  threadData: new Map(),
  userName: new Map(),
  allUserID: [],
  allCurrenciesID: [],
  allThreadID: [],
};

global.utils = require("./utils"); // Will be converted to import later

global.loading = logger;
global.settings = {};
global.moduleData = [];
global.account = {};
global.queues = [];
global.games = {};

global.zuckbot.configPath = join(global.zuckbot.mainPath, "settings.json");
global.settings = fs.readJsonSync(join(process.cwd(), "settings.json"));
global.uploadMode = global.settings.uploadMode || "all";

const appStateFile = resolve(join(global.zuckbot.mainPath, "appstate.json"));
const appState = fs.readJsonSync(appStateFile);

async function onBot({ models }: { models: any }) {
  let status = false;

  async function upload(api: any, url: string, retryCount = 3): Promise<[string, any] | null> {
    try {
      const stream = await getStreamFromURL(url);
      const response = await api.postFormData(
        "https://upload.facebook.com/ajax/mercury/upload.php",
        { upload_1024: stream }
      );
      const result = JSON.parse(response.body.replace("for (;;);", ""));
      const metadata = result.payload?.metadata?.[0];
      return metadata ? Object.entries(metadata)[0] as [string, any] : null;
    } catch (error) {
      if (retryCount > 0) {
        console.error(`Failed to upload ${url}, retrying... (${3 - retryCount + 1})`);
        return upload(api, url, retryCount - 1);
      } else {
        console.error(`Failed to upload ${url} after multiple attempts:`, error);
        return null;
      }
    }
  }

  function getUploadURL(): string | null {
    const mode = global.uploadMode;
    if (mode === "off") return null;
    if (mode === "gai") return global.urls.gai[Math.floor(Math.random() * global.urls.gai.length)];
    if (mode === "cosplay") return global.urls.cosplay[Math.floor(Math.random() * global.urls.cosplay.length)];
    const source = Math.random() < 0.5 ? global.urls.gai : global.urls.cosplay;
    return source[Math.floor(Math.random() * source.length)];
  }

  function startUploadProcess(api: any) {
    if (!global.zuckbot.xx) {
      global.zuckbot.xx = setInterval(async () => {
        if (status || global.queues.length >= 20) return;
        status = true;
        try {
          const numUploads = 20 - global.queues.length;
          const uploadPromises = Array.from({ length: numUploads }, () => {
            const url = getUploadURL();
            return url ? upload(api, url) : null;
          });
          const res = await Promise.all(uploadPromises);
          global.queues.push(...res.filter(Boolean));
        } catch (error) {
          console.error("Error during upload process:", error);
        } finally {
          status = false;
        }
      }, 5000);
    }
  }

  login({ appState }, async (err: any, api: any) => {
    if (err) {
      return console.error(err);
    }
    api.setOptions(global.settings.FCAOption);
    writeFileSync(appStateFile, JSON.stringify(api.getAppState(), null, 2));
    global.account.cookie = api.getAppState().map((i: any) => `${i.key}=${i.value}`).join(";");
    global.zuckbot.api = api;
    global.settings.version = "1.0.0";
    global.zuckbot.timeStart = Date.now();

    const listCommand = readdirSync(join(global.zuckbot.mainPath, "cmds"))
      .filter((command) => command.endsWith(".ts") && !command.includes("example"));

    for (const command of listCommand) {
      const module = require(join(global.zuckbot.mainPath, "cmds", command));
      if (!module.zuckbotconfig || !module.onRun || !module.zuckbotconfig.Category) {
        throw new Error(`Module không đúng định dạng: ${command}`);
      }
      if (global.zuckbot.commands.has(module.zuckbotconfig.name)) {
        throw new Error(`Tên module bị trùng: ${module.zuckbotconfig.name}`);
      }
      if (module.onLoad) {
        try {
          module.onLoad({ api, models });
        } catch (error: any) {
          throw new Error(`Không thể khởi chạy setup của module ${module.zuckbotconfig.name}: ${error.message}`);
        }
      }
      if (module.onEvent) global.zuckbot.eventRegistered.push(module.zuckbotconfig.name);
      global.zuckbot.commands.set(module.zuckbotconfig.name, module);
    }

    startUploadProcess(api);

    const Action = require("../handler/Action")( { api, models }); // Adjust path as needed

    function handleMqttEvents(error: any, message: any) {
      if (error) {
        return logger("Lỗi khi lắng nghe sự kiện: " + JSON.stringify(error), "error");
      } else if (JSON.stringify(error).includes("Not logged in")) {
        console.log("Bot bị đăng xuất, đang khởi động lại...");
        process.exit(1); // để cho PM2 tự khởi động lại
      } else if (JSON.stringify(error).includes("ECONNRESET")) {
        api.stopListenMqtt();
        api.listenMqtt(handleMqttEvents);
      }
      if (message && !["presence", "typ", "read_receipt"].includes(message.type)) {
        Action(message);
      }
    }

    setInterval(() => {
      api.stopListenMqtt();
      api.listenMqtt(handleMqttEvents);
      console.log("suusss");
    }, 1000 * 60 * 30);

    api.listenMqtt(handleMqttEvents);
  });
}

