import { spawn } from "child_process";

function run(script: string) {
  const child = spawn(
    "bun", // Use 'bun' instead of 'node'
    [
      "--trace-deprecation",
      script
    ],
    {
      cwd: __dirname,
      stdio: "inherit",
      shell: true,
    }
  );

  child.on("close", (codeExit) => {
    if (codeExit !== 0) {
      console.log(`[ RESTART ] Đang khởi động lại ${script}...`);
      run(script);
    } else {
      console.log(`[ STOP ] Tiến trình con ${script} đã kết thúc!`);
    }
  });

  child.on("error", (error) => {
    console.error(`[ ERROR ] Đã xảy ra lỗi với ${script}: ` + JSON.stringify(error));
  });
}

run("main.ts"); // Run main.ts instead of main.js

