interface Api {
  sendMessage(message: string, threadID: string, messageID: string): Promise<any>;
}

interface Models {
  // Define model types if known
}

interface UsersController {
  // Define Users controller methods if known
}

interface ThreadsController {
  // Define Threads controller methods if known
}

interface CurrenciesController {
  // Define Currencies controller methods if known
}

interface Event {
  messageReply?: { messageID: string };
  threadID: string;
  messageID: string;
  // Add other event properties as needed
}

interface OnReplyData {
  messageID: string;
  name: string;
  // Add other properties of onReply data if known
}

interface CommandModule {
  onReply?: (options: { api: Api; event: Event; models: Models; Users: UsersController; Threads: ThreadsController; Currencies: CurrenciesController; onReply: OnReplyData }) => void;
}

export default function ({ api, models, Users, Threads, Currencies }: { api: Api; models: Models; Users: UsersController; Threads: ThreadsController; Currencies: CurrenciesController }) {
  return function ({ event }: { event: Event }) {
    if (!event.messageReply) return;
    const { onReply, commands } = global.zuckbot;
    const indexOfHandle = onReply.findIndex((e: OnReplyData) => e.messageID === event.messageReply?.messageID);
    if (indexOfHandle < 0) return;

    const replyData: OnReplyData = onReply[indexOfHandle];
    const commandModule: CommandModule | undefined = commands.get(replyData.name);

    if (!commandModule) {
      api.sendMessage("Thiếu dữ liệu để có thể thực thi phản hồi lại câu trả lời của bạn", event.threadID, event.messageID);
      return;
    }

    try {
      if (commandModule.onReply) {
        commandModule.onReply({ api, event, models, Users, Threads, onReply: replyData, Currencies });
      }
    } catch (error) {
      console.log(error);
    }
  };
}


