interface Api {
  getThreadInfo(threadID: string): Promise<any>;
  getCurrentUserID(): string;
}

interface Models {
  // Define model types if known
}

interface UsersController {
  // Define Users controller methods if known
}

interface ThreadsController {
  setData(threadID: string, options: object): Promise<any>;
  getData(threadID: string): Promise<any>;
  delData(threadID: string): Promise<any>;
  createData(threadID: string, defaults: object): Promise<any>;
}

interface CurrenciesController {
  // Define Currencies controller methods if known
}

interface Event {
  threadID: string;
  logMessageType: string;
  logMessageData: any;
  // Add other event properties as needed
}

export default function ({ api, models, Users, Threads, Currencies }: { api: Api; models: Models; Users: UsersController; Threads: ThreadsController; Currencies: CurrenciesController }) {
  const logger = global.loading;
  return async function ({ event }: { event: Event }) {
    try {
      const { threadID, logMessageType, logMessageData } = event;
      const { setData, getData, delData, createData } = Threads;

      let dataThread = await api.getThreadInfo(threadID);

      switch (logMessageType) {
        case "log:thread-admins": {
          console.log(dataThread.adminIDs);
          if (logMessageData.ADMIN_EVENT === "add_admin") {
            dataThread.adminIDs.push({
              id: logMessageData.TARGET_ID,
            });
          } else if (logMessageData.ADMIN_EVENT === "remove_admin") {
            dataThread.adminIDs = dataThread.adminIDs.filter((item: any) => item.id !== logMessageData.TARGET_ID);
          }
          logger(`Làm mới list admin tại nhóm ${threadID}`, "UPDATE DATA");

          await setData(threadID, { threadInfo: dataThread });
          console.log(dataThread.adminIDs);
          break;
        }
        case "log:thread-name": {
          logger(`Cập nhật tên tại nhóm ${threadID}`, "UPDATE DATA");
          dataThread.threadName = event.logMessageData.name;
          await setData(threadID, { threadInfo: dataThread });
          break;
        }
        case "log:subscribe": {
          if (event.logMessageData.addedParticipants.some((i: any) => i.userFbId === api.getCurrentUserID())) {
            await new Promise((resolve) => setTimeout(resolve, 2000));
            try {
              // Assuming CreateDatabase.ts will be imported and used correctly
              require('./CreateDatabase').default({ Users, Threads, Currencies });
            } catch (e) {
              console.log(e);
            }
            return;
          }
          break;
        }

        case "log:unsubscribe": {
          try {
            if (logMessageData.leftParticipantFbId === api.getCurrentUserID()) {
              logger(`Thực hiện xóa data của nhóm ${threadID}`, "DELETE DATA");
              const index = global.db.allThreadID.findIndex((item: string) => item === threadID);
              global.db.allThreadID.splice(index, 1);
              await delData(threadID);
              return;
            } else {
              const index = dataThread.participantIDs.findIndex((item: string) => item === logMessageData.leftParticipantFbId);
              dataThread.participantIDs.splice(index, 1);
              if (dataThread.adminIDs.find((i: any) => i.id === logMessageData.leftParticipantFbId)) {
                dataThread.adminIDs = dataThread.adminIDs.filter((item: any) => item.id !== logMessageData.leftParticipantFbId);
              }
              logger(`Thực hiện xóa user ${logMessageData.leftParticipantFbId}`, "DELETE DATA");
              await setData(threadID, { threadInfo: dataThread });
            }
            break;
          } catch (e) {
            console.log(e);
          }
        }
      }
    } catch (e) {
      console.log(`Đã xảy ra lỗi update data: ${e}`);
    }
    return;
  };
}


